/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import com.google.common.collect.ImmutableList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import org.jdom2.Element;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.stream.NcStreamWriter;
import ucar.nc2.ui.StructureTable;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.dialog.CompareDialog;
import ucar.nc2.ui.dialog.NetcdfOutputChooser;
import ucar.nc2.ui.op.DatasetTreeView;
import ucar.nc2.ui.op.NCdumpPane;
import ucar.nc2.ui.op.VariablePlot;
import ucar.nc2.ui.op.VariableTable;
import ucar.nc2.util.CompareNetcdf2;
import ucar.nc2.write.Nc4Chunking;
import ucar.nc2.write.Nc4ChunkingStrategy;
import ucar.nc2.write.Ncdump;
import ucar.nc2.write.NcmlWriter;
import ucar.nc2.write.NetcdfCopier;
import ucar.nc2.write.NetcdfFileFormat;
import ucar.nc2.write.NetcdfFormatWriter;
import ucar.ui.prefs.BeanTable;
import ucar.ui.prefs.Debug;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class DatasetViewer
extends JPanel {
    private FileManager fileChooser;
    private PreferencesExt prefs;
    private NetcdfFile ds;
    private List<NestedTable> nestedTableList = new ArrayList<NestedTable>();
    private BeanTable attTable;
    private JPanel tablePanel;
    private JSplitPane mainSplit;
    private JComponent currentComponent;
    private DatasetTreeView datasetTree;
    private NCdumpPane dumpPane;
    private VariablePlot dataPlot;
    private VariableTable variableTable;
    private TextHistoryPane infoTA;
    private StructureTable dataTable;
    private IndependentWindow infoWindow;
    private IndependentWindow dataWindow;
    private IndependentWindow plotWindow;
    private IndependentWindow dumpWindow;
    private IndependentWindow attWindow;
    private boolean eventsOK = true;
    private boolean useCoords = false;
    private NetcdfOutputChooser outChooser;
    private CompareDialog dialog;

    DatasetViewer(PreferencesExt prefs, FileManager fileChooser) {
        this.prefs = prefs;
        this.fileChooser = fileChooser;
        this.tablePanel = new JPanel(new BorderLayout());
        this.setNestedTable(0, null);
        this.datasetTree = new DatasetTreeView();
        this.datasetTree.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Selection")) {
                    DatasetViewer.this.setSelected((Variable)e.getNewValue());
                }
            }
        });
        this.mainSplit = new JSplitPane(1, false, this.datasetTree, this.tablePanel);
        this.mainSplit.setDividerLocation(prefs.getInt("mainSplit", 100));
        this.setLayout(new BorderLayout());
        this.add((Component)this.mainSplit, "Center");
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Variable Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.dataTable = new StructureTable((PreferencesExt)prefs.node("structTable"));
        this.variableTable = new VariableTable((PreferencesExt)prefs.node("variableTable"));
        this.dataWindow = new IndependentWindow("Data Table", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.dataTable);
        this.dataWindow.setBounds((Rectangle)prefs.getBean("dataWindowBounds", (Object)new Rectangle(50, 300, 1000, 1200)));
        this.dumpPane = new NCdumpPane((PreferencesExt)prefs.node("dumpPane"));
        this.dumpWindow = new IndependentWindow("NCDump Variable Data", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)((Object)this.dumpPane));
        this.dumpWindow.setBounds((Rectangle)prefs.getBean("DumpWindowBounds", (Object)new Rectangle(300, 300, 300, 200)));
        this.dataPlot = new VariablePlot((PreferencesExt)prefs.node("plotPane"));
        this.plotWindow = new IndependentWindow("Plot Variable Data", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.dataPlot);
        this.plotWindow.setBounds((Rectangle)prefs.getBean("PlotWindowBounds", (Object)new Rectangle(300, 300, 300, 200)));
        this.plotWindow.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DatasetViewer.this.dataPlot.clear();
            }
        });
    }

    void addActions(JPanel buttPanel) {
        AbstractAction netcdfAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DatasetViewer.this.ds == null) {
                    return;
                }
                if (DatasetViewer.this.outChooser == null) {
                    DatasetViewer.this.outChooser = new NetcdfOutputChooser((Frame)null);
                    DatasetViewer.this.outChooser.addPropertyChangeListener("OK", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            DatasetViewer.this.writeNetcdf((NetcdfOutputChooser.Data)evt.getNewValue());
                        }
                    });
                }
                DatasetViewer.this.outChooser.setOutputFilename(DatasetViewer.this.ds.getLocation());
                DatasetViewer.this.outChooser.setVisible(true);
            }
        };
        BAMutil.setActionProperties((AbstractAction)netcdfAction, (String)"nj22/Netcdf", (String)"Write netCDF file", (boolean)false, (int)83, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)netcdfAction);
        AbstractButton compareButton = BAMutil.makeButtcon((String)"Select", (String)"Compare to another file", (boolean)false);
        compareButton.addActionListener(e -> this.compareDataset());
        buttPanel.add(compareButton);
        AbstractButton builderButton = BAMutil.makeButtcon((String)"Select", (String)"Compare w/wo builder", (boolean)false);
        builderButton.addActionListener(e -> {
            if (this.useCoords) {
                this.compareBuilderDS();
            } else {
                this.compareBuilder();
            }
        });
        buttPanel.add(builderButton);
        AbstractAction attAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetViewer.this.showAtts();
            }
        };
        BAMutil.setActionProperties((AbstractAction)attAction, (String)"FontDecr", (String)"global attributes", (boolean)false, (int)65, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)attAction);
    }

    private void writeNetcdf(NetcdfOutputChooser.Data data) {
        if (data.format == NetcdfFileFormat.NCSTREAM) {
            this.writeNcstream(data.outputFilename);
            return;
        }
        try {
            NetcdfFormatWriter.Builder builder = NetcdfFormatWriter.builder().setNewFile(true).setFormat(data.format).setLocation(data.outputFilename).setChunker(Nc4ChunkingStrategy.factory((Nc4Chunking.Strategy)data.chunkerType, (int)data.deflate, (boolean)data.shuffle));
            NetcdfCopier copier = NetcdfCopier.create((NetcdfFile)this.ds, (NetcdfFormatWriter.Builder)builder);
            NetcdfFile result = copier.write(null);
            Throwable throwable = null;
            if (result != null) {
                if (throwable != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    result.close();
                }
            }
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    void writeNcstream(String filename) {
        try {
            NcStreamWriter writer = new NcStreamWriter(this.ds, null);
            try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(filename), 50000);){
                writer.streamAll((OutputStream)fos);
            }
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    void writeNcstreamHeader(String filename) {
        try {
            NcStreamWriter writer = new NcStreamWriter(this.ds, null);
            try (FileOutputStream fos = new FileOutputStream(filename);){
                writer.sendHeader((OutputStream)fos);
            }
            JOptionPane.showMessageDialog(this, "File successfully written");
        }
        catch (Exception ioe) {
            JOptionPane.showMessageDialog(this, "ERROR: " + ioe.getMessage());
            ioe.printStackTrace();
        }
    }

    private void compareDataset() {
        if (this.ds == null) {
            return;
        }
        if (this.dialog == null) {
            this.dialog = new CompareDialog(null, this.fileChooser);
            this.dialog.pack();
            this.dialog.addPropertyChangeListener("OK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    CompareDialog.Data data = (CompareDialog.Data)evt.getNewValue();
                    DatasetViewer.this.compareDataset(data);
                }
            });
        }
        this.dialog.setVisible(true);
    }

    private void compareBuilder() {
        if (this.ds == null) {
            return;
        }
        String fileLocation = this.ds.getLocation();
        try (NetcdfFile org = NetcdfFile.open((String)fileLocation);
             NetcdfFile withBuilder = NetcdfFiles.open((String)fileLocation);){
            Formatter f = new Formatter();
            CompareNetcdf2 compare = new CompareNetcdf2(f, false, false, true);
            boolean ok = compare.compare(org, withBuilder, (CompareNetcdf2.ObjFilter)new CoordsObjFilter());
            this.infoTA.setText(f.toString());
            this.infoTA.gotoTop();
            this.infoWindow.setTitle("Compare Old (file1) with Builder (file 2)");
            this.infoWindow.show();
        }
        catch (Throwable ioe) {
            StringWriter sw = new StringWriter(10000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.infoTA.setText(sw.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
        }
    }

    private void compareBuilderDS() {
        if (this.ds == null) {
            return;
        }
        String fileLocation = this.ds.getLocation();
        try (NetcdfDataset org = NetcdfDataset.openDataset((String)fileLocation);
             NetcdfDataset withBuilder = NetcdfDatasets.openDataset((String)fileLocation);){
            Formatter f = new Formatter();
            CompareNetcdf2 compare = new CompareNetcdf2(f, false, false, true);
            compare.compare((NetcdfFile)org, (NetcdfFile)withBuilder, (CompareNetcdf2.ObjFilter)new CoordsObjFilter());
            this.infoTA.setText(f.toString());
            this.infoTA.gotoTop();
            this.infoWindow.setTitle("Compare Old (file1) with Builder (file 2)");
            this.infoWindow.show();
        }
        catch (Throwable ioe) {
            StringWriter sw = new StringWriter(10000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.infoTA.setText(sw.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
        }
    }

    private void compareDataset(CompareDialog.Data data) {
        if (data.name == null) {
            return;
        }
        try (NetcdfFile compareFile = ToolsUI.getToolsUI().openFile(data.name, false, null);
             Formatter f = new Formatter();){
            CompareNetcdf2 cn = new CompareNetcdf2(f, data.showCompare, data.showDetails, data.readData);
            if (data.howMuch == CompareDialog.HowMuch.All) {
                cn.compare(this.ds, compareFile);
            } else if (data.howMuch == CompareDialog.HowMuch.varNameOnly) {
                f.format(" First file = %s%n", this.ds.getLocation());
                f.format(" Second file= %s%n", compareFile.getLocation());
                CompareNetcdf2.compareLists(this.getVariableNames(this.ds), this.getVariableNames(compareFile), (Formatter)f);
            } else {
                NestedTable nested = this.nestedTableList.get(0);
                Variable org = this.getCurrentVariable(nested.table);
                if (org == null) {
                    return;
                }
                Variable ov = compareFile.findVariable(org.getFullNameEscaped());
                if (ov != null) {
                    cn.compareVariable(org, ov, CompareNetcdf2.IDENTITY_FILTER);
                }
            }
            this.infoTA.setText(f.toString());
            this.infoTA.gotoTop();
            this.infoWindow.setTitle("Compare");
            this.infoWindow.show();
        }
        catch (Throwable ioe) {
            StringWriter sw = new StringWriter(10000);
            ioe.printStackTrace(new PrintWriter(sw));
            this.infoTA.setText(sw.toString());
            this.infoTA.gotoTop();
            this.infoWindow.show();
        }
    }

    private List<String> getVariableNames(NetcdfFile nc) {
        ArrayList<String> result = new ArrayList<String>();
        for (Variable v : nc.getVariables()) {
            result.add(v.getFullName());
        }
        return result;
    }

    public void showAtts() {
        if (this.ds == null) {
            return;
        }
        if (this.attTable == null) {
            this.attTable = new BeanTable(AttributeBean.class, (PreferencesExt)this.prefs.node("AttributeBeans"), false);
            PopupMenu varPopup = new PopupMenu((JComponent)this.attTable.getJTable(), "Options");
            varPopup.addAction("Show Attribute", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeBean bean = (AttributeBean)DatasetViewer.this.attTable.getSelectedBean();
                    if (bean != null) {
                        DatasetViewer.this.infoTA.setText(bean.att.toString());
                        DatasetViewer.this.infoTA.gotoTop();
                        DatasetViewer.this.infoWindow.show();
                    }
                }
            });
            this.attWindow = new IndependentWindow("Global Attributes", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.attTable);
            this.attWindow.setBounds((Rectangle)this.prefs.getBean("AttWindowBounds", (Object)new Rectangle(300, 100, 500, 800)));
        }
        ArrayList<AttributeBean> attlist = new ArrayList<AttributeBean>();
        for (Attribute att : this.ds.getGlobalAttributes()) {
            attlist.add(new AttributeBean(att));
        }
        this.attTable.setBeans(attlist);
        this.attWindow.show();
    }

    public NetcdfFile getDataset() {
        return this.ds;
    }

    public void clear() {
        this.ds = null;
        if (this.attTable != null) {
            this.attTable.clearBeans();
        }
        for (NestedTable nt : this.nestedTableList) {
            nt.table.clearBeans();
        }
        this.datasetTree.clear();
    }

    public void setDataset(NetcdfFile ds) {
        this.ds = ds;
        NestedTable nt = this.nestedTableList.get(0);
        nt.table.setBeans(this.getVariableBeans(ds));
        this.hideNestedTable(1);
        this.datasetTree.setFile(ds);
    }

    void setUseCoords(boolean useCoords) {
        this.useCoords = useCoords;
    }

    private void setSelected(Variable v) {
        this.eventsOK = false;
        ArrayList<Variable> vchain = new ArrayList<Variable>();
        vchain.add(v);
        Variable vp = v;
        while (vp.isMemberOfStructure()) {
            vp = vp.getParentStructure();
            vchain.add(0, vp);
        }
        for (int i = 0; i < vchain.size(); ++i) {
            vp = (Variable)vchain.get(i);
            NestedTable ntable = this.setNestedTable(i, vp.getParentStructure());
            ntable.setSelected(vp);
        }
        this.eventsOK = true;
    }

    private NestedTable setNestedTable(int level, Structure s) {
        NestedTable ntable;
        if (this.nestedTableList.size() < level + 1) {
            ntable = new NestedTable(level);
            this.nestedTableList.add(ntable);
        } else {
            ntable = this.nestedTableList.get(level);
        }
        if (s != null) {
            ntable.table.setBeans(this.getStructureVariables(s));
        }
        ntable.show();
        return ntable;
    }

    private void hideNestedTable(int level) {
        int n = this.nestedTableList.size();
        for (int i = n - 1; i >= level; --i) {
            NestedTable ntable = this.nestedTableList.get(i);
            ntable.hide();
        }
    }

    private void showDeclaration(BeanTable from, boolean isNcml) {
        Variable v = this.getCurrentVariable(from);
        if (v == null) {
            return;
        }
        this.infoTA.clear();
        if (isNcml) {
            NcmlWriter ncmlWriter = new NcmlWriter();
            ncmlWriter.getXmlFormat().setOmitDeclaration(true);
            Element varElement = ncmlWriter.makeVariableElement(v, false);
            this.infoTA.appendLine(ncmlWriter.writeToString(varElement));
        } else {
            this.infoTA.appendLine(v.toString());
        }
        if (Debug.isSet((String)"Xdeveloper")) {
            this.infoTA.appendLine("\n");
            this.infoTA.appendLine("FULL NAME = " + v.getFullName());
            this.infoTA.appendLine("\n");
            this.infoTA.appendLine(v.toStringDebug());
        }
        this.infoTA.gotoTop();
        this.infoWindow.setTitle("Variable Info");
        this.infoWindow.show();
    }

    private void showData(BeanTable from) {
        Variable v = this.getCurrentVariable(from);
        if (v == null) {
            return;
        }
        this.infoTA.clear();
        try {
            Array data = v.read();
            this.infoTA.setText(Ncdump.printArray((Array)data, (String)v.getFullName(), null));
        }
        catch (Exception ex) {
            StringWriter s = new StringWriter();
            ex.printStackTrace(new PrintWriter(s));
            this.infoTA.setText(s.toString());
        }
        this.infoTA.gotoTop();
        this.infoWindow.setTitle("Variable Info");
        this.infoWindow.show();
    }

    private void dumpData(BeanTable from) {
        Variable v = this.getCurrentVariable(from);
        if (v == null) {
            return;
        }
        this.dumpPane.clear();
        try {
            String spec = ParsedSectionSpec.makeSectionSpecString((Variable)v, null);
            this.dumpPane.setContext(this.ds, spec);
        }
        catch (Exception ex) {
            StringWriter s = new StringWriter();
            ex.printStackTrace(new PrintWriter(s));
            this.dumpPane.setText(s.toString());
        }
        this.dumpWindow.show();
    }

    private void writeData(BeanTable from, File name) {
        Variable v = this.getCurrentVariable(from);
        if (v == null || name == null) {
            return;
        }
        try (FileOutputStream stream = new FileOutputStream(name);){
            FileChannel channel = stream.getChannel();
            v.readToByteChannel(v.getShapeAsSection(), (WritableByteChannel)channel);
            System.out.printf("Write ok to %s%n", name);
        }
        catch (IOException | InvalidRangeException e) {
            e.printStackTrace();
        }
    }

    private void dataTable(BeanTable from) {
        VariableBean vb = (VariableBean)from.getSelectedBean();
        if (vb == null) {
            return;
        }
        Variable v = vb.vs;
        if (v instanceof Structure) {
            try {
                this.dataTable.setStructure((Structure)v);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.dataWindow.setComponent((Component)this.dataTable);
        } else {
            List l = from.getSelectedBeans();
            ArrayList<Variable> vl = new ArrayList<Variable>();
            for (VariableBean vb1 : l) {
                if (vb1 == null) {
                    return;
                }
                v = vb1.vs;
                if (v != null) {
                    vl.add(v);
                    continue;
                }
                return;
            }
            this.variableTable.setDataset(this.ds);
            this.variableTable.setVariableList(vl);
            this.variableTable.createTable();
            this.dataWindow.setComponent((Component)this.variableTable);
        }
        Rectangle r = (Rectangle)this.prefs.getBean("dataWindowBounds", (Object)new Rectangle(50, 300, 1000, 1200));
        this.dataWindow.setBounds(r);
        this.dataWindow.show();
    }

    private void dataPlot(BeanTable from) {
        List l = from.getSelectedBeans();
        for (VariableBean vb : l) {
            if (vb == null) {
                return;
            }
            Variable v = vb.vs;
            if (v != null) {
                try {
                    this.dataPlot.setDataset(this.ds);
                    this.dataPlot.setVariable(v);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                continue;
            }
            return;
        }
        this.plotWindow.show();
    }

    private Variable getCurrentVariable(BeanTable from) {
        VariableBean vb = (VariableBean)from.getSelectedBean();
        if (vb == null) {
            return null;
        }
        return vb.vs;
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.dumpPane.save();
        this.fileChooser.save();
        for (NestedTable nt : this.nestedTableList) {
            nt.saveState();
        }
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putBeanObject("dataWindowBounds", (Object)this.dataWindow.getBounds());
        this.prefs.putBeanObject("DumpWindowBounds", (Object)this.dumpWindow.getBounds());
        this.prefs.putBeanObject("PlotWindowBounds", (Object)this.plotWindow.getBounds());
        if (this.attWindow != null) {
            this.prefs.putBeanObject("AttWindowBounds", (Object)this.attWindow.getBounds());
        }
        this.prefs.putInt("mainSplit", this.mainSplit.getDividerLocation());
    }

    private List<VariableBean> getVariableBeans(NetcdfFile ds) {
        ArrayList<VariableBean> vlist = new ArrayList<VariableBean>();
        for (Variable v : ds.getVariables()) {
            vlist.add(new VariableBean(v));
        }
        return vlist;
    }

    private List<VariableBean> getStructureVariables(Structure s) {
        ArrayList<VariableBean> vlist = new ArrayList<VariableBean>();
        for (Variable v : s.getVariables()) {
            vlist.add(new VariableBean(v));
        }
        return vlist;
    }

    public static class AttributeBean {
        private Attribute att;

        public AttributeBean(Attribute att) {
            this.att = att;
        }

        public String getName() {
            return this.att.getShortName();
        }

        public String getValue() {
            Array value = this.att.getValues();
            return Ncdump.printArray((Array)value, null, null);
        }
    }

    public static class VariableBean {
        private Variable vs;
        private String name;
        private String dimensions;
        private String desc;
        private String units;
        private String dataType;
        private String shape;

        public VariableBean(Variable vs) {
            this.vs = vs;
            this.setName(vs.getShortName());
            this.setDescription(vs.getDescription());
            this.setUnits(vs.getUnitsString());
            this.setDataType(vs.getDataType().toString());
            StringBuilder lens = new StringBuilder();
            StringBuilder names = new StringBuilder();
            ImmutableList dims = vs.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = (Dimension)dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getShortName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDimensions(names.toString());
            this.setShape(lens.toString());
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGroup() {
            return this.vs.getParentGroup().getFullName();
        }

        public String getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(String dimensions) {
            this.dimensions = dimensions;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public String getDataType() {
            return this.dataType;
        }

        public void setDataType(String dataType) {
            this.dataType = dataType;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }
    }

    private class NestedTable {
        int level;
        PreferencesExt myPrefs;
        BeanTable table;
        JSplitPane split;
        int splitPos = 100;
        boolean isShowing;

        NestedTable(int level) {
            this.level = level;
            this.myPrefs = (PreferencesExt)DatasetViewer.this.prefs.node("NestedTable" + level);
            this.table = new BeanTable(VariableBean.class, this.myPrefs, false);
            JTable jtable = this.table.getJTable();
            PopupMenu csPopup = new PopupMenu((JComponent)jtable, "Options");
            csPopup.addAction("Show Declaration", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.showDeclaration(NestedTable.this.table, false);
                }
            });
            csPopup.addAction("Show NcML", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.showDeclaration(NestedTable.this.table, true);
                }
            });
            csPopup.addAction("Show Data", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.showData(NestedTable.this.table);
                }
            });
            csPopup.addAction("NCdump Data", "Dump", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatasetViewer.this.dumpData(NestedTable.this.table);
                }
            });
            csPopup.addAction("Write binary Data to file", (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String binaryFilePath = DatasetViewer.this.fileChooser.chooseFilenameToSave("data.bin");
                    if (binaryFilePath != null) {
                        DatasetViewer.this.writeData(NestedTable.this.table, new File(binaryFilePath));
                    }
                }
            });
            if (level == 0) {
                csPopup.addAction("Data Table", (Action)new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DatasetViewer.this.dataTable(NestedTable.this.table);
                    }
                });
                csPopup.addAction("Data Plot", (Action)new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DatasetViewer.this.dataPlot(NestedTable.this.table);
                    }
                });
            }
            this.table.addListSelectionListener(e -> {
                Variable v = DatasetViewer.this.getCurrentVariable(this.table);
                if (v instanceof Structure) {
                    DatasetViewer.this.hideNestedTable(this.level + 2);
                    DatasetViewer.this.setNestedTable(this.level + 1, (Structure)v);
                } else {
                    DatasetViewer.this.hideNestedTable(this.level + 1);
                }
                if (DatasetViewer.this.eventsOK) {
                    DatasetViewer.this.datasetTree.setSelected(v);
                }
            });
            if (DatasetViewer.this.currentComponent == null) {
                DatasetViewer.this.currentComponent = (JComponent)this.table;
                DatasetViewer.this.tablePanel.add((Component)DatasetViewer.this.currentComponent, "Center");
                this.isShowing = true;
            } else {
                this.split = new JSplitPane(0, false, DatasetViewer.this.currentComponent, (Component)this.table);
                this.splitPos = this.myPrefs.getInt("splitPos" + level, 500);
                if (this.splitPos > 0) {
                    this.split.setDividerLocation(this.splitPos);
                }
                this.show();
            }
        }

        void show() {
            if (this.isShowing) {
                return;
            }
            DatasetViewer.this.tablePanel.remove(DatasetViewer.this.currentComponent);
            this.split.setLeftComponent(DatasetViewer.this.currentComponent);
            this.split.setDividerLocation(this.splitPos);
            DatasetViewer.this.currentComponent = this.split;
            DatasetViewer.this.tablePanel.add((Component)DatasetViewer.this.currentComponent, "Center");
            DatasetViewer.this.tablePanel.revalidate();
            this.isShowing = true;
        }

        void hide() {
            if (!this.isShowing) {
                return;
            }
            DatasetViewer.this.tablePanel.remove(DatasetViewer.this.currentComponent);
            if (this.split != null) {
                this.splitPos = this.split.getDividerLocation();
                DatasetViewer.this.currentComponent = (JComponent)this.split.getLeftComponent();
                DatasetViewer.this.tablePanel.add((Component)DatasetViewer.this.currentComponent, "Center");
            }
            DatasetViewer.this.tablePanel.revalidate();
            this.isShowing = false;
        }

        void setSelected(Variable vs) {
            List beans = this.table.getBeans();
            for (Object bean1 : beans) {
                VariableBean bean = (VariableBean)bean1;
                if (bean.vs != vs) continue;
                this.table.setSelectedBean((Object)bean);
                return;
            }
        }

        void saveState() {
            this.table.saveState(false);
            if (this.split != null) {
                this.myPrefs.putInt("splitPos" + this.level, this.split.getDividerLocation());
            }
        }
    }

    public static class CoordsObjFilter
    implements CompareNetcdf2.ObjFilter {
        public boolean attCheckOk(Variable v, Attribute att) {
            return !att.getShortName().equals("_CoordSysBuilder");
        }
    }
}

