/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.op.Hdf5DataTable;
import ucar.nc2.ui.op.Hdf5NewDataTable;
import ucar.ui.widget.BAMutil;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Hdf5DataPanel
extends OpPanel {
    private RandomAccessFile raf;
    private Hdf5DataTable hdf5Table;

    public Hdf5DataPanel(PreferencesExt p, boolean useBuilders) {
        super(p, "file:", true, false);
        this.hdf5Table = useBuilders ? new Hdf5NewDataTable(this.prefs, this.buttPanel) : new Hdf5DataTable(this.prefs, this.buttPanel);
        this.add((Component)this.hdf5Table, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon((String)"Information", (String)"Detail Info", (boolean)false);
        infoButton.addActionListener(e -> {
            Formatter f = new Formatter();
            try {
                this.hdf5Table.showInfo(f);
            }
            catch (IOException ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                return;
            }
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(infoButton);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            if (this.raf != null) {
                this.raf.close();
            }
            this.raf = new RandomAccessFile(command, "r");
            this.hdf5Table.setHdf5File(this.raf);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "Hdf5DataTable cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        this.hdf5Table.closeOpenFiles();
    }

    @Override
    public void save() {
        this.hdf5Table.save();
        super.save();
    }
}

