/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.gis;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import ucar.nc2.ui.gis.GisFeature;
import ucar.nc2.ui.gis.GisPart;
import ucar.ui.prefs.Debug;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;

public abstract class AbstractGisFeature
implements GisFeature {
    @Override
    public abstract Rectangle2D getBounds2D();

    @Override
    public abstract int getNumPoints();

    @Override
    public abstract int getNumParts();

    @Override
    public abstract Iterator getGisParts();

    public Shape getShape() {
        int npts = this.getNumPoints();
        GeneralPath path = new GeneralPath(0, npts);
        Iterator pi = this.getGisParts();
        while (pi.hasNext()) {
            GisPart gp = (GisPart)pi.next();
            double[] xx = gp.getX();
            double[] yy = gp.getY();
            int np = gp.getNumPoints();
            if (np > 0) {
                path.moveTo((float)xx[0], (float)yy[0]);
            }
            for (int i = 1; i < np; ++i) {
                path.lineTo((float)xx[i], (float)yy[i]);
            }
        }
        return path;
    }

    Shape getProjectedShape(ProjectionImpl displayProject) {
        GeneralPath path = new GeneralPath(0, this.getNumPoints());
        boolean showPts = Debug.isSet((String)"projection/showPoints");
        ProjectionPoint lastW = ProjectionPoint.create();
        Iterator pi = this.getGisParts();
        while (pi.hasNext()) {
            GisPart gp = (GisPart)pi.next();
            double[] xx = gp.getX();
            double[] yy = gp.getY();
            boolean skipPrev = false;
            int count = 0;
            for (int i = 0; i < gp.getNumPoints(); ++i) {
                LatLonPoint workL = LatLonPoint.create((double)yy[i], (double)xx[i]);
                ProjectionPoint pt = displayProject.latLonToProj(workL);
                if (showPts) {
                    System.out.println("AbstractGisFeature getProjectedShape 1 " + xx[i] + " " + yy[i] + " === " + pt.getX() + " " + pt.getY());
                    if (displayProject.crossSeam(pt, lastW)) {
                        System.out.println("***cross seam");
                    }
                }
                if (Double.isNaN(pt.getX()) || Double.isNaN(pt.getY())) {
                    skipPrev = true;
                    continue;
                }
                if (count == 0 || skipPrev || displayProject.crossSeam(pt, lastW)) {
                    path.moveTo((float)pt.getX(), (float)pt.getY());
                } else {
                    path.lineTo((float)pt.getX(), (float)pt.getY());
                }
                ++count;
                skipPrev = false;
                lastW = pt;
            }
        }
        return path;
    }

    public Shape getProjectedShape(ProjectionImpl dataProject, ProjectionImpl displayProject) {
        ProjectionPoint lastW = ProjectionPoint.create();
        GeneralPath path = new GeneralPath(0, this.getNumPoints());
        boolean showPts = Debug.isSet((String)"projection/showPoints");
        Iterator pi = this.getGisParts();
        while (pi.hasNext()) {
            GisPart gp = (GisPart)pi.next();
            double[] xx = gp.getX();
            double[] yy = gp.getY();
            boolean skipPrev = false;
            int count = 0;
            for (int i = 0; i < gp.getNumPoints(); ++i) {
                ProjectionPoint pt1 = ProjectionPoint.create((double)xx[i], (double)yy[i]);
                LatLonPoint llpt = dataProject.projToLatLon(pt1);
                ProjectionPoint pt2 = displayProject.latLonToProj(llpt);
                if (showPts) {
                    System.out.println("AbstractGisFeature getProjectedShape 2 " + xx[i] + " " + yy[i] + " === " + pt2.getX() + " " + pt2.getY());
                    if (displayProject.crossSeam(pt2, lastW)) {
                        System.out.println("***cross seam");
                    }
                }
                if (Double.isNaN(pt2.getX()) || Double.isNaN(pt2.getY())) {
                    skipPrev = true;
                    continue;
                }
                if (count == 0 || skipPrev || displayProject.crossSeam(pt2, lastW)) {
                    path.moveTo((float)pt2.getX(), (float)pt2.getY());
                } else {
                    path.lineTo((float)pt2.getX(), (float)pt2.getY());
                }
                ++count;
                skipPrev = false;
                lastW = pt2;
            }
        }
        return path;
    }
}

