/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileSubclass;
import ucar.nc2.internal.iosp.hdf5.H5headerNew;
import ucar.nc2.internal.iosp.hdf5.H5iospNew;
import ucar.nc2.internal.iosp.hdf5.H5objects;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.ui.op.Hdf5ObjectTable;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DebugFlagsImpl;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Hdf5NewObjectTable
extends Hdf5ObjectTable {
    private BeanTable<ObjectBean> objectTable;
    private BeanTable<MessageBean> messTable;
    private BeanTable<AttributeBean> attTable;
    private JSplitPane splitH;
    private JSplitPane split;
    private JSplitPane split2;
    private TextHistoryPane dumpTA;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;
    private H5iospNew iosp;
    private String location;

    public Hdf5NewObjectTable(PreferencesExt prefs) {
        super(prefs);
        this.objectTable = new BeanTable(ObjectBean.class, (PreferencesExt)prefs.node("Hdf5Object"), false, "H5headerNew.DataObject", "Level 2A data object header", null);
        this.objectTable.addListSelectionListener(e -> {
            this.messTable.setBeans(new ArrayList());
            ArrayList<MessageBean> beans = new ArrayList<MessageBean>();
            ObjectBean ob = (ObjectBean)this.objectTable.getSelectedBean();
            for (H5objects.HeaderMessage m : ob.m.getMessages()) {
                beans.add(new MessageBean(m));
            }
            this.messTable.setBeans(beans);
            ArrayList<AttributeBean> attBeans = new ArrayList<AttributeBean>();
            for (H5objects.MessageAttribute m : ob.m.getAttributes()) {
                attBeans.add(new AttributeBean(m));
            }
            this.attTable.setBeans(attBeans);
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.objectTable.getJTable(), "Options");
        varPopup.addAction("show", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectBean mb = (ObjectBean)Hdf5NewObjectTable.this.objectTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Hdf5NewObjectTable.this.dumpTA.clear();
                Formatter f = new Formatter();
                try {
                    mb.show(f);
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
                Hdf5NewObjectTable.this.dumpTA.appendLine(f.toString());
                Hdf5NewObjectTable.this.dumpTA.gotoTop();
            }
        });
        this.messTable = new BeanTable(MessageBean.class, (PreferencesExt)prefs.node("MessBean"), false, "H5headerNew.HeaderMessage", "Level 2A1 and 2A2 (part of Data Object)", null);
        this.messTable.addListSelectionListener(e -> {
            MessageBean mb = (MessageBean)this.messTable.getSelectedBean();
            this.dumpTA.setText(mb.m.toString());
        });
        varPopup = new PopupMenu((JComponent)this.messTable.getJTable(), "Options");
        varPopup.addAction("Show FractalHeap", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBean mb = (MessageBean)Hdf5NewObjectTable.this.messTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                if (Hdf5NewObjectTable.this.infoTA == null) {
                    Hdf5NewObjectTable.this.makeInfoWindow();
                }
                Hdf5NewObjectTable.this.infoTA.clear();
                Formatter f = new Formatter();
                mb.m.showFractalHeap(f);
                Hdf5NewObjectTable.this.infoTA.appendLine(f.toString());
                Hdf5NewObjectTable.this.infoTA.gotoTop();
                Hdf5NewObjectTable.this.infoWindow.show();
            }
        });
        this.attTable = new BeanTable(AttributeBean.class, (PreferencesExt)prefs.node("AttBean"), false, "H5headerNew.HeaderAttribute", "Message Type 12/0xC : define an Atribute", null);
        this.attTable.addListSelectionListener(e -> {
            AttributeBean mb = (AttributeBean)this.attTable.getSelectedBean();
            Formatter f = new Formatter();
            mb.show(f);
            this.dumpTA.setText(f.toString());
        });
        this.dumpTA = new TextHistoryPane();
        this.splitH = new JSplitPane(1, false, (Component)this.objectTable, (Component)this.dumpTA);
        this.splitH.setDividerLocation(prefs.getInt("splitPosH", 600));
        this.split = new JSplitPane(0, false, this.splitH, (Component)this.messTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.split2 = new JSplitPane(0, false, this.split, (Component)this.attTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split2, "Center");
    }

    @Override
    public void save() {
        this.objectTable.saveState(false);
        this.messTable.saveState(false);
        this.attTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        this.prefs.putInt("splitPosH", this.splitH.getDividerLocation());
    }

    private void makeInfoWindow() {
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds(new Rectangle(300, 300, 500, 800));
    }

    @Override
    public void getEosInfo(Formatter f) throws IOException {
        H5headerNew header = this.iosp.getHeader();
        header.getEosInfo(f);
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.iosp != null) {
            this.iosp.close();
        }
        this.iosp = null;
        this.attTable.clearBeans();
        this.messTable.clearBeans();
        this.objectTable.clearBeans();
        this.dumpTA.clear();
    }

    @Override
    public void setHdf5File(RandomAccessFile raf) throws IOException {
        this.closeOpenFiles();
        this.location = raf.getLocation();
        ArrayList<ObjectBean> beanList = new ArrayList<ObjectBean>();
        this.iosp = new H5iospNew();
        NetcdfFileSubclass ncfile = new NetcdfFileSubclass((IOServiceProvider)this.iosp, this.location);
        ncfile.sendIospMessage((Object)"IncludeOrgAttributes");
        try {
            this.iosp.open(raf, (NetcdfFile)ncfile, null);
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter(20000);
            PrintWriter s = new PrintWriter(sw);
            t.printStackTrace(s);
            this.dumpTA.setText(sw.toString());
        }
        H5headerNew header = this.iosp.getHeader();
        for (H5objects.DataObject dataObj : header.getDataObjects()) {
            beanList.add(new ObjectBean(dataObj));
        }
        this.objectTable.setBeans(beanList);
    }

    @Override
    public void showInfo(Formatter f) throws IOException {
        if (this.iosp == null) {
            return;
        }
        for (ObjectBean bean : this.objectTable.getBeans()) {
            bean.m.show(f);
        }
    }

    @Override
    public void showInfo2(Formatter f) throws IOException {
        if (this.iosp == null) {
            return;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(100000);
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)os, StandardCharsets.UTF_8));
        H5headerNew.setDebugFlags((DebugFlags)new DebugFlagsImpl("H5headerNew/header H5headerNew/headerDetails H5headerNew/symbolTable H5headerNew/memTracker"));
        H5headerNew headerEmpty = (H5headerNew)this.iosp.sendIospMessage((Object)"headerEmpty");
        headerEmpty.read(pw);
        H5headerNew.setDebugFlags((DebugFlags)new DebugFlagsImpl(""));
        pw.flush();
        f.format("%s", os.toString(StandardCharsets.UTF_8.name()));
        H5headerNew.setDebugFlags((DebugFlags)new DebugFlagsImpl());
    }

    public static class AttributeBean {
        H5objects.MessageAttribute att;

        public AttributeBean() {
        }

        AttributeBean(H5objects.MessageAttribute att) {
            this.att = att;
        }

        public byte getVersion() {
            return this.att.getVersion();
        }

        public String getAttributeName() {
            return this.att.getName();
        }

        public String getMdt() {
            return this.att.getMdt().toString();
        }

        public String getMds() {
            return this.att.getMds().toString();
        }

        public long getDataPos() {
            return this.att.getDataPosAbsolute();
        }

        void show(Formatter f) {
            f.format("hdf5 att = %s%n%n", this.att);
        }
    }

    public static class MessageBean {
        H5objects.HeaderMessage m;

        public MessageBean() {
        }

        MessageBean(H5objects.HeaderMessage m) {
            this.m = m;
        }

        public String getMessageType() {
            return this.m.getMtype().toString();
        }

        public String getName() {
            return this.m.getName();
        }

        public int getSize() {
            return this.m.getSize();
        }

        public byte getFlags() {
            return this.m.getFlags();
        }

        public long getStart() {
            return this.m.getStart();
        }
    }

    public static class ObjectBean {
        H5objects.DataObject m;

        public ObjectBean() {
        }

        ObjectBean(H5objects.DataObject m) {
            this.m = m;
        }

        public long getAddress() {
            return this.m.getAddress();
        }

        public String getName() {
            return this.m.getName();
        }

        void show(Formatter f) throws IOException {
            f.format("HDF5 object name '%s'%n", this.m.getName());
            for (H5objects.MessageAttribute mess : this.m.getAttributes()) {
                f.format("  %s%n", mess);
            }
        }
    }
}

