/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.net;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.entity.StringEntity;
import ucar.httpservices.HTTPException;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.nc2.util.IO;
import ucar.unidata.util.Urlencoded;

public class HttpClientManager {
    private static boolean debug;
    private static int timeout;

    public static void init(CredentialsProvider provider, String userAgent) {
        if (provider != null) {
            try {
                HTTPSession.setGlobalCredentialsProvider((CredentialsProvider)provider);
            }
            catch (HTTPException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (userAgent != null) {
            HTTPSession.setGlobalUserAgent((String)(userAgent + "/NetcdfJava/HttpClient"));
        } else {
            HTTPSession.setGlobalUserAgent((String)"NetcdfJava/HttpClient");
        }
    }

    @Urlencoded
    public static String getContentAsString(String urlencoded) throws IOException {
        return HttpClientManager.getContentAsString(null, urlencoded);
    }

    @Deprecated
    @Urlencoded
    public static String getContentAsString(HTTPSession session, String urlencoded) throws IOException {
        HTTPSession useSession = session;
        try {
            String string;
            block11: {
                if (useSession == null) {
                    useSession = HTTPFactory.newSession((String)urlencoded);
                }
                HTTPMethod m = HTTPFactory.Get((HTTPSession)useSession, (String)urlencoded);
                try {
                    m.execute();
                    string = m.getResponseAsString();
                    if (m == null) break block11;
                }
                catch (Throwable throwable) {
                    if (m != null) {
                        try {
                            m.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                m.close();
            }
            return string;
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    public static int putContent(String urlencoded, String content) throws IOException {
        try (HTTPMethod m = HTTPFactory.Put((String)urlencoded);){
            Optional locationOpt;
            m.setRequestContent((HttpEntity)new StringEntity(content, "application/text", "UTF-8"));
            m.execute();
            int resultCode = m.getStatusCode();
            if (resultCode == 302 && (locationOpt = m.getResponseHeaderValue("location")).isPresent()) {
                String redirectLocation = (String)locationOpt.get();
                resultCode = HttpClientManager.putContent(redirectLocation, content);
            }
            int n = resultCode;
            return n;
        }
    }

    public static String getUrlContentsAsString(String urlencoded, int maxKbytes) throws IOException {
        return HttpClientManager.getUrlContentsAsString(null, urlencoded, maxKbytes);
    }

    @Deprecated
    public static String getUrlContentsAsString(HTTPSession session, String urlencoded, int maxKbytes) throws IOException {
        HTTPSession useSession = session;
        try {
            String string;
            block24: {
                String charset;
                HTTPMethod m;
                block20: {
                    String string2;
                    block23: {
                        String encoding;
                        block21: {
                            String string3;
                            block22: {
                                if (useSession == null) {
                                    useSession = HTTPFactory.newSession((String)urlencoded);
                                }
                                m = HTTPFactory.Get((HTTPSession)useSession, (String)urlencoded);
                                try {
                                    Optional encodingOpt;
                                    m.setFollowRedirects(true);
                                    m.setCompression("gzip,deflate");
                                    int status = m.execute();
                                    if (status != 200) {
                                        throw new RuntimeException("failed status = " + status);
                                    }
                                    charset = m.getResponseCharSet();
                                    if (charset == null) {
                                        charset = "UTF-8";
                                    }
                                    if (!(encodingOpt = m.getResponseHeaderValue("content-encoding")).isPresent()) break block20;
                                    encoding = (String)encodingOpt.get();
                                    if (!"deflate".equals(encoding)) break block21;
                                    byte[] body = m.getResponseAsBytes();
                                    if (body == null) {
                                        throw new IOException("empty body");
                                    }
                                    BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream(body)), 10000);
                                    string3 = HttpClientManager.readContents(is, charset, maxKbytes);
                                    if (m == null) break block22;
                                }
                                catch (Throwable throwable) {
                                    if (m != null) {
                                        try {
                                            m.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                m.close();
                            }
                            return string3;
                        }
                        if (!"gzip".equals(encoding)) break block20;
                        byte[] body = m.getResponseAsBytes();
                        if (body == null) {
                            throw new IOException("empty body");
                        }
                        BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(new ByteArrayInputStream(body)), 10000);
                        string2 = HttpClientManager.readContents(is, charset, maxKbytes);
                        if (m == null) break block23;
                        m.close();
                    }
                    return string2;
                }
                byte[] body = m.getResponseAsBytes(maxKbytes * 1000);
                if (body == null) {
                    throw new IOException("empty body");
                }
                string = new String(body, charset);
                if (m == null) break block24;
                m.close();
            }
            return string;
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    private static String readContents(InputStream is, String charset, int maxKbytes) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1000 * maxKbytes);
        IO.copy((InputStream)is, (OutputStream)bout, (int)(1000 * maxKbytes));
        return bout.toString(charset);
    }

    public static void copyUrlContentsToFile(String urlencoded, File file) throws IOException {
        HttpClientManager.copyUrlContentsToFile(null, urlencoded, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void copyUrlContentsToFile(HTTPSession session, String urlencoded, File file) throws IOException {
        HTTPSession useSession = session;
        try {
            if (useSession == null) {
                useSession = HTTPFactory.newSession((String)urlencoded);
            }
            HTTPMethod m = HTTPFactory.Get((HTTPSession)useSession, (String)urlencoded);
            m.setCompression("gzip,deflate");
            int status = m.execute();
            if (status != 200) {
                throw new IOException(urlencoded + ": failed status = " + status);
            }
            Optional encodingOpt = m.getResponseHeaderValue("content-encoding");
            if (encodingOpt.isPresent()) {
                String encoding = (String)encodingOpt.get();
                if ("deflate".equals(encoding)) {
                    BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseAsStream()), 10000);
                    IO.writeToFile((InputStream)is, (String)file.getPath());
                    return;
                }
                if ("gzip".equals(encoding)) {
                    BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseAsStream()), 10000);
                    IO.writeToFile((InputStream)is, (String)file.getPath());
                    return;
                }
            }
            IO.writeToFile((InputStream)m.getResponseAsStream(), (String)file.getPath());
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
    }

    public static long appendUrlContentsToFile(String urlencoded, File file, long start, long end) throws IOException {
        return HttpClientManager.appendUrlContentsToFile(null, urlencoded, file, start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static long appendUrlContentsToFile(HTTPSession session, String urlencoded, File file, long start, long end) throws IOException {
        long nbytes;
        HTTPSession useSession = session;
        try {
            if (useSession == null) {
                useSession = HTTPFactory.newSession((String)urlencoded);
            }
            try (HTTPMethod m = HTTPFactory.Get((HTTPSession)useSession, (String)urlencoded);){
                m.setCompression("gzip,deflate");
                m.setRange(start, end);
                int status = m.execute();
                if (status != 200 && status != 206) {
                    throw new RuntimeException("failed status = " + status);
                }
                Optional encodingOpt = m.getResponseHeaderValue("content-encoding");
                if (encodingOpt.isPresent()) {
                    String encoding = (String)encodingOpt.get();
                    if ("deflate".equals(encoding)) {
                        BufferedInputStream is = new BufferedInputStream(new InflaterInputStream(m.getResponseAsStream()), 10000);
                        nbytes = IO.appendToFile((InputStream)is, (String)file.getPath());
                    } else if ("gzip".equals(encoding)) {
                        BufferedInputStream is = new BufferedInputStream(new GZIPInputStream(m.getResponseAsStream()), 10000);
                        nbytes = IO.appendToFile((InputStream)is, (String)file.getPath());
                    }
                }
                nbytes = IO.appendToFile((InputStream)m.getResponseAsStream(), (String)file.getPath());
            }
        }
        finally {
            if (session == null && useSession != null) {
                useSession.close();
            }
        }
        return nbytes;
    }
}

