/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ui.ToolsUI;

public class BuildInfo {
    private static final Logger log = LoggerFactory.getLogger(BuildInfo.class);
    private final String version;
    private final String timestamp;

    BuildInfo(String version, String timestamp) {
        this.version = version;
        this.timestamp = timestamp;
    }

    public String getVersion() {
        return this.version;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    static BuildInfo getToolsUIBuildInfo() {
        Properties buildProps = new Properties();
        try (InputStream stream = ToolsUI.class.getClassLoader().getResourceAsStream("toolsui.properties");){
            buildProps.load(stream);
        }
        catch (IOException e) {
            log.error("Error reading build properties");
        }
        return new BuildInfo(buildProps.getProperty("toolsui.version", "Unknown"), buildProps.getProperty("toolsui.buildTimestamp", "Unknown"));
    }
}

