/*
 * Decompiled with CFR 0.152.
 */
package thredds.ui.monitor;

import com.github.lgooddatepicker.components.DateTimePicker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import thredds.logs.LogReader;
import thredds.logs.ServletLogParser;
import thredds.ui.monitor.DnsLookup;
import thredds.ui.monitor.LogLocalManager;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class ServletLogTable
extends JPanel {
    private final PreferencesExt prefs;
    private final BeanTable<ServletLogParser.ServletLog> logTable;
    private final BeanTable<Uptime> uptimeTable;
    private final BeanTable<Merge> mergeTable;
    private final BeanTable<Merge> undoneTable;
    private final BeanTable<ServletLogParser.ServletLog> miscTable;
    private ArrayList<ServletLogParser.ServletLog> completeLogs;
    private boolean calcMerge = true;
    private final JTabbedPane tabbedPanel;
    private final JSplitPane split;
    private final TextHistoryPane infoTA;
    private final IndependentWindow infoWindow;
    private final DateTimePicker dateTimePickerStart;
    private final DateTimePicker dateTimePickerEnd;
    private LogLocalManager manager;
    private List<LogLocalManager.FileDateRange> logFiles;
    private MergeFilter currFilter;

    public ServletLogTable(DateTimePicker dateTimePickerStart, DateTimePicker dateTimePickerEnd, PreferencesExt prefs, final DnsLookup dnsLookup) {
        this.dateTimePickerStart = dateTimePickerStart;
        this.dateTimePickerEnd = dateTimePickerEnd;
        this.prefs = prefs;
        this.logTable = new BeanTable(ServletLogParser.ServletLog.class, (PreferencesExt)prefs.node("Logs"), false);
        this.logTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LogReader.Log log = (LogReader.Log)ServletLogTable.this.logTable.getSelectedBean();
                if (log == null) {
                    return;
                }
                ServletLogTable.this.infoTA.setText(log.toString());
                ServletLogTable.this.infoWindow.show();
            }
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.logTable.getJTable(), "Options");
        varPopup.addAction("DNS Lookup", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LogReader.Log log = (LogReader.Log)ServletLogTable.this.logTable.getSelectedBean();
                if (log == null) {
                    return;
                }
                try {
                    ServletLogTable.this.infoTA.setText(log.getIp() + " = " + dnsLookup.reverseDNS(log.getIp()));
                }
                catch (Exception ee) {
                    ServletLogTable.this.infoTA.setTextFromStackTrace((Throwable)ee);
                }
                ServletLogTable.this.infoWindow.show();
            }
        });
        this.uptimeTable = new BeanTable(Uptime.class, (PreferencesExt)prefs.node("UptimeTable"), false);
        this.uptimeTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Uptime uptime = (Uptime)ServletLogTable.this.uptimeTable.getSelectedBean();
                if (uptime == null) {
                    return;
                }
                ServletLogTable.this.mergeTable.setBeans(ServletLogTable.this.filter(uptime.mergeList));
            }
        });
        this.mergeTable = new BeanTable(Merge.class, (PreferencesExt)prefs.node("MergeTable"), false);
        this.mergeTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Merge m = (Merge)ServletLogTable.this.mergeTable.getSelectedBean();
                if (m == null) {
                    return;
                }
                ServletLogTable.this.infoTA.setText(m.toString());
                ServletLogTable.this.infoWindow.show();
            }
        });
        PopupMenu varPopupM = new PopupMenu((JComponent)this.mergeTable.getJTable(), "Options");
        varPopupM.addAction("DNS Lookup", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Merge m = (Merge)ServletLogTable.this.mergeTable.getSelectedBean();
                if (m == null) {
                    return;
                }
                try {
                    ServletLogTable.this.infoTA.setText(m.getIp() + " = " + dnsLookup.reverseDNS(m.getIp()));
                }
                catch (Exception ee) {
                    ServletLogTable.this.infoTA.setTextFromStackTrace((Throwable)ee);
                }
                ServletLogTable.this.infoWindow.show();
            }
        });
        varPopupM.addAction("Remove selected logs", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List all = ServletLogTable.this.mergeTable.getBeans();
                List selected = ServletLogTable.this.mergeTable.getSelectedBeans();
                all.removeAll(selected);
                ServletLogTable.this.mergeTable.setBeans(all);
            }
        });
        this.undoneTable = new BeanTable(Merge.class, (PreferencesExt)prefs.node("UndoneTable"), false);
        this.undoneTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Merge m = (Merge)ServletLogTable.this.undoneTable.getSelectedBean();
                if (m == null) {
                    return;
                }
                ServletLogTable.this.infoTA.setText(m.toString());
                ServletLogTable.this.infoWindow.show();
            }
        });
        this.miscTable = new BeanTable(ServletLogParser.ServletLog.class, (PreferencesExt)prefs.node("Logs"), false);
        this.miscTable.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LogReader.Log log = (LogReader.Log)ServletLogTable.this.miscTable.getSelectedBean();
                if (log == null) {
                    return;
                }
                ServletLogTable.this.infoTA.setText(log.toString());
                ServletLogTable.this.infoWindow.show();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 100)));
        this.split = new JSplitPane(0, false, (Component)this.uptimeTable, (Component)this.mergeTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.tabbedPanel = new JTabbedPane(1);
        this.tabbedPanel.addTab("LogTable", (Component)this.logTable);
        this.tabbedPanel.addTab("Merge", this.split);
        this.tabbedPanel.addTab("Undone", (Component)this.undoneTable);
        this.tabbedPanel.addTab("Misc", (Component)this.miscTable);
        this.tabbedPanel.setSelectedIndex(0);
        this.tabbedPanel.addChangeListener(e -> {
            String title;
            int idx = this.tabbedPanel.getSelectedIndex();
            switch (title = this.tabbedPanel.getTitleAt(idx)) {
                case "Merge": {
                    this.calcMergeLogs(this.completeLogs);
                    break;
                }
                case "Undone": {
                    this.calcMergeLogs(this.completeLogs);
                    break;
                }
                case "Misc": {
                    this.calcMergeLogs(this.completeLogs);
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.tabbedPanel, "Center");
    }

    public void exit() {
        this.logTable.saveState(false);
        this.mergeTable.saveState(false);
        this.undoneTable.saveState(false);
        this.uptimeTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public void setLocalManager(LogLocalManager manager) {
        this.manager = manager;
    }

    public void showLogs(MergeFilter filter) {
        Date start = null;
        Date end = null;
        try {
            start = Date.from(this.dateTimePickerStart.getDateTimeStrict().atZone(ZoneId.systemDefault()).toInstant());
            end = Date.from(this.dateTimePickerEnd.getDateTimeStrict().atZone(ZoneId.systemDefault()).toInstant());
            this.logFiles = this.manager.getLocalFiles(start, end);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logFiles = this.manager.getLocalFiles(null, null);
        }
        this.currFilter = start != null && end != null ? new DateFilter(start.getTime(), end.getTime(), filter) : filter;
        LogReader reader = new LogReader(new ServletLogParser());
        long startElapsed = System.nanoTime();
        LogReader.Stats stats = new LogReader.Stats();
        this.logFiles.sort(new Comparator<LogLocalManager.FileDateRange>(){

            @Override
            public int compare(LogLocalManager.FileDateRange o1, LogLocalManager.FileDateRange o2) {
                if (o1.f.getName().equals("threddsServlet.log")) {
                    return 1;
                }
                if (o2.f.getName().equals("threddsServlet.log")) {
                    return -1;
                }
                return o1.f.getName().compareTo(o2.f.getName());
            }

            private int getSeq(File f) {
                String name = f.getName();
                int pos = name.indexOf(".log") + 5;
                if (name.length() <= pos) {
                    return 0;
                }
                return Integer.parseInt(name.substring(pos));
            }
        });
        try {
            this.completeLogs = new ArrayList(30000);
            for (LogLocalManager.FileDateRange fdr : this.logFiles) {
                reader.scanLogFile(fdr.f, new MyClosure(this.completeLogs), new LogReader.FilterNoop(), stats);
            }
            int nthreads = 0;
            for (ServletLogParser.ServletLog log : this.completeLogs) {
                if (log.isStart()) {
                    ++nthreads;
                }
                if (log.isDone() && nthreads > 0) {
                    --nthreads;
                }
                log.setNthreads(nthreads);
            }
            this.logTable.setBeans(this.completeLogs);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        long elapsedTime = System.nanoTime() - startElapsed;
        System.out.printf(" setLogFile total= %d passed=%d%n", stats.total, stats.passed);
        System.out.printf(" elapsed=%f msecs %n", (double)elapsedTime / 1000000.0);
        this.mergeTable.setBeans(new ArrayList());
        this.undoneTable.setBeans(new ArrayList());
        this.tabbedPanel.setSelectedIndex(0);
        this.calcMerge = true;
    }

    public List<Merge> filter(List<Merge> allMerge) {
        ArrayList<Merge> result = new ArrayList<Merge>(allMerge.size());
        for (Merge m : allMerge) {
            if (!this.currFilter.pass(m)) continue;
            result.add(m);
        }
        return result;
    }

    void showInfo(Formatter f) {
        List restrict;
        f.format(" Current time =   %s%n%n", new Date().toString());
        int n = 0;
        if (this.completeLogs != null) {
            n = this.completeLogs.size();
            f.format("Complete logs n=%d%n", n);
            f.format("  first log date= %s%n", this.completeLogs.get(0).getDate());
            f.format("   last log date= %s%n", this.completeLogs.get(n - 1).getDate());
        }
        if ((restrict = this.mergeTable.getBeans()) != null && restrict.size() != n) {
            f.format("%nRestricted, merged logs n=%d%n", restrict.size());
        }
        if (this.logFiles != null) {
            f.format("%nFiles used%n", new Object[0]);
            for (LogLocalManager.FileDateRange fdr : this.logFiles) {
                f.format(" %s [%s,%s]%n", fdr.f.getName(), fdr.start, fdr.end);
            }
        }
    }

    private void calcMergeLogs(ArrayList<ServletLogParser.ServletLog> logs) {
        if (!this.calcMerge) {
            return;
        }
        if (logs == null) {
            return;
        }
        logs.sort((o1, o2) -> {
            long d1 = o1.getDateMillisec();
            long d2 = o2.getDateMillisec();
            return Long.compare(d1, d2);
        });
        ArrayList<Merge> completeMerge = new ArrayList<Merge>(logs.size() / 2 + 100);
        ArrayList<ServletLogParser.ServletLog> miscList = new ArrayList<ServletLogParser.ServletLog>(1000);
        ArrayList<Uptime> uptimeList = new ArrayList<Uptime>(10);
        ArrayList<Merge> undoneList = new ArrayList<Merge>(1000);
        ServletLogParser.ServletLog last = null;
        Uptime current = null;
        for (ServletLogParser.ServletLog log : logs) {
            if (log.getReqSeq() == 0L) continue;
            if (current == null) {
                current = new Uptime(log);
                uptimeList.add(current);
            } else if (log.getReqSeq() < 50L && last.getReqSeq() > 100L) {
                current.finish(last, undoneList);
                completeMerge.addAll(current.mergeList);
                current = new Uptime(log);
                uptimeList.add(current);
            }
            last = log;
            current.add(log, miscList);
        }
        if (current != null) {
            current.finish(last, undoneList);
            completeMerge.addAll(current.mergeList);
        }
        this.uptimeTable.setBeans(uptimeList);
        this.undoneTable.setBeans(undoneList);
        this.miscTable.setBeans(miscList);
        this.calcMerge = false;
    }

    public static class Uptime {
        private String startDate;
        private String endDate;
        private long startTime;
        private long endTime;
        private long startSeq;
        private long endSeq;
        ArrayList<Merge> mergeList;
        HashMap<Long, Merge> map;

        public int getN() {
            return this.mergeList.size();
        }

        public String getStartDate() {
            return this.startDate;
        }

        public String getEndDate() {
            return this.endDate;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public long getEndTime() {
            return this.endTime;
        }

        public long getStartSeq() {
            return this.startSeq;
        }

        public long getEndSeq() {
            return this.endSeq;
        }

        public Uptime() {
        }

        public Uptime(ServletLogParser.ServletLog log) {
            this.startSeq = log.getReqSeq();
            this.startTime = log.getReqTime();
            this.startDate = log.getDate();
            int n = 10000;
            this.mergeList = new ArrayList(n);
            this.map = new HashMap(n);
        }

        void add(ServletLogParser.ServletLog log, ArrayList<ServletLogParser.ServletLog> miscList) {
            if (log.isStart()) {
                Merge merge = new Merge(log);
                this.map.put(log.getReqSeq(), merge);
            } else if (log.isDone()) {
                Merge merge = this.map.get(log.getReqSeq());
                if (merge != null) {
                    merge.setDone(log);
                    this.mergeList.add(merge);
                    this.map.remove(log.getReqSeq());
                } else {
                    miscList.add(log);
                }
            } else {
                Merge merge = this.map.get(log.getReqSeq());
                if (merge != null) {
                    merge.add(log);
                } else {
                    miscList.add(log);
                }
            }
        }

        void finish(ServletLogParser.ServletLog log, ArrayList<Merge> undoneList) {
            this.endSeq = log.getReqSeq();
            this.endTime = log.getReqTime();
            this.endDate = log.getDate();
            undoneList.addAll(this.map.values());
            this.map = null;
        }
    }

    public static class Merge {
        ArrayList<ServletLogParser.ServletLog> logs = new ArrayList(2);
        ServletLogParser.ServletLog start;
        ServletLogParser.ServletLog done;
        String level;
        StringBuilder extra;

        public long getReqTime() {
            return this.start.getReqTime();
        }

        public long getReqSeq() {
            return this.start.getReqSeq();
        }

        public String getLevel() {
            return this.level;
        }

        public boolean isExtra() {
            return this.extra != null;
        }

        public String getIp() {
            return this.start.getIp();
        }

        public String getDate() {
            return this.start.getDate();
        }

        public int getStatus() {
            return this.done == null ? -1 : this.done.getStatus();
        }

        public long getMsecs() {
            return this.done == null ? -1L : this.done.getMsecs();
        }

        public long getBytes() {
            return this.done == null ? -1L : this.done.getBytes();
        }

        public String getPath() {
            return this.start.getPath();
        }

        public Merge() {
        }

        Merge(ServletLogParser.ServletLog start) {
            this.start = start;
            this.add(start);
        }

        void setDone(ServletLogParser.ServletLog done) {
            this.done = done;
            this.add(done);
        }

        void add(ServletLogParser.ServletLog log) {
            this.logs.add(log);
            if (!log.getLevel().equals("INFO")) {
                this.level = log.getLevel();
            }
            if (log.extra != null) {
                this.extra = log.extra;
            }
        }

        public String toString() {
            Formatter f = new Formatter();
            for (ServletLogParser.ServletLog log : this.logs) {
                f.format("%s%n", log);
            }
            return f.toString();
        }
    }

    private static class MyClosure
    implements LogReader.Closure {
        ArrayList<ServletLogParser.ServletLog> logs;

        MyClosure(ArrayList<ServletLogParser.ServletLog> logs) {
            this.logs = logs;
        }

        @Override
        public void process(LogReader.Log log) {
            if (log instanceof ServletLogParser.ServletLog) {
                this.logs.add((ServletLogParser.ServletLog)log);
            } else {
                System.out.printf("NULL LOG%n", new Object[0]);
            }
        }
    }

    public static class ErrorOnlyFilter
    implements MergeFilter {
        MergeFilter chain;

        public ErrorOnlyFilter(MergeFilter chain) {
            this.chain = chain;
        }

        @Override
        public boolean pass(Merge log) {
            if (this.chain != null && !this.chain.pass(log)) {
                return false;
            }
            int status = log.getStatus();
            return status >= 400 && status < 1000;
        }
    }

    public static class IpFilter
    implements MergeFilter {
        String[] match;
        MergeFilter chain;

        public IpFilter(String[] match, MergeFilter chain) {
            this.match = match;
            this.chain = chain;
        }

        @Override
        public boolean pass(Merge log) {
            if (this.chain != null && !this.chain.pass(log)) {
                return false;
            }
            for (String s : this.match) {
                if (!log.getIp().startsWith(s)) continue;
                return false;
            }
            return true;
        }
    }

    private static class DateFilter
    implements MergeFilter {
        long start;
        long end;
        MergeFilter chain;

        public DateFilter(long start, long end, MergeFilter chain) {
            this.start = start;
            this.end = end;
            this.chain = chain;
        }

        @Override
        public boolean pass(Merge log) {
            if (this.chain != null && !this.chain.pass(log)) {
                return false;
            }
            return log.start.date >= this.start && log.start.date <= this.end;
        }
    }

    static interface MergeFilter {
        public boolean pass(Merge var1);
    }
}

