/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import ucar.ui.util.Resource;
import ucar.ui.widget.BAMutil;

public class ToolsAboutWindow
extends JWindow {
    public ToolsAboutWindow(JFrame parent) {
        super(parent);
        Point location;
        JLabel lab1 = new JLabel("<html> <body bgcolor=\"#FFECEC\"> <center><h1>Netcdf Tools User Interface (ToolsUI)</h1><b>" + this.getVersion() + "</b><br><i>https://www.unidata.ucar.edu/software/netcdf-java/</i><br><b><i>Developers:</b> John Caron, Sean Arms</i></b></center><br><br>With thanks to these <b>Open Source</b> contributors:<ul><li><b>ADDE/VisAD</b>: Bill Hibbard, Don Murray, Tom Whittaker, et al (http://visad.ssec.wisc.edu/)</li><li><b>Apache HTTP Components</b> libraries: (http://hc.apache.org/)</li><li><b>Guava</b> library: Google (https://github.com/google/guava)</li><li><b>IDV:</b> Yuan Ho, Julien Chastang, Don Murray, Jeff McWhirter (https://www.unidata.ucar.edu/software/IDV/)</li><li><b>Java Native Access (JNA)</b> Todd Fast and Timothy Wall et al. (https://github.com/java-native-access/jna)</li><li><b>Joda Time</b> library: Stephen Colebourne (http://www.joda.org/joda-time/)</li><li><b>JDOM</b> library: Jason Hunter, Brett McLaughlin et al (www.jdom.org)</li><li><b>JGoodies</b> library: Karsten Lentzsch (www.jgoodies.com)</li><li><b>JPEG-2000</b> Java library: (http://www.jpeg.org/jpeg2000/)</li><li><b>JUnit</b> library: Erich Gamma, Kent Beck, Erik Meade, et al (http://sourceforge.net/projects/junit/)</li><li><b>NetCDF C Library</b> library: Russ Rew, Ward Fisher, Dennis Heimbinger</li><li><b>OPeNDAP Java</b> library: Dennis Heimbinger, James Gallagher, Nathan Potter, Don Denbo, et. al.(http://opendap.org)</li><li><b>Protobuf serialization</b> library: Google (https://developers.google.com/protocol-buffers)</li><li><b>Simple Logging Facade for Java</b> library: Ceki Gulcu (http://www.slf4j.org/)</li><li><b>Udunits:</b>: Steve Emmerson</li></ul><center>Special thanks to <b>Sun/Oracle/OpenJDK</b> for the platform on which we stand.</center></body></html> ");
        JPanel main = new JPanel(new BorderLayout());
        main.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        main.setBackground(new Color(0xFFECEC));
        JLabel ring = new JLabel(new ImageIcon(BAMutil.getImage((String)"nj22/NetcdfUI")));
        ring.setOpaque(true);
        ring.setBackground(new Color(0xFFECEC));
        JLabel threddsLogo = new JLabel(Resource.getIcon((String)(BAMutil.getResourcePath() + "nj22/Cdm.png"), (boolean)false));
        threddsLogo.setBackground(new Color(0xFFECEC));
        threddsLogo.setOpaque(true);
        main.add((Component)threddsLogo, "North");
        main.add((Component)lab1, "Center");
        main.add((Component)ring, "South");
        this.getContentPane().add(main);
        this.pack();
        Dimension labelSize = this.getPreferredSize();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        if (gc != null) {
            Rectangle gcrect = gc.getBounds();
            location = new Point(gcrect.x + gcrect.width / 2 - labelSize.width / 2, gcrect.y + gcrect.height / 2 - labelSize.height / 2);
        } else {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            location = new Point(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        }
        this.setLocation(location);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ToolsAboutWindow.this.setVisible(false);
            }
        });
        this.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getVersion() {
        try (InputStream is = Resource.getFileResource((String)"/README");){
            if (is == null) {
                String string = "6.0";
                return string;
            }
            BufferedReader dataIS = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            StringBuilder sbuff = new StringBuilder();
            for (int i = 0; i < 3; ++i) {
                sbuff.append(dataIS.readLine());
                sbuff.append("<br>");
            }
            String version = sbuff.toString();
            return version;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return "version unknown";
        }
    }
}

