/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.coverage2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EtchedBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ui.coverage2.CoverageRenderer;
import ucar.nc2.ui.coverage2.CoverageTable;
import ucar.nc2.ui.coverage2.DataState;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.nc2.ui.geoloc.ProjectionManager;
import ucar.nc2.ui.gis.MapBean;
import ucar.nc2.ui.grid.ColorScale;
import ucar.nc2.ui.util.NamedObjects;
import ucar.nc2.ui.util.Renderer;
import ucar.ui.event.ActionCoordinator;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.event.ActionValueEvent;
import ucar.ui.prefs.Debug;
import ucar.ui.util.NamedObject;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.MFlowLayout;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.SuperComboBox;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.util.prefs.PreferencesExt;

public class CoverageViewer
extends JPanel {
    private static final Logger log = LoggerFactory.getLogger(CoverageViewer.class);
    private static final int DELAY_DRAW_AFTER_DATA_EVENT = 250;
    private static final String LastMapAreaName = "LastMapArea";
    private static final String LastProjectionName = "LastProjection";
    private static final String ColorScaleName = "ColorScale";
    private final PreferencesExt store;
    private ColorScale colorScale;
    private ColorScale.Panel colorScalePanel;
    private List<Chooser> choosers;
    private SuperComboBox fieldChooser;
    private SuperComboBox levelChooser;
    private SuperComboBox timeChooser;
    private SuperComboBox ensembleChooser;
    private SuperComboBox runtimeChooser;
    private JLabel dataValueLabel;
    private NavigatedPanel navPanel;
    private TextHistoryPane datasetInfoTA;
    private JPanel drawingPanel;
    private JComboBox csDataMinMax;
    private PopupMenu mapBeanMenu;
    private JSpinner strideSpinner;
    private final JLabel datasetNameLabel = new JLabel();
    private ProjectionManager projManager;
    private IndependentWindow infoWindow;
    private JPanel fieldPanel;
    private JPanel toolPanel;
    private JToolBar navToolbar;
    private JToolBar moveToolbar;
    private AbstractAction navToolbarAction;
    private AbstractAction moveToolbarAction;
    private AbstractAction redrawAction;
    private AbstractAction showDatasetInfoAction;
    private AbstractAction minmaxHorizAction;
    private AbstractAction minmaxLogAction;
    private AbstractAction minmaxHoldAction;
    private AbstractAction fieldLoopAction;
    private AbstractAction levelLoopAction;
    private AbstractAction timeLoopAction;
    private AbstractAction runtimeLoopAction;
    private AbstractAction chooseProjectionAction;
    private AbstractAction saveCurrentProjectionAction;
    private AbstractAction dataProjectionAction;
    private AbstractAction drawBBAction;
    private AbstractAction showGridAction;
    private AbstractAction showContoursAction;
    private AbstractAction showContourLabelsAction;
    private AbstractAction drawHorizAction;
    private AbstractAction drawVertAction;
    private DataState dataState;
    private CoverageCollection coverageDataset;
    private Coverage currentField;
    private Projection project;
    private List<NamedObject> levelNames;
    private List<NamedObject> timeNames;
    private List<NamedObject> ensembleNames;
    private List<NamedObject> runtimeNames;
    private int currentLevel;
    private int currentTime;
    private int currentEnsemble;
    private int currentRunTime;
    private boolean drawHorizOn = true;
    private boolean drawVertOn;
    private boolean eventsOK = true;
    private final Color mapColor = Color.black;
    private int mapBeanCount;
    private final AffineTransform atI = new AffineTransform();
    private Renderer mapRenderer;
    private CoverageRenderer coverageRenderer;
    private Timer redrawTimer;
    private boolean startOK = true;

    public CoverageViewer(PreferencesExt pstore, RootPaneContainer root, FileManager fileChooser, int defaultHeight) {
        this.store = pstore;
        try {
            this.choosers = new ArrayList<Chooser>();
            this.fieldChooser = new SuperComboBox(root, "field", true, null);
            this.choosers.add(new Chooser("field", this.fieldChooser, true));
            this.levelChooser = new SuperComboBox(root, "level", false, null);
            this.choosers.add(new Chooser("level", this.levelChooser, false));
            this.timeChooser = new SuperComboBox(root, "time", false, null);
            this.choosers.add(new Chooser("time", this.timeChooser, false));
            this.ensembleChooser = new SuperComboBox(root, "ensemble", false, null);
            this.choosers.add(new Chooser("ensemble", this.ensembleChooser, false));
            this.runtimeChooser = new SuperComboBox(root, "runtime", false, null);
            this.choosers.add(new Chooser("runtime", this.runtimeChooser, false));
            Object bean = this.store.getBean(ColorScaleName, null);
            this.colorScale = !(bean instanceof ColorScale) ? new ColorScale("default") : (ColorScale)this.store.getBean(ColorScaleName, null);
            this.colorScalePanel = new ColorScale.Panel(this, this.colorScale);
            this.csDataMinMax = new JComboBox<ColorScale.MinMaxType>(ColorScale.MinMaxType.values());
            this.csDataMinMax.setToolTipText("ColorScale Min/Max setting");
            this.csDataMinMax.addActionListener(e -> {
                this.coverageRenderer.setDataMinMaxType((ColorScale.MinMaxType)((Object)((Object)this.csDataMinMax.getSelectedItem())));
                this.redrawLater();
            });
            this.coverageRenderer = new CoverageRenderer(this.store);
            this.coverageRenderer.setColorScale(this.colorScale);
            this.strideSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
            this.strideSpinner.addChangeListener(e -> {
                Integer val = (Integer)this.strideSpinner.getValue();
                this.coverageRenderer.setHorizStride(val);
            });
            this.makeActionsDataset();
            this.makeActionsToolbars();
            this.makeActions();
            this.makeEventManagement();
            this.toolPanel = new JPanel();
            this.toolPanel.setBorder(new EtchedBorder());
            this.toolPanel.setLayout((LayoutManager)new MFlowLayout(0, 0, 0));
            JMenu dataMenu = new JMenu("Dataset");
            dataMenu.setMnemonic('D');
            JMenu configMenu = new JMenu("Configure");
            configMenu.setMnemonic('C');
            JMenu toolMenu = new JMenu("Controls");
            toolMenu.setMnemonic('T');
            JMenuBar menuBar = new JMenuBar();
            menuBar.add(dataMenu);
            menuBar.add(configMenu);
            menuBar.add(toolMenu);
            this.toolPanel.add(menuBar);
            this.fieldPanel = new JPanel();
            this.fieldPanel.setLayout(new FlowLayout(0, 0, 0));
            this.toolPanel.add(this.fieldPanel);
            this.toolPanel.add(this.strideSpinner);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.drawHorizAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.drawVertAction);
            this.mapBeanMenu = MapBean.makeMapSelectButton();
            this.toolPanel.add(this.mapBeanMenu.getParentComponent());
            this.navPanel = new NavigatedPanel();
            this.navPanel.setLayout(new FlowLayout());
            ProjectionRect ma = (ProjectionRect)this.store.getBean(LastMapAreaName, null);
            if (ma != null) {
                this.navPanel.setMapArea(ma);
            }
            this.navToolbar = this.navPanel.getNavToolBar();
            this.moveToolbar = this.navPanel.getMoveToolBar();
            if (((Boolean)this.navToolbarAction.getValue("state")).booleanValue()) {
                this.toolPanel.add(this.navToolbar);
            }
            if (((Boolean)this.moveToolbarAction.getValue("state")).booleanValue()) {
                this.toolPanel.add(this.moveToolbar);
            }
            this.makeNavPanelWiring();
            this.addActionsToMenus(dataMenu, configMenu, toolMenu);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.navPanel.setReferenceAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.dataProjectionAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.showGridAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.drawBBAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.redrawAction);
            this.drawingPanel = new JPanel(new BorderLayout());
            JPanel statusPanel = new JPanel(new BorderLayout());
            statusPanel.setBorder(new EtchedBorder());
            JLabel positionLabel = new JLabel("position");
            positionLabel.setToolTipText("position at cursor");
            this.dataValueLabel = new JLabel("data value", 0);
            this.dataValueLabel.setToolTipText("data value (double click on grid)");
            statusPanel.add((Component)positionLabel, "West");
            statusPanel.add((Component)this.dataValueLabel, "Center");
            this.navPanel.setPositionLabel(positionLabel);
            JPanel westPanel = new JPanel(new BorderLayout());
            westPanel.add((Component)this.colorScalePanel, "Center");
            westPanel.add((Component)this.csDataMinMax, "North");
            JPanel northPanel = new JPanel();
            northPanel.setLayout(new BorderLayout());
            northPanel.add((Component)this.datasetNameLabel, "North");
            northPanel.add((Component)this.toolPanel, "South");
            this.setLayout(new BorderLayout());
            this.add((Component)northPanel, "North");
            this.add((Component)statusPanel, "South");
            this.add((Component)westPanel, "West");
            this.add((Component)this.drawingPanel, "Center");
            this.setDrawHorizAndVert(this.drawHorizOn, this.drawVertOn);
            this.project = (Projection)this.store.getBean(LastProjectionName, null);
            if (this.project != null) {
                this.setProjection(this.project);
            }
            this.redrawTimer = new Timer(0, e -> {
                SwingUtilities.invokeLater(() -> this.draw(false));
                this.redrawTimer.stop();
            });
            this.redrawTimer.setInitialDelay(250);
            this.redrawTimer.setRepeats(false);
        }
        catch (Exception e2) {
            System.out.println("UI creation failed");
            e2.printStackTrace();
        }
    }

    private void makeActionsDataset() {
        this.chooseProjectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageViewer.this.getProjectionManager().setVisible();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.chooseProjectionAction, null, (String)"Projection Manager...", (boolean)false, (int)80, (int)0);
        this.saveCurrentProjectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageViewer.this.getProjectionManager();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.saveCurrentProjectionAction, null, (String)"save Current Projection", (boolean)false, (int)83, (int)0);
        this.redrawAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageViewer.this.repaint();
                CoverageViewer.this.start(true);
                CoverageViewer.this.draw(true);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.redrawAction, (String)"alien", (String)"RedRaw", (boolean)false, (int)87, (int)0);
        this.showDatasetInfoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CoverageViewer.this.infoWindow == null) {
                    CoverageViewer.this.datasetInfoTA = new TextHistoryPane();
                    CoverageViewer.this.infoWindow = new IndependentWindow("Dataset Information", BAMutil.getImage((String)"nj22/GDVs"), (Component)CoverageViewer.this.datasetInfoTA);
                    CoverageViewer.this.infoWindow.setSize(700, 700);
                    CoverageViewer.this.infoWindow.setLocation(100, 100);
                }
                CoverageViewer.this.datasetInfoTA.clear();
                if (CoverageViewer.this.coverageDataset != null) {
                    Formatter f = new Formatter();
                    CoverageViewer.this.coverageDataset.toString(f);
                    CoverageViewer.this.datasetInfoTA.appendLine(f.toString());
                } else {
                    CoverageViewer.this.datasetInfoTA.appendLine("No coverageDataset loaded");
                }
                CoverageViewer.this.datasetInfoTA.gotoTop();
                CoverageViewer.this.infoWindow.show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showDatasetInfoAction, (String)"Information", (String)"Show info...", (boolean)false, (int)83, (int)-1);
        this.minmaxHorizAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageViewer.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.horiz);
                CoverageViewer.this.setDataMinMaxType(ColorScale.MinMaxType.horiz);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.minmaxHorizAction, null, (String)"Horizontal plane", (boolean)false, (int)72, (int)0);
        this.minmaxLogAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageViewer.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.log);
                CoverageViewer.this.setDataMinMaxType(ColorScale.MinMaxType.log);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.minmaxLogAction, null, (String)"log horiz plane", (boolean)false, (int)86, (int)0);
        this.minmaxHoldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageViewer.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.hold);
                CoverageViewer.this.setDataMinMaxType(ColorScale.MinMaxType.hold);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.minmaxHoldAction, null, (String)"Hold scale constant", (boolean)false, (int)67, (int)0);
        this.fieldLoopAction = new LoopControlAction(this.fieldChooser);
        this.levelLoopAction = new LoopControlAction(this.levelChooser);
        this.timeLoopAction = new LoopControlAction(this.timeChooser);
        this.runtimeLoopAction = new LoopControlAction(this.runtimeChooser);
    }

    private void makeActionsToolbars() {
        this.navToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    CoverageViewer.this.toolPanel.add(CoverageViewer.this.navToolbar);
                } else {
                    CoverageViewer.this.toolPanel.remove(CoverageViewer.this.navToolbar);
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.navToolbarAction, (String)"MagnifyPlus", (String)"show Navigate toolbar", (boolean)true, (int)77, (int)0);
        this.navToolbarAction.putValue("state", this.store.getBoolean("navToolbarAction", true));
        this.moveToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    CoverageViewer.this.toolPanel.add(CoverageViewer.this.moveToolbar);
                } else {
                    CoverageViewer.this.toolPanel.remove(CoverageViewer.this.moveToolbar);
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.moveToolbarAction, (String)"Up", (String)"show Move toolbar", (boolean)true, (int)77, (int)0);
        this.moveToolbarAction.putValue("state", this.store.getBoolean("moveToolbarAction", true));
    }

    private void makeActions() {
        this.dataProjectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    Projection dataProjection = CoverageViewer.this.coverageRenderer.getDataProjection();
                    if (null != dataProjection) {
                        CoverageViewer.this.setProjection(dataProjection);
                    }
                } else {
                    CoverageViewer.this.setProjection((Projection)new LatLonProjection());
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.dataProjectionAction, (String)"nj22/DataProjection", (String)"use Data Projection", (boolean)true, (int)68, (int)0);
        this.dataProjectionAction.putValue("state", true);
        this.drawBBAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoverageViewer.this.coverageRenderer.setDrawBB(state);
                CoverageViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.drawBBAction, (String)"nj22/Contours", (String)"draw bounding box", (boolean)true, (int)66, (int)0);
        this.drawBBAction.putValue("state", false);
        this.drawHorizAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageViewer.this.drawHorizOn = (Boolean)this.getValue("state");
                CoverageViewer.this.setDrawHorizAndVert(CoverageViewer.this.drawHorizOn, CoverageViewer.this.drawVertOn);
                CoverageViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.drawHorizAction, (String)"nj22/DrawHoriz", (String)"draw horizontal", (boolean)true, (int)72, (int)0);
        boolean state = this.store.getBoolean("drawHorizAction", true);
        this.drawHorizAction.putValue("state", state);
        this.drawHorizOn = state;
        this.drawVertAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoverageViewer.this.drawVertOn = (Boolean)this.getValue("state");
                CoverageViewer.this.setDrawHorizAndVert(CoverageViewer.this.drawHorizOn, CoverageViewer.this.drawVertOn);
                CoverageViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.drawVertAction, (String)"nj22/DrawVert", (String)"draw vertical", (boolean)true, (int)86, (int)0);
        state = this.store.getBoolean("drawVertAction", false);
        this.drawVertAction.putValue("state", state);
        this.drawVertOn = state;
        this.showGridAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoverageViewer.this.coverageRenderer.setDrawGridLines(state);
                CoverageViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showGridAction, (String)"nj22/Grid", (String)"show grid lines", (boolean)true, (int)71, (int)0);
        state = this.store.getBoolean("showGridAction", false);
        this.showGridAction.putValue("state", state);
        this.coverageRenderer.setDrawGridLines(state);
        this.showContoursAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoverageViewer.this.coverageRenderer.setDrawContours(state);
                CoverageViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showContoursAction, (String)"nj22/Contours", (String)"show contours", (boolean)true, (int)67, (int)0);
        state = this.store.getBoolean("showContoursAction", false);
        this.showContoursAction.putValue("state", state);
        this.coverageRenderer.setDrawContours(state);
        this.showContourLabelsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                CoverageViewer.this.coverageRenderer.setDrawContourLabels(state);
                CoverageViewer.this.draw(false);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showContourLabelsAction, (String)"nj22/ContourLabels", (String)"show contour labels", (boolean)true, (int)76, (int)0);
        state = this.store.getBoolean("showContourLabelsAction", false);
        this.showContourLabelsAction.putValue("state", state);
        this.coverageRenderer.setDrawContourLabels(state);
    }

    private void makeEventManagement() {
        String actionName = "field";
        ActionCoordinator fieldCoordinator = new ActionCoordinator(actionName);
        fieldCoordinator.addActionSourceListener(this.fieldChooser.getActionSourceListener());
        ActionSourceListener fieldSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                if (CoverageViewer.this.setField(e.getValue())) {
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        CoverageViewer.this.draw(true);
                    } else {
                        CoverageViewer.this.redrawLater();
                    }
                }
            }
        };
        fieldCoordinator.addActionSourceListener(fieldSource);
        actionName = "level";
        ActionCoordinator levelCoordinator = new ActionCoordinator(actionName);
        levelCoordinator.addActionSourceListener(this.levelChooser.getActionSourceListener());
        ActionSourceListener levelSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                int level = CoverageViewer.this.findIndexFromName(CoverageViewer.this.levelNames, e.getValue().toString());
                if (level != -1 && level != CoverageViewer.this.currentLevel) {
                    CoverageViewer.this.currentLevel = level;
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        CoverageViewer.this.draw(true);
                    } else {
                        CoverageViewer.this.redrawLater();
                    }
                }
            }
        };
        levelCoordinator.addActionSourceListener(levelSource);
        actionName = "time";
        ActionCoordinator timeCoordinator = new ActionCoordinator(actionName);
        timeCoordinator.addActionSourceListener(this.timeChooser.getActionSourceListener());
        ActionSourceListener timeSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                int time = CoverageViewer.this.findIndexFromName(CoverageViewer.this.timeNames, e.getValue().toString());
                if (time != -1 && time != CoverageViewer.this.currentTime) {
                    CoverageViewer.this.currentTime = time;
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        CoverageViewer.this.draw(true);
                    } else {
                        CoverageViewer.this.redrawLater();
                    }
                }
            }
        };
        timeCoordinator.addActionSourceListener(timeSource);
        actionName = "runtime";
        ActionCoordinator runtimeCoordinator = new ActionCoordinator(actionName);
        runtimeCoordinator.addActionSourceListener(this.runtimeChooser.getActionSourceListener());
        ActionSourceListener runtimeSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                int runtime = CoverageViewer.this.findIndexFromName(CoverageViewer.this.runtimeNames, e.getValue().toString());
                if (runtime != -1 && runtime != CoverageViewer.this.currentRunTime) {
                    CoverageViewer.this.currentRunTime = runtime;
                    if (((CoverageViewer)CoverageViewer.this).dataState.taxis2D != null) {
                        ((CoverageViewer)CoverageViewer.this).dataState.taxis = ((CoverageViewer)CoverageViewer.this).dataState.taxis2D.getTimeAxisForRun(CoverageViewer.this.currentRunTime);
                        CoverageViewer.this.timeNames = NamedObjects.getNames(((CoverageViewer)CoverageViewer.this).dataState.taxis);
                        CoverageViewer.this.timeChooser.setCollection(CoverageViewer.this.timeNames.iterator());
                        if (CoverageViewer.this.currentTime >= CoverageViewer.this.timeNames.size()) {
                            CoverageViewer.this.currentTime = 0;
                        }
                        CoverageViewer.this.timeChooser.setSelectedByIndex(CoverageViewer.this.currentTime);
                    }
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        CoverageViewer.this.draw(true);
                    } else {
                        CoverageViewer.this.redrawLater();
                    }
                }
            }
        };
        runtimeCoordinator.addActionSourceListener(runtimeSource);
        actionName = "ensemble";
        ActionCoordinator ensembleCoordinator = new ActionCoordinator(actionName);
        ensembleCoordinator.addActionSourceListener(this.ensembleChooser.getActionSourceListener());
        ActionSourceListener ensembleSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                int ensIndex = CoverageViewer.this.findIndexFromName(CoverageViewer.this.ensembleNames, e.getValue().toString());
                if (ensIndex != -1 && ensIndex != CoverageViewer.this.currentEnsemble) {
                    CoverageViewer.this.currentEnsemble = ensIndex;
                    if (e.getActionCommand().equals("redrawImmediate")) {
                        CoverageViewer.this.draw(true);
                    } else {
                        CoverageViewer.this.redrawLater();
                    }
                }
            }
        };
        ensembleCoordinator.addActionSourceListener(ensembleSource);
    }

    private void makeNavPanelWiring() {
        this.navPanel.addNewProjectionListener(e -> {
            if (Debug.isSet((String)"event/NewProjection")) {
                System.out.println("Controller got NewProjectionEvent " + this.navPanel.getMapArea());
            }
            if (this.eventsOK && this.mapRenderer != null) {
                this.mapRenderer.setProjection(e.getProjection());
                this.coverageRenderer.setViewProjection(e.getProjection());
                this.drawH(false);
            }
        });
        this.navPanel.addNewMapAreaListener(e -> {
            if (Debug.isSet((String)"event/NewMapArea")) {
                System.out.println("Controller got NewMapAreaEvent " + this.navPanel.getMapArea());
            }
            this.drawH(false);
        });
        this.navPanel.addCursorMoveEventListener(e -> {
            String valueS = this.coverageRenderer.getXYvalueStr(e.getLocation());
            this.dataValueLabel.setText(valueS);
        });
    }

    private int findIndexFromName(List<NamedObject> list, String name) {
        for (int idx = 0; idx < list.size(); ++idx) {
            NamedObject no = list.get(idx);
            if (!name.equals(no.getName())) continue;
            return idx;
        }
        log.error("findIndexFromName cant find " + name);
        return -1;
    }

    public void save() {
        this.store.putBoolean("navToolbarAction", ((Boolean)this.navToolbarAction.getValue("state")).booleanValue());
        this.store.putBoolean("moveToolbarAction", ((Boolean)this.moveToolbarAction.getValue("state")).booleanValue());
        if (this.projManager != null) {
            this.projManager.storePersistentData();
        }
        this.store.putBeanObject(LastMapAreaName, (Object)this.navPanel.getMapArea());
        this.store.putBeanObject(LastProjectionName, (Object)this.navPanel.getProjectionImpl());
        this.store.putBeanObject(ColorScaleName, (Object)this.colorScale);
        this.store.putBoolean("showGridAction", ((Boolean)this.showGridAction.getValue("state")).booleanValue());
        this.store.putBoolean("showContoursAction", ((Boolean)this.showContoursAction.getValue("state")).booleanValue());
        this.store.putBoolean("showContourLabelsAction", ((Boolean)this.showContourLabelsAction.getValue("state")).booleanValue());
    }

    public void addMapBean(MapBean mb) {
        this.mapBeanMenu.addAction(mb.getActionDesc(), mb.getIcon(), mb.getAction());
        if (this.mapBeanCount == 0) {
            this.setMapRenderer(mb.getRenderer());
        }
        ++this.mapBeanCount;
        mb.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("Renderer")) {
                this.setMapRenderer((Renderer)e.getNewValue());
            }
        });
    }

    void setMapRenderer(Renderer mapRenderer) {
        this.mapRenderer = mapRenderer;
        mapRenderer.setProjection(this.navPanel.getProjectionImpl());
        mapRenderer.setColor(this.mapColor);
        this.redrawLater();
    }

    boolean showDataset() {
        ProjectionRect fieldBB;
        Iterable grids = this.coverageDataset.getCoverages();
        this.currentField = (Coverage)grids.iterator().next();
        this.currentLevel = 0;
        this.currentTime = 0;
        this.currentEnsemble = 0;
        this.currentRunTime = 0;
        this.eventsOK = false;
        this.dataState = this.coverageRenderer.setCoverage(this.coverageDataset, this.currentField);
        this.coverageRenderer.setDataProjection(this.currentField.getCoordSys().getProjection());
        this.setField(this.currentField);
        Projection dataProjection = this.currentField.getCoordSys().getProjection();
        if (dataProjection != null) {
            this.setProjection(dataProjection);
        }
        if ((fieldBB = this.currentField.getBoundingBox()) != null) {
            this.navPanel.setMapArea(fieldBB);
        }
        this.eventsOK = true;
        return true;
    }

    public void setDataMinMaxType(ColorScale.MinMaxType type) {
        this.coverageRenderer.setDataMinMaxType(type);
        this.redrawLater();
    }

    public void setDataset(CoverageTable dsTable) {
        this.coverageDataset = dsTable.getCoverageDataset();
        this.setFieldsFromBeans(dsTable.getCoverageBeans());
        this.startOK = false;
        this.showDataset();
        this.datasetNameLabel.setText("Dataset:  " + this.coverageDataset.getName());
    }

    public void setDataset(CoverageCollection gcd) {
        this.coverageDataset = gcd;
        this.setFields(gcd.getCoverages());
        this.startOK = false;
        this.showDataset();
        this.datasetNameLabel.setText("Dataset:  " + this.coverageDataset.getName());
    }

    void setFieldsFromBeans(List<CoverageTable.CoverageBean> fields) {
        this.fieldChooser.setCollection(fields.iterator());
    }

    void setFields(Iterable<Coverage> fields) {
        this.fieldChooser.setCollection(fields.iterator());
    }

    private boolean setField(Object fld) {
        NamedObject no;
        Coverage gg = null;
        if (fld instanceof Coverage) {
            gg = (Coverage)fld;
        } else if (fld instanceof String) {
            gg = this.coverageDataset.findCoverage((String)fld);
        } else if (fld instanceof NamedObject) {
            gg = this.coverageDataset.findCoverage(((NamedObject)fld).getName());
        }
        if (null == gg) {
            return false;
        }
        this.dataState = this.coverageRenderer.setCoverage(this.coverageDataset, gg);
        this.coverageRenderer.setDataProjection(this.dataState.geocs.getProjection());
        this.currentField = gg;
        if (this.dataState.rtaxis != null) {
            this.runtimeNames = NamedObjects.getNames(this.dataState.rtaxis);
            int n = this.currentRunTime = !this.runtimeNames.isEmpty() ? 0 : -1;
            if (this.currentRunTime < 0 || this.currentRunTime >= this.runtimeNames.size()) {
                this.currentRunTime = 0;
            }
            this.setChooserWanted("runtime", true);
            this.runtimeChooser.setCollection(this.runtimeNames.iterator(), true);
            NamedObject no2 = this.runtimeNames.get(this.currentRunTime);
            this.runtimeChooser.setSelectedByName(no2.getName());
            if (this.dataState.taxis2D != null) {
                this.dataState.taxis = this.dataState.taxis2D.getTimeAxisForRun(this.currentRunTime);
            }
        } else {
            this.runtimeNames = new ArrayList<NamedObject>();
            this.setChooserWanted("runtime", false);
            this.coverageRenderer.setRunTime(-1);
        }
        if (this.dataState.taxis != null) {
            this.timeNames = NamedObjects.getNames(this.dataState.taxis);
            if (this.currentTime < 0 || this.currentTime >= this.timeNames.size()) {
                this.currentTime = 0;
            }
            boolean hasDependentTimeAxis = true;
            this.setChooserWanted("time", true);
            this.timeChooser.setCollection(this.timeNames.iterator(), true);
            no = this.timeNames.get(this.currentTime);
            this.timeChooser.setSelectedByName(no.getName());
        } else {
            this.timeNames = new ArrayList<NamedObject>();
            boolean hasDependentTimeAxis = false;
            this.setChooserWanted("time", false);
        }
        if (this.dataState.ensaxis != null) {
            this.ensembleNames = NamedObjects.getNames(this.dataState.ensaxis);
            int n = this.currentEnsemble = !this.ensembleNames.isEmpty() ? 0 : -1;
            if (this.currentEnsemble < 0 || this.currentEnsemble >= this.ensembleNames.size()) {
                this.currentEnsemble = 0;
            }
            this.setChooserWanted("ensemble", true);
            this.ensembleChooser.setCollection(this.ensembleNames.iterator(), true);
            no = this.ensembleNames.get(this.currentEnsemble);
            this.ensembleChooser.setSelectedByName(no.getName());
        } else {
            this.ensembleNames = new ArrayList<NamedObject>();
            this.setChooserWanted("ensemble", false);
            this.coverageRenderer.setEnsemble(-1);
        }
        if (this.dataState.zaxis != null) {
            this.levelNames = NamedObjects.getNames(this.dataState.zaxis);
            if (this.currentLevel < 0 || this.currentLevel >= this.levelNames.size()) {
                this.currentLevel = 0;
            }
            this.setChooserWanted("level", true);
            this.levelChooser.setCollection(this.levelNames.iterator(), true);
            no = this.levelNames.get(this.currentLevel);
            this.levelChooser.setSelectedByName(no.getName());
        } else {
            this.levelNames = new ArrayList<NamedObject>();
            this.setChooserWanted("level", false);
            this.coverageRenderer.setLevel(-1);
        }
        this.addChoosers();
        this.fieldChooser.setToolTipText(gg.getShortName());
        this.colorScalePanel.setUnitString(gg.getUnitsString());
        return true;
    }

    void setDrawHorizAndVert(boolean drawHoriz, boolean drawVert) {
        this.drawingPanel.removeAll();
        if (drawHoriz && drawVert) {
            this.drawingPanel.add((Component)this.navPanel, "Center");
        } else if (drawHoriz) {
            this.drawingPanel.add((Component)this.navPanel, "Center");
        } else if (drawVert) {
            this.drawingPanel.add((Component)this.navPanel, "Center");
        }
    }

    public void setProjection(Projection p) {
        this.project = p;
        if (this.mapRenderer != null) {
            this.mapRenderer.setProjection(p);
        }
        this.coverageRenderer.setViewProjection(p);
        this.navPanel.setProjectionImpl(p);
        this.redrawLater();
    }

    void start(boolean ok) {
        this.startOK = ok;
    }

    synchronized void draw(boolean immediate) {
        if (!this.startOK) {
            return;
        }
        this.coverageRenderer.setLevel(this.currentLevel);
        this.coverageRenderer.setTime(this.currentTime);
        this.coverageRenderer.setEnsemble(this.currentEnsemble);
        this.coverageRenderer.setRunTime(this.currentRunTime);
        if (this.drawHorizOn) {
            this.drawH(immediate);
        }
    }

    private void drawH(boolean immediate) {
        long tookTime;
        if (!this.startOK) {
            return;
        }
        boolean already = this.redrawTimer.isRunning();
        if (already) {
            this.redrawTimer.stop();
        }
        long tstart = System.currentTimeMillis();
        Graphics2D gNP = this.navPanel.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.navPanel.getBackgroundColor());
        gNP.fill(gNP.getClipBounds());
        long startTime = System.currentTimeMillis();
        this.coverageRenderer.renderPlanView(gNP, this.atI);
        if (Debug.isSet((String)"timing/GridDraw")) {
            tookTime = System.currentTimeMillis() - startTime;
            System.out.println("timing.GridDraw: " + (double)tookTime * 0.001 + " seconds");
        }
        if (this.mapRenderer != null) {
            startTime = System.currentTimeMillis();
            this.mapRenderer.draw(gNP, this.atI);
            if (Debug.isSet((String)"timing/MapDraw")) {
                tookTime = System.currentTimeMillis() - startTime;
                System.out.println("timing/MapDraw: " + (double)tookTime * 0.001 + " seconds");
            }
        }
        if (immediate) {
            this.navPanel.drawG();
        } else {
            this.navPanel.repaint();
        }
        gNP.dispose();
        if (Debug.isSet((String)"timing/total")) {
            tookTime = System.currentTimeMillis() - tstart;
            System.out.println("timing.total: " + (double)tookTime * 0.001 + " seconds");
        }
    }

    private synchronized void redrawLater() {
        boolean already = this.redrawTimer.isRunning();
        if (already) {
            this.redrawTimer.restart();
        } else {
            this.redrawTimer.start();
        }
    }

    public ProjectionManager getProjectionManager() {
        if (null != this.projManager) {
            return this.projManager;
        }
        this.projManager = new ProjectionManager(null, this.store);
        this.projManager.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("ProjectionImpl")) {
                Projection p = (Projection)e.getNewValue();
                this.setProjection(p);
            }
        });
        return this.projManager;
    }

    private void addChoosers() {
        this.fieldPanel.removeAll();
        for (Chooser c : this.choosers) {
            if (!c.isWanted) continue;
            this.fieldPanel.add((Component)c.field);
        }
    }

    private void setChooserWanted(String name, boolean want) {
        for (Chooser chooser : this.choosers) {
            if (!chooser.name.equals(name)) continue;
            chooser.isWanted = want;
        }
    }

    private void addActionsToMenus(JMenu datasetMenu, JMenu configMenu, JMenu toolMenu) {
        BAMutil.addActionToMenu((JMenu)datasetMenu, (Action)this.showDatasetInfoAction);
        JMenu toolbarMenu = new JMenu("Toolbars");
        toolbarMenu.setMnemonic('T');
        configMenu.add(toolbarMenu);
        BAMutil.addActionToMenu((JMenu)toolbarMenu, (Action)this.navToolbarAction);
        BAMutil.addActionToMenu((JMenu)toolbarMenu, (Action)this.moveToolbarAction);
        BAMutil.addActionToMenu((JMenu)configMenu, (Action)this.chooseProjectionAction);
        BAMutil.addActionToMenu((JMenu)configMenu, (Action)this.saveCurrentProjectionAction);
        JMenu displayMenu = new JMenu("Display control");
        displayMenu.setMnemonic('D');
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.showGridAction);
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.showContoursAction);
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.showContourLabelsAction);
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.redrawAction);
        toolMenu.add(displayMenu);
        JMenu loopMenu = new JMenu("Loop control");
        loopMenu.setMnemonic('L');
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.fieldLoopAction);
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.levelLoopAction);
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.timeLoopAction);
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.runtimeLoopAction);
        toolMenu.add(loopMenu);
        JMenu mmMenu = new JMenu("ColorScale min/max");
        mmMenu.setMnemonic('C');
        BAMutil.addActionToMenu((JMenu)mmMenu, (Action)this.minmaxHorizAction);
        BAMutil.addActionToMenu((JMenu)mmMenu, (Action)this.minmaxLogAction);
        BAMutil.addActionToMenu((JMenu)mmMenu, (Action)this.minmaxHoldAction);
        toolMenu.add(mmMenu);
        JMenu zoomMenu = new JMenu("Zoom/Pan");
        zoomMenu.setMnemonic('Z');
        this.navPanel.addActionsToMenu(zoomMenu);
        toolMenu.add(zoomMenu);
    }

    private static class LoopControlAction
    extends AbstractAction {
        SuperComboBox scbox;

        LoopControlAction(SuperComboBox cbox) {
            this.scbox = cbox;
            BAMutil.setActionProperties((AbstractAction)this, null, (String)cbox.getName(), (boolean)false, (int)0, (int)0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.scbox.getLoopControl().show();
        }
    }

    private static class Chooser {
        boolean isWanted;
        String name;
        SuperComboBox field;

        Chooser(String name, SuperComboBox field, boolean want) {
            this.name = name;
            this.field = field;
            this.isWanted = want;
        }
    }
}

