/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.geoloc;

import java.awt.Dimension;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import ucar.nc2.ui.geoloc.NewProjectionEvent;
import ucar.nc2.ui.geoloc.NewProjectionListener;
import ucar.ui.util.ListenerManager;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.util.prefs.PreferencesExt;

public class JTableProjection
extends JTable {
    private static final boolean debug = false;
    private final PreferencesExt store;
    private ProjectionTableModel model;
    private final ArrayList<Projection> projections;
    private int selectedRow;
    private final ListenerManager lm;
    private static final String STORE_NAME = "ProjectionTableModel";

    public JTableProjection(PreferencesExt pstore) {
        this.store = pstore;
        if (this.store == null) {
            this.model = new ProjectionTableModel();
        } else {
            this.model = (ProjectionTableModel)this.store.getObject(STORE_NAME);
            if (this.model == null) {
                this.model = new ProjectionTableModel();
            }
        }
        this.projections = this.model.getProjections();
        this.setModel(this.model);
        this.setAutoResizeMode(2);
        this.setPreferredScrollableViewportSize(new Dimension(400, 200));
        this.getTableHeader().setReorderingAllowed(true);
        this.model.adjustColumns(this.getColumnModel());
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    JTableProjection.this.selectedRow = JTableProjection.this.getSelectedRow();
                    JTableProjection.this.lm.sendEvent((EventObject)new NewProjectionEvent(this, JTableProjection.this.getSelected()));
                }
            }
        });
        this.lm = new ListenerManager("ucar.nc2.ui.geoloc.NewProjectionListener", "ucar.nc2.ui.geoloc.NewProjectionEvent", "actionPerformed");
    }

    public void addProjection(Projection proj) {
        int rowno = this.model.addProjection(proj);
        this.setRowSelectionInterval(rowno, rowno);
        this.selectedRow = rowno;
    }

    public void replaceProjection(Projection proj) {
        int rowno = this.model.replaceProjection(proj);
        this.setRowSelectionInterval(rowno, rowno);
        this.selectedRow = rowno;
    }

    public boolean contains(Projection proj) {
        return this.model.search(proj) >= 0;
    }

    public boolean contains(String id) {
        return this.model.search(id) >= 0;
    }

    public Projection getSelected() {
        int len = this.projections.size();
        if (0 > this.selectedRow || len <= this.selectedRow) {
            return null;
        }
        return this.projections.get(this.selectedRow);
    }

    public void deleteSelected() {
        int len = this.projections.size();
        if (0 > this.selectedRow || len <= this.selectedRow) {
            return;
        }
        this.model.deleteRow(this.selectedRow);
        len = this.projections.size();
        if (len == 0) {
            this.clearSelection();
            this.selectedRow = -1;
        } else {
            if (this.selectedRow > len - 1) {
                this.selectedRow = len - 1;
            }
            this.setRowSelectionInterval(this.selectedRow, this.selectedRow);
        }
        this.lm.sendEvent((EventObject)new NewProjectionEvent(this, this.getSelected()));
        this.repaint();
    }

    public boolean isEmpty() {
        return this.model.getRowCount() == 0;
    }

    public void storePersistentData() {
        if (this.store != null) {
            this.store.putObject(STORE_NAME, (Object)this.model);
        }
    }

    public void setMapArea(ProjectionRect bb) {
        if (0 > this.selectedRow) {
            return;
        }
        this.model.setMapArea(this.selectedRow, bb);
    }

    public void setCurrentProjection(Projection proj) {
        int row = this.model.search(proj);
        if (0 <= row) {
            this.selectedRow = row;
            this.setRowSelectionInterval(row, row);
        } else {
            this.selectedRow = -1;
            this.clearSelection();
        }
    }

    public void addNewProjectionListener(NewProjectionListener l) {
        this.lm.addListener((Object)l);
    }

    public void removeNewProjectionListener(NewProjectionListener l) {
        this.lm.removeListener((Object)l);
    }

    private static class ProjectionTableModel
    extends AbstractTableModel
    implements Serializable {
        private static final String[] colName = new String[]{"Name", "Type", "Parameters", "Default Zoom"};
        private final ArrayList<Projection> projections = new ArrayList(20);
        private transient ListenerManager lm;

        @Override
        public int getRowCount() {
            return this.projections.size();
        }

        @Override
        public int getColumnCount() {
            return colName.length;
        }

        @Override
        public String getColumnName(int col) {
            return colName[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            Projection proj = this.projections.get(row);
            switch (col) {
                case 0: {
                    return proj.getName();
                }
                case 1: {
                    return proj.getClassName();
                }
                case 2: {
                    return proj.paramsToString();
                }
            }
            return "error";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Projection proj = this.projections.get(rowIndex);
        }

        ProjectionTableModel() {
            this.constructLM();
        }

        private void constructLM() {
            this.lm = new ListenerManager("javax.swing.event.TableModelListener", "javax.swing.event.TableModelEvent", "tableChanged");
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.lm.addListener((Object)l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.lm.removeListener((Object)l);
        }

        @Override
        public void fireTableChanged(TableModelEvent e) {
            this.lm.sendEvent((EventObject)e);
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.constructLM();
        }

        int addProjection(Projection proj) {
            this.projections.add(proj);
            int count = this.projections.size() - 1;
            this.fireTableRowsInserted(count, count);
            return count;
        }

        int replaceProjection(Projection proj) {
            int rowno = this.search(proj);
            if (rowno < 0) {
                return -1;
            }
            this.projections.set(rowno, proj);
            return rowno;
        }

        void adjustColumns(TableColumnModel colModel) {
            for (int i = 0; i < colName.length; ++i) {
                colModel.getColumn(i).setMinWidth(50);
                colModel.getColumn(i).setPreferredWidth(100);
            }
        }

        ArrayList<Projection> getProjections() {
            return this.projections;
        }

        void deleteRow(int row) {
            int len = this.projections.size();
            if (row >= len) {
                return;
            }
            this.projections.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        int search(Projection proj) {
            for (int row = 0; row < this.projections.size(); ++row) {
                Projection test = this.projections.get(row);
                if (!proj.getName().equals(test.getName())) continue;
                return row;
            }
            return -1;
        }

        int search(String projName) {
            for (int row = 0; row < this.projections.size(); ++row) {
                Projection test = this.projections.get(row);
                if (!projName.equals(test.getName())) continue;
                return row;
            }
            return -1;
        }

        void setMapArea(int row, ProjectionRect bb) {
            int len = this.projections.size();
            if (row >= len) {
                return;
            }
            Projection proj = this.projections.get(row);
            this.fireTableRowsUpdated(row, row);
        }
    }
}

