/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.geoloc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.nc2.ui.gis.MapBean;
import ucar.nc2.ui.gis.worldmap.WorldMap;
import ucar.nc2.ui.util.Renderer;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.PopupMenu;
import ucar.unidata.geoloc.Projection;

public class NPController
extends JPanel {
    private static final boolean debug = false;
    protected NavigatedPanel np;
    protected ArrayList<Renderer> renderers = new ArrayList();
    protected Projection project;
    protected AffineTransform atI = new AffineTransform();
    protected boolean eventOk = true;
    protected JPanel toolPanel;

    public NPController() {
        this.np = new NavigatedPanel();
        WorldMap render = new WorldMap();
        this.project = this.np.getProjectionImpl();
        render.setProjection(this.project);
        this.addRenderer(render);
        this.np.addNewProjectionListener(e -> {
            Projection p = e.getProjection();
            Iterator<Renderer> iterator = this.renderers.iterator();
            while (iterator.hasNext()) {
                Renderer renderer;
                Renderer r = renderer = iterator.next();
                r.setProjection(p);
            }
            this.redraw(true);
        });
        this.np.addNewMapAreaListener(e -> this.redraw(true));
        PopupMenu mapBeanMenu = MapBean.getStandardMapSelectButton(e -> {
            if (e.getPropertyName().equals("Renderer")) {
                Renderer mapRender = (Renderer)e.getNewValue();
                mapRender.setProjection(this.np.getProjectionImpl());
                this.renderers.set(0, mapRender);
                this.redraw(true);
            }
        });
        this.toolPanel = new JPanel(new FlowLayout(0));
        this.toolPanel.add(mapBeanMenu.getParentComponent());
        this.toolPanel.add(this.np.getNavToolBar());
        this.toolPanel.add(this.np.getMoveToolBar());
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.np.setReferenceAction);
        this.makeUI();
    }

    protected void makeUI() {
        this.setLayout(new BorderLayout());
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(new EtchedBorder());
        JLabel positionLabel = new JLabel("position");
        statusPanel.add((Component)positionLabel, "Center");
        this.np.setPositionLabel(positionLabel);
        this.add((Component)this.toolPanel, "North");
        this.add((Component)this.np, "Center");
        this.add((Component)statusPanel, "South");
    }

    public NavigatedPanel getNavigatedPanel() {
        return this.np;
    }

    public void addRenderer(Renderer r) {
        this.renderers.add(r);
        r.setProjection(this.project);
    }

    public void setProjection(Projection p) {
        this.project = p;
        Iterator<Renderer> iterator = this.renderers.iterator();
        while (iterator.hasNext()) {
            Renderer renderer;
            Renderer r = renderer = iterator.next();
            r.setProjection(p);
        }
        this.eventOk = false;
        this.np.setProjectionImpl(p);
        this.eventOk = true;
        this.redraw(true);
    }

    protected void redraw(boolean complete) {
        if (this.project == null) {
            return;
        }
        long tstart = System.currentTimeMillis();
        Graphics2D gNP = this.np.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.np.getBackgroundColor());
        gNP.fill(gNP.getClipBounds());
        Iterator<Renderer> iterator = this.renderers.iterator();
        while (iterator.hasNext()) {
            Renderer renderer;
            Renderer r = renderer = iterator.next();
            r.draw(gNP, this.atI);
        }
        gNP.dispose();
        this.np.repaint();
    }
}

