/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.geoloc;

import java.awt.Frame;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ui.geoloc.NewProjectionDialog;
import ucar.ui.util.ListenerManager;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.util.Format;
import ucar.util.prefs.PreferencesExt;

public class ProjectionManager {
    private static final boolean debugBeans = false;
    private static final Logger log = LoggerFactory.getLogger(ProjectionManager.class);
    private static final int min_sigfig = 6;
    private static final Object[] voidObjectArg = new Object[0];
    static String[] types = new String[]{"ucar.unidata.geoloc.projection.LatLonProjection", "ucar.unidata.geoloc.projection.AlbersEqualArea", "ucar.unidata.geoloc.projection.FlatEarth", "ucar.unidata.geoloc.projection.LambertAzimuthalEqualArea", "ucar.unidata.geoloc.projection.LambertConformal", "ucar.unidata.geoloc.projection.Mercator", "ucar.unidata.geoloc.projection.Orthographic", "ucar.unidata.geoloc.projection.RotatedLatLon", "ucar.unidata.geoloc.projection.Stereographic", "ucar.unidata.geoloc.projection.TransverseMercator", "ucar.unidata.geoloc.projection.UtmProjection", "ucar.unidata.geoloc.projection.VerticalPerspectiveView", "ucar.unidata.geoloc.projection.sat.MSGnavigation", "ucar.unidata.geoloc.projection.proj4.AlbersEqualAreaEllipse", "ucar.unidata.geoloc.projection.proj4.CylindricalEqualAreaProjection", "ucar.unidata.geoloc.projection.proj4.EquidistantAzimuthalProjection", "ucar.unidata.geoloc.projection.proj4.LambertConformalConicEllipse", "ucar.unidata.geoloc.projection.proj4.PolyconicProjection", "ucar.unidata.geoloc.projection.proj4.StereographicAzimuthalProjection", "ucar.unidata.geoloc.projection.proj4.TransverseMercatorProjection"};
    private final Frame owner;
    private NewProjectionDialog dialog;
    private final ListenerManager lm;

    public ProjectionManager(Frame owner, PreferencesExt store) {
        this.owner = owner;
        this.lm = new ListenerManager("java.beans.PropertyChangeListener", "java.beans.PropertyChangeEvent", "propertyChange");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.lm.addListener((Object)l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.lm.removeListener((Object)l);
    }

    public void setVisible() {
        if (null == this.dialog) {
            this.init();
        }
        this.dialog.setVisible(true);
    }

    public void storePersistentData() {
    }

    private void init() {
        this.dialog = new NewProjectionDialog(this.owner);
        ArrayList<Object> ps = new ArrayList<Object>();
        for (String p : types) {
            try {
                ps.add(new ProjectionClass(p));
            }
            catch (IntrospectionException | ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.dialog.setProjectionManager(this, ps);
    }

    class ProjectionParam {
        Method reader;
        Method writer;
        String name;
        Class<?> paramType;
        JTextField tf;

        ProjectionParam(String name, Method reader, Method writer, Class<?> paramType) {
            this.name = name;
            this.reader = reader;
            this.writer = writer;
            this.paramType = paramType;
        }

        public String toString() {
            return this.paramType.getName() + " " + this.name + " " + (this.reader == null ? "-" : "R") + (this.writer == null ? "-" : "W");
        }

        void setTextField(JTextField tf) {
            this.tf = tf;
        }

        private void putParamIntoDialog(ProjectionClass projClass, Projection proj) {
            Double value;
            try {
                value = (Double)this.reader.invoke((Object)proj, voidObjectArg);
            }
            catch (IllegalAccessException | InvocationTargetException ee) {
                log.error("putParamIntoDialog failed  invoking read {} class {}", (Object)this.name, (Object)projClass);
                return;
            }
            String valstr = Format.d((double)value, (int)6);
            this.tf.setText(valstr);
        }

        private void setProjFromDialog(ProjectionClass projClass, Projection proj) {
            try {
                String valstr = this.tf.getText();
                double valdub = Double.parseDouble(valstr);
                Object[] args = new Object[]{valdub};
                this.writer.invoke((Object)proj, args);
            }
            catch (IllegalAccessException | InvocationTargetException ee) {
                log.error("ProjectionManager: setProjParams failed  invoking write {} class {}", (Object)this.name, (Object)projClass);
            }
        }
    }

    class ProjectionClass {
        Class<Projection> projClass;
        Projection projInstance;
        String name;
        List<ProjectionParam> paramList = new ArrayList<ProjectionParam>();

        public String toString() {
            return this.name;
        }

        ProjectionClass(String className) throws ClassNotFoundException, IntrospectionException {
            PropertyDescriptor[] props;
            Class<?> stopClass;
            this.projClass = Class.forName(className);
            try {
                stopClass = Class.forName("ucar.unidata.geoloc.Projection");
            }
            catch (Exception ee) {
                System.err.println("constructParamInput failed ");
                stopClass = null;
            }
            BeanInfo info = Introspector.getBeanInfo(this.projClass, stopClass);
            for (PropertyDescriptor pd : props = info.getPropertyDescriptors()) {
                Method reader = pd.getReadMethod();
                Method writer = pd.getWriteMethod();
                if (reader == null || writer == null) continue;
                ProjectionParam p = new ProjectionParam(pd.getName(), reader, writer, pd.getPropertyType());
                this.paramList.add(p);
            }
            if (null == this.makeDefaultProjection()) {
                this.name = "none";
                return;
            }
            Class[] voidClassArg = new Class[]{};
            Object[] voidObjectArg = new Object[]{};
            try {
                Method m = this.projClass.getMethod("getClassName", voidClassArg);
                this.name = (String)m.invoke((Object)this.projInstance, voidObjectArg);
            }
            catch (NoSuchMethodException ee) {
                System.err.println("ProjectionManager: class " + this.projClass + " does not have method getClassName()");
                throw new ClassNotFoundException();
            }
            catch (SecurityException ee) {
                System.err.println("ProjectionManager: class " + this.projClass + " got SecurityException on getClassName()" + ee);
                throw new ClassNotFoundException();
            }
            catch (Exception ee) {
                System.err.println("ProjectionManager: class " + this.projClass + " Exception when invoking getClassName()" + ee);
                throw new ClassNotFoundException();
            }
        }

        Projection makeDefaultProjection() {
            Class[] voidClassArg = new Class[]{};
            Object[] voidObjectArg = new Object[]{};
            try {
                Constructor<Projection> c = this.projClass.getConstructor(voidClassArg);
                this.projInstance = c.newInstance(voidObjectArg);
                return this.projInstance;
            }
            catch (Exception ee) {
                log.error("ProjectionManager makeDefaultProjection failed to construct class " + this.projClass, (Throwable)ee);
                return null;
            }
        }

        void putParamIntoDialog(Projection projInstance) {
            for (ProjectionParam pp : this.paramList) {
                pp.putParamIntoDialog(this, projInstance);
            }
        }

        void setProjFromDialog(Projection projInstance) {
            for (ProjectionParam pp : this.paramList) {
                pp.setProjFromDialog(this, projInstance);
            }
        }
    }
}

