/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.gis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import ucar.nc2.ui.gis.AbstractGisFeature;
import ucar.nc2.ui.gis.GisFeature;
import ucar.nc2.ui.util.Renderer;
import ucar.ui.prefs.Debug;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;

public abstract class GisFeatureRenderer
implements Renderer {
    private Color color = Color.blue;
    protected Projection displayProject;
    protected ArrayList<Shape> shapeList;

    @Override
    public abstract LatLonRect getPreferredArea();

    protected abstract List<GisFeature> getFeatures();

    protected abstract Projection getDataProjection();

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void setProjection(Projection project) {
        this.displayProject = project;
        this.shapeList = null;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform pixelAT) {
        g.setColor(this.color);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setStroke(new BasicStroke(0.0f));
        Rectangle2D clipRect = (Rectangle2D)g.getClip();
        for (Shape s : this.getShapes(g, pixelAT)) {
            Rectangle2D shapeBounds = s.getBounds2D();
            if (!shapeBounds.intersects(clipRect)) continue;
            g.draw(s);
        }
    }

    protected Iterable<Shape> getShapes(Graphics2D g, AffineTransform normal2device) {
        if (this.shapeList != null) {
            return this.shapeList;
        }
        if (Debug.isSet((String)"projection/LatLonShift")) {
            System.out.println("projection/LatLonShift GisFeatureRenderer.getShapes called");
        }
        Projection dataProject = this.getDataProjection();
        List<GisFeature> featList = this.getFeatures();
        this.shapeList = new ArrayList(featList.size());
        for (GisFeature o : featList) {
            AbstractGisFeature feature = (AbstractGisFeature)o;
            Shape shape = dataProject == null ? feature.getShape() : (dataProject.isLatLon() ? feature.getProjectedShape(this.displayProject) : (dataProject == this.displayProject ? feature.getShape() : feature.getProjectedShape(dataProject, this.displayProject)));
            this.shapeList.add(shape);
        }
        return this.shapeList;
    }
}

