/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grib;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.grib.GribRewritePanel;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.util.prefs.PreferencesExt;

public class GribRewriteOpPanel
extends OpPanel {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final GribRewritePanel ftTable;
    private final FileManager dirChooser;

    public GribRewriteOpPanel(PreferencesExt prefs) {
        super(prefs, "dir:", false, false);
        this.dirChooser = new FileManager(ToolsUI.getToolsFrame(), null, null, (PreferencesExt)prefs.node("FeatureScanFileManager"));
        this.ftTable = new GribRewritePanel(prefs, this.buttPanel);
        this.add((Component)this.ftTable, "Center");
        this.ftTable.addPropertyChangeListener(e -> {
            if (!(e.getNewValue() instanceof String)) {
                return;
            }
            String pname = e.getPropertyName();
            String datasetName = (String)e.getNewValue();
            if ("openNetcdfFile".equals(pname)) {
                ToolsUI.getToolsUI().openNetcdfFile(datasetName);
            } else if ("openGridDataset".equals(pname)) {
                ToolsUI.getToolsUI().openGridDataset(datasetName);
            } else if ("openGrib1Data".equals(pname)) {
                ToolsUI.getToolsUI().openGrib1Data(datasetName);
            } else if ("openGrib2Data".equals(pname)) {
                ToolsUI.getToolsUI().openGrib2Data(datasetName);
            } else {
                logger.debug("Unknown popertry name {}", (Object)pname);
            }
        });
        this.dirChooser.getFileChooser().setFileSelectionMode(2);
        this.dirChooser.setCurrentDirectory(prefs.get("currDir", "."));
        AbstractAction fileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = GribRewriteOpPanel.this.dirChooser.chooseFilename();
                if (filename == null) {
                    return;
                }
                GribRewriteOpPanel.this.cb.setSelectedItem((Object)filename);
            }
        };
        BAMutil.setActionProperties((AbstractAction)fileAction, (String)"FileChooser", (String)"open Local dataset...", (boolean)false, (int)76, (int)-1);
        BAMutil.addActionToContainer((Container)this.buttPanel, (Action)fileAction);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        return this.ftTable.setScanDirectory(command);
    }

    @Override
    public void closeOpenFiles() {
        this.ftTable.clear();
    }

    @Override
    public void save() {
        this.dirChooser.save();
        this.ftTable.save();
        this.prefs.put("currDir", this.dirChooser.getCurrentDirectory());
        super.save();
    }
}

