/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ucar.ma2.IsMissingEvaluator;
import ucar.ui.util.ListenerManager;
import ucar.ui.widget.FontUtil;
import ucar.unidata.util.Format;

public class ColorScale
implements Cloneable,
Serializable {
    public static final int VERTICAL = 0;
    private static final long serialVersionUID = -1L;
    private static final int objectVersion = 1;
    private static final boolean debugColors = false;
    private String name;
    private int ncolors;
    private Color[] colors;
    private Color[] useColors;
    private ListenerManager lm;
    private IsMissingEvaluator gg;
    private double[] edge;
    private int[] hist;
    private double min;
    private double max;
    private double interval;
    private boolean hasMissingData;
    private Color missingDataColor = Color.white;
    public static final Color[] redHot = new Color[]{new Color(6073582), new Color(16774635), new Color(16770764), new Color(16767408), new Color(16761989), new Color(16758891), new Color(16756054), new Color(16750891), new Color(16743936), new Color(16738816), new Color(15816704), new Color(14828544), new Color(13774592), new Color(12654848), new Color(0xA00300), new Color(0xFF00FF)};
    public static final Color[] redBlue = new Color[]{new Color(1, 57, 255), new Color(0, 140, 255), new Color(1, 209, 255), new Color(1, 255, 232), new Color(1, 255, 171), new Color(1, 255, 79), new Color(43, 255, 0), new Color(166, 255, 2), new Color(227, 255, 1), new Color(255, 198, 0), new Color(255, 168, 1), new Color(255, 145, 1), new Color(255, 130, 1), new Color(255, 107, 0), new Color(255, 84, 0), new Color(255, 7, 0)};
    public static final Color[] hueBands = new Color[]{new Color(204, 0, 0), new Color(255, 0, 0), new Color(255, 51, 51), new Color(255, 102, 102), new Color(255, 153, 153), new Color(255, 102, 0), new Color(255, 153, 0), new Color(255, 204, 102), new Color(255, 255, 0), new Color(255, 255, 51), new Color(255, 255, 102), new Color(255, 255, 153), new Color(0, 255, 0), new Color(51, 255, 51), new Color(102, 255, 102), new Color(153, 255, 153), new Color(204, 255, 204), new Color(0, 255, 255), new Color(51, 255, 255), new Color(102, 255, 255), new Color(153, 255, 255), new Color(204, 255, 255), new Color(0, 0, 255), new Color(51, 51, 255), new Color(102, 102, 255), new Color(153, 153, 255), new Color(255, 0, 255), new Color(255, 51, 255), new Color(255, 102, 255), new Color(255, 153, 255), new Color(255, 204, 255)};
    public static final Color[] spectrum2 = new Color[]{new Color(204, 0, 0), new Color(255, 31, 0), new Color(255, 69, 0), new Color(255, 107, 0), new Color(255, 138, 0), new Color(255, 168, 0), new Color(255, 199, 0), new Color(255, 244, 0), new Color(227, 255, 0), new Color(196, 255, 0), new Color(165, 255, 0), new Color(127, 255, 0), new Color(89, 255, 0), new Color(43, 255, 0), new Color(0, 255, 40), new Color(0, 255, 80), new Color(0, 255, 110), new Color(0, 255, 140), new Color(0, 255, 170), new Color(0, 255, 201), new Color(0, 255, 232), new Color(0, 232, 255), new Color(0, 209, 255), new Color(0, 170, 255), new Color(0, 140, 255), new Color(0, 79, 255), new Color(0, 57, 255), new Color(0, 34, 255), new Color(0, 3, 255), new Color(29, 1, 255), new Color(59, 1, 255), new Color(82, 1, 255), new Color(112, 1, 255), new Color(125, 1, 255), new Color(166, 1, 255), new Color(189, 1, 255), new Color(219, 1, 255)};
    private static final Color[] defaultColors = redBlue;

    public ColorScale(String name, Color[] c) {
        this.name = name;
        this.ncolors = c.length;
        this.colors = new Color[this.ncolors];
        System.arraycopy(c, 0, this.colors, 0, this.ncolors);
        this.constructTransient();
    }

    public ColorScale(String name) {
        this(name, defaultColors);
    }

    public ColorScale() {
        this("", defaultColors);
    }

    private void constructTransient() {
        this.useColors = this.colors;
        this.edge = new double[this.ncolors];
        this.hist = new int[this.ncolors + 1];
        this.lm = new ListenerManager("java.beans.PropertyChangeListener", "java.beans.PropertyChangeEvent", "propertyChange");
        this.missingDataColor = Color.white;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.lm.addListener((Object)l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.lm.removeListener((Object)l);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getNumColors() {
        return this.ncolors;
    }

    public void setNumColors(int n) {
        if (n != this.ncolors) {
            this.colors = new Color[n];
            int prevn = Math.min(this.ncolors, n);
            System.arraycopy(this.useColors, 0, this.colors, 0, prevn);
            for (int i = this.ncolors; i < n; ++i) {
                this.colors[i] = Color.white;
            }
            this.useColors = this.colors;
            this.ncolors = n;
            this.edge = new double[this.ncolors];
            this.hist = new int[this.ncolors + 1];
        }
    }

    public Color getColor(int i) {
        if (i >= 0 && i < this.ncolors) {
            return this.useColors[i];
        }
        if (i == this.ncolors && this.hasMissingData) {
            return this.missingDataColor;
        }
        throw new IllegalArgumentException("Color Scale getColor " + i);
    }

    public double getEdge(int index) {
        return this.edge[index];
    }

    public void setGeoGrid(IsMissingEvaluator gg) {
        this.gg = gg;
        this.hasMissingData = gg.hasMissing();
    }

    public Color getMissingDataColor() {
        return this.missingDataColor;
    }

    public int getIndexFromValue(double value) {
        int index = this.hasMissingData && this.gg.isMissing(value) ? this.ncolors : (value <= this.min ? 0 : (value >= this.max ? this.ncolors - 1 : (int)((value - this.min) / this.interval) + 1));
        int n = index;
        this.hist[n] = this.hist[n] + 1;
        return index;
    }

    public int getIndexFromValueLog(double value) {
        int index = this.hasMissingData && this.gg.isMissing(value) ? this.ncolors : (value <= this.min ? 0 : (value >= this.max ? this.ncolors - 1 : (int)((value - this.min) / this.interval) + 1));
        int n = index;
        this.hist[n] = this.hist[n] + 1;
        return index;
    }

    public void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
        this.interval = (max - min) / (double)(this.ncolors - 2);
        for (int i = 0; i < this.ncolors; ++i) {
            this.edge[i] = min + (double)i * this.interval;
        }
        this.lm.sendEvent((EventObject)new PropertyChangeEvent(this, "ColorScaleLimits", null, this));
    }

    public int getHistMax() {
        int max = 0;
        int maxi = 0;
        for (int i = 0; i <= this.ncolors; ++i) {
            if (this.hist[i] <= max) continue;
            max = this.hist[i];
            maxi = i;
        }
        return maxi;
    }

    public void resetHist() {
        for (int i = 0; i <= this.ncolors; ++i) {
            this.hist[i] = 0;
        }
    }

    public String toString() {
        return this.name;
    }

    public Object clone() {
        ColorScale cl = new ColorScale(this.name, this.colors);
        return cl;
    }

    private void editModeBegin() {
        Color[] editColors = new Color[this.ncolors];
        System.arraycopy(this.colors, 0, editColors, 0, this.ncolors);
        this.useColors = editColors;
    }

    private void editModeEnd(boolean accept) {
        if (accept) {
            System.arraycopy(this.useColors, 0, this.colors, 0, this.ncolors);
        }
        this.useColors = this.colors;
    }

    private void setColor(int i, Color c) {
        if (i >= 0 && i < this.ncolors) {
            this.useColors[i] = c;
        }
    }

    private void setColors(Color[] c) {
        this.ncolors = c.length;
        this.colors = new Color[this.ncolors];
        System.arraycopy(c, 0, this.colors, 0, this.ncolors);
        this.edge = new double[this.ncolors];
        this.hist = new int[this.ncolors + 1];
        this.useColors = this.colors;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.readInt();
        this.name = s.readUTF();
        this.colors = (Color[])s.readObject();
        this.ncolors = this.colors.length;
        this.constructTransient();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(1);
        s.writeUTF(this.name);
        s.writeObject(this.colors);
    }

    public static class Panel
    extends JPanel {
        private int type;
        private int size = 50;
        private ColorScale cs;
        private JLabel unitLabel = new JLabel("unit", 0);
        private JPanel lpanel;
        private boolean editable;
        private int selected = -1;
        private int nColorInterval;
        private String[] label;
        private boolean useLabel = true;
        private FontUtil.StandardFont sf = FontUtil.getStandardFont((int)10);

        public Panel(Component parent) {
            this(parent, 0, null);
        }

        public Panel(Component parent, ColorScale cscale) {
            this(parent, 0, cscale);
        }

        public Panel(Component parent, int type, ColorScale cscale) {
            this.cs = cscale == null ? new ColorScale("default") : cscale;
            this.type = type;
            if (type == 0) {
                this.setPreferredSize(new Dimension(this.size, 400));
                this.setLayout(new BoxLayout(this, 1));
            } else {
                this.setPreferredSize(new Dimension(400, this.size));
                this.setLayout(new BoxLayout(this, 0));
            }
            this.setListener();
            this.nColorInterval = this.cs.getNumColors();
            for (int i = 0; i < this.nColorInterval; ++i) {
                ColorInterval intv = new ColorInterval(this.nColorInterval - i - 1);
                this.add(intv);
            }
            this.lpanel = new JPanel();
            this.lpanel.add(this.unitLabel);
            if (type == 0) {
                this.lpanel.setPreferredSize(new Dimension(this.size, 0));
            } else {
                this.lpanel.setPreferredSize(new Dimension(0, this.size));
            }
            this.add(this.lpanel);
            this.label = new String[this.nColorInterval];
            this.calcLabels();
        }

        private void calcLabels() {
            int sigfig = 4;
            this.label[0] = "<" + Format.d((double)this.cs.getEdge(0), (int)sigfig);
            for (int i = 1; i < this.nColorInterval - 1; ++i) {
                this.label[i] = Format.d((double)this.cs.getEdge(i), (int)sigfig);
            }
            this.label[this.nColorInterval - 1] = ">" + Format.d((double)this.cs.getEdge(this.nColorInterval - 2), (int)sigfig);
        }

        private void setListener() {
            this.cs.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("ColorScaleLimits")) {
                        this.calcLabels();
                    }
                    this.repaint();
                }
            });
        }

        public ColorScale getColorScale() {
            return this.cs;
        }

        public void setColorScale(ColorScale cscale) {
            if (this.nColorInterval != cscale.getNumColors()) {
                this.removeAll();
                this.nColorInterval = cscale.getNumColors();
                this.label = new String[this.nColorInterval];
                for (int i = 0; i < this.nColorInterval; ++i) {
                    ColorInterval intv = new ColorInterval(this.nColorInterval - i - 1);
                    this.add(intv);
                    this.label[i] = "none";
                }
                this.add(this.lpanel);
                this.revalidate();
            }
            this.cs = cscale;
            this.setListener();
            this.calcLabels();
            this.repaint();
        }

        public void setColors(Color[] c) {
            if (this.nColorInterval != c.length) {
                this.removeAll();
                this.nColorInterval = c.length;
                this.label = new String[this.nColorInterval];
                for (int i = 0; i < this.nColorInterval; ++i) {
                    ColorInterval intv = new ColorInterval(this.nColorInterval - i - 1);
                    this.add(intv);
                    this.label[i] = "none";
                }
                this.add(this.lpanel);
                this.revalidate();
            }
            this.cs.setColors(c);
            this.cs.editModeBegin();
            this.calcLabels();
            this.repaint();
        }

        public void setColor(Color c) {
            this.cs.setColor(this.selected, c);
        }

        public void setEditMode(boolean on, boolean accept) {
            if (on) {
                this.editable = true;
                this.cs.editModeBegin();
            } else {
                this.cs.editModeEnd(accept);
                if (accept) {
                    this.setColorScale(this.cs);
                }
                this.selected = -1;
                this.editable = false;
            }
            this.repaint();
        }

        public void setSelected(int i) {
            this.selected = i;
        }

        public void setShowText(boolean b) {
            this.useLabel = b;
        }

        public void setUnitString(String s) {
            this.unitLabel.setText(s);
        }

        public void print(Graphics2D g, double x, double y, double width, double height) {
            int n = this.cs.getNumColors();
            double size = this.type == 0 ? height / (double)n : width / (double)n;
            int count = 0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof ColorInterval)) continue;
                ColorInterval intv = (ColorInterval)c;
                if (this.type == 0) {
                    intv.printV(g, (int)x, (int)(y + (double)count * size), (int)width, (int)size);
                } else {
                    double xpos = x + width - (double)(count + 1) * size;
                    intv.printH(g, (int)xpos, (int)y, (int)size, (int)height);
                }
                ++count;
            }
        }

        private class ColorInterval
        extends JComponent {
            private int rank;

            ColorInterval(int r) {
                this.rank = r;
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (Panel.this.editable) {
                            Panel.this.selected = ColorInterval.this.rank;
                            Panel.this.repaint();
                        }
                    }
                });
            }

            public void printV(Graphics2D g, int x, int y, int width, int height) {
                int textSize = 15;
                g.setColor(Panel.this.cs.getColor(this.rank));
                g.fillRect(x, y + textSize, width, height - textSize);
                if (Panel.this.useLabel) {
                    g.setColor(Color.black);
                    g.setFont(Panel.this.sf.getFont());
                    g.drawString(Panel.this.label[this.rank], x + 3, y + 10);
                }
            }

            public void printH(Graphics2D g, int x, int y, int width, int height) {
                int textSize = 15;
                g.setColor(Panel.this.cs.getColor(this.rank));
                g.fillRect(x, y + textSize, width, height - 2 * textSize);
                g.setColor(Color.white);
                g.drawRect(x, y + textSize, width, height - 2 * textSize);
                if (Panel.this.useLabel) {
                    g.setColor(Color.black);
                    g.setFont(Panel.this.sf.getFont());
                    if (this.rank % 2 == 0) {
                        g.drawString(Panel.this.label[this.rank], x, y + textSize);
                    } else {
                        g.drawString(Panel.this.label[this.rank], x, y + height);
                    }
                }
            }

            @Override
            public void paintComponent(Graphics g) {
                Rectangle b = this.getBounds();
                g.setColor(Panel.this.cs.getColor(this.rank));
                g.fillRect(0, 0, b.width - 1, b.height - 1);
                g.setColor(Panel.this.selected == this.rank ? Color.magenta : Color.black);
                g.drawRect(0, 0, b.width - 1, b.height - 1);
                if (Panel.this.selected == this.rank) {
                    g.drawLine(0, 0, b.width, b.height);
                    g.drawLine(0, b.height, b.width, 0);
                }
                if (Panel.this.useLabel) {
                    g.setColor(Color.black);
                    g.setFont(Panel.this.sf.getFont());
                    g.drawString(Panel.this.label[this.rank], 3, 10);
                }
            }
        }
    }

    public static enum MinMaxType {
        horiz,
        log,
        hold;

    }
}

