/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.JPanel;
import ucar.nc2.Dimension;
import ucar.nc2.dt.GridDatatype;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.event.ActionValueEvent;
import ucar.ui.table.JTableSorted;
import ucar.ui.table.TableRow;
import ucar.ui.table.TableRowAbstract;

public class GridTable {
    private static final boolean debug = false;
    private final JTableSorted table = new JTableSorted(colName, this.tableRows);
    private ArrayList<TableRow> tableRows;
    private final ActionSourceListener actionSource;
    private boolean eventOK = true;
    private static final String[] colName = new String[]{"Name", "Dimensions", "Units", "Long Name"};

    public GridTable(String actionName) {
        this.actionSource = new ActionSourceListener(actionName){

            public void actionPerformed(ActionValueEvent e) {
                if (GridTable.this.tableRows == null) {
                    return;
                }
                String want = e.getValue().toString();
                int count = 0;
                for (TableRow row : GridTable.this.tableRows) {
                    if (want.equals(((Row)row).gg.getFullName())) {
                        GridTable.this.eventOK = false;
                        GridTable.this.table.setSelected(count);
                        GridTable.this.eventOK = true;
                        break;
                    }
                    ++count;
                }
            }
        };
        this.table.addListSelectionListener(e -> {
            Row row;
            if (this.eventOK && !e.getValueIsAdjusting() && (row = (Row)this.table.getSelected()) != null) {
                this.actionSource.fireActionValueEvent("selected", (Object)row.gg.getFullName());
            }
        });
    }

    public void clear() {
        this.tableRows.clear();
        this.table.setRows(this.tableRows);
    }

    public void setDataset(List<GridDatatype> fields) {
        if (fields == null) {
            return;
        }
        this.tableRows = new ArrayList(fields.size());
        for (GridDatatype gg : fields) {
            this.tableRows.add((TableRow)new Row(gg));
        }
        this.table.setRows(this.tableRows);
    }

    public JPanel getPanel() {
        return this.table;
    }

    public ActionSourceListener getActionSourceListener() {
        return this.actionSource;
    }

    private static class Row
    extends TableRowAbstract {
        GridDatatype gg;
        String dims;

        Row(GridDatatype gg) {
            this.gg = gg;
            Formatter f = new Formatter();
            for (Dimension dim : gg.getDimensions()) {
                f.format("%s ", dim.getShortName());
            }
            this.dims = f.toString();
        }

        public Object getUserObject() {
            return this.gg;
        }

        public Object getValueAt(int col) {
            switch (col) {
                case 0: {
                    return this.gg.getFullName();
                }
                case 1: {
                    return this.dims;
                }
                case 2: {
                    return this.gg.getUnitsString();
                }
                case 3: {
                    return this.gg.getDescription();
                }
            }
            return "error";
        }
    }
}

