/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid2;

import javax.annotation.Nullable;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridAxis1DTime;
import ucar.nc2.grid.GridAxisOffsetTimeRegular;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.time.CalendarDate;

class DataState {
    GridDataset gridDataset;
    Grid grid;
    GridCoordinateSystem geocs;
    @Nullable
    GridAxis1DTime rtaxis;
    @Nullable
    GridAxis1DTime taxis;
    @Nullable
    GridAxis1D toaxis;
    @Nullable
    GridAxisOffsetTimeRegular toaxisReg;
    @Nullable
    GridAxis1D zaxis;
    @Nullable
    GridAxis1D ensaxis;
    CalendarDate runtimeCoord;
    Object timeCoord;
    Object vertCoord;
    Double ensCoord;
    int horizStride = 1;
    Grid lastGrid;
    Object lastRuntime;
    Object lastTime;
    Object lastVert;
    Object lastEnsemble;
    int lastStride;

    public DataState(GridDataset gridDataset, Grid grid) {
        this.gridDataset = gridDataset;
        this.grid = grid;
        this.geocs = grid.getCoordinateSystem();
        if (this.geocs.getTimeOffsetAxis() != null) {
            if (this.geocs.getTimeOffsetAxis() instanceof GridAxisOffsetTimeRegular) {
                this.toaxisReg = (GridAxisOffsetTimeRegular)this.geocs.getTimeOffsetAxis();
            } else if (this.geocs.getTimeOffsetAxis() instanceof GridAxis1D) {
                this.toaxis = (GridAxis1D)this.geocs.getTimeOffsetAxis();
            }
        } else {
            this.taxis = this.geocs.getTimeAxis();
        }
        this.rtaxis = this.geocs.getRunTimeAxis();
        this.zaxis = this.geocs.getVerticalAxis();
        this.ensaxis = this.geocs.getEnsembleAxis();
    }

    boolean setRuntimeCoord(@Nullable Object coord) {
        boolean changed = coord != null && !coord.equals(this.runtimeCoord);
        this.runtimeCoord = (CalendarDate)coord;
        return changed;
    }

    boolean setTimeCoord(@Nullable Object coord) {
        boolean changed = coord != null && !coord.equals(this.timeCoord);
        this.timeCoord = coord;
        return changed;
    }

    boolean setVertCoord(@Nullable Object coord) {
        boolean changed = coord != null && !coord.equals(this.vertCoord);
        this.vertCoord = coord;
        return changed;
    }

    boolean setEnsCoord(@Nullable Object coord) {
        boolean changed = coord != null && !coord.equals(this.ensCoord);
        this.ensCoord = (Double)coord;
        return changed;
    }

    void saveState() {
        this.lastGrid = this.grid;
        this.lastRuntime = this.runtimeCoord;
        this.lastTime = this.timeCoord;
        this.lastVert = this.vertCoord;
        this.lastEnsemble = this.ensCoord;
        this.lastStride = this.horizStride;
    }

    boolean hasChanged() {
        if (this.grid != null && !this.grid.equals(this.lastGrid)) {
            return true;
        }
        if (this.runtimeCoord != null && !this.runtimeCoord.equals(this.lastRuntime)) {
            return true;
        }
        if (this.timeCoord != null && !this.timeCoord.equals(this.lastTime)) {
            return true;
        }
        if (this.vertCoord != null && !this.vertCoord.equals(this.lastVert)) {
            return true;
        }
        if (this.ensCoord != null && !this.ensCoord.equals(this.lastEnsemble)) {
            return true;
        }
        return this.horizStride != this.lastStride;
    }
}

