/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid2;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import ucar.array.ArrayType;
import ucar.nc2.constants.AxisType;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridAxisOffsetTimeRegular;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.internal.grid.GridLatLon2D;
import ucar.ui.prefs.BeanTable;
import ucar.ui.util.NamedObject;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.geoloc.Projection;
import ucar.util.prefs.PreferencesExt;

public class GridNewTable
extends JPanel {
    private final PreferencesExt prefs;
    private final BeanTable<DatasetBean> dsTable;
    private final BeanTable<GridBean> covTable;
    private final BeanTable<CoordSysBean> csysTable;
    private final BeanTable<AxisBean> axisTable;
    private final JSplitPane split;
    private final JSplitPane split2;
    private final JSplitPane split3;
    private final TextHistoryPane infoTA;
    private final IndependentWindow infoWindow;
    private GridDataset gridDataset;

    public GridNewTable(PreferencesExt prefs) {
        this.prefs = prefs;
        this.dsTable = new BeanTable(DatasetBean.class, (PreferencesExt)prefs.node("GridDataset"), false, "GridDataset", "ucar.nc2.grid.GridDataset", null);
        this.dsTable.addListSelectionListener(e -> {
            DatasetBean pb = (DatasetBean)this.dsTable.getSelectedBean();
            if (pb != null) {
                this.setDataset(pb.gdataset);
            }
        });
        this.covTable = new BeanTable(GridBean.class, (PreferencesExt)prefs.node("GridBeans"), false, "Grids", "ucar.nc2.grid.Grid", (Object)new GridBean());
        this.csysTable = new BeanTable(CoordSysBean.class, (PreferencesExt)prefs.node("CoordSysBeans"), false, "GridCoordinateSystems", "ucar.nc2.grid.GridCoordinateSystem", null);
        this.csysTable.addListSelectionListener(e -> {
            CoordSysBean bean = (CoordSysBean)this.csysTable.getSelectedBean();
            if (null != bean) {
                ArrayList<GridBean> result = new ArrayList<GridBean>();
                for (GridBean covBean : this.covTable.getBeans()) {
                    if (!covBean.getCoordSysName().equals(bean.getName())) continue;
                    result.add(covBean);
                }
                this.covTable.setSelectedBeans(result);
            }
        });
        this.axisTable = new BeanTable(AxisBean.class, (PreferencesExt)prefs.node("AxisBeans"), false, "GridAxes", "ucar.nc2.grid.GridAxis", null);
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.split = new JSplitPane(0, false, (Component)this.dsTable, (Component)this.covTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 300));
        this.split2 = new JSplitPane(0, false, this.split, (Component)this.csysTable);
        this.split2.setDividerLocation(prefs.getInt("splitPos2", 200));
        this.split3 = new JSplitPane(0, false, this.split2, (Component)this.axisTable);
        this.split3.setDividerLocation(prefs.getInt("splitPos3", 200));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split3, "Center");
        JTable jtable = this.dsTable.getJTable();
        PopupMenu dsPopup = new PopupMenu((JComponent)jtable, "Options");
        dsPopup.addAction("Show GridDataset", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatasetBean bean = (DatasetBean)GridNewTable.this.dsTable.getSelectedBean();
                if (bean != null) {
                    GridNewTable.this.infoTA.clear();
                    GridNewTable.this.infoTA.appendLine(bean.gdataset.toString());
                    GridNewTable.this.infoTA.gotoTop();
                    GridNewTable.this.infoWindow.show();
                }
            }
        });
        jtable = this.covTable.getJTable();
        PopupMenu csPopup = new PopupMenu((JComponent)jtable, "Options");
        csPopup.addAction("Show Grid", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GridBean vb = (GridBean)GridNewTable.this.covTable.getSelectedBean();
                if (vb != null) {
                    GridNewTable.this.infoTA.clear();
                    GridNewTable.this.infoTA.appendLine(vb.geogrid.toString());
                    GridNewTable.this.infoTA.gotoTop();
                    GridNewTable.this.infoWindow.show();
                }
            }
        });
        jtable = this.csysTable.getJTable();
        csPopup = new PopupMenu((JComponent)jtable, "Options");
        csPopup.addAction("Show GridCoordinateSystem", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordSysBean bean = (CoordSysBean)GridNewTable.this.csysTable.getSelectedBean();
                if (bean != null) {
                    GridNewTable.this.infoTA.clear();
                    Formatter f = new Formatter();
                    bean.gcs.show(f, false);
                    GridNewTable.this.infoTA.appendLine(f.toString());
                    GridNewTable.this.infoTA.gotoTop();
                    GridNewTable.this.infoWindow.show();
                }
            }
        });
        jtable = this.axisTable.getJTable();
        csPopup = new PopupMenu((JComponent)jtable, "Options");
        csPopup.addAction("Show GridAxis", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)GridNewTable.this.axisTable.getSelectedBean();
                if (bean != null) {
                    GridNewTable.this.infoTA.clear();
                    GridNewTable.this.infoTA.appendLine(bean.axis.toString());
                    GridNewTable.this.infoTA.gotoTop();
                    GridNewTable.this.infoWindow.show();
                }
            }
        });
        csPopup.addAction("Show Coord Value differences", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AxisBean bean = (AxisBean)GridNewTable.this.axisTable.getSelectedBean();
                if (bean != null) {
                    GridNewTable.this.infoTA.clear();
                    GridNewTable.this.infoTA.appendLine(bean.showCoordValueDiffs());
                    GridNewTable.this.infoTA.gotoTop();
                    GridNewTable.this.infoWindow.show();
                }
            }
        });
    }

    public void clear() {
        this.dsTable.clearBeans();
        this.covTable.clearBeans();
        this.csysTable.clearBeans();
        this.axisTable.clearBeans();
    }

    public void save() {
        this.dsTable.saveState(false);
        this.covTable.saveState(false);
        this.csysTable.saveState(false);
        this.axisTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        this.prefs.putInt("splitPos3", this.split3.getDividerLocation());
    }

    public void showInfo(Formatter result) {
        this.gridDataset.toString(result);
    }

    public void setGridDataset(GridDataset gds) {
        this.clear();
        this.gridDataset = gds;
        ImmutableList dsList = ImmutableList.of((Object)new DatasetBean(gds));
        this.dsTable.setBeans((List)dsList);
    }

    public GridDataset getGridCollection() {
        return this.gridDataset;
    }

    public void setDataset(GridDataset gridDataset) {
        ArrayList<GridBean> beanList = new ArrayList<GridBean>();
        for (Grid g : gridDataset.getGrids()) {
            beanList.add(new GridBean(g));
        }
        this.covTable.setBeans(beanList);
        ArrayList<CoordSysBean> csList = new ArrayList<CoordSysBean>();
        for (GridCoordinateSystem gcs : gridDataset.getGridCoordinateSystems()) {
            csList.add(new CoordSysBean(gcs));
        }
        this.csysTable.setBeans(csList);
        ArrayList<AxisBean> axisList = new ArrayList<AxisBean>();
        for (GridAxis axis : gridDataset.getGridAxes()) {
            axisList.add(new AxisBean(axis));
        }
        this.axisTable.setBeans(axisList);
    }

    private boolean contains(List<AxisBean> axisList, String name) {
        for (AxisBean axis : axisList) {
            if (!axis.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public List<GridBean> getCoverageBeans() {
        return this.covTable.getBeans();
    }

    public List<String> getSelectedGrids() {
        List grids = this.covTable.getSelectedBeans();
        ArrayList<String> result = new ArrayList<String>();
        for (GridBean gbean : grids) {
            result.add(gbean.getName());
        }
        return result;
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        return new Dialog(parent, title, modal);
    }

    private class Dialog
    extends JDialog {
        private Dialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(e -> {
                if (e.getPropertyName().equals("lookAndFeel")) {
                    SwingUtilities.updateComponentTreeUI(this);
                }
            });
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)GridNewTable.this, "Center");
            this.pack();
        }
    }

    public static class AxisBean {
        GridAxis axis;
        GridAxis1D axis1d;
        String name;
        String desc;
        String units;
        AxisType axisType;
        int[] shape;

        public AxisBean() {
        }

        public AxisBean(GridAxis v) {
            this.axis = v;
            if (this.axis instanceof GridAxis1D) {
                this.axis1d = (GridAxis1D)this.axis;
            }
            this.name = v.getName();
            this.axisType = v.getAxisType();
            this.units = v.getUnits();
            this.desc = v.getDescription();
            this.shape = v.getCoordsAsArray().getShape();
        }

        public String getName() {
            return this.name;
        }

        public String getAxisType() {
            return this.axisType == null ? "" : this.axisType.name();
        }

        public String getDescription() {
            return this.desc;
        }

        public String getUnits() {
            return this.units;
        }

        public String getSpacing() {
            GridAxis.Spacing sp = this.axis.getSpacing();
            return sp == null ? "" : sp.toString();
        }

        public String getShape() {
            return Arrays.toString(this.shape);
        }

        public double getNcoords() {
            return this.axis1d != null ? (double)this.axis1d.getNcoords() : Double.NaN;
        }

        public double getStartValue() {
            return this.axis1d != null ? this.axis1d.getStartValue() : Double.NaN;
        }

        public double getEndValue() {
            return this.axis1d != null ? this.axis1d.getEndValue() : Double.NaN;
        }

        public double getResolution() {
            return this.axis.getResolution();
        }

        public String getDependance() {
            String extra = this.axis.getDependsOn().isEmpty() ? "" : ": " + String.join((CharSequence)",", (Iterable<? extends CharSequence>)this.axis.getDependsOn());
            return this.axis.getDependenceType().toString() + extra;
        }

        String showCoordValueDiffs() {
            if (this.axis1d == null) {
                return "only 1d";
            }
            Formatter f = new Formatter();
            switch (this.axis1d.getSpacing()) {
                case regularInterval: 
                case regularPoint: {
                    f.format("%n%s resolution=%f%n", this.axis.getSpacing(), this.axis.getResolution());
                    break;
                }
                case irregularPoint: 
                case contiguousInterval: {
                    double[] values = this.axis1d.getValues();
                    int n = values.length;
                    f.format("%n%s (npts=%d)%n", this.axis.getSpacing(), n);
                    for (int i = 0; i < n - 1; ++i) {
                        double diff = values[i + 1] - values[i];
                        f.format("%10f %10f == %10f%n", values[i], values[i + 1], diff);
                    }
                    f.format("%n", new Object[0]);
                    break;
                }
                case discontiguousInterval: {
                    double[] values = this.axis1d.getValues();
                    int n = values.length;
                    f.format("%ndiscontiguous intervals (npts=%d)%n", n);
                    for (int i = 0; i < n; i += 2) {
                        double diff = values[i + 1] - values[i];
                        f.format("(%10f,%10f) = %10f%n", values[i], values[i + 1], diff);
                    }
                    f.format("%n", new Object[0]);
                }
            }
            return f.toString();
        }
    }

    public static class CoordSysBean {
        private GridCoordinateSystem gcs;
        private String coordTrans;
        private int nIndAxis;

        public CoordSysBean() {
        }

        public CoordSysBean(GridCoordinateSystem gcs) {
            this.gcs = gcs;
            Formatter f = new Formatter();
            Projection p = gcs.getHorizCoordSystem().getProjection();
            if (p != null) {
                f.format("%s ", p.getName());
            }
            this.coordTrans = f.toString();
            for (GridAxis axis : gcs.getGridAxes()) {
                if (axis.getDependenceType() != GridAxis.DependenceType.independent) continue;
                ++this.nIndAxis;
            }
        }

        public String getName() {
            return this.gcs.getName();
        }

        public int getNIndCoords() {
            return this.nIndAxis;
        }

        public String getRuntime() {
            return this.gcs.getRunTimeAxis() == null ? "" : this.gcs.getRunTimeAxis().getName();
        }

        public String getTime() {
            return this.gcs.getTimeAxis() == null ? "" : this.gcs.getTimeAxis().getName();
        }

        public String getTimeOffset() {
            return this.gcs.getTimeOffsetAxis() == null ? "" : this.gcs.getTimeOffsetAxis().getName();
        }

        public String getEns() {
            return this.gcs.getEnsembleAxis() == null ? "" : this.gcs.getEnsembleAxis().getName();
        }

        public String getVert() {
            return this.gcs.getVerticalAxis() == null ? "" : this.gcs.getVerticalAxis().getName();
        }

        public String getTransforms() {
            return this.coordTrans;
        }

        public String getProjection() {
            Projection p = this.gcs.getHorizCoordSystem().getProjection();
            return p == null ? "" : p.getName();
        }
    }

    public static class GridBean
    implements NamedObject {
        Grid geogrid;
        String name;
        String desc;
        String units;
        String coordSysName;
        ArrayType dataType;

        public String hiddenProperties() {
            return "value";
        }

        public GridBean() {
        }

        public GridBean(Grid geogrid) {
            this.geogrid = geogrid;
            this.name = geogrid.getName();
            this.desc = geogrid.getDescription();
            this.units = geogrid.getUnits();
            this.dataType = geogrid.getArrayType();
            this.coordSysName = geogrid.getCoordinateSystem().getName();
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public Object getValue() {
            return this.geogrid;
        }

        public String getUnits() {
            return this.units;
        }

        public String getCoordSysName() {
            return this.coordSysName;
        }

        public ArrayType getArrayType() {
            return this.dataType;
        }

        public String getShape() {
            int n = Iterables.size((Iterable)this.geogrid.getCoordinateSystem().getGridAxes());
            int[] shape = new int[n];
            int count = 0;
            for (GridAxis gridAxis : this.geogrid.getCoordinateSystem().getGridAxes()) {
                int ncoords = -1;
                if (gridAxis instanceof GridAxis1D) {
                    ncoords = ((GridAxis1D)gridAxis).getNcoords();
                } else if (gridAxis instanceof GridAxisOffsetTimeRegular) {
                    ncoords = ((GridAxisOffsetTimeRegular)gridAxis).getNOffsetPerRun();
                }
                shape[count++] = ncoords;
            }
            if (this.geogrid.getCoordinateSystem().getHorizCoordSystem() instanceof GridLatLon2D) {
                GridLatLon2D hcs = (GridLatLon2D)this.geogrid.getCoordinateSystem().getHorizCoordSystem();
                int[] hshape = hcs.getShape();
                shape[count++] = hshape[0];
                shape[count++] = hshape[1];
            }
            return Arrays.toString(shape);
        }
    }

    public static class DatasetBean {
        GridDataset gdataset;

        public DatasetBean() {
        }

        public DatasetBean(GridDataset cds) {
            this.gdataset = cds;
        }

        public String getName() {
            return this.gdataset.getName();
        }

        public int getNCoverages() {
            return Iterables.size((Iterable)this.gdataset.getGrids());
        }

        public int getNCooordSys() {
            return Iterables.size((Iterable)this.gdataset.getGridCoordinateSystems());
        }

        public int getNAxes() {
            return Iterables.size((Iterable)this.gdataset.getGridAxes());
        }
    }
}

