/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.grid2;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Formatter;
import java.util.Optional;
import ucar.array.Array;
import ucar.array.Arrays;
import ucar.array.InvalidRangeException;
import ucar.array.IsMissingEvaluator;
import ucar.array.MinMax;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridAxis2D;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.grid.GridHorizCoordinateSystem;
import ucar.nc2.grid.GridReferencedArray;
import ucar.nc2.grid.GridSubset;
import ucar.nc2.internal.grid.GridLatLon2D;
import ucar.nc2.ui.grid.ColorScale;
import ucar.nc2.ui.grid2.DataState;
import ucar.ui.prefs.Debug;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.util.Format;
import ucar.util.prefs.PreferencesExt;

public class GridRenderer {
    private static boolean debugPts = false;
    private final boolean drawGrid = true;
    private boolean drawGridLines = true;
    private boolean drawContours;
    private boolean isNewField = true;
    private ColorScale colorScale;
    private ColorScale.MinMaxType dataMinMaxType = ColorScale.MinMaxType.horiz;
    private Projection drawProjection;
    private Projection dataProjection;
    private DataState dataState;
    private GridReferencedArray geodata;
    private boolean useModeForProjections = false;
    private boolean sameProjection = true;
    private LatLonProjection projectll;
    private static final boolean debugHorizDraw = false;
    private static final boolean debugMiss = false;
    private GeneralPath gpRun = new GeneralPath(0, 25);

    public GridRenderer(PreferencesExt store) {
    }

    public ColorScale getColorScale() {
        return this.colorScale;
    }

    public void setColorScale(ColorScale cs) {
        this.colorScale = cs;
    }

    public void setDataMinMaxType(ColorScale.MinMaxType type) {
        if (type != this.dataMinMaxType) {
            this.dataMinMaxType = type;
        }
    }

    public DataState setGrid(GridDataset gridDataset, Grid grid) {
        this.dataState = new DataState(gridDataset, grid);
        this.isNewField = true;
        return this.dataState;
    }

    public Projection getDataProjection() {
        return this.dataProjection;
    }

    public void setDataProjection(Projection dataProjection) {
        this.dataProjection = dataProjection;
    }

    public Projection getDisplayProjection() {
        return this.drawProjection;
    }

    public void setViewProjection(Projection project) {
        this.drawProjection = project;
    }

    public void setDrawBB(boolean drawBB) {
    }

    public void setDrawGridLines(boolean drawGrid) {
        this.drawGridLines = drawGrid;
    }

    public void setDrawContours(boolean drawContours) {
        this.drawContours = drawContours;
    }

    public void setDrawContourLabels(boolean drawContourLabels) {
    }

    public String getXYvalueStr(ProjectionPoint loc) {
        GridHorizCoordinateSystem hcs;
        Optional opt;
        if (this.dataState.grid == null || this.geodata == null) {
            return "";
        }
        if (!this.sameProjection) {
            LatLonPoint llpt = this.drawProjection.projToLatLon(loc);
            loc = this.dataProjection.latLonToProj(llpt);
        }
        if (!(opt = (hcs = this.dataState.geocs.getHorizCoordSystem()).findXYindexFromCoord(loc.getX(), loc.getY())).isPresent()) {
            return "hcs.findXYindexFromCoord failed";
        }
        GridHorizCoordinateSystem.CoordReturn cr = (GridHorizCoordinateSystem.CoordReturn)opt.get();
        try {
            Array array = this.geodata.data();
            double dataValue = ((Number)array.get(new int[]{cr.yindex, cr.xindex})).doubleValue();
            return this.makeXYZvalueStr(dataValue, cr);
        }
        catch (Exception e) {
            return "error on " + cr.toString();
        }
    }

    private String makeXYZvalueStr(double value, GridHorizCoordinateSystem.CoordReturn cr) {
        String val = this.dataState.grid.isMissing(value) ? "missing value" : Format.d((double)value, (int)6);
        Formatter sbuff = new Formatter();
        sbuff.format("%s %s", val, this.dataState.grid.getUnits());
        sbuff.format(" @ (%f,%f)", cr.xcoord, cr.ycoord);
        sbuff.format("  [%d,%d]", cr.xindex, cr.yindex);
        return sbuff.toString();
    }

    private GridReferencedArray readHSlice() throws IOException, InvalidRangeException {
        if (!this.dataState.hasChanged()) {
            return this.geodata;
        }
        GridSubset subset = new GridSubset();
        if (this.dataState.vertCoord != null) {
            subset.setVertCoord(this.dataState.vertCoord);
        }
        if (this.dataState.timeCoord != null) {
            if (this.dataState.taxis != null) {
                subset.setTimeCoord(this.dataState.timeCoord);
            } else {
                subset.setTimeOffsetCoord(this.dataState.timeCoord);
            }
        }
        if (this.dataState.runtimeCoord != null) {
            subset.setRunTime(this.dataState.runtimeCoord);
        }
        if (this.dataState.ensCoord != null) {
            subset.setEnsCoord((Object)this.dataState.ensCoord);
        }
        if (this.dataState.horizStride != 1) {
            subset.setHorizStride(this.dataState.horizStride);
        }
        this.geodata = this.dataState.grid.readData(subset);
        this.dataState.saveState();
        return this.geodata;
    }

    private void setColorScaleParams() throws IOException, InvalidRangeException {
        if (this.dataMinMaxType == ColorScale.MinMaxType.hold && !this.isNewField) {
            return;
        }
        this.isNewField = false;
        GridReferencedArray dataArr = this.readHSlice();
        if (dataArr != null) {
            MinMax minmax = Arrays.getMinMaxSkipMissingData((Array)dataArr.data(), (IsMissingEvaluator)this.dataState.grid);
            this.colorScale.setMinMax(minmax.min(), minmax.max());
            this.colorScale.setGeoGrid((ucar.ma2.IsMissingEvaluator)this.dataState.grid);
        }
    }

    public void renderPlanView(Graphics2D g, AffineTransform dFromN) throws IOException, InvalidRangeException {
        if (this.dataState.grid == null || this.colorScale == null || this.drawProjection == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        GridReferencedArray dataArr = this.readHSlice();
        if (dataArr == null) {
            return;
        }
        this.setColorScaleParams();
        GridHorizCoordinateSystem hcs = this.dataState.geocs.getHorizCoordSystem();
        if (hcs.isRegular()) {
            this.drawGridHorizRegular(g, dataArr);
        } else {
            this.drawGridHoriz(g, dataArr);
        }
    }

    private boolean drawGridBB(Graphics2D g, LatLonRect latLonRect) {
        g.setColor(Color.BLACK);
        Rectangle2D.Double rect = new Rectangle2D.Double(latLonRect.getLonMin(), latLonRect.getLatMin(), latLonRect.getWidth(), latLonRect.getHeight());
        g.draw(rect);
        return true;
    }

    private void drawGridHorizRegular(Graphics2D g, GridReferencedArray referencedArray) {
        GridCoordinateSystem gsys = referencedArray.csSubset();
        Array data = referencedArray.data();
        data = Arrays.reduce((Array)data);
        int count = 0;
        GridAxis1D xaxis = (GridAxis1D)gsys.getXHorizAxis();
        GridAxis1D yaxis = (GridAxis1D)gsys.getYHorizAxis();
        if (data.getRank() != 2) {
            System.out.printf("drawGridHorizRegular Rank equals %d, must be 2%n", data.getRank());
            return;
        }
        int nx = xaxis.getNcoords();
        int ny = yaxis.getNcoords();
        this.sameProjection = this.drawProjection.equals(this.dataProjection);
        if (this.drawProjection.isLatLon()) {
            this.projectll = (LatLonProjection)this.drawProjection;
            double centerLon = this.projectll.getCenterLon();
            if (Debug.isSet((String)"projection/LatLonShift")) {
                System.out.println("projection/LatLonShift: gridDraw = " + centerLon);
            }
        }
        this.colorScale.resetHist();
        for (Number number : data) {
            this.colorScale.getIndexFromValue(number.doubleValue());
        }
        int modeColor = this.colorScale.getHistMax();
        MinMax xminmax = xaxis.getCoordEdgeMinMax();
        MinMax yminmax = yaxis.getCoordEdgeMinMax();
        if (this.sameProjection) {
            count += this.drawRect(g, modeColor, xminmax.min(), yminmax.min(), xminmax.max(), yminmax.max(), this.drawProjection.isLatLon());
        } else if (this.useModeForProjections) {
            this.drawPathShape(g, modeColor, xaxis, yaxis);
        }
        debugPts = Debug.isSet((String)"GridRenderer/showPts");
        for (int y = 0; y < ny; ++y) {
            double ybeg = yaxis.getCoordEdge1(y);
            double yend = yaxis.getCoordEdge2(y);
            int lastColor = 0;
            int run = 0;
            int xbeg = 0;
            for (int x = 0; x < nx; ++x) {
                double val = ((Number)data.get(new int[]{y, x})).doubleValue();
                int thisColor = this.colorScale.getIndexFromValue(val);
                if (run == 0 || lastColor == thisColor) {
                    ++run;
                } else {
                    if (this.sameProjection) {
                        if (lastColor != modeColor) {
                            count += this.drawRect(g, lastColor, xaxis.getCoordEdge1(xbeg), ybeg, xaxis.getCoordEdge2(x), yend, this.drawProjection.isLatLon());
                        }
                    } else if (!this.useModeForProjections || lastColor != modeColor) {
                        count += this.drawPathRun(g, lastColor, ybeg, yend, xaxis, xbeg, x - 1, debugPts);
                    }
                    xbeg = x;
                }
                lastColor = thisColor;
            }
            if (this.sameProjection) {
                if (lastColor == modeColor) continue;
                count += this.drawRect(g, lastColor, xaxis.getCoordEdge1(xbeg), ybeg, xaxis.getCoordEdge2(xaxis.getNcoords() - 1), yend, this.drawProjection.isLatLon());
                continue;
            }
            if (this.useModeForProjections && lastColor == modeColor) continue;
            count += this.drawPathRun(g, lastColor, ybeg, yend, xaxis, xbeg, nx - 1, false);
        }
    }

    private int drawRectLatLon(Graphics2D g, int color, double lon1, double lat1, double lon2, double lat2) {
        g.setColor(this.colorScale.getColor(color));
        int count = 0;
        ProjectionRect[] rects = this.projectll.latLonToProjRect(lat1, lon1, lat2, lon2);
        for (int i = 0; i < 2; ++i) {
            if (null == rects[i]) continue;
            ProjectionRect r2 = rects[i];
            Rectangle2D.Double r = new Rectangle2D.Double(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
            g.fill(r);
            ++count;
        }
        return count;
    }

    private int drawRect(Graphics2D g, int color, double w1, double h1, double w2, double h2, boolean useLatlon) {
        if (useLatlon) {
            return this.drawRectLatLon(g, color, w1, h1, w2, h2);
        }
        g.setColor(this.colorScale.getColor(color));
        double wmin = Math.min(w1, w2);
        double hmin = Math.min(h1, h2);
        double width = Math.abs(w1 - w2);
        double height = Math.abs(h1 - h2);
        Rectangle2D.Double rect = new Rectangle2D.Double(wmin, hmin, width, height);
        g.fill(rect);
        return 1;
    }

    private int drawPathShape(Graphics2D g, int color, GridAxis1D xaxis, GridAxis1D yaxis) {
        int count = 0;
        for (int y = 0; y < yaxis.getNcoords() - 1; ++y) {
            double y1 = yaxis.getCoordEdge1(y);
            double y2 = yaxis.getCoordEdge2(y);
            count += this.drawPathRun(g, color, y1, y2, xaxis, 0, xaxis.getNcoords() - 1, false);
        }
        return count;
    }

    private int drawPathRun(Graphics2D g, int color, double y1, double y2, GridAxis1D xaxis, int x1, int x2, boolean debugPts) {
        int e;
        int nx = xaxis.getNcoords();
        if (x1 < 0 || x2 < 0 || x2 > nx || x1 > x2) {
            return 0;
        }
        int count = 0;
        this.gpRun.reset();
        LatLonPoint llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge1(x1), y1);
        ProjectionPoint pt = this.drawProjection.latLonToProj(llp);
        if (debugPts) {
            System.out.printf("** moveTo = x1=%d (%f, %f)%n", x1, pt.getX(), pt.getY());
        }
        this.gpRun.moveTo((float)pt.getX(), (float)pt.getY());
        for (e = x1; e <= x2; ++e) {
            llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge2(e), y1);
            pt = this.drawProjection.latLonToProj(llp);
            if (debugPts) {
                System.out.printf("%d x2=%d lineTo = (%f, %f)%n", count++, e, pt.getX(), pt.getY());
            }
            this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
        }
        for (e = x2; e >= x1; --e) {
            llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge2(e), y2);
            pt = this.drawProjection.latLonToProj(llp);
            if (debugPts) {
                System.out.printf("%d x2=%d lineTo = (%f, %f)%n", count++, e, pt.getX(), pt.getY());
            }
            this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
        }
        llp = this.dataProjection.projToLatLon(xaxis.getCoordEdge1(x1), y2);
        pt = this.drawProjection.latLonToProj(llp);
        if (debugPts) {
            System.out.printf("%d (%d,y2) lineTo = [%f, %f]%n", count, x1, pt.getX(), pt.getY());
        }
        this.gpRun.lineTo((float)pt.getX(), (float)pt.getY());
        g.setColor(this.colorScale.getColor(color));
        try {
            g.fill(this.gpRun);
        }
        catch (Throwable e2) {
            System.out.println("Exception in drawPathRun = " + e2);
            return 0;
        }
        return 1;
    }

    private void drawGridHoriz(Graphics2D g, GridReferencedArray referencedArray) {
        GridLatLon2D hcsys2D = (GridLatLon2D)referencedArray.csSubset().getHorizCoordSystem();
        Array data = referencedArray.data();
        data = Arrays.reduce((Array)data);
        GridAxis2D lat2D = hcsys2D.getLatAxis();
        GridAxis2D lon2D = hcsys2D.getLonAxis();
        GeneralPath gp = new GeneralPath(0, 5);
        int[] shape = hcsys2D.getShape();
        int ny = shape[0];
        int nx = shape[1];
        for (int y = 0; y < ny; ++y) {
            int x = 0;
            while (x < nx) {
                gp.reset();
                gp.moveTo((float)lon2D.getCoordValue(y, x), (float)lat2D.getCoordValue(y, x));
                gp.lineTo((float)lon2D.getCoordValue(y, x + 1), (float)lat2D.getCoordValue(y, x + 1));
                gp.lineTo((float)lon2D.getCoordValue(y + 1, x + 1), (float)lat2D.getCoordValue(y + 1, x + 1));
                gp.lineTo((float)lon2D.getCoordValue(y + 1, x), (float)lat2D.getCoordValue(y + 1, x));
                double val = ((Number)data.get(new int[]{y, x++})).doubleValue();
                int colorIndex = this.colorScale.getIndexFromValue(val);
                g.setColor(this.colorScale.getColor(colorIndex));
                g.fill(gp);
            }
        }
    }
}

