/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Set;
import javax.swing.JOptionPane;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.op.AggTable;
import ucar.util.prefs.PreferencesExt;

public class AggPanel
extends OpPanel {
    private final AggTable aggTable;
    private NetcdfDataset ncd;

    public AggPanel(PreferencesExt p) {
        super(p, "file:", true, false);
        this.aggTable = new AggTable(this.prefs, this.buttPanel);
        this.aggTable.addPropertyChangeListener(e -> {
            switch (e.getPropertyName()) {
                case "openNetcdfFile": {
                    NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                    if (ncfile == null) break;
                    ToolsUI.getToolsUI().openNetcdfFile(ncfile);
                    break;
                }
                case "openCoordSystems": {
                    NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                    if (ncfile == null) {
                        return;
                    }
                    try {
                        NetcdfDataset ncd = NetcdfDatasets.enhance((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
                        ToolsUI.getToolsUI().openCoordSystems(ncd);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
                case "openGridDataset": {
                    NetcdfFile ncfile = (NetcdfFile)e.getNewValue();
                    if (ncfile == null) {
                        return;
                    }
                    try {
                        NetcdfDataset ncd = NetcdfDatasets.enhance((NetcdfFile)ncfile, (Set)NetcdfDataset.getDefaultEnhanceMode(), null);
                        ToolsUI.getToolsUI().openGridDataset(ncd);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    break;
                }
            }
        });
        this.add((Component)this.aggTable, "Center");
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            if (this.ncd != null) {
                try {
                    this.ncd.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            this.ncd = NetcdfDatasets.openDataset((String)command);
            this.aggTable.setAggDataset(this.ncd);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.ncd != null) {
            this.ncd.close();
        }
        this.ncd = null;
        this.aggTable.clear();
    }

    @Override
    public void save() {
        this.aggTable.save();
        super.save();
    }
}

