/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.ToolsUI;
import ucar.nc2.ui.op.FeatureScanPanel;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.util.prefs.PreferencesExt;

public class FeatureScanOpPanel
extends OpPanel {
    private final FeatureScanPanel ftTable;
    final FileManager dirChooser;

    public FeatureScanOpPanel(PreferencesExt prefs, final FileManager dirChooser) {
        super(prefs, "dir:", false, false);
        this.dirChooser = dirChooser;
        this.ftTable = new FeatureScanPanel(prefs);
        this.add((Component)this.ftTable, "Center");
        this.ftTable.addPropertyChangeListener(e -> {
            if (!(e.getNewValue() instanceof String)) {
                return;
            }
            String datasetName = (String)e.getNewValue();
            switch (e.getPropertyName()) {
                case "openPointFeatureDataset": {
                    ToolsUI.getToolsUI().openPointFeatureDataset(datasetName);
                    break;
                }
                case "openNetcdfFile": {
                    ToolsUI.getToolsUI().openNetcdfFile(datasetName);
                    break;
                }
                case "openCoordSystems": {
                    ToolsUI.getToolsUI().openCoordSystems(datasetName);
                    break;
                }
                case "openNcML": {
                    ToolsUI.getToolsUI().openNcML(datasetName);
                    break;
                }
                case "openGridDataset": {
                    ToolsUI.getToolsUI().openGridDataset(datasetName);
                    break;
                }
                case "openCoverageDataset": {
                    ToolsUI.getToolsUI().openCoverageDataset(datasetName);
                    break;
                }
                case "openNewGrid": {
                    ToolsUI.getToolsUI().openNewGrid(datasetName);
                    break;
                }
                case "openRadialDataset": {
                    ToolsUI.getToolsUI().openRadialDataset(datasetName);
                }
            }
        });
        dirChooser.getFileChooser().setFileSelectionMode(2);
        dirChooser.setCurrentDirectory(prefs.get("currDir", "."));
        AbstractAction fileAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String filename = dirChooser.chooseFilename();
                if (filename == null) {
                    return;
                }
                FeatureScanOpPanel.this.cb.setSelectedItem((Object)filename);
            }
        };
        BAMutil.setActionProperties((AbstractAction)fileAction, (String)"FileChooser", (String)"open Local dataset...", (boolean)false, (int)76, (int)-1);
        BAMutil.addActionToContainer((Container)this.buttPanel, (Action)fileAction);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        return this.ftTable.setScanDirectory(command);
    }

    @Override
    public void closeOpenFiles() {
        this.ftTable.clear();
    }

    @Override
    public void save() {
        this.dirChooser.save();
        this.ftTable.save();
        this.prefs.put("currDir", this.dirChooser.getCurrentDirectory());
        super.save();
    }
}

