/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.ft2.scan.FeatureScan;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class FeatureScanPanel
extends JPanel {
    private final PreferencesExt prefs;
    private final BeanTable<FeatureScan.Bean> ftTable;
    private final JSplitPane split;
    private final TextHistoryPane dumpTA;
    private final IndependentWindow infoWindow;

    public FeatureScanPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.ftTable = new BeanTable(FeatureScan.Bean.class, (PreferencesExt)prefs.node("FeatureDatasetBeans"), false);
        this.ftTable.addListSelectionListener(e -> {
            FeatureScan.Bean ftb = (FeatureScan.Bean)this.ftTable.getSelectedBean();
            if (ftb != null) {
                this.setSelectedFeatureDataset(ftb);
            }
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.ftTable.getJTable(), "Options");
        varPopup.addAction("Open as NetcdfFile", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openNetcdfFile", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open in CoordSystems", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openCoordSystems", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as GridDataset", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openGridDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as CoverageDataset", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openCoverageDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as NewGrid", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openNewGrid", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as PointDataset", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openPointFeatureDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as RadialDataset", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openRadialDataset", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Open as NcML", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.firePropertyChange("openNcML", null, ftb.f.getPath());
            }
        });
        varPopup.addAction("Show Report on selected rows", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selected = FeatureScanPanel.this.ftTable.getSelectedBeans();
                Formatter f = new Formatter();
                for (FeatureScan.Bean bean : selected) {
                    bean.toString(f, false);
                }
                FeatureScanPanel.this.dumpTA.setText(f.toString());
            }
        });
        varPopup.addAction("Run Coverage Classifier", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureScan.Bean ftb = (FeatureScan.Bean)FeatureScanPanel.this.ftTable.getSelectedBean();
                if (ftb == null) {
                    return;
                }
                FeatureScanPanel.this.dumpTA.setText(ftb.runClassifier());
            }
        });
        TextHistoryPane infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 500, 300)));
        this.dumpTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, (Component)this.ftTable, (Component)this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.ftTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
    }

    public void clear() {
        this.ftTable.setBeans(new ArrayList());
    }

    public boolean setScanDirectory(String dirName) {
        this.clear();
        FeatureScan scanner = new FeatureScan(dirName, true);
        Formatter errlog = new Formatter();
        List beans = scanner.scan(errlog);
        if (beans.isEmpty()) {
            this.dumpTA.setText(errlog.toString());
            return false;
        }
        this.ftTable.setBeans(beans);
        return true;
    }

    private void setSelectedFeatureDataset(FeatureScan.Bean ftb) {
        this.dumpTA.setText(ftb.toString());
        this.dumpTA.gotoTop();
    }
}

