/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.JSplitPane;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.internal.iosp.hdf4.H4header;
import ucar.nc2.internal.iosp.hdf4.H4iosp;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.ui.op.Hdf4Table;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Hdf4NewTable
extends Hdf4Table {
    private final BeanTable<TagBean> tagTable;
    private final JSplitPane split;
    private TextHistoryPane dumpTA;
    private H4iosp iosp;
    private H4header header;

    Hdf4NewTable(PreferencesExt prefs) {
        super(prefs);
        this.tagTable = new BeanTable(TagBean.class, (PreferencesExt)prefs.node("Hdf4Object"), false);
        this.tagTable.addListSelectionListener(e -> {
            TagBean bean = (TagBean)this.tagTable.getSelectedBean();
            if (bean != null) {
                this.dumpTA.setText("Tag=\n ");
                this.dumpTA.appendLine(bean.tag.detail());
                this.dumpTA.appendLine("\nVinfo=");
                this.dumpTA.appendLine(bean.tag.getVinfo());
            }
        });
        this.dumpTA = new TextHistoryPane();
        this.split = new JSplitPane(0, false, (Component)this.tagTable, (Component)this.dumpTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
    }

    @Override
    public void save() {
        this.tagTable.saveState(false);
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.iosp != null) {
            this.iosp.close();
        }
        this.iosp = null;
    }

    @Override
    void setHdf4File(RandomAccessFile raf) throws IOException {
        this.closeOpenFiles();
        this.iosp = new H4iosp();
        try {
            NetcdfFiles.build((IOServiceProvider)this.iosp, (RandomAccessFile)raf, (String)raf.getLocation(), null);
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter(20000);
            t.printStackTrace(new PrintWriter(sw));
            this.dumpTA.setText(sw.toString());
        }
        ArrayList<TagBean> beanList = new ArrayList<TagBean>();
        this.header = (H4header)this.iosp.sendIospMessage((Object)"header");
        if (this.header != null) {
            for (H4header.Tag tag : this.header.getTags()) {
                beanList.add(new TagBean(tag));
            }
        }
        this.tagTable.setBeans(beanList);
    }

    @Override
    void getEosInfo(Formatter f) throws IOException {
        this.header.getEosInfo(f);
    }

    public static class TagBean {
        H4header.Tag tag;

        public TagBean() {
        }

        TagBean(H4header.Tag tag) {
            this.tag = tag;
        }

        public short getCode() {
            return this.tag.getCode();
        }

        public String getType() {
            return this.tag.getType();
        }

        public short getRefno() {
            return this.tag.getRefno();
        }

        public boolean isExtended() {
            return this.tag.isExtended();
        }

        public String getVClass() {
            return this.tag.getVClass();
        }

        public int getOffset() {
            return this.tag.getOffset();
        }

        public int getLength() {
            return this.tag.getLength();
        }

        public boolean isUsed() {
            return this.tag.isUsed();
        }

        public String getVinfo() {
            return this.tag.getVinfo();
        }
    }
}

