/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.op.Hdf4NewTable;
import ucar.nc2.ui.op.Hdf4Table;
import ucar.ui.widget.BAMutil;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Hdf4Panel
extends OpPanel {
    private final Hdf4Table hdf4Table;
    private RandomAccessFile raf;

    public Hdf4Panel(PreferencesExt p, boolean useBuilders) {
        super(p, "file:", true, false);
        this.hdf4Table = useBuilders ? new Hdf4NewTable(this.prefs) : new Hdf4Table(this.prefs);
        this.add((Component)this.hdf4Table, "Center");
        AbstractButton eosdump = BAMutil.makeButtcon((String)"alien", (String)"Show EOS processing", (boolean)false);
        eosdump.addActionListener(e -> {
            try {
                Formatter f = new Formatter();
                this.hdf4Table.getEosInfo(f);
                this.detailTA.setText(f.toString());
                this.detailWindow.show();
            }
            catch (IOException ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
            }
        });
        this.buttPanel.add(eosdump);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            if (this.raf != null) {
                this.raf.close();
            }
            this.raf = new RandomAccessFile(command, "r");
            this.hdf4Table.setHdf4File(this.raf);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "NetcdfDataset cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        this.hdf4Table.closeOpenFiles();
    }

    @Override
    public void save() {
        this.hdf4Table.save();
        super.save();
    }
}

