/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.ma2.Array;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;
import ucar.nc2.Variable;
import ucar.nc2.internal.iosp.hdf5.H5diagNew;
import ucar.nc2.internal.iosp.hdf5.H5header;
import ucar.nc2.internal.iosp.hdf5.H5iosp;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.ui.op.Hdf5DataTable;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Hdf5NewDataTable
extends Hdf5DataTable {
    private final BeanTable<VarBean> objectTable;
    private final JSplitPane splitH;
    private final TextHistoryPane infoTA;
    private NetcdfFile ncfile;
    private H5iosp iosp;
    private String location;

    public Hdf5NewDataTable(PreferencesExt prefs, JPanel buttPanel) {
        super(prefs, null);
        this.objectTable = new BeanTable(VarBean.class, (PreferencesExt)prefs.node("Hdf5Object"), false, "H5headerNew.DataObject", "Level 2A data object header", null);
        this.objectTable.addListSelectionListener(e -> {
            VarBean vb = (VarBean)this.objectTable.getSelectedBean();
            if (vb != null) {
                vb.count(true);
                vb.show();
            }
        });
        AbstractAction calcAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Hdf5NewDataTable.this.calcStorage();
            }
        };
        BAMutil.setActionProperties((AbstractAction)calcAction, (String)"nj22/Dataset", (String)"calc storage", (boolean)false, (int)68, (int)-1);
        BAMutil.addActionToContainer((Container)buttPanel, (Action)calcAction);
        PopupMenu varPopup = new PopupMenu((JComponent)this.objectTable.getJTable(), "Options");
        varPopup.addAction("deflate", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean mb = (VarBean)Hdf5NewDataTable.this.objectTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Hdf5NewDataTable.this.infoTA.clear();
                Formatter f = new Formatter();
                Hdf5NewDataTable.this.deflate(f, mb);
                Hdf5NewDataTable.this.infoTA.appendLine(f.toString());
                Hdf5NewDataTable.this.infoTA.gotoTop();
            }
        });
        varPopup.addAction("show storage", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean mb = (VarBean)Hdf5NewDataTable.this.objectTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Hdf5NewDataTable.this.infoTA.clear();
                Formatter f = new Formatter();
                Hdf5NewDataTable.this.showStorage(f, mb);
                Hdf5NewDataTable.this.infoTA.appendLine(f.toString());
                Hdf5NewDataTable.this.infoTA.gotoTop();
            }
        });
        varPopup.addAction("show vlen", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VarBean mb = (VarBean)Hdf5NewDataTable.this.objectTable.getSelectedBean();
                if (mb == null) {
                    return;
                }
                Hdf5NewDataTable.this.infoTA.clear();
                Formatter f = new Formatter();
                Hdf5NewDataTable.this.showVlen(f, mb);
                Hdf5NewDataTable.this.infoTA.appendLine(f.toString());
                Hdf5NewDataTable.this.infoTA.gotoTop();
            }
        });
        this.infoTA = new TextHistoryPane();
        this.splitH = new JSplitPane(0, false, (Component)this.objectTable, (Component)this.infoTA);
        this.splitH.setDividerLocation(prefs.getInt("splitPosH", 600));
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitH, "Center");
    }

    @Override
    public void save() {
        this.objectTable.saveState(false);
        this.prefs.putInt("splitPosH", this.splitH.getDividerLocation());
    }

    @Override
    public void closeOpenFiles() throws IOException {
        if (this.iosp != null) {
            this.iosp.close();
        }
        this.iosp = null;
    }

    @Override
    public void setHdf5File(RandomAccessFile raf) throws IOException {
        this.closeOpenFiles();
        this.location = raf.getLocation();
        ArrayList<VarBean> beanList = new ArrayList<VarBean>();
        this.iosp = new H5iosp();
        try {
            this.ncfile = NetcdfFiles.build((IOServiceProvider)this.iosp, (RandomAccessFile)raf, (String)raf.getLocation(), null);
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter(20000);
            t.printStackTrace(new PrintWriter(sw));
            this.infoTA.setText(sw.toString());
        }
        for (Variable v : this.ncfile.getVariables()) {
            beanList.add(new VarBean(v));
        }
        this.objectTable.setBeans(beanList);
    }

    public void showInfo(Formatter f) throws IOException {
        if (this.iosp == null) {
            return;
        }
        H5diagNew header = new H5diagNew(this.ncfile, this.iosp);
        header.showCompress(f);
    }

    void deflate(Formatter f, VarBean bean) {
        H5diagNew diag = new H5diagNew(this.ncfile, this.iosp);
        try {
            diag.showCompress(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void calcStorage() {
        if (this.iosp == null) {
            return;
        }
        long totalVars = 0L;
        long totalStorage = 0L;
        long totalCount = 0L;
        Formatter f = new Formatter();
        for (Object obean : this.objectTable.getBeans()) {
            VarBean bean = (VarBean)obean;
            bean.count(false);
            totalStorage += bean.getStorage();
            totalCount += bean.getNchunks();
            totalVars += bean.getSizeBytes();
        }
        f.format("%n", new Object[0]);
        f.format(" total uncompressed  = %,d%n", totalVars);
        f.format(" total data storage  = %,d%n", totalStorage);
        File raf = new File(this.location);
        f.format("        file size    = %,d%n", raf.length());
        float ratio = totalStorage == 0L ? 0.0f : (float)raf.length() / (float)totalStorage;
        f.format("        overhead     = %f%n", Float.valueOf(ratio));
        ratio = totalStorage == 0L ? 0.0f : (float)totalVars / (float)totalStorage;
        f.format("         compression = %f%n", Float.valueOf(ratio));
        f.format("   # data chunks     = %d%n", totalCount);
        this.infoTA.setText(f.toString());
    }

    private void showStorage(Formatter f, VarBean bean) {
        try {
            bean.vinfo.countStorageSize(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void showVlen(Formatter f, VarBean bean) {
        if (!bean.v.isVariableLength()) {
            f.format("Variable %s must be variable length", bean.v.getFullName());
            return;
        }
        try {
            int countRows = 0;
            long countElems = 0L;
            Array result = bean.v.read();
            f.format("class = %s%n", result.getClass().getName());
            while (result.hasNext()) {
                Array line = (Array)result.next();
                long size = line.getSize();
                countElems += size;
                f.format("  row %d size=%d%n", ++countRows, size);
            }
            float avg = countRows == 0 ? 0.0f : (float)countElems / (float)countRows;
            f.format("%n  nrows = %d totalElems=%d avg=%f%n", countRows, countElems, Float.valueOf(avg));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public class VarBean {
        Variable v;
        H5header.Vinfo vinfo;
        long[] countResult;

        public VarBean() {
        }

        public VarBean(Variable v) {
            this.v = v;
            this.vinfo = (H5header.Vinfo)v.getSPobject();
        }

        public String getName() {
            return this.v.getShortName();
        }

        public boolean isUseFill() {
            return this.vinfo.useFillValue();
        }

        public boolean isChunk() {
            return this.vinfo.isChunked();
        }

        public String getDims() {
            Formatter f = new Formatter();
            for (Dimension d : this.v.getDimensions()) {
                f.format("%d ", d.getLength());
            }
            return f.toString();
        }

        public String getChunks() {
            if (!this.vinfo.isChunked()) {
                return "";
            }
            int[] chunk = this.vinfo.getChunking();
            Formatter f = new Formatter();
            for (int i : chunk) {
                f.format("%d ", i);
            }
            return f.toString();
        }

        public int getChunkSize() {
            if (!this.vinfo.isChunked()) {
                return -1;
            }
            int[] chunks = this.vinfo.getChunking();
            int total = 1;
            for (int chunk : chunks) {
                total *= chunk;
            }
            return total;
        }

        public long getNelems() {
            return this.v.getSize();
        }

        public long getSizeBytes() {
            return this.v.getSize() * (long)this.v.getElementSize();
        }

        public long getNchunks() {
            return this.countResult == null ? 0L : this.countResult[1];
        }

        public long getStorage() {
            return this.countResult == null ? 0L : this.countResult[0];
        }

        public float getRatio() {
            if (this.countResult == null) {
                return 0.0f;
            }
            if (this.countResult[0] == 0L) {
                return 0.0f;
            }
            return (float)this.getSizeBytes() / (float)this.countResult[0];
        }

        public String getDataType() {
            return this.v.getDataType().toString();
        }

        public String getCompression() {
            return this.vinfo.getCompression();
        }

        void count(boolean force) {
            if (!force && this.countResult != null) {
                return;
            }
            if (this.vinfo.useFillValue()) {
                this.countResult = new long[2];
                return;
            }
            if (!this.vinfo.isChunked()) {
                this.countResult = new long[2];
                this.countResult[0] = this.getSizeBytes();
                this.countResult[1] = 1L;
                return;
            }
            try {
                this.countResult = this.vinfo.countStorageSize(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        void show() {
            Formatter f = new Formatter();
            f.format("vinfo = %s%n%n", this.vinfo.toString());
            f.format("      = %s%n", this.vinfo.extraInfo());
            Hdf5NewDataTable.this.infoTA.setText(f.toString());
        }
    }
}

