/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Formatter;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.ui.op.Hdf5NewObjectTable;
import ucar.nc2.ui.op.Hdf5ObjectTable;
import ucar.ui.widget.BAMutil;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class Hdf5ObjectPanel
extends OpPanel {
    final Hdf5ObjectTable hdf5Table;
    RandomAccessFile raf;

    public Hdf5ObjectPanel(PreferencesExt p, boolean useBuilders) {
        super(p, "file:", true, false);
        this.hdf5Table = useBuilders ? new Hdf5NewObjectTable(this.prefs) : new Hdf5ObjectTable(this.prefs);
        this.add((Component)this.hdf5Table, "Center");
        AbstractButton infoButton = BAMutil.makeButtcon((String)"Information", (String)"Compact Representation", (boolean)false);
        infoButton.addActionListener(e -> {
            Formatter f = new Formatter();
            this.hdf5Table.showInfo(f);
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(infoButton);
        AbstractButton infoButton2 = BAMutil.makeButtcon((String)"Information", (String)"Detail Info", (boolean)false);
        infoButton2.addActionListener(e -> {
            Formatter f = new Formatter();
            try {
                this.hdf5Table.showInfo2(f);
            }
            catch (IOException ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
                return;
            }
            this.detailTA.setText(f.toString());
            this.detailTA.gotoTop();
            this.detailWindow.show();
        });
        this.buttPanel.add(infoButton2);
        AbstractButton eosdump = BAMutil.makeButtcon((String)"alien", (String)"Show EOS processing", (boolean)false);
        eosdump.addActionListener(e -> {
            try {
                Formatter f = new Formatter();
                this.hdf5Table.getEosInfo(f);
                this.detailTA.setText(f.toString());
                this.detailWindow.show();
            }
            catch (IOException ioe) {
                StringWriter sw = new StringWriter(5000);
                ioe.printStackTrace(new PrintWriter(sw));
                this.detailTA.setText(sw.toString());
                this.detailWindow.show();
            }
        });
        this.buttPanel.add(eosdump);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        boolean err = false;
        try {
            if (this.raf != null) {
                this.raf.close();
            }
            this.raf = new RandomAccessFile(command, "r");
            this.hdf5Table.setHdf5File(this.raf);
        }
        catch (FileNotFoundException ioe) {
            JOptionPane.showMessageDialog(null, "Hdf5ObjectTable cannot open " + command + "\n" + ioe.getMessage());
            err = true;
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter(5000);
            e.printStackTrace(new PrintWriter(sw));
            this.detailTA.setText(sw.toString());
            this.detailWindow.show();
            err = true;
        }
        return !err;
    }

    @Override
    public void closeOpenFiles() throws IOException {
        this.hdf5Table.closeOpenFiles();
    }

    @Override
    public void save() {
        this.hdf5Table.save();
        super.save();
    }
}

