/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.IsMissingEvaluator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Variable;
import ucar.nc2.util.CancelTask;
import ucar.nc2.write.Ncdump;
import ucar.ui.prefs.ComboBox;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.ProgressMonitorTask;
import ucar.ui.widget.StopButton;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PersistenceManager;
import ucar.util.prefs.PreferencesExt;

public class NCdumpPane
extends TextHistoryPane {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ComboBox<String> cb;
    private CommonTask task;
    private final StopButton stopButton;
    private final FileManager fileChooser;
    private NetcdfFile ds;

    public NCdumpPane(PreferencesExt prefs) {
        super(true);
        this.fileChooser = new FileManager(null, null, null, (PreferencesExt)prefs.node("FileManager"));
        this.cb = new ComboBox((PersistenceManager)prefs);
        JButton getButton = new JButton("NCdump");
        getButton.setToolTipText("show selected data values");
        getButton.addActionListener(e -> this.ncdump((String)this.cb.getSelectedItem()));
        JButton imageButton = new JButton("Image");
        imageButton.setToolTipText("view selected data as Image");
        imageButton.addActionListener(e -> this.showImage((String)this.cb.getSelectedItem()));
        this.stopButton = new StopButton("stop NCdump");
        this.stopButton.addActionListener(e -> {
            this.ta.setText(this.task.v.toString());
            this.ta.append("\n data:\n");
            this.ta.append(this.task.contents);
            if (e.getActionCommand().equals("success")) {
                this.cb.setSelectedItem((Object)this.task.command);
            }
        });
        JPanel buttPanel = new JPanel(new FlowLayout(0, 5, 0));
        buttPanel.add(getButton);
        buttPanel.add(imageButton);
        buttPanel.add((Component)this.stopButton);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)new JLabel("Variable:"), "West");
        topPanel.add((Component)this.cb, "Center");
        topPanel.add((Component)buttPanel, "East");
        this.add(topPanel, "North");
    }

    public void setContext(NetcdfFile ds, String command) {
        this.ds = ds;
        this.cb.addItem((Object)command);
    }

    private void ncdump(String command) {
        if (this.ds == null) {
            return;
        }
        if (command == null) {
            return;
        }
        this.task = new NCdumpTask(command);
        if (this.task.v != null) {
            this.stopButton.startProgressMonitorTask((ProgressMonitorTask)this.task);
        }
    }

    private void showImage(String command) {
        if (this.ds == null) {
            return;
        }
        if (command == null) {
            return;
        }
        this.task = new GetContentsTask(command);
        if (this.task.v != null) {
            this.stopButton.startProgressMonitorTask((ProgressMonitorTask)this.task);
        }
    }

    public void save() {
        this.cb.save();
        this.fileChooser.save();
    }

    public void clear() {
        this.ta.setText(null);
    }

    public String getText() {
        return this.ta.getText();
    }

    public void gotoTop() {
        this.ta.setCaretPosition(0);
    }

    public void setText(String text) {
        this.ta.setText(text);
    }

    private class NCdumpTask
    extends CommonTask {
        NCdumpTask(String command) {
            super(command);
        }

        public void run() {
            try {
                this.data = NCdumpPane.this.ds.readSection(this.command);
                this.contents = Ncdump.printArray((Array)this.data, null, (CancelTask)this);
            }
            catch (Exception e) {
                e.printStackTrace();
                StringWriter sw = new StringWriter(100000);
                e.printStackTrace(new PrintWriter(sw));
                this.contents = sw.toString();
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            if (this.cancel) {
                this.contents = "\n***Cancelled by User";
            }
            this.success = !this.cancel;
            this.done = true;
        }
    }

    private class GetContentsTask
    extends CommonTask {
        GetContentsTask(String command) {
            super(command);
        }

        public void run() {
            StringWriter sw = new StringWriter(100000);
            PrintWriter ps = new PrintWriter(sw);
            try {
                this.data = NCdumpPane.this.ds.readSection(this.command);
            }
            catch (Exception e) {
                e.printStackTrace();
                e.printStackTrace(new PrintWriter(sw));
                this.contents = sw.toString();
                this.setError(e.getMessage());
                this.done = true;
                return;
            }
            if (this.cancel) {
                ps.println("\n***Cancelled by User");
            }
            this.contents = sw.toString();
            this.success = !this.cancel;
            this.done = true;
        }
    }

    private abstract class CommonTask
    extends ProgressMonitorTask
    implements CancelTask {
        String contents;
        String command;
        Variable v;
        Array data;
        IsMissingEvaluator eval;

        CommonTask(String command) {
            this.command = command;
            try {
                for (ParsedSectionSpec cer = ParsedSectionSpec.parseVariableSection((NetcdfFile)NCdumpPane.this.ds, (String)command); cer != null; cer = cer.getChild()) {
                    this.v = cer.getVariable();
                }
                if (this.v instanceof IsMissingEvaluator) {
                    this.eval = (IsMissingEvaluator)this.v;
                }
            }
            catch (Exception e) {
                NCdumpPane.this.ta.setText(e.getMessage());
            }
        }
    }
}

