/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.stream.NcStreamIosp;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.io.RandomAccessFile;
import ucar.util.prefs.PreferencesExt;

public class NcStreamPanel
extends JPanel {
    private final PreferencesExt prefs;
    private final BeanTable<MessBean> messTable;
    private final JSplitPane split;
    private TextHistoryPane infoTA;
    private RandomAccessFile raf;
    private NetcdfFile ncfile;
    private NcStreamIosp iosp;

    public NcStreamPanel(PreferencesExt prefs) {
        this.prefs = prefs;
        this.messTable = new BeanTable(MessBean.class, (PreferencesExt)prefs.node("NcStreamPanel"), false);
        this.messTable.addListSelectionListener(e -> {
            MessBean bean = (MessBean)this.messTable.getSelectedBean();
            if (bean == null) {
                return;
            }
            this.infoTA.setText(bean.getDesc());
        });
        PopupMenu varPopup = new PopupMenu((JComponent)this.messTable.getJTable(), "Options");
        varPopup.addAction("Show deflate", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessBean bean = (MessBean)NcStreamPanel.this.messTable.getSelectedBean();
                if (bean == null) {
                    return;
                }
                NcStreamPanel.this.infoTA.setText(bean.m.showDeflate());
            }
        });
        this.infoTA = new TextHistoryPane();
        TextHistoryPane infoPopup2 = new TextHistoryPane();
        IndependentWindow infoWindow2 = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)infoPopup2);
        infoWindow2.setBounds((Rectangle)prefs.getBean("InfoWindowBounds2", (Object)new Rectangle(300, 300, 500, 300)));
        TextHistoryPane infoPopup3 = new TextHistoryPane();
        IndependentWindow infoWindow3 = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)infoPopup3);
        infoWindow3.setBounds((Rectangle)prefs.getBean("InfoWindowBounds3", (Object)new Rectangle(300, 300, 500, 300)));
        this.setLayout(new BorderLayout());
        this.split = new JSplitPane(0, false, (Component)this.messTable, (Component)this.infoTA);
        this.split.setDividerLocation(prefs.getInt("splitPos", 800));
        this.add((Component)this.split, "Center");
    }

    public void save() {
        this.messTable.saveState(false);
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
    }

    public void closeOpenFiles() throws IOException {
        if (this.ncfile != null) {
            this.ncfile.close();
        }
        this.ncfile = null;
        this.raf = null;
        this.iosp = null;
    }

    public void showInfo(Formatter f) {
        if (this.ncfile == null) {
            return;
        }
        try {
            f.format("%s%n", this.raf.getLocation());
            f.format(" file length = %d%n", this.raf.length());
            f.format(" version = %d%n", this.iosp.getVersion());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        f.format("%n%s", this.ncfile.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNcStreamFile(String filename) throws IOException {
        this.closeOpenFiles();
        ArrayList<MessBean> messages = new ArrayList<MessBean>();
        Group.Builder root = Group.builder();
        this.iosp = new NcStreamIosp();
        try {
            this.raf = new RandomAccessFile(filename, "r");
            ArrayList ncm = new ArrayList();
            this.iosp.openDebugNew(this.raf, root, ncm);
            for (NcStreamIosp.NcsMess m : ncm) {
                messages.add(new MessBean(m));
            }
            this.ncfile = NetcdfFile.builder().setRootGroup(root).setLocation(filename).build();
        }
        finally {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        this.messTable.setBeans(messages);
    }

    public static class MessBean {
        private NcStreamIosp.NcsMess m;

        MessBean() {
        }

        MessBean(NcStreamIosp.NcsMess m) {
            this.m = m;
        }

        public String getObjClass() {
            return this.m.what.getClass().toString();
        }

        public String getDesc() {
            return this.m.what.toString();
        }

        public int getSize() {
            return this.m.len;
        }

        public int getNelems() {
            return this.m.nelems;
        }

        public String getDataType() {
            return this.m.dataType == null ? "" : this.m.dataType.toString();
        }

        public String getVarname() {
            return this.m.varName;
        }

        public long getFilePos() {
            return this.m.filePos;
        }
    }
}

