/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.Component;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.StringTokenizer;
import javax.swing.JButton;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.ui.OpPanel;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.units.TimeUnit;
import ucar.ui.prefs.Debug;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class UnitConvert
extends OpPanel {
    private final TextHistoryPane ta = new TextHistoryPane(true);

    public UnitConvert(PreferencesExt prefs) {
        super(prefs, "unit:", false, false);
        this.add((Component)this.ta, "Center");
        JButton compareButton = new JButton("Compare");
        compareButton.addActionListener(e -> this.compare(this.cb.getSelectedItem()));
        this.buttPanel.add(compareButton);
        JButton dateButton = new JButton("UdunitDate");
        dateButton.addActionListener(e -> this.checkUdunits(this.cb.getSelectedItem()));
        this.buttPanel.add(dateButton);
        JButton cdateButton = new JButton("CalendarDate");
        cdateButton.addActionListener(e -> this.checkCalendarDate(this.cb.getSelectedItem()));
        this.buttPanel.add(cdateButton);
    }

    @Override
    public boolean process(Object o) {
        String command = (String)o;
        try {
            SimpleUnit su = SimpleUnit.factoryWithExceptions((String)command);
            this.ta.setText("parse=" + command + "\n");
            this.ta.appendLine("SimpleUnit.toString()          =" + su + "\n");
            this.ta.appendLine("SimpleUnit.getCanonicalString  =" + su.getCanonicalString());
            this.ta.appendLine("SimpleUnit.getImplementingClass= " + su.getImplementingClass());
            this.ta.appendLine("SimpleUnit.isUnknownUnit       = " + su.isUnknownUnit());
            return true;
        }
        catch (Exception e) {
            if (Debug.isSet((String)"Xdeveloper")) {
                StringWriter sw = new StringWriter(10000);
                e.printStackTrace(new PrintWriter(sw));
                this.ta.setText(sw.toString());
            } else {
                this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
            }
            return false;
        }
    }

    @Override
    public void closeOpenFiles() {
    }

    public void compare(Object o) {
        String command = (String)o;
        StringTokenizer stoke = new StringTokenizer(command);
        ArrayList<String> list = new ArrayList<String>();
        while (stoke.hasMoreTokens()) {
            list.add(stoke.nextToken());
        }
        try {
            String unitS1 = (String)list.get(0);
            String unitS2 = (String)list.get(1);
            SimpleUnit su1 = SimpleUnit.factoryWithExceptions((String)unitS1);
            SimpleUnit su2 = SimpleUnit.factoryWithExceptions((String)unitS2);
            this.ta.setText("<" + su1 + "> isConvertable to <" + su2 + ">=" + SimpleUnit.isCompatibleWithExceptions((String)unitS1, (String)unitS2));
        }
        catch (Exception e) {
            if (Debug.isSet((String)"Xdeveloper")) {
                StringWriter sw = new StringWriter(10000);
                e.printStackTrace(new PrintWriter(sw));
                this.ta.setText(sw.toString());
            }
            this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
        }
    }

    private void checkUdunits(Object o) {
        String command = (String)o;
        boolean isDate = false;
        try {
            Formatter f2 = new Formatter();
            CalendarDateUnit cdu = CalendarDate.parseUdunitsUnit(null, (String)command);
            f2.format("%nFrom udunits: '%s' CalendarDateUnit = '%s'%n", command, cdu);
            f2.format("getBaseCalendarDate = %s%n", CalendarDateFormatter.toDateTimeString((CalendarDate)cdu.getBaseCalendarDate()));
            CalendarDate cd = CalendarDate.parseUdunitsOrIso(null, (String)command);
            if (cd != null) {
                f2.format("parseUdunitsOrIso = %s%n", CalendarDateFormatter.toDateTimeString((CalendarDate)cd));
                isDate = true;
            } else {
                f2.format("parseUdunitsOrIso is null%n", new Object[0]);
            }
            this.ta.appendLine(f2.toString());
        }
        catch (Exception f2) {
            // empty catch block
        }
        this.ta.appendLine("isDate = " + isDate);
        if (!isDate) {
            try {
                SimpleUnit su = SimpleUnit.factory((String)command);
                boolean isTime = su instanceof TimeUnit;
                this.ta.setText("<" + command + "> isTimeUnit= " + isTime);
                if (isTime) {
                    TimeUnit du = (TimeUnit)su;
                    this.ta.appendLine("\nTimeUnit = " + du);
                }
            }
            catch (Exception e) {
                if (Debug.isSet((String)"Xdeveloper")) {
                    StringWriter sw = new StringWriter(10000);
                    e.printStackTrace(new PrintWriter(sw));
                    this.ta.setText(sw.toString());
                }
                this.ta.setText(e.getClass().getName() + ":" + e.getMessage() + "\n" + command);
            }
        }
    }

    private void checkCalendarDate(Object o) {
        String command = (String)o;
        try {
            this.ta.setText("\nParse CalendarDate: <" + command + ">\n");
            CalendarDate cd = CalendarDate.parseUdunits(null, (String)command);
            this.ta.appendLine("CalendarDate = " + cd);
        }
        catch (Throwable t) {
            this.ta.appendLine("not a CalendarDateUnit= " + t.getMessage());
        }
        try {
            this.ta.appendLine("\nParse CalendarDateUnit: <" + command + ">\n");
            CalendarDateUnit cdu = CalendarDateUnit.of(null, (String)command);
            this.ta.appendLine("CalendarDateUnit = " + cdu);
            this.ta.appendLine(" Calendar        = " + cdu.getCalendar());
            this.ta.appendLine(" PeriodField     = " + cdu.getCalendarPeriod().getField());
            this.ta.appendLine(" PeriodValue     = " + cdu.getCalendarPeriod().getValue());
            this.ta.appendLine(" Base            = " + cdu.getBaseCalendarDate());
            this.ta.appendLine(" isCalendarField = " + cdu.isCalendarField());
        }
        catch (Exception e) {
            this.ta.appendLine("not a CalendarDateUnit= " + e.getMessage());
            try {
                String[] s = command.split("%");
                if (s.length == 2) {
                    double val = Double.parseDouble(s[0].trim());
                    this.ta.appendLine("\nval= " + val + " unit=" + s[1]);
                    CalendarDateUnit cdu = CalendarDateUnit.of(null, (String)s[1].trim());
                    this.ta.appendLine("CalendarDateUnit= " + cdu);
                    CalendarDate cd = cdu.makeCalendarDate(val);
                    this.ta.appendLine(" CalendarDate = " + cd);
                    Date d = cd.toDate();
                    this.ta.appendLine(" Date.toString() = " + d);
                    this.ta.appendLine(" DateFormatter= " + CalendarDateFormatter.toDateTimeString((Date)cd.toDate()));
                }
            }
            catch (Exception ee) {
                this.ta.appendLine("Failed on CalendarDateUnit " + ee.getMessage());
            }
        }
    }
}

