/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.op;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import ucar.nc2.internal.wmo.CommonCodeTable;
import ucar.ui.prefs.BeanTable;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.TextHistoryPane;
import ucar.util.prefs.PreferencesExt;

public class WmoCommonCodesPanel
extends JPanel {
    private final PreferencesExt prefs;
    private final BeanTable<TableBean> codeTable;
    private final BeanTable<EntryBean> entryTable;
    private final JSplitPane split;
    private final TextHistoryPane compareTA;
    private final IndependentWindow infoWindow;

    public WmoCommonCodesPanel(PreferencesExt prefs, JPanel buttPanel) {
        this.prefs = prefs;
        this.codeTable = new BeanTable(TableBean.class, (PreferencesExt)prefs.node("CodeTableBean"), false);
        this.codeTable.addListSelectionListener(e -> {
            TableBean csb = (TableBean)this.codeTable.getSelectedBean();
            if (csb != null) {
                CommonCodeTable cct = CommonCodeTable.getTable((int)csb.t.getTableNo());
                this.setEntries(cct);
            }
        });
        this.entryTable = new BeanTable(EntryBean.class, (PreferencesExt)prefs.node("EntryBean"), false);
        PopupMenu varPopup = new PopupMenu((JComponent)this.codeTable.getJTable(), "Options");
        varPopup.addAction("Show", (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Formatter out = new Formatter();
                TableBean csb = (TableBean)WmoCommonCodesPanel.this.codeTable.getSelectedBean();
                if (csb == null) {
                    return;
                }
                CommonCodeTable cct = CommonCodeTable.getTable((int)csb.t.getTableNo());
                out.format("%s ==== %s%n", csb.getName(), csb.getResource());
                List<EntryBean> beans = WmoCommonCodesPanel.this.setEntries(cct);
                for (EntryBean bean : beans) {
                    bean.show(out);
                }
                WmoCommonCodesPanel.this.compareTA.setText(out.toString());
                WmoCommonCodesPanel.this.compareTA.gotoTop();
                WmoCommonCodesPanel.this.infoWindow.setVisible(true);
            }
        });
        this.compareTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Extra Information", BAMutil.getImage((String)"nj22/NetcdfUI"), (Component)this.compareTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", (Object)new Rectangle(300, 300, 800, 600)));
        this.split = new JSplitPane(0, false, (Component)this.codeTable, (Component)this.entryTable);
        this.split.setDividerLocation(prefs.getInt("splitPos", 500));
        this.setLayout(new BorderLayout());
        this.add((Component)this.split, "Center");
        try {
            ArrayList<TableBean> tables = new ArrayList<TableBean>();
            for (CommonCodeTable.Table t : CommonCodeTable.Table.values()) {
                tables.add(new TableBean(t));
            }
            this.codeTable.setBeans(tables);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void save() {
        this.codeTable.saveState(false);
        this.entryTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", (Object)this.infoWindow.getBounds());
        this.prefs.putInt("splitPos", this.split.getDividerLocation());
    }

    public List<EntryBean> setEntries(CommonCodeTable codeTable) {
        ArrayList<EntryBean> beans = new ArrayList<EntryBean>(codeTable.entries.size());
        for (CommonCodeTable.TableEntry d : codeTable.entries) {
            beans.add(new EntryBean(d));
        }
        this.entryTable.setBeans(beans);
        return beans;
    }

    public static class EntryBean {
        CommonCodeTable.TableEntry te;

        public EntryBean() {
        }

        public EntryBean(CommonCodeTable.TableEntry te) {
            this.te = te;
        }

        public String getValue() {
            return this.te.value;
        }

        public String getComment() {
            return this.te.comment;
        }

        public String getStatus() {
            return this.te.status;
        }

        public int getCode() {
            return this.te.code;
        }

        public int getCode2() {
            return this.te.code2;
        }

        public int getLine() {
            return this.te.line;
        }

        private void show(Formatter f) {
            if (this.getCode() > 0) {
                f.format("%4d; %4d; %s%n", this.getCode(), this.getCode2(), this.getValue());
            }
        }
    }

    public static class TableBean {
        CommonCodeTable.Table t;

        public TableBean() {
        }

        public TableBean(CommonCodeTable.Table t) {
            this.t = t;
        }

        public String getName() {
            return this.t.getName();
        }

        public String getEnumName() {
            return this.t.name();
        }

        public int getType() {
            return this.t.getTableType();
        }

        public String getResource() {
            return this.t.getResourceName();
        }
    }
}

