/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.point;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ui.util.Renderer;
import ucar.ui.widget.FontUtil;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionPoint;

public class PointRenderer
implements Renderer {
    private List<ObservationUI> obsUIlist = new ArrayList<ObservationUI>();
    private Projection project;
    private Color color = Color.black;
    private final Color selectedColor = Color.magenta;
    private final int circleRadius = 3;
    private final Rectangle2D circleBB = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    private final FontUtil.StandardFont textFont = FontUtil.getStandardFont((int)10);
    private boolean drawConnectingLine;
    private ObservationUI selected;
    private boolean declutter = true;
    private boolean posWasCalc;

    public void incrFontSize() {
        this.textFont.incrFontSize();
    }

    public void decrFontSize() {
        this.textFont.decrFontSize();
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public LatLonRect getPreferredArea() {
        return null;
    }

    public void setPointFeatures(List<PointFeature> obs) {
        this.obsUIlist = new ArrayList<ObservationUI>(obs.size());
        for (PointFeature ob : obs) {
            ObservationUI sui = new ObservationUI(ob);
            this.obsUIlist.add(sui);
        }
        this.posWasCalc = false;
        this.calcWorldPos();
        this.selected = null;
    }

    public void setDrawConnectingLine(boolean drawConnectingLine) {
        this.drawConnectingLine = drawConnectingLine;
    }

    public void setSelected(PointFeature obs) {
        this.selected = null;
        for (ObservationUI observationUI : this.obsUIlist) {
            if (!this.testPointObsDatatype(observationUI.obs, obs)) continue;
            this.selected = observationUI;
            break;
        }
    }

    private boolean testPointObsDatatype(PointFeature obs1, PointFeature obs2) {
        if (obs1.getObservationTime() != obs2.getObservationTime()) {
            return false;
        }
        EarthLocation loc1 = obs1.getLocation();
        EarthLocation loc2 = obs2.getLocation();
        if (loc1.getLatitude() != loc2.getLatitude()) {
            return false;
        }
        return loc1.getLongitude() == loc2.getLongitude();
    }

    public void setDeclutter(boolean declut) {
        this.declutter = declut;
    }

    public boolean getDeclutter() {
        return this.declutter;
    }

    @Override
    public void setProjection(Projection project) {
        this.project = project;
        this.calcWorldPos();
    }

    private void calcWorldPos() {
        if (this.project == null) {
            return;
        }
        for (ObservationUI observationUI : this.obsUIlist) {
            observationUI.worldPos = this.project.latLonToProj(observationUI.latlonPos);
        }
        this.posWasCalc = true;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform normal2Device) {
        AffineTransform world2Normal;
        if (this.project == null || !this.posWasCalc) {
            return;
        }
        AffineTransform world2Device = g.getTransform();
        g.setTransform(normal2Device);
        try {
            world2Normal = normal2Device.createInverse();
            world2Normal.concatenate(world2Device);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println(" RendSurfObs: NoninvertibleTransformException on " + normal2Device);
            return;
        }
        Object saveHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setStroke(new BasicStroke(1.0f));
        g.setFont(this.textFont.getFont());
        g.setColor(this.color);
        int count = 0;
        int npts = this.obsUIlist.size();
        GeneralPath path = new GeneralPath(0, npts);
        Iterator<ObservationUI> iterator = this.obsUIlist.iterator();
        while (iterator.hasNext()) {
            ObservationUI observationUI;
            ObservationUI s = observationUI = iterator.next();
            s.calcPos(world2Normal);
            s.draw(g);
            if (Double.isNaN(s.screenPos.getX())) {
                System.out.println("screenPos=" + s.screenPos + " world = " + s.worldPos);
                continue;
            }
            if (count == 0) {
                path.moveTo((float)s.screenPos.getX(), (float)s.screenPos.getY());
            } else {
                path.lineTo((float)s.screenPos.getX(), (float)s.screenPos.getY());
            }
            ++count;
        }
        g.setColor(this.color);
        if (this.drawConnectingLine) {
            g.draw(path);
        }
        if (this.selected != null) {
            this.selected.draw(g);
        }
        g.setTransform(world2Device);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, saveHint);
    }

    public class ObservationUI {
        private PointFeature obs;
        private LatLonPoint latlonPos;
        private ProjectionPoint worldPos = ProjectionPoint.create((double)0.0, (double)0.0);
        private Point2D.Double screenPos = new Point2D.Double();
        private Rectangle2D bb;
        private Rectangle2D bbPos = new Rectangle2D.Double();

        ObservationUI(PointFeature obs) {
            this.obs = obs;
            this.latlonPos = LatLonPoint.create((double)obs.getLocation().getLatitude(), (double)obs.getLocation().getLongitude());
            Dimension t = PointRenderer.this.textFont.getBoundingBox("O");
            this.bb = new Rectangle2D.Double(-3.0, -3.0 - t.getHeight(), t.getWidth(), t.getHeight());
            this.bb.add(PointRenderer.this.circleBB);
        }

        public PointFeature getObservation() {
            return this.obs;
        }

        public LatLonPoint getLatLon() {
            return this.latlonPos;
        }

        public ProjectionPoint getLocation() {
            return this.worldPos;
        }

        public Rectangle2D getBB() {
            return this.bbPos;
        }

        boolean contains(Point p) {
            return this.bbPos.contains(p);
        }

        void calcPos(AffineTransform w2n) {
            w2n.transform(new Point2D.Double(this.worldPos.getX(), this.worldPos.getY()), this.screenPos);
            this.bbPos.setRect(this.screenPos.getX() + this.bb.getX(), this.screenPos.getY() + this.bb.getY(), this.bb.getWidth(), this.bb.getHeight());
        }

        void draw(Graphics2D g) {
            if (this == PointRenderer.this.selected) {
                g.setColor(PointRenderer.this.selectedColor);
                this.fillCircle(g, this.screenPos);
                g.setColor(PointRenderer.this.color);
            } else {
                this.drawCircle(g, this.screenPos);
            }
        }

        private void drawCircle(Graphics2D g, Point2D loc) {
            int x = (int)(loc.getX() - 3.0);
            int y = (int)(loc.getY() - 3.0);
            g.drawOval(x, y, 6, 6);
        }

        private void fillCircle(Graphics2D g, Point2D loc) {
            int x = (int)(loc.getX() - 3.0);
            int y = (int)(loc.getY() - 3.0);
            g.fillOval(x, y, 6, 6);
        }
    }
}

