/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.point;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import ucar.nc2.ui.geoloc.NPController;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.nc2.ui.geoloc.Navigation;
import ucar.nc2.ui.geoloc.RubberbandRectangleHandles;
import ucar.nc2.ui.point.StationRenderer;
import ucar.nc2.ui.util.Renderer;
import ucar.nc2.ui.widget.RangeDateSelector;
import ucar.nc2.units.DateRange;
import ucar.ui.event.ActionSourceListener;
import ucar.ui.event.ActionValueEvent;
import ucar.ui.event.ActionValueListener;
import ucar.ui.prefs.Field;
import ucar.ui.prefs.PrefPanel;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.IndependentDialog;
import ucar.ui.widget.PopupManager;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.util.Format;

public class StationRegionDateChooser
extends NPController {
    private final boolean regionSelect;
    private final boolean stationSelect;
    private final boolean dateSelect;
    private StationRenderer stnRender;
    private Station selectedStation;
    private ProjectionRect geoBounds;
    private ProjectionRect geoSelection = new ProjectionRect();
    private boolean geoSelectionMode;
    private final Color outlineColor = Color.black;
    private RangeDateSelector dateSelector;
    private IndependentDialog dateWindow;
    private AbstractAction dateAction;
    private PrefPanel minmaxPP;
    private Field.Double minLonField;
    private Field.Double maxLonField;
    private Field.Double minLatField;
    private Field.Double maxLatField;
    private ActionSourceListener actionSource;
    private final PopupManager popupInfo = new PopupManager("Station Info");
    private boolean debugEvent;
    private boolean debug;

    public StationRegionDateChooser() {
        this(true, true, true);
    }

    public StationRegionDateChooser(boolean stationSelect, boolean regionSelect, boolean dateSelect) {
        this.regionSelect = regionSelect;
        this.stationSelect = stationSelect;
        this.dateSelect = dateSelect;
        this.np.setGeoSelectionMode(regionSelect && this.geoSelectionMode);
        if (stationSelect) {
            this.stnRender = new StationRenderer();
            this.addRenderer(this.stnRender);
            this.np.addPickEventListener(e -> {
                this.selectedStation = this.stnRender.pick(e.getLocationPoint());
                if (this.selectedStation != null) {
                    this.redraw();
                    this.firePropertyChangeEvent(this.selectedStation, "Station");
                    this.actionSource.fireActionValueEvent("selected", (Object)this.selectedStation);
                }
            });
            this.np.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent e) {
                    Point p = e.getPoint();
                    StationRenderer.StationUI sui = StationRegionDateChooser.this.stnRender.isOnStation(p);
                    StringBuilder sbuff = new StringBuilder();
                    if (sui != null) {
                        Station s = sui.getStation();
                        sbuff.append(s.getName());
                        sbuff.append(" ");
                        sbuff.append("\n");
                        if (null != s.getDescription()) {
                            sbuff.append(s.getDescription()).append("\n");
                        }
                        sbuff.append(LatLonPoints.latToString((double)s.getLatitude(), (int)4));
                        sbuff.append(" ");
                        sbuff.append(LatLonPoints.lonToString((double)s.getLongitude(), (int)4));
                        sbuff.append(" ");
                        double alt = s.getAltitude();
                        if (!Double.isNaN(alt)) {
                            sbuff.append(Format.d((double)alt, (int)0));
                            sbuff.append(" m");
                        }
                        StationRegionDateChooser.this.popupInfo.show(sbuff.toString(), p, (Component)StationRegionDateChooser.this, (Object)s);
                    } else {
                        StationRegionDateChooser.this.popupInfo.hide();
                    }
                }
            });
            this.np.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent e) {
                    StationRegionDateChooser.this.popupInfo.hide();
                }
            });
            this.actionSource = new ActionSourceListener("station"){

                public void actionPerformed(ActionValueEvent e) {
                    if (StationRegionDateChooser.this.debugEvent) {
                        System.out.println(" StationdatasetChooser: actionSource event " + e);
                    }
                    StationRegionDateChooser.this.selectedStation = (Station)e.getValue();
                    StationRegionDateChooser.this.redraw();
                }
            };
        }
        if (dateSelect) {
            DateRange range = null;
            try {
                range = new DateRange();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            this.dateSelector = new RangeDateSelector(null, range, true, false, null, false, true);
            this.dateWindow = new IndependentDialog(null, false, "Date Selection", (Component)this.dateSelector);
            this.dateAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StationRegionDateChooser.this.dateWindow.setVisible(true);
                }
            };
            BAMutil.setActionProperties((AbstractAction)this.dateAction, (String)"nj22/SelectDate", (String)"select date range", (boolean)false, (int)68, (int)-1);
        }
        this.makeMyUI();
    }

    @Override
    protected void makeUI() {
    }

    private void makeMyUI() {
        AbstractAction incrFontAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StationRegionDateChooser.this.stnRender.incrFontSize();
                StationRegionDateChooser.this.redraw();
            }
        };
        BAMutil.setActionProperties((AbstractAction)incrFontAction, (String)"FontIncr", (String)"increase font size", (boolean)false, (int)73, (int)-1);
        AbstractAction decrFontAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StationRegionDateChooser.this.stnRender.decrFontSize();
                StationRegionDateChooser.this.redraw();
            }
        };
        BAMutil.setActionProperties((AbstractAction)decrFontAction, (String)"FontDecr", (String)"decrease font size", (boolean)false, (int)68, (int)-1);
        JCheckBox declutCB = new JCheckBox("Declutter", true);
        declutCB.addActionListener(e -> this.setDeclutter(((JCheckBox)e.getSource()).isSelected()));
        AbstractAction bbAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StationRegionDateChooser.this.geoSelectionMode = !StationRegionDateChooser.this.geoSelectionMode;
                StationRegionDateChooser.this.np.setGeoSelectionMode(StationRegionDateChooser.this.geoSelectionMode);
                StationRegionDateChooser.this.redraw();
            }
        };
        BAMutil.setActionProperties((AbstractAction)bbAction, (String)"nj22/Geoselect", (String)"select geo region", (boolean)true, (int)66, (int)-1);
        bbAction.putValue("state", this.geoSelectionMode ? Boolean.TRUE : Boolean.FALSE);
        if (this.regionSelect) {
            this.minmaxPP = new PrefPanel(null, null);
            int nfracDig = 3;
            this.minLonField = this.minmaxPP.addDoubleField("minLon", "minLon", this.geoSelection.getMinX(), nfracDig, 0, 0, null);
            this.maxLonField = this.minmaxPP.addDoubleField("maxLon", "maxLon", this.geoSelection.getMaxX(), nfracDig, 2, 0, null);
            this.minLatField = this.minmaxPP.addDoubleField("minLat", "minLat", this.geoSelection.getMinY(), nfracDig, 4, 0, null);
            this.maxLatField = this.minmaxPP.addDoubleField("maxLat", "maxLat", this.geoSelection.getMaxY(), nfracDig, 6, 0, null);
            this.minmaxPP.finish(true, "East");
            this.minmaxPP.addActionListener(e -> {
                double minLon = this.minLonField.getDouble();
                double minLat = this.minLatField.getDouble();
                double maxLon = this.maxLonField.getDouble();
                double maxLat = this.maxLatField.getDouble();
                LatLonRect llbb = new LatLonRect(minLat, minLon, maxLat, maxLon);
                this.setGeoSelection(llbb);
                this.redraw();
            });
        }
        this.setLayout(new BorderLayout());
        if (this.stationSelect) {
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)incrFontAction);
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)decrFontAction);
            this.toolPanel.add(declutCB);
        }
        if (this.regionSelect) {
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)bbAction);
        }
        if (this.dateSelect) {
            BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.dateAction);
        }
        JPanel upperPanel = new JPanel(new BorderLayout());
        if (this.regionSelect) {
            upperPanel.add((Component)this.minmaxPP, "North");
        }
        upperPanel.add((Component)this.toolPanel, "South");
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(new EtchedBorder());
        JLabel positionLabel = new JLabel("position");
        statusPanel.add((Component)positionLabel, "Center");
        this.np.setPositionLabel(positionLabel);
        this.add((Component)upperPanel, "North");
        this.add((Component)this.np, "Center");
        this.add((Component)statusPanel, "South");
    }

    public void addToolbarAction(AbstractAction act) {
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)act);
    }

    private void firePropertyChangeEvent(Object newValue, String propertyName) {
        this.firePropertyChange(propertyName, null, newValue);
    }

    public void addActionValueListener(ActionValueListener l) {
        this.actionSource.addActionValueListener(l);
    }

    public void removeActionValueListener(ActionValueListener l) {
        this.actionSource.removeActionValueListener(l);
    }

    public ActionSourceListener getActionSourceListener() {
        return this.actionSource;
    }

    public void setStations(List<Station> stns) {
        this.stnRender.setStations(stns);
        this.redraw(true);
    }

    public void setSelectedStation(String id) {
        this.stnRender.setSelectedStation(id);
        this.selectedStation = this.stnRender.getSelectedStation();
        assert (this.selectedStation != null);
        this.np.setLatLonCenterMapArea(this.selectedStation.getLatitude(), this.selectedStation.getLongitude());
        this.redraw();
    }

    public Station getSelectedStation() {
        return this.selectedStation;
    }

    @Override
    public NavigatedPanel getNavigatedPanel() {
        return this.np;
    }

    public void setDeclutter(boolean declut) {
        this.stnRender.setDeclutter(declut);
        this.redraw();
    }

    public boolean getDeclutter() {
        return this.stnRender.getDeclutter();
    }

    protected void redraw() {
        long tstart = System.currentTimeMillis();
        Graphics2D gNP = this.np.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.np.getBackgroundColor());
        Rectangle r = gNP.getClipBounds();
        gNP.clearRect(r.x, r.y, r.width, r.height);
        if (this.regionSelect && this.geoSelectionMode) {
            if (this.geoSelection != null) {
                this.drawBB(gNP, this.geoSelection, Color.cyan);
            }
            if (this.geoBounds != null) {
                this.drawBB(gNP, this.geoBounds, null);
            }
            if (this.geoSelection != null) {
                Navigation navigate = this.np.getNavigation();
                double handleSize = RubberbandRectangleHandles.handleSizePixels / navigate.getPixPerWorld();
                Rectangle2D.Double rect = new Rectangle2D.Double(this.geoSelection.getX(), this.geoSelection.getY(), this.geoSelection.getWidth(), this.geoSelection.getHeight());
                RubberbandRectangleHandles.drawHandledRect(gNP, rect, handleSize);
                if (this.debug) {
                    System.out.println("GeoRegionChooser.drawHandledRect=" + handleSize + " = " + this.geoSelection);
                }
            }
        }
        for (Object renderer : this.renderers) {
            Renderer rend = (Renderer)renderer;
            rend.draw(gNP, this.atI);
        }
        gNP.dispose();
        if (this.debug) {
            long tend = System.currentTimeMillis();
            System.out.println("StationRegionDateChooser draw time = " + (double)(tend - tstart) / 1000.0 + " secs");
        }
        this.np.repaint();
    }

    private void drawBB(Graphics2D g, ProjectionRect bb, Color fillColor) {
        Rectangle2D.Double rect = new Rectangle2D.Double(bb.getX(), bb.getY(), bb.getWidth(), bb.getHeight());
        if (null != fillColor) {
            g.setColor(fillColor);
            g.fill(rect);
        }
        g.setColor(this.outlineColor);
        g.draw(rect);
    }

    public void setGeoBounds(LatLonRect llbb) {
        this.np.setMapArea(llbb);
        this.geoBounds = this.np.getProjectionImpl().latLonToProjBB(llbb);
        this.setGeoSelection(this.geoBounds);
    }

    public void setGeoBounds(ProjectionRect bb) {
        this.geoBounds = bb;
        this.np.setMapArea(bb);
    }

    public void setGeoSelection(LatLonRect llbb) {
        this.np.setGeoSelection(llbb);
        this.setGeoSelection(this.np.getGeoSelection());
    }

    public void setGeoSelection(ProjectionRect bb) {
        this.geoSelection = bb;
        if (this.minLonField != null) {
            this.minLonField.setDouble(this.geoSelection.getMinX());
            this.minLatField.setDouble(this.geoSelection.getMinY());
            this.maxLonField.setDouble(this.geoSelection.getMaxX());
            this.maxLatField.setDouble(this.geoSelection.getMaxY());
        }
        this.np.setGeoSelection(this.geoSelection);
    }

    public LatLonRect getGeoSelectionLL() {
        return this.np.getGeoSelectionLL();
    }

    public ProjectionRect getGeoSelection() {
        return this.np.getGeoSelection();
    }

    public boolean getGeoSelectionMode() {
        return this.geoSelectionMode;
    }

    public DateRange getDateRange() {
        if (!(this.dateSelect && this.dateWindow.isShowing() && this.dateSelector.isEnabled())) {
            return null;
        }
        return this.dateSelector.getDateRange();
    }

    public void setDateRange(DateRange range) {
        this.dateSelector.setDateRange(range);
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        return new Dialog(parent, title, modal);
    }

    private class Dialog
    extends JDialog {
        private Dialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            JPanel buttPanel = new JPanel();
            JButton dismissButton = new JButton("Dismiss");
            dismissButton.addActionListener(e -> this.setVisible(false));
            buttPanel.add((Component)dismissButton, null);
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)StationRegionDateChooser.this, "Center");
            cp.add((Component)buttPanel, "South");
            this.pack();
        }
    }
}

