/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.simplegeom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.border.EtchedBorder;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.tools.DataFactory;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ui.geoloc.NavigatedPanel;
import ucar.nc2.ui.geoloc.ProjectionManager;
import ucar.nc2.ui.gis.MapBean;
import ucar.nc2.ui.grid.ColorScale;
import ucar.nc2.ui.grid.GeoGridTable;
import ucar.nc2.ui.grid.GridTable;
import ucar.nc2.ui.grid.VertPanel;
import ucar.nc2.ui.simplegeom.SimpleGeomController;
import ucar.nc2.ui.util.NamedObjects;
import ucar.nc2.ui.util.Renderer;
import ucar.nc2.util.CancelTask;
import ucar.ui.util.NamedObject;
import ucar.ui.widget.BAMutil;
import ucar.ui.widget.FileManager;
import ucar.ui.widget.IndependentWindow;
import ucar.ui.widget.MFlowLayout;
import ucar.ui.widget.PopupMenu;
import ucar.ui.widget.ProgressMonitor;
import ucar.ui.widget.ProgressMonitorTask;
import ucar.ui.widget.SuperComboBox;
import ucar.ui.widget.TextHistoryPane;
import ucar.unidata.geoloc.Projection;
import ucar.util.prefs.PreferencesExt;

public class SimpleGeomUI
extends JPanel {
    private static final String GEOTIFF_FILECHOOSER_DEFAULTDIR = "geotiffDefDir";
    private final PreferencesExt store;
    private final FileManager fileChooser;
    SuperComboBox fieldChooser;
    SuperComboBox levelChooser;
    SuperComboBox timeChooser;
    SuperComboBox ensembleChooser;
    SuperComboBox runtimeChooser;
    NavigatedPanel panz = new NavigatedPanel();
    VertPanel vertPanel;
    GridTable gridTable;
    JLabel dataValueLabel;
    JLabel positionLabel;
    private SimpleGeomController controller;
    private ColorScale.Panel colorScalePanel;
    private GeoGridTable dsTable;
    private TextHistoryPane datasetInfoTA;
    private TextHistoryPane ncmlTA;
    private JPanel drawingPanel;
    private JSplitPane splitDraw;
    private JComboBox<ColorScale.MinMaxType> csDataMinMax;
    private PopupMenu mapBeanMenu;
    private JLabel datasetNameLabel;
    private ProjectionManager projManager;
    private IndependentWindow infoWindow;
    private IndependentWindow ncmlWindow;
    private IndependentWindow gtWindow;
    private JDialog dsDialog;
    private FileManager geotiffFileChooser;
    private JPanel fieldPanel;
    private JPanel toolPanel;
    private JToolBar navToolbar;
    private JToolBar moveToolbar;
    private AbstractAction navToolbarAction;
    private AbstractAction moveToolbarAction;
    private AbstractAction redrawAction;
    private AbstractAction showDatasetInfoAction;
    private AbstractAction showNcMLAction;
    private AbstractAction showGridTableAction;
    private AbstractAction showGridDatasetInfoAction;
    private AbstractAction showNetcdfDatasetAction;
    private AbstractAction minmaxHorizAction;
    private AbstractAction minmaxLogAction;
    private AbstractAction minmaxHoldAction;
    private AbstractAction fieldLoopAction;
    private AbstractAction levelLoopAction;
    private AbstractAction timeLoopAction;
    private AbstractAction chooseProjectionAction;
    private AbstractAction saveCurrentProjectionAction;
    private boolean selected;
    private int mapBeanCount;
    private boolean debugBeans;
    private boolean debugChooser;
    private boolean debugPrint;
    private boolean debugHelp;
    private boolean debugTask;
    private ArrayList<Chooser> choosers;

    public SimpleGeomUI(PreferencesExt pstore, RootPaneContainer root, FileManager fileChooser, int defaultHeight) {
        this.store = pstore;
        this.fileChooser = fileChooser;
        try {
            this.choosers = new ArrayList();
            this.fieldChooser = new SuperComboBox(root, "field", true, null);
            this.choosers.add(new Chooser("field", this.fieldChooser, true));
            this.runtimeChooser = new SuperComboBox(root, "runtime", false, null);
            this.choosers.add(new Chooser("runtime", this.runtimeChooser, false));
            this.timeChooser = new SuperComboBox(root, "time", false, null);
            this.choosers.add(new Chooser("time", this.timeChooser, false));
            this.ensembleChooser = new SuperComboBox(root, "ensemble", false, null);
            this.choosers.add(new Chooser("ensemble", this.ensembleChooser, false));
            this.levelChooser = new SuperComboBox(root, "level", false, null);
            this.choosers.add(new Chooser("level", this.levelChooser, false));
            this.makeActionsDataset();
            this.makeActionsToolbars();
            this.gridTable = new GridTable("field");
            this.gtWindow = new IndependentWindow("Grid Table Information", BAMutil.getImage((String)"nj22/GDVs"), (Component)this.gridTable.getPanel());
            PreferencesExt dsNode = (PreferencesExt)pstore.node("DatasetTable");
            this.dsTable = new GeoGridTable(dsNode, true);
            this.dsDialog = this.dsTable.makeDialog(root, "NetcdfDataset Info", false);
            Rectangle bounds = (Rectangle)dsNode.getBean("DialogBounds", (Object)new Rectangle(50, 50, 800, 450));
            this.dsDialog.setBounds(bounds);
            this.controller = new SimpleGeomController(this, this.store);
            this.makeUI(defaultHeight);
            this.controller.finishInit();
            this.geotiffFileChooser = new FileManager(null);
            this.geotiffFileChooser.setCurrentDirectory(this.store.get(GEOTIFF_FILECHOOSER_DEFAULTDIR, "."));
        }
        catch (Exception e) {
            System.out.println("UI creation failed");
            e.printStackTrace();
        }
    }

    public void storePersistentData() {
        this.store.putInt("vertSplit", this.splitDraw.getDividerLocation());
        this.store.putBoolean("navToolbarAction", ((Boolean)this.navToolbarAction.getValue("state")).booleanValue());
        this.store.putBoolean("moveToolbarAction", ((Boolean)this.moveToolbarAction.getValue("state")).booleanValue());
        if (this.projManager != null) {
            this.projManager.storePersistentData();
        }
        this.dsTable.save();
        this.dsTable.getPrefs().putBeanObject("DialogBounds", (Object)this.dsDialog.getBounds());
        this.store.put(GEOTIFF_FILECHOOSER_DEFAULTDIR, this.geotiffFileChooser.getCurrentDirectory());
        this.controller.storePersistentData();
    }

    boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean b) {
        this.selected = b;
        this.showGridTableAction.setEnabled(b);
        this.showNcMLAction.setEnabled(b);
        this.showNcMLAction.setEnabled(b);
        this.showNetcdfDatasetAction.setEnabled(b);
        this.showGridDatasetInfoAction.setEnabled(b);
        this.navToolbarAction.setEnabled(b);
        this.moveToolbarAction.setEnabled(b);
        this.controller.showGridAction.setEnabled(b);
        this.controller.showContoursAction.setEnabled(b);
        this.controller.showContourLabelsAction.setEnabled(b);
        this.redrawAction.setEnabled(b);
        this.minmaxHorizAction.setEnabled(b);
        this.minmaxLogAction.setEnabled(b);
        this.minmaxHoldAction.setEnabled(b);
        this.fieldLoopAction.setEnabled(b);
        this.levelLoopAction.setEnabled(b);
        this.timeLoopAction.setEnabled(b);
        this.panz.setEnabledActions(b);
    }

    public void addMapBean(MapBean mb) {
        this.mapBeanMenu.addAction(mb.getActionDesc(), mb.getIcon(), mb.getAction());
        if (this.mapBeanCount == 0) {
            this.setMapRenderer(mb.getRenderer());
        }
        ++this.mapBeanCount;
        mb.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("Renderer")) {
                this.setMapRenderer((Renderer)e.getNewValue());
            }
        });
    }

    void setMapRenderer(Renderer mapRenderer) {
        this.controller.setMapRenderer(mapRenderer);
    }

    public void clear() {
        this.controller.clear();
        this.gridTable.clear();
    }

    public void setDataset(Dataset ds) {
        if (ds == null) {
            return;
        }
        OpenDatasetTask openTask = new OpenDatasetTask(ds);
        ProgressMonitor pm = new ProgressMonitor((ProgressMonitorTask)openTask, e -> {
            this.controller.showDataset();
            this.gridTable.setDataset(this.controller.getFields());
            this.datasetNameLabel.setText("Dataset:  " + this.controller.getDatasetUrlString());
            this.setSelected(true);
            this.gtWindow.setVisible(false);
        });
        pm.start((Component)this, "Open Dataset " + ds.getName(), 100);
    }

    public void setDataset(ucar.nc2.dt.GridDataset ds) {
        this.controller.setGridDataset(ds);
        this.controller.showDataset();
        this.datasetNameLabel.setText("Dataset:  " + this.controller.getDatasetUrlString());
        this.gridTable.setDataset(this.controller.getFields());
    }

    void setFields(List<Object> fields) {
        this.fieldChooser.setCollection(fields.iterator());
    }

    void setField(GridDatatype field) {
        List<NamedObject> names;
        NamedObject no;
        this.fieldChooser.setToolTipText(field.getName());
        GridCoordSystem gcs = field.getCoordinateSystem();
        CoordinateAxis1D axis = gcs.getVerticalAxis();
        this.setChooserWanted("level", axis != null);
        if (axis != null) {
            List<NamedObject> levels = NamedObjects.getNames(axis);
            this.levelChooser.setCollection(levels.iterator(), true);
            no = levels.get(this.controller.getCurrentLevelIndex());
            this.levelChooser.setSelectedByName(no.getName());
        }
        if (gcs.hasTimeAxis()) {
            axis = gcs.hasTimeAxis1D() ? gcs.getTimeAxis1D() : gcs.getTimeAxisForRun(0);
            this.setChooserWanted("time", axis != null);
            if (axis != null) {
                names = NamedObjects.getNames(axis);
                this.timeChooser.setCollection(names.iterator(), true);
                no = names.get(this.controller.getCurrentTimeIndex());
                this.timeChooser.setSelectedByName(no.getName());
            }
        } else {
            this.setChooserWanted("time", false);
        }
        this.setChooserWanted("ensemble", (axis = gcs.getEnsembleAxis()) != null);
        if (axis != null) {
            names = NamedObjects.getNames(axis);
            this.ensembleChooser.setCollection(names.iterator(), true);
            no = names.get(this.controller.getCurrentEnsembleIndex());
            this.ensembleChooser.setSelectedByName(no.getName());
        }
        this.setChooserWanted("runtime", (axis = gcs.getRunTimeAxis()) != null);
        if (axis != null) {
            names = NamedObjects.getNames(axis);
            this.runtimeChooser.setCollection(names.iterator(), true);
            no = names.get(this.controller.getCurrentRunTimeIndex());
            this.runtimeChooser.setSelectedByName(no.getName());
        }
        this.setChoosers();
        this.colorScalePanel.setUnitString(field.getUnitsString());
    }

    void setDrawHorizAndVert(boolean drawHoriz, boolean drawVert) {
        this.drawingPanel.removeAll();
        if (drawHoriz && drawVert) {
            this.splitDraw.setTopComponent(this.panz);
            this.splitDraw.setBottomComponent(this.vertPanel);
            this.drawingPanel.add((Component)this.splitDraw, "Center");
        } else if (drawHoriz) {
            this.drawingPanel.add((Component)this.panz, "Center");
        } else if (drawVert) {
            this.drawingPanel.add((Component)this.splitDraw, "Center");
        }
    }

    private void makeActionsDataset() {
        AbstractAction chooseLocalDatasetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dataset invDs;
                String filename = SimpleGeomUI.this.fileChooser.chooseFilename();
                if (filename == null) {
                    return;
                }
                try {
                    invDs = Dataset.makeStandalone((String)filename, (String)FeatureType.GRID.toString(), (String)"", (String)ServiceType.File.toString());
                }
                catch (Exception ue) {
                    JOptionPane.showMessageDialog(SimpleGeomUI.this, "Invalid filename = <" + filename + ">\n" + ue.getMessage());
                    ue.printStackTrace();
                    return;
                }
                SimpleGeomUI.this.setDataset(invDs);
            }
        };
        BAMutil.setActionProperties((AbstractAction)chooseLocalDatasetAction, (String)"FileChooser", (String)"open Local dataset...", (boolean)false, (int)76, (int)-1);
        this.chooseProjectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomUI.this.getProjectionManager().setVisible();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.chooseProjectionAction, null, (String)"Projection Manager...", (boolean)false, (int)80, (int)0);
        this.saveCurrentProjectionAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomUI.this.getProjectionManager();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.saveCurrentProjectionAction, null, (String)"save Current Projection", (boolean)false, (int)83, (int)0);
        this.redrawAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomUI.this.repaint();
                SimpleGeomUI.this.controller.start(true);
                SimpleGeomUI.this.controller.draw(true);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.redrawAction, (String)"alien", (String)"RedRaw", (boolean)false, (int)87, (int)0);
        this.showDatasetInfoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleGeomUI.this.infoWindow == null) {
                    SimpleGeomUI.this.datasetInfoTA = new TextHistoryPane();
                    SimpleGeomUI.this.infoWindow = new IndependentWindow("Dataset Information", BAMutil.getImage((String)"nj22/GDVs"), (Component)SimpleGeomUI.this.datasetInfoTA);
                    SimpleGeomUI.this.infoWindow.setSize(700, 700);
                    SimpleGeomUI.this.infoWindow.setLocation(100, 100);
                }
                SimpleGeomUI.this.datasetInfoTA.clear();
                SimpleGeomUI.this.datasetInfoTA.appendLine(SimpleGeomUI.this.controller.getDatasetInfo());
                SimpleGeomUI.this.datasetInfoTA.gotoTop();
                SimpleGeomUI.this.infoWindow.show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showDatasetInfoAction, (String)"Information", (String)"Show info...", (boolean)false, (int)83, (int)-1);
        this.showNcMLAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleGeomUI.this.ncmlWindow == null) {
                    SimpleGeomUI.this.ncmlTA = new TextHistoryPane();
                    SimpleGeomUI.this.ncmlWindow = new IndependentWindow("Dataset NcML", BAMutil.getImage((String)"nj22/GDVs"), (Component)SimpleGeomUI.this.ncmlTA);
                    SimpleGeomUI.this.ncmlWindow.setSize(700, 700);
                    SimpleGeomUI.this.ncmlWindow.setLocation(200, 70);
                }
                SimpleGeomUI.this.ncmlTA.clear();
                SimpleGeomUI.this.ncmlTA.appendLine(SimpleGeomUI.this.controller.getNcML());
                SimpleGeomUI.this.ncmlTA.gotoTop();
                SimpleGeomUI.this.ncmlWindow.show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showNcMLAction, null, (String)"Show NcML...", (boolean)false, (int)88, (int)-1);
        this.showGridDatasetInfoAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimpleGeomUI.this.ncmlWindow == null) {
                    SimpleGeomUI.this.ncmlTA = new TextHistoryPane();
                    SimpleGeomUI.this.ncmlWindow = new IndependentWindow("Dataset NcML", BAMutil.getImage((String)"nj22/GDVs"), (Component)SimpleGeomUI.this.ncmlTA);
                    SimpleGeomUI.this.ncmlWindow.setSize(700, 700);
                    SimpleGeomUI.this.ncmlWindow.setLocation(200, 70);
                }
                SimpleGeomUI.this.ncmlTA.clear();
                SimpleGeomUI.this.ncmlTA.appendLine(SimpleGeomUI.this.controller.getDatasetXML());
                SimpleGeomUI.this.ncmlTA.gotoTop();
                SimpleGeomUI.this.ncmlWindow.show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showGridDatasetInfoAction, null, (String)"Show GridDataset Info XML...", (boolean)false, (int)88, (int)-1);
        this.showGridTableAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomUI.this.gtWindow.show();
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showGridTableAction, (String)"Table", (String)"grid Table...", (boolean)false, (int)84, (int)-1);
        this.showNetcdfDatasetAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetcdfDataset netcdfDataset = SimpleGeomUI.this.controller.getNetcdfDataset();
                if (null != netcdfDataset) {
                    try {
                        SimpleGeomUI.this.dsTable.setDataset(netcdfDataset, null);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        return;
                    }
                    SimpleGeomUI.this.dsDialog.show();
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.showNetcdfDatasetAction, (String)"nj22/Netcdf", (String)"NetcdfDataset Table Info...", (boolean)false, (int)68, (int)-1);
        this.minmaxHorizAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomUI.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.horiz);
                SimpleGeomUI.this.controller.setDataMinMaxType(ColorScale.MinMaxType.horiz);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.minmaxHorizAction, null, (String)"Horizontal plane", (boolean)false, (int)72, (int)0);
        this.minmaxLogAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomUI.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.log);
                SimpleGeomUI.this.controller.setDataMinMaxType(ColorScale.MinMaxType.log);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.minmaxLogAction, null, (String)"log horiz plane", (boolean)false, (int)86, (int)0);
        this.minmaxHoldAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomUI.this.csDataMinMax.setSelectedItem((Object)ColorScale.MinMaxType.hold);
                SimpleGeomUI.this.controller.setDataMinMaxType(ColorScale.MinMaxType.hold);
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.minmaxHoldAction, null, (String)"Hold scale constant", (boolean)false, (int)67, (int)0);
        this.fieldLoopAction = new LoopControlAction(this.fieldChooser);
        this.levelLoopAction = new LoopControlAction(this.levelChooser);
        this.timeLoopAction = new LoopControlAction(this.timeChooser);
    }

    private void makeActionsToolbars() {
        this.navToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    SimpleGeomUI.this.toolPanel.add(SimpleGeomUI.this.navToolbar);
                } else {
                    SimpleGeomUI.this.toolPanel.remove(SimpleGeomUI.this.navToolbar);
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.navToolbarAction, (String)"MagnifyPlus", (String)"show Navigate toolbar", (boolean)true, (int)77, (int)0);
        this.navToolbarAction.putValue("state", this.store.getBoolean("navToolbarAction", true));
        this.moveToolbarAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Boolean state = (Boolean)this.getValue("state");
                if (state.booleanValue()) {
                    SimpleGeomUI.this.toolPanel.add(SimpleGeomUI.this.moveToolbar);
                } else {
                    SimpleGeomUI.this.toolPanel.remove(SimpleGeomUI.this.moveToolbar);
                }
            }
        };
        BAMutil.setActionProperties((AbstractAction)this.moveToolbarAction, (String)"Up", (String)"show Move toolbar", (boolean)true, (int)77, (int)0);
        this.moveToolbarAction.putValue("state", this.store.getBoolean("moveToolbarAction", true));
    }

    public ProjectionManager getProjectionManager() {
        if (null != this.projManager) {
            return this.projManager;
        }
        this.projManager = new ProjectionManager(null, this.store);
        this.projManager.addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("ProjectionImpl")) {
                Projection p = (Projection)e.getNewValue();
                this.controller.setProjection(p);
            }
        });
        return this.projManager;
    }

    private void makeUI(int defaultHeight) {
        this.datasetNameLabel = new JLabel();
        this.toolPanel = new JPanel();
        this.toolPanel.setBorder(new EtchedBorder());
        this.toolPanel.setLayout((LayoutManager)new MFlowLayout(0, 0, 0));
        JMenu dataMenu = new JMenu("Dataset");
        dataMenu.setMnemonic('D');
        JMenu configMenu = new JMenu("Configure");
        configMenu.setMnemonic('C');
        JMenu toolMenu = new JMenu("Controls");
        toolMenu.setMnemonic('T');
        this.addActionsToMenus(dataMenu, configMenu, toolMenu);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(dataMenu);
        menuBar.add(configMenu);
        menuBar.add(toolMenu);
        this.toolPanel.add(menuBar);
        this.fieldPanel = new JPanel();
        this.fieldPanel.setLayout(new FlowLayout(0, 0, 0));
        this.toolPanel.add(this.fieldPanel);
        this.toolPanel.add(this.controller.strideSpinner);
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.controller.drawHorizAction);
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.controller.drawVertAction);
        this.mapBeanMenu = MapBean.makeMapSelectButton();
        this.toolPanel.add(this.mapBeanMenu.getParentComponent());
        this.panz.setLayout(new FlowLayout());
        this.navToolbar = this.panz.getNavToolBar();
        this.moveToolbar = this.panz.getMoveToolBar();
        if (((Boolean)this.navToolbarAction.getValue("state")).booleanValue()) {
            this.toolPanel.add(this.navToolbar);
        }
        if (((Boolean)this.moveToolbarAction.getValue("state")).booleanValue()) {
            this.toolPanel.add(this.moveToolbar);
        }
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.panz.setReferenceAction);
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.controller.dataProjectionAction);
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.controller.showGridAction);
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.controller.showContoursAction);
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.controller.showContourLabelsAction);
        BAMutil.addActionToContainer((Container)this.toolPanel, (Action)this.redrawAction);
        this.vertPanel = new VertPanel();
        this.splitDraw = new JSplitPane(0, this.panz, this.vertPanel);
        int divLoc = this.store.getInt("vertSplit", 2 * defaultHeight / 3);
        this.splitDraw.setDividerLocation(divLoc);
        this.drawingPanel = new JPanel(new BorderLayout());
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(new EtchedBorder());
        this.positionLabel = new JLabel("position");
        this.positionLabel.setToolTipText("position at cursor");
        this.dataValueLabel = new JLabel("data value", 0);
        this.dataValueLabel.setToolTipText("data value (double click on grid)");
        statusPanel.add((Component)this.positionLabel, "West");
        statusPanel.add((Component)this.dataValueLabel, "Center");
        this.panz.setPositionLabel(this.positionLabel);
        this.colorScalePanel = new ColorScale.Panel(this, this.controller.getColorScale());
        this.csDataMinMax = new JComboBox<ColorScale.MinMaxType>(ColorScale.MinMaxType.values());
        this.csDataMinMax.setToolTipText("ColorScale Min/Max setting");
        this.csDataMinMax.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleGeomUI.this.controller.setDataMinMaxType((ColorScale.MinMaxType)((Object)SimpleGeomUI.this.csDataMinMax.getSelectedItem()));
            }
        });
        JPanel westPanel = new JPanel(new BorderLayout());
        westPanel.add((Component)this.colorScalePanel, "Center");
        westPanel.add(this.csDataMinMax, "North");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        northPanel.add((Component)this.datasetNameLabel, "North");
        northPanel.add((Component)this.toolPanel, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)northPanel, "North");
        this.add((Component)statusPanel, "South");
        this.add((Component)westPanel, "West");
        this.add((Component)this.drawingPanel, "Center");
        this.setDrawHorizAndVert(this.controller.drawHorizOn, this.controller.drawVertOn);
    }

    private void setChoosers() {
        this.fieldPanel.removeAll();
        Iterator<Chooser> iterator = this.choosers.iterator();
        while (iterator.hasNext()) {
            Chooser chooser;
            Chooser c = chooser = iterator.next();
            if (!c.isWanted) continue;
            this.fieldPanel.add((Component)c.field);
        }
    }

    private void setChooserWanted(String name, boolean want) {
        Iterator<Chooser> iterator = this.choosers.iterator();
        while (iterator.hasNext()) {
            Chooser chooser1;
            Chooser chooser = chooser1 = iterator.next();
            if (!chooser.name.equals(name)) continue;
            chooser.isWanted = want;
        }
    }

    private void addToolbarOption(String toolbarName, JToolBar toolbar, AbstractAction act) {
        boolean wantsToolbar = this.store.getBoolean(toolbarName, true);
        if (wantsToolbar) {
            this.toolPanel.add(toolbar);
        }
    }

    void addActionsToMenus(JMenu datasetMenu, JMenu configMenu, JMenu toolMenu) {
        BAMutil.addActionToMenu((JMenu)datasetMenu, (Action)this.showGridTableAction);
        BAMutil.addActionToMenu((JMenu)datasetMenu, (Action)this.showDatasetInfoAction);
        BAMutil.addActionToMenu((JMenu)datasetMenu, (Action)this.showNcMLAction);
        BAMutil.addActionToMenu((JMenu)datasetMenu, (Action)this.showGridDatasetInfoAction);
        BAMutil.addActionToMenu((JMenu)datasetMenu, (Action)this.showNetcdfDatasetAction);
        JMenu toolbarMenu = new JMenu("Toolbars");
        toolbarMenu.setMnemonic('T');
        configMenu.add(toolbarMenu);
        BAMutil.addActionToMenu((JMenu)toolbarMenu, (Action)this.navToolbarAction);
        BAMutil.addActionToMenu((JMenu)toolbarMenu, (Action)this.moveToolbarAction);
        BAMutil.addActionToMenu((JMenu)configMenu, (Action)this.chooseProjectionAction);
        BAMutil.addActionToMenu((JMenu)configMenu, (Action)this.saveCurrentProjectionAction);
        JMenu displayMenu = new JMenu("Display control");
        displayMenu.setMnemonic('D');
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.controller.showGridAction);
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.controller.showContoursAction);
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.controller.showContourLabelsAction);
        BAMutil.addActionToMenu((JMenu)displayMenu, (Action)this.redrawAction);
        toolMenu.add(displayMenu);
        JMenu loopMenu = new JMenu("Loop control");
        loopMenu.setMnemonic('L');
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.fieldLoopAction);
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.levelLoopAction);
        BAMutil.addActionToMenu((JMenu)loopMenu, (Action)this.timeLoopAction);
        toolMenu.add(loopMenu);
        JMenu mmMenu = new JMenu("ColorScale min/max");
        mmMenu.setMnemonic('C');
        BAMutil.addActionToMenu((JMenu)mmMenu, (Action)this.minmaxHorizAction);
        BAMutil.addActionToMenu((JMenu)mmMenu, (Action)this.minmaxLogAction);
        BAMutil.addActionToMenu((JMenu)mmMenu, (Action)this.minmaxHoldAction);
        toolMenu.add(mmMenu);
        JMenu zoomMenu = new JMenu("Zoom/Pan");
        zoomMenu.setMnemonic('Z');
        this.panz.addActionsToMenu(zoomMenu);
        toolMenu.add(zoomMenu);
    }

    private class OpenDatasetTask
    extends ProgressMonitorTask
    implements CancelTask {
        DataFactory factory = new DataFactory();
        Dataset invds;

        OpenDatasetTask(Dataset ds) {
            this.invds = ds;
        }

        public void run() {
            GridDataset gridDataset = null;
            Formatter errlog = new Formatter();
            try {
                NetcdfDataset dataset = this.factory.openDataset(this.invds, true, (CancelTask)this, errlog);
                gridDataset = new GridDataset(dataset);
            }
            catch (IOException e) {
                this.setError("Failed to open datset: " + errlog);
            }
            boolean bl = this.success = !this.cancel && gridDataset != null;
            if (this.success) {
                SimpleGeomUI.this.controller.setGridDataset((ucar.nc2.dt.GridDataset)gridDataset);
            }
            this.done = true;
        }
    }

    private static class LoopControlAction
    extends AbstractAction {
        SuperComboBox scbox;

        LoopControlAction(SuperComboBox cbox) {
            this.scbox = cbox;
            BAMutil.setActionProperties((AbstractAction)this, null, (String)cbox.getName(), (boolean)false, (int)0, (int)0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.scbox.getLoopControl().show();
        }
    }

    private static class Chooser {
        boolean isWanted;
        String name;
        SuperComboBox field;

        Chooser(String name, SuperComboBox field, boolean want) {
            this.name = name;
            this.field = field;
            this.isWanted = want;
        }
    }
}

