/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.util;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.ft2.coverage.CoordInterval;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis1D;
import ucar.nc2.grid.GridAxis1DTime;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.ui.util.NamedObject;
import ucar.unidata.util.Format;

public class NamedObjects {
    public static List<NamedObject> getNames(CoordinateAxis1DTime axis) {
        if (axis == null) {
            return new ArrayList<NamedObject>();
        }
        List cdates = axis.getCalendarDates();
        ArrayList<NamedObject> names = new ArrayList<NamedObject>(cdates.size());
        for (CalendarDate cd : cdates) {
            names.add(NamedObject.create((Object)CalendarDateFormatter.toDateTimeStringISO((CalendarDate)cd), (String)axis.getShortName()));
        }
        return names;
    }

    public static List<NamedObject> getNames(CoordinateAxis1D axis) {
        if (axis == null) {
            return new ArrayList<NamedObject>();
        }
        ArrayList<NamedObject> names = new ArrayList<NamedObject>();
        int i = 0;
        while ((long)i < axis.getSize()) {
            names.add(NamedObject.create((Object)axis.getCoordName(i), (String)(axis.getShortName() + " " + axis.getUnitsString())));
            ++i;
        }
        return names;
    }

    public static List<NamedObject> getNames(CoverageCoordAxis1D axis) {
        if (axis == null) {
            return new ArrayList<NamedObject>();
        }
        if (axis.getAxisType() == AxisType.Time || axis.getAxisType() == AxisType.RunTime) {
            return NamedObjects.getCoverageCoordTimeNames(axis);
        }
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        for (int i = 0; i < axis.getNcoords(); ++i) {
            String value = null;
            switch (axis.getSpacing()) {
                case regularPoint: 
                case irregularPoint: {
                    value = Format.d((double)axis.getCoordMidpoint(i), (int)3);
                    break;
                }
                case regularInterval: 
                case contiguousInterval: 
                case discontiguousInterval: {
                    value = new CoordInterval(axis.getCoordEdge1(i), axis.getCoordEdge2(i), 3);
                }
            }
            result.add(NamedObject.create((Object)value, (String)(value + " " + axis.getUnits())));
        }
        return result;
    }

    private static List<NamedObject> getCoverageCoordTimeNames(CoverageCoordAxis1D axis) {
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        block4: for (int i = 0; i < axis.getNcoords(); ++i) {
            switch (axis.getSpacing()) {
                case regularPoint: 
                case irregularPoint: {
                    double value = axis.getCoordMidpoint(i);
                    result.add(NamedObject.create((Object)axis.makeDate(value), (String)axis.getAxisType().toString()));
                    continue block4;
                }
                case regularInterval: 
                case contiguousInterval: 
                case discontiguousInterval: {
                    CoordInterval coord = new CoordInterval(axis.getCoordEdge1(i), axis.getCoordEdge2(i), 3);
                    result.add(NamedObject.create((Object)coord, (String)(coord + " " + axis.getUnits())));
                }
            }
        }
        return result;
    }

    public static List<NamedObject> getNames(Iterable<Grid> grids) {
        if (grids == null) {
            return new ArrayList<NamedObject>();
        }
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        for (Grid grid : grids) {
            result.add(NamedObject.create((String)grid.getName(), (String)grid.getDescription(), (Object)grid));
        }
        return result;
    }

    public static List<NamedObject> getCoordNames(GridAxis1D axis) {
        if (axis == null) {
            return new ArrayList<NamedObject>();
        }
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        for (Object coord : axis) {
            result.add(NamedObject.create(coord, (String)axis.getUnits()));
        }
        return result;
    }

    public static List<NamedObject> getTimeNames(GridAxis1DTime axis) {
        if (axis == null) {
            return new ArrayList<NamedObject>();
        }
        ArrayList<NamedObject> result = new ArrayList<NamedObject>();
        for (CalendarDate cdate : axis.getCalendarDates()) {
            result.add(NamedObject.create((Object)cdate, (String)axis.getAxisType().toString()));
        }
        return result;
    }
}

