/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui.widget;

import java.awt.Component;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import ucar.httpservices.HTTPAuthUtil;
import ucar.httpservices.HTTPCredentialsProvider;
import ucar.httpservices.HTTPSession;
import ucar.ui.prefs.Field;
import ucar.ui.prefs.PrefPanel;
import ucar.ui.widget.IndependentDialog;

public class UrlAuthenticatorDialog
extends Authenticator
implements HTTPCredentialsProvider {
    private static final boolean debug = false;
    private IndependentDialog dialog;
    private UsernamePasswordCredentials pwa = null;
    private final Field.Text serverF;
    private final Field.Text realmF;
    private final Field.Text userF;
    private final Field.Password passwF;
    public HTTPSession session = null;
    private final Map<AuthScope, Credentials> setcache = new ConcurrentHashMap<AuthScope, Credentials>();
    private final Map<AuthScope, Credentials> dialogcache = new ConcurrentHashMap<AuthScope, Credentials>();

    public UrlAuthenticatorDialog(JFrame parent) {
        PrefPanel pp = new PrefPanel("UrlAuthenticatorDialog", null);
        this.serverF = pp.addTextField("server", "Server", "wwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwwww");
        this.realmF = pp.addTextField("realm", "Realm", "");
        this.serverF.setEditable(false);
        this.realmF.setEditable(false);
        this.userF = pp.addTextField("user", "User", "");
        this.passwF = pp.addPasswordField("password", "Password", "");
        pp.addActionListener(e -> {
            char[] pw = this.passwF.getPassword();
            if (pw == null) {
                return;
            }
            this.pwa = new UsernamePasswordCredentials(this.userF.getText(), new String(pw));
            this.dialog.setVisible(false);
        });
        JButton cancel = new JButton("Cancel");
        pp.addButton((JComponent)cancel);
        cancel.addActionListener(evt -> {
            this.pwa = null;
            this.dialog.setVisible(false);
        });
        pp.finish();
        this.dialog = new IndependentDialog(parent, true, "HTTP Authentication", (Component)pp);
        this.dialog.setLocationRelativeTo((Component)parent);
        this.dialog.setLocation(100, 100);
    }

    public void clear() {
        this.dialogcache.clear();
    }

    public void remove(HttpHost host) {
        AuthScope hostscope = HTTPAuthUtil.hostToAuthScope((HttpHost)host);
        AuthScope match = HTTPAuthUtil.bestmatch((AuthScope)hostscope, this.dialogcache.keySet());
        if (match != null) {
            this.dialogcache.remove(match);
        }
    }

    public void setCredentials(AuthScope scope, Credentials cred) {
        this.setcache.put(scope, cred);
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        if (this.pwa == null) {
            throw new IllegalStateException();
        }
        this.serverF.setText(this.getRequestingHost() + ":" + this.getRequestingPort());
        this.realmF.setText(this.getRequestingPrompt());
        this.dialog.setVisible(true);
        return new PasswordAuthentication(this.pwa.getUserName(), this.pwa.getPassword().toCharArray());
    }

    public Credentials getCredentials(AuthScope scope) {
        Credentials creds = null;
        AuthScope bestMatch = HTTPAuthUtil.bestmatch((AuthScope)scope, this.dialogcache.keySet());
        if (bestMatch != null) {
            creds = this.dialogcache.get(bestMatch);
        }
        if (creds == null && (bestMatch = HTTPAuthUtil.bestmatch((AuthScope)scope, this.setcache.keySet())) != null) {
            creds = this.setcache.get(bestMatch);
        }
        if (creds != null) {
            return creds;
        }
        this.serverF.setText(scope.getHost() + ":" + scope.getPort());
        this.realmF.setText(scope.getRealm());
        this.dialog.setVisible(true);
        if (this.pwa == null) {
            throw new IllegalStateException();
        }
        UsernamePasswordCredentials upc = new UsernamePasswordCredentials(this.pwa.getUserName(), this.pwa.getPassword());
        this.dialogcache.put(scope, (Credentials)upc);
        return upc;
    }
}

