/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.DisplayException;
import visad.ErrorEstimate;
import visad.Gridded3DSet;
import visad.Linear1DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.ScalarMap;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADIndexedTriangleStripArray;
import visad.VisADTriangleStripArray;

public class Linear3DSet
extends Gridded3DSet
implements LinearSet {
    Linear1DSet X;
    Linear1DSet Y;
    Linear1DSet Z;
    private boolean cacheSamples;

    public Linear3DSet(Linear1DSet[] sets) throws VisADException {
        this((MathType)RealTupleType.Generic3D, sets, null, null, null);
    }

    public Linear3DSet(MathType type, Linear1DSet[] sets) throws VisADException {
        this(type, sets, null, null, null);
    }

    public Linear3DSet(double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3) throws VisADException {
        this((MathType)RealTupleType.Generic3D, LinearNDSet.get_linear1d_array(RealTupleType.Generic3D, first1, last1, length1, first2, last2, length2, first3, last3, length3, null), null, null, null);
    }

    public Linear3DSet(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3) throws VisADException {
        this(type, LinearNDSet.get_linear1d_array(type, first1, last1, length1, first2, last2, length2, first3, last3, length3, null), null, null, null);
    }

    public Linear3DSet(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, first1, last1, length1, first2, last2, length2, first3, last3, length3, coord_sys, units, errors, false);
    }

    public Linear3DSet(MathType type, double first1, double last1, int length1, double first2, double last2, int length2, double first3, double last3, int length3, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        this(type, LinearNDSet.get_linear1d_array(type, first1, last1, length1, first2, last2, length2, first3, last3, length3, units), coord_sys, units, errors, cache);
    }

    public Linear3DSet(MathType type, Linear1DSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, sets, coord_sys, units, errors, false);
    }

    public Linear3DSet(MathType type, Linear1DSet[] sets, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean cache) throws VisADException {
        super(type, (float[][])null, sets[0].getLength(), sets[1].getLength(), sets[2].getLength(), coord_sys, LinearNDSet.units_array_linear1d(sets, units), errors);
        if (this.DomainDimension != 3) {
            throw new SetException("Linear3DSet: DomainDimension must be 3, not " + this.DomainDimension);
        }
        if (sets.length != 3) {
            throw new SetException("Linear3DSet: ManifoldDimension must be 3, not " + sets.length);
        }
        Linear1DSet[] ss = LinearNDSet.linear1d_array_units(sets, units);
        this.X = ss[0];
        this.Y = ss[1];
        this.Z = ss[2];
        this.LengthX = this.X.getLength();
        this.LengthY = this.Y.getLength();
        this.LengthZ = this.Z.getLength();
        this.Length = this.LengthX * this.LengthY * this.LengthZ;
        this.Low[0] = this.X.getLowX();
        this.Hi[0] = this.X.getHiX();
        this.Low[1] = this.Y.getLowX();
        this.Hi[1] = this.Y.getHiX();
        this.Low[2] = this.Z.getLowX();
        this.Hi[2] = this.Z.getHiX();
        if (this.SetErrors[0] != null) {
            this.SetErrors[0] = new ErrorEstimate(this.SetErrors[0].getErrorValue(), (double)(this.Low[0] + this.Hi[0]) / 2.0, this.Length, this.SetErrors[0].getUnit());
        }
        if (this.SetErrors[1] != null) {
            this.SetErrors[1] = new ErrorEstimate(this.SetErrors[1].getErrorValue(), (double)(this.Low[1] + this.Hi[1]) / 2.0, this.Length, this.SetErrors[1].getUnit());
        }
        if (this.SetErrors[2] != null) {
            this.SetErrors[2] = new ErrorEstimate(this.SetErrors[2].getErrorValue(), (double)(this.Low[2] + this.Hi[2]) / 2.0, this.Length, this.SetErrors[2].getUnit());
        }
        this.cacheSamples = cache;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        int[] indexX = new int[length];
        int[] indexY = new int[length];
        int[] indexZ = new int[length];
        float[][] values = new float[3][];
        for (int i = 0; i < length; ++i) {
            if (0 <= index[i] && index[i] < this.Length) {
                indexX[i] = index[i] % this.LengthX;
                int k = index[i] / this.LengthX;
                indexY[i] = k % this.LengthY;
                indexZ[i] = k / this.LengthY;
                continue;
            }
            indexX[i] = -1;
            indexY[i] = -1;
            indexZ[i] = -1;
        }
        float[][] valuesX = this.X.indexToValue(indexX);
        float[][] valuesY = this.Y.indexToValue(indexY);
        float[][] valuesZ = this.Z.indexToValue(indexZ);
        values[0] = valuesX[0];
        values[1] = valuesY[0];
        values[2] = valuesZ[0];
        return values;
    }

    public float[][] gridToValue(float[][] grid) throws VisADException {
        if (grid.length != this.ManifoldDimension) {
            throw new SetException("Linear3DSet.gridToValue: grid dimension " + grid.length + " not equal to Manifold dimension " + this.ManifoldDimension);
        }
        if (this.ManifoldDimension != 3) {
            throw new SetException("Linear3DSet.gridToValue: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2)) {
            throw new SetException("Linear3DSet.gridToValue: requires all grid dimensions to be > 1");
        }
        int length = grid[0].length;
        float[][] gridX = new float[][]{grid[0]};
        float[][] gridY = new float[][]{grid[1]};
        float[][] gridZ = new float[][]{grid[2]};
        float[][] valueX = this.X.gridToValue(gridX);
        float[][] valueY = this.Y.gridToValue(gridY);
        float[][] valueZ = this.Z.gridToValue(gridZ);
        float[][] value = new float[][]{valueX[0], valueY[0], valueZ[0]};
        return value;
    }

    public float[][] valueToGrid(float[][] value) throws VisADException {
        if (value.length != 3) {
            throw new SetException("Linear3DSet.valueToGrid: value dimension must be 3, not " + value.length);
        }
        if (this.Length > 1 && (this.Lengths[0] < 2 || this.Lengths[1] < 2 || this.Lengths[2] < 2)) {
            throw new SetException("Linear3DSet.valueToGrid: requires all grid dimensions to be > 1");
        }
        int length = value[0].length;
        float[][] valueX = new float[][]{value[0]};
        float[][] valueY = new float[][]{value[1]};
        float[][] valueZ = new float[][]{value[2]};
        float[][] gridX = this.X.valueToGrid(valueX);
        float[][] gridY = this.Y.valueToGrid(valueY);
        float[][] gridZ = this.Z.valueToGrid(valueZ);
        float[][] grid = new float[][]{gridX[0], gridY[0], gridZ[0]};
        return grid;
    }

    public Linear1DSet getX() {
        return this.X;
    }

    public Linear1DSet getY() {
        return this.Y;
    }

    public Linear1DSet getZ() {
        return this.Z;
    }

    public boolean isMissing() {
        return false;
    }

    public float[][] getSamples(boolean copy) throws VisADException {
        float[][] mySamples = this.getMySamples();
        if (mySamples != null) {
            return copy ? Set.copyFloats(mySamples) : mySamples;
        }
        float[][] samples = this.makeSamples();
        if (this.cacheSamples) {
            this.setMySamples(samples);
            return copy ? Set.copyFloats(samples) : samples;
        }
        return samples;
    }

    private float[][] makeSamples() throws VisADException {
        float[][] xVals = this.X.getSamples(false);
        float[][] yVals = this.Y.getSamples(false);
        float[][] zVals = this.Z.getSamples(false);
        float[][] samples = new float[3][this.Length];
        int idx = 0;
        for (int k = 0; k < zVals[0].length; ++k) {
            for (int j = 0; j < yVals[0].length; ++j) {
                for (int i = 0; i < xVals[0].length; ++i) {
                    samples[0][idx] = xVals[0][i];
                    samples[1][idx] = yVals[0][j];
                    samples[2][idx] = zVals[0][k];
                    ++idx;
                }
            }
        }
        return samples;
    }

    public VisADGeometryArray[] make3DGeometry(byte[][] color_values) throws VisADException {
        if (this.ManifoldDimension != 3) {
            throw new SetException("Linear3DSet.make3DGeometry: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        int lengthX = this.X.getLength();
        int lengthY = this.Y.getLength();
        int lengthZ = this.Z.getLength();
        if (lengthX < 2 || lengthY < 2 || lengthZ < 2 || color_values.length < 4) {
            VisADGeometryArray array = this.makePointGeometry(color_values);
            return new VisADGeometryArray[]{array, array, array};
        }
        double firstX = this.X.getFirst();
        double firstY = this.Y.getFirst();
        double firstZ = this.Z.getFirst();
        double lastX = this.X.getLast();
        double lastY = this.Y.getLast();
        double lastZ = this.Z.getLast();
        for (int x = 0; x < lengthX; ++x) {
            for (int y = 0; y < lengthY; ++y) {
                for (int z = 0; z < lengthZ; ++z) {
                    float red = color_values[0][x + lengthX * (y + lengthY * z)];
                    float green = color_values[2][x + lengthX * (y + lengthY * z)];
                    float blue = color_values[3][x + lengthX * (y + lengthY * z)];
                    float alpha = color_values[4][x + lengthX * (y + lengthY * z)];
                }
            }
        }
        VisADGeometryArray[] arrays = new VisADTriangleStripArray[]{new VisADTriangleStripArray(), new VisADTriangleStripArray(), new VisADTriangleStripArray()};
        return arrays;
    }

    public VisADGeometryArray makeLinearIsoSurface(float isolevel, float[] fieldValues, byte[][] color_values, boolean indexed, ScalarMap[] spatial_maps, int[] permute) throws VisADException {
        int i;
        boolean debug = false;
        if (this.ManifoldDimension != 3) {
            throw new DisplayException("Linear3DSet.makeLinearIsoSurface: ManifoldDimension must be 3, not " + this.ManifoldDimension);
        }
        int xdim = this.LengthY;
        int ydim = this.LengthX;
        int zdim = this.LengthZ;
        float[] ptGRID = fieldValues;
        int xdim_x_ydim = xdim * ydim;
        int xdim_x_ydim_x_zdim = xdim_x_ydim * zdim;
        int num_cubes = (xdim - 1) * (ydim - 1) * (zdim - 1);
        int[] ptFLAG = new int[num_cubes];
        int[] ptAUX = new int[xdim_x_ydim_x_zdim];
        int[] pcube = new int[num_cubes + 1];
        int npolygons = Linear3DSet.flags(isolevel, ptFLAG, ptAUX, pcube, ptGRID, xdim, ydim, zdim);
        if (debug) {
            System.out.println("npolygons= " + npolygons);
        }
        if (npolygons == 0) {
            return null;
        }
        pcube = null;
        int nvertex_estimate = 4 * npolygons + 100;
        int ix = 9 * (nvertex_estimate + 50);
        int iy = 7 * npolygons;
        float[][] VX = new float[1][nvertex_estimate];
        float[][] VY = new float[1][nvertex_estimate];
        float[][] VZ = new float[1][nvertex_estimate];
        Object color_temps = null;
        if (color_values != null) {
            color_temps = new byte[color_values.length][];
        }
        int[] Pol_f_Vert = new int[ix];
        int[] Vert_f_Pol = new int[iy];
        int[][] arg_Pol_f_Vert = new int[][]{Pol_f_Vert};
        float[] sos = new float[6];
        Unit[] set_units = this.getSetUnits();
        RealTupleType domain_type = ((SetType)this.getType()).getDomain();
        Unit[] def_units = domain_type.getDefaultUnits();
        Linear1DSet[] sets = new Linear1DSet[]{this.getX(), this.getY(), this.getZ()};
        double[] so = new double[2];
        double[] data = new double[2];
        double[] display = new double[2];
        for (i = 0; i < 3; ++i) {
            double first = sets[i].getFirst();
            double step = sets[i].getStep();
            if (set_units[i] != null && !set_units[i].equals(def_units[i])) {
                double uo = set_units[i].toThat(0.0, def_units[i]);
                double us = set_units[i].toThat(1.0, def_units[i]) - uo;
                first = uo + us * first;
                step = us * step;
            }
            spatial_maps[i].getScale(so, data, display);
            sos[2 * i + 0] = (float)(so[1] + so[0] * first);
            sos[2 * i + 1] = (float)(so[0] * step);
        }
        float t = sos[0];
        sos[0] = sos[2];
        sos[2] = t;
        t = sos[1];
        sos[1] = sos[3];
        sos[3] = t;
        int nvertex = this.linear_isosurf(isolevel, ptFLAG, nvertex_estimate, npolygons, ptGRID, xdim, ydim, zdim, VY, VX, VZ, color_values, (byte[][])color_temps, arg_Pol_f_Vert, Vert_f_Pol, sos);
        Pol_f_Vert = arg_Pol_f_Vert[0];
        if (nvertex == 0) {
            return null;
        }
        ptFLAG = null;
        ptAUX = null;
        float[][] fieldVertices = new float[3][nvertex];
        System.arraycopy(VX[0], 0, fieldVertices[permute[0]], 0, nvertex);
        System.arraycopy(VY[0], 0, fieldVertices[permute[1]], 0, nvertex);
        System.arraycopy(VZ[0], 0, fieldVertices[permute[2]], 0, nvertex);
        VX = null;
        VY = null;
        VZ = null;
        byte[][] color_levels = null;
        if (color_values != null) {
            color_levels = new byte[color_values.length][nvertex];
            System.arraycopy(color_temps[0], 0, color_levels[0], 0, nvertex);
            System.arraycopy(color_temps[1], 0, color_levels[1], 0, nvertex);
            System.arraycopy(color_temps[2], 0, color_levels[2], 0, nvertex);
            if (((byte[][])color_temps).length > 3) {
                System.arraycopy(color_temps[3], 0, color_levels[3], 0, nvertex);
            }
            color_temps = null;
        }
        if (debug) {
            System.out.println("nvertex= " + nvertex);
        }
        float[] NxA = new float[npolygons];
        float[] NxB = new float[npolygons];
        float[] NyA = new float[npolygons];
        float[] NyB = new float[npolygons];
        float[] NzA = new float[npolygons];
        float[] NzB = new float[npolygons];
        float[] Pnx = new float[npolygons];
        float[] Pny = new float[npolygons];
        float[] Pnz = new float[npolygons];
        float[] NX = new float[nvertex];
        float[] NY = new float[nvertex];
        float[] NZ = new float[nvertex];
        Linear3DSet.make_normals(fieldVertices[0], fieldVertices[1], fieldVertices[2], NX, NY, NZ, nvertex, npolygons, Pnx, Pny, Pnz, NxA, NxB, NyA, NyB, NzA, NzB, Pol_f_Vert, Vert_f_Pol);
        Pnz = null;
        Pny = null;
        Pnx = null;
        NzB = null;
        NzA = null;
        NyB = null;
        NyA = null;
        NxB = null;
        NxA = null;
        float[] normals = new float[3 * nvertex];
        int j = 0;
        for (i = 0; i < nvertex; ++i) {
            normals[j++] = NX[i];
            normals[j++] = NY[i];
            normals[j++] = NZ[i];
        }
        NZ = null;
        NY = null;
        NX = null;
        int[] stripe = new int[6 * npolygons];
        int[] vet_pol = new int[npolygons];
        int size_stripe = Linear3DSet.poly_triangle_stripe(vet_pol, stripe, nvertex, npolygons, Pol_f_Vert, Vert_f_Pol);
        Pol_f_Vert = null;
        Vert_f_Pol = null;
        if (indexed) {
            VisADIndexedTriangleStripArray array = new VisADIndexedTriangleStripArray();
            array.indexCount = size_stripe;
            array.indices = new int[size_stripe];
            System.arraycopy(stripe, 0, array.indices, 0, size_stripe);
            array.stripVertexCounts = new int[1];
            array.stripVertexCounts[0] = size_stripe;
            stripe = null;
            Linear3DSet.setGeometryArray(array, fieldVertices, 4, color_levels);
            fieldVertices = null;
            color_levels = null;
            array.normals = normals;
            if (debug) {
                System.out.println("size_stripe= " + size_stripe);
                for (int ii = 0; ii < size_stripe; ++ii) {
                    System.out.println(array.indices[ii]);
                }
            }
            return array;
        }
        VisADTriangleStripArray array = new VisADTriangleStripArray();
        array.stripVertexCounts = new int[]{size_stripe};
        array.vertexCount = size_stripe;
        array.normals = new float[3 * size_stripe];
        int k = 0;
        for (i = 0; i < 3 * size_stripe; i += 3) {
            j = 3 * stripe[k];
            array.normals[i] = normals[j];
            array.normals[i + 1] = normals[j + 1];
            array.normals[i + 2] = normals[j + 2];
            ++k;
        }
        normals = null;
        array.coordinates = new float[3 * size_stripe];
        k = 0;
        for (i = 0; i < 3 * size_stripe; i += 3) {
            j = stripe[k];
            array.coordinates[i] = fieldVertices[0][j];
            array.coordinates[i + 1] = fieldVertices[1][j];
            array.coordinates[i + 2] = fieldVertices[2][j];
            ++k;
        }
        fieldVertices = null;
        if (color_levels != null) {
            int color_length = color_levels.length;
            array.colors = new byte[color_length * size_stripe];
            k = 0;
            if (color_length == 4) {
                for (i = 0; i < color_length * size_stripe; i += color_length) {
                    j = stripe[k];
                    array.colors[i] = color_levels[0][j];
                    array.colors[i + 1] = color_levels[1][j];
                    array.colors[i + 2] = color_levels[2][j];
                    array.colors[i + 3] = color_levels[3][j];
                    ++k;
                }
            } else {
                for (i = 0; i < color_length * size_stripe; i += color_length) {
                    j = stripe[k];
                    array.colors[i] = color_levels[0][j];
                    array.colors[i + 1] = color_levels[1][j];
                    array.colors[i + 2] = color_levels[2][j];
                    ++k;
                }
            }
        }
        color_levels = null;
        stripe = null;
        return array;
    }

    private int linear_isosurf(float isovalue, int[] ptFLAG, int nvertex_estimate, int npolygons, float[] ptGRID, int xdim, int ydim, int zdim, float[][] VX, float[][] VY, float[][] VZ, byte[][] auxValues, byte[][] auxLevels, int[][] Pol_f_Vert, int[] Vert_f_Pol, float[] sos) throws VisADException {
        int jj;
        int naux;
        int[] calc_edge = new int[13];
        float vnode0 = 0.0f;
        float vnode1 = 0.0f;
        float vnode2 = 0.0f;
        float vnode3 = 0.0f;
        float vnode4 = 0.0f;
        float vnode5 = 0.0f;
        float vnode6 = 0.0f;
        float vnode7 = 0.0f;
        int pt = 0;
        int xdim_x_ydim = xdim * ydim;
        float[][] mySamples = this.getMySamples();
        float xo = sos[0];
        float xs = sos[1];
        float yo = sos[2];
        float ys = sos[3];
        float zo = sos[4];
        float zs = sos[5];
        int n = naux = auxValues != null ? auxValues.length : 0;
        if (naux > 0) {
            if (auxLevels == null || auxLevels.length != naux) {
                throw new SetException("Linear3DSet.isosurf: auxLevels length " + auxLevels.length + " doesn't match expected " + naux);
            }
            for (int i = 0; i < naux; ++i) {
                if (auxValues[i].length == this.Length) continue;
                throw new SetException("Linear3DSet.isosurf: expected auxValues  length#" + i + " to be " + this.Length + ", not " + auxValues[i].length);
            }
        } else if (auxLevels != null) {
            throw new SetException("Linear3DSet.isosurf: auxValues null but auxLevels not null");
        }
        byte[][] tempaux = naux > 0 ? new byte[naux][nvertex_estimate] : (byte[][])null;
        int rear = 0;
        int bellow = 0;
        int front = 1;
        int above = 1;
        for (jj = 0; jj < Pol_f_Vert[0].length; ++jj) {
            Pol_f_Vert[0][jj] = -2000000000;
        }
        for (jj = 8; jj < Pol_f_Vert[0].length; jj += 9) {
            Pol_f_Vert[0][jj] = 0;
        }
        for (jj = 0; jj < Vert_f_Pol.length; ++jj) {
            Vert_f_Pol[jj] = -2000000000;
        }
        for (jj = 6; jj < Vert_f_Pol.length; jj += 7) {
            Vert_f_Pol[jj] = 0;
        }
        int xx = xdim_x_ydim - ydim;
        int yy = xdim_x_ydim - xdim;
        int zz = ydim;
        int ii = 2 * (xx + yy + zz);
        int[] P_array = new int[ii];
        int pvp = 0;
        int cpl = 0;
        int ncube = 0;
        int nvet = 0;
        for (int iz = 0; iz < zdim - 1; ++iz) {
            int caseA;
            for (int ix = 0; ix < xdim - 1; ++ix) {
                for (int iy = 0; iy < ydim - 1; ++iy) {
                    if (ptFLAG[ncube] != 0 & ptFLAG[ncube] != 255) {
                        int t;
                        float cp;
                        if (nvet + 12 > nvertex_estimate) {
                            nvertex_estimate = 2 * (nvet + 12);
                            if (naux > 0) {
                                for (int i = 0; i < naux; ++i) {
                                    byte[] tt = tempaux[i];
                                    tempaux[i] = new byte[nvertex_estimate];
                                    System.arraycopy(tt, 0, tempaux[i], 0, nvet);
                                }
                            }
                            float[] tt = VX[0];
                            VX[0] = new float[nvertex_estimate];
                            System.arraycopy(tt, 0, VX[0], 0, tt.length);
                            tt = VY[0];
                            VY[0] = new float[nvertex_estimate];
                            System.arraycopy(tt, 0, VY[0], 0, tt.length);
                            tt = VZ[0];
                            VZ[0] = new float[nvertex_estimate];
                            System.arraycopy(tt, 0, VZ[0], 0, tt.length);
                            int big_ix = 9 * (nvertex_estimate + 50);
                            int[] it = Pol_f_Vert[0];
                            Pol_f_Vert[0] = new int[big_ix];
                            for (jj = 0; jj < Pol_f_Vert[0].length; ++jj) {
                                Pol_f_Vert[0][jj] = -2000000000;
                            }
                            for (jj = 8; jj < Pol_f_Vert[0].length; jj += 9) {
                                Pol_f_Vert[0][jj] = 0;
                            }
                            System.arraycopy(it, 0, Pol_f_Vert[0], 0, it.length);
                        }
                        vnode0 = ptGRID[pt];
                        vnode1 = ptGRID[pt + ydim];
                        vnode2 = ptGRID[pt + 1];
                        vnode3 = ptGRID[pt + ydim + 1];
                        vnode4 = ptGRID[pt + xdim_x_ydim];
                        vnode5 = ptGRID[pt + ydim + xdim_x_ydim];
                        vnode6 = ptGRID[pt + 1 + xdim_x_ydim];
                        vnode7 = ptGRID[pt + 1 + ydim + xdim_x_ydim];
                        if (ptFLAG[ncube] < 317) {
                            int ve;
                            int kk = pol_edges[ptFLAG[ncube]][2];
                            int aa = ptFLAG[ncube];
                            int bb = 4;
                            int pa = pvp;
                            int n_pol = pol_edges[ptFLAG[ncube]][1];
                            for (ii = 0; ii < n_pol; ++ii) {
                                Vert_f_Pol[pa + 6] = ve = kk & 0xF;
                                ve += pa;
                                for (jj = pa; jj < ve && jj < pa + 6; ++jj) {
                                    Vert_f_Pol[jj] = pol_edges[aa][bb];
                                    if (++bb < 16) continue;
                                    ++aa;
                                    bb -= 16;
                                }
                                kk >>= 4;
                                pa += 7;
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 2) != 0) {
                                if (iz != 0 || iy != 0) {
                                    calc_edge[1] = P_array[bellow * xx + ix * ydim + iy];
                                } else {
                                    cp = (isovalue - vnode0) / (vnode1 - vnode0);
                                    VX[0][nvet] = xo + xs * (cp + (float)ix);
                                    VY[0][nvet] = yo + ys * (float)iy;
                                    VZ[0][nvet] = zo + zs * (float)iz;
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + ydim] < 0 ? (float)auxValues[j][pt + ydim] + 256.0f : (float)auxValues[j][pt + ydim]) + (1.0f - cp) * (auxValues[j][pt] < 0 ? (float)auxValues[j][pt] + 256.0f : (float)auxValues[j][pt]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    calc_edge[1] = nvet++;
                                }
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 4) != 0) {
                                if (iz != 0 || ix != 0) {
                                    calc_edge[2] = P_array[2 * xx + bellow * yy + iy * xdim + ix];
                                } else {
                                    cp = (isovalue - vnode0) / (vnode2 - vnode0);
                                    VX[0][nvet] = xo + xs * (float)ix;
                                    VY[0][nvet] = yo + ys * (cp + (float)iy);
                                    VZ[0][nvet] = zo + zs * (float)iz;
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + 1] < 0 ? (float)auxValues[j][pt + 1] + 256.0f : (float)auxValues[j][pt + 1]) + (1.0f - cp) * (auxValues[j][pt] < 0 ? (float)auxValues[j][pt] + 256.0f : (float)auxValues[j][pt]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    calc_edge[2] = nvet++;
                                }
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 8) != 0) {
                                if (ix != 0 || iy != 0) {
                                    calc_edge[3] = P_array[2 * xx + 2 * yy + rear * zz + iy];
                                } else {
                                    cp = (isovalue - vnode0) / (vnode4 - vnode0);
                                    VX[0][nvet] = xo + xs * (float)ix;
                                    VY[0][nvet] = yo + ys * (float)iy;
                                    VZ[0][nvet] = zo + zs * (cp + (float)iz);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt] < 0 ? (float)auxValues[j][pt] + 256.0f : (float)auxValues[j][pt]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    calc_edge[3] = nvet++;
                                }
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 0x10) != 0) {
                                if (iz != 0) {
                                    calc_edge[4] = P_array[2 * xx + bellow * yy + iy * xdim + (ix + 1)];
                                } else {
                                    cp = (isovalue - vnode1) / (vnode3 - vnode1);
                                    VX[0][nvet] = xo + xs * (float)(ix + 1);
                                    VY[0][nvet] = yo + ys * (cp + (float)iy);
                                    VZ[0][nvet] = zo + zs * (float)iz;
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + ydim + 1] < 0 ? (float)auxValues[j][pt + ydim + 1] + 256.0f : (float)auxValues[j][pt + ydim + 1]) + (1.0f - cp) * (auxValues[j][pt + ydim] < 0 ? (float)auxValues[j][pt + ydim] + 256.0f : (float)auxValues[j][pt + ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    calc_edge[4] = nvet;
                                    P_array[2 * xx + bellow * yy + iy * xdim + (ix + 1)] = nvet++;
                                }
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 0x20) != 0) {
                                if (iy != 0) {
                                    calc_edge[5] = P_array[2 * xx + 2 * yy + front * zz + iy];
                                } else {
                                    cp = (isovalue - vnode1) / (vnode5 - vnode1);
                                    VX[0][nvet] = xo + xs * (float)(ix + 1);
                                    VY[0][nvet] = yo + ys * (float)iy;
                                    VZ[0][nvet] = zo + zs * (cp + (float)iz);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + ydim] < 0 ? (float)auxValues[j][pt + ydim] + 256.0f : (float)auxValues[j][pt + ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    calc_edge[5] = nvet;
                                    P_array[2 * xx + 2 * yy + front * zz + iy] = nvet++;
                                }
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 0x40) != 0) {
                                if (iz != 0) {
                                    calc_edge[6] = P_array[bellow * xx + ix * ydim + (iy + 1)];
                                } else {
                                    cp = (isovalue - vnode2) / (vnode3 - vnode2);
                                    VX[0][nvet] = xo + xs * (cp + (float)ix);
                                    VY[0][nvet] = yo + ys * (float)(iy + 1);
                                    VZ[0][nvet] = zo + zs * (float)iz;
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + ydim + 1] < 0 ? (float)auxValues[j][pt + ydim + 1] + 256.0f : (float)auxValues[j][pt + ydim + 1]) + (1.0f - cp) * (auxValues[j][pt + 1] < 0 ? (float)auxValues[j][pt + 1] + 256.0f : (float)auxValues[j][pt + 1]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    calc_edge[6] = nvet;
                                    P_array[bellow * xx + ix * ydim + (iy + 1)] = nvet++;
                                }
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 0x80) != 0) {
                                if (ix != 0) {
                                    calc_edge[7] = P_array[2 * xx + 2 * yy + rear * zz + (iy + 1)];
                                } else {
                                    cp = (isovalue - vnode2) / (vnode6 - vnode2);
                                    VX[0][nvet] = xo + xs * (float)ix;
                                    VY[0][nvet] = yo + ys * (float)(iy + 1);
                                    VZ[0][nvet] = zo + zs * (cp + (float)iz);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + 1 + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + 1] < 0 ? (float)auxValues[j][pt + 1] + 256.0f : (float)auxValues[j][pt + 1]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    calc_edge[7] = nvet;
                                    P_array[2 * xx + 2 * yy + rear * zz + (iy + 1)] = nvet++;
                                }
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 0x100) != 0) {
                                cp = (isovalue - vnode3) / (vnode7 - vnode3);
                                VX[0][nvet] = xo + xs * (float)(ix + 1);
                                VY[0][nvet] = yo + ys * (float)(iy + 1);
                                VZ[0][nvet] = zo + zs * (cp + (float)iz);
                                for (int j = 0; j < naux; ++j) {
                                    t = (int)(cp * (auxValues[j][pt + 1 + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + ydim + 1] < 0 ? (float)auxValues[j][pt + ydim + 1] + 256.0f : (float)auxValues[j][pt + ydim + 1]));
                                    tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                                calc_edge[8] = nvet;
                                P_array[2 * xx + 2 * yy + front * zz + (iy + 1)] = nvet++;
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 0x200) != 0) {
                                if (iy != 0) {
                                    calc_edge[9] = P_array[above * xx + ix * ydim + iy];
                                } else {
                                    cp = (isovalue - vnode4) / (vnode5 - vnode4);
                                    VX[0][nvet] = xo + xs * (cp + (float)ix);
                                    VY[0][nvet] = yo + ys * (float)iy;
                                    VZ[0][nvet] = zo + zs * (float)(iz + 1);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + xdim_x_ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    calc_edge[9] = nvet;
                                    P_array[above * xx + ix * ydim + iy] = nvet++;
                                }
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 0x400) != 0) {
                                if (ix != 0) {
                                    calc_edge[10] = P_array[2 * xx + above * yy + iy * xdim + ix];
                                } else {
                                    cp = (isovalue - vnode4) / (vnode6 - vnode4);
                                    VX[0][nvet] = xo + xs * (float)ix;
                                    VY[0][nvet] = yo + ys * (cp + (float)iy);
                                    VZ[0][nvet] = zo + zs * (float)(iz + 1);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + 1 + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + xdim_x_ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    calc_edge[10] = nvet;
                                    P_array[2 * xx + above * yy + iy * xdim + ix] = nvet++;
                                }
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 0x800) != 0) {
                                cp = (isovalue - vnode5) / (vnode7 - vnode5);
                                VX[0][nvet] = xo + xs * (float)(ix + 1);
                                VY[0][nvet] = yo + ys * (cp + (float)iy);
                                VZ[0][nvet] = zo + zs * (float)(iz + 1);
                                for (int j = 0; j < naux; ++j) {
                                    t = (int)(cp * (auxValues[j][pt + 1 + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + ydim + xdim_x_ydim]));
                                    tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                                calc_edge[11] = nvet;
                                P_array[2 * xx + above * yy + iy * xdim + (ix + 1)] = nvet++;
                            }
                            if ((pol_edges[ptFLAG[ncube]][3] & 0x1000) != 0) {
                                cp = (isovalue - vnode6) / (vnode7 - vnode6);
                                VX[0][nvet] = xo + xs * (cp + (float)ix);
                                VY[0][nvet] = yo + ys * (float)(iy + 1);
                                VZ[0][nvet] = zo + zs * (float)(iz + 1);
                                for (int j = 0; j < naux; ++j) {
                                    t = (int)(cp * (auxValues[j][pt + 1 + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + 1 + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + xdim_x_ydim]));
                                    tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                }
                                calc_edge[12] = nvet;
                                P_array[above * xx + ix * ydim + (iy + 1)] = nvet++;
                            }
                            kk = pol_edges[ptFLAG[ncube]][2];
                            int nn = pol_edges[ptFLAG[ncube]][1];
                            for (ii = 0; ii < nn; ++ii) {
                                int mm = pvp + (kk & 0xF);
                                for (jj = pvp; jj < mm; ++jj) {
                                    Vert_f_Pol[jj] = ve = calc_edge[Vert_f_Pol[jj]];
                                    int temp = Pol_f_Vert[0][ve * 9 + 8];
                                    Pol_f_Vert[0][ve * 9 + temp] = cpl;
                                    Pol_f_Vert[0][ve * 9 + 8] = temp + 1;
                                }
                                kk >>= 4;
                                pvp += 7;
                                ++cpl;
                            }
                        } else {
                            int n2 = ncube;
                            ptFLAG[n2] = ptFLAG[n2] & 0x1FF;
                            if (ptFLAG[ncube] != 0 & ptFLAG[ncube] != 255) {
                                if ((pol_edges[ptFLAG[ncube]][3] & 0x10) != 0 && iz == 0 && vnode3 == vnode3 && vnode1 == vnode1) {
                                    cp = (isovalue - vnode1) / (vnode3 - vnode1);
                                    VX[0][nvet] = xo + xs * (float)(ix + 1);
                                    VY[0][nvet] = yo + ys * (cp + (float)iy);
                                    VZ[0][nvet] = zo + zs * (float)iz;
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + ydim + 1] < 0 ? (float)auxValues[j][pt + ydim + 1] + 256.0f : (float)auxValues[j][pt + ydim + 1]) + (1.0f - cp) * (auxValues[j][pt + ydim] < 0 ? (float)auxValues[j][pt + ydim] + 256.0f : (float)auxValues[j][pt + ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    P_array[2 * xx + bellow * yy + iy * xdim + (ix + 1)] = nvet++;
                                }
                                if ((pol_edges[ptFLAG[ncube]][3] & 0x20) != 0 && iy == 0 && vnode5 == vnode5 && vnode1 == vnode1) {
                                    cp = (isovalue - vnode1) / (vnode5 - vnode1);
                                    VX[0][nvet] = xo + xs * (float)(ix + 1);
                                    VY[0][nvet] = yo + ys * (float)iy;
                                    VZ[0][nvet] = zo + zs * (cp + (float)iz);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + ydim] < 0 ? (float)auxValues[j][pt + ydim] + 256.0f : (float)auxValues[j][pt + ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    P_array[2 * xx + 2 * yy + front * zz + iy] = nvet++;
                                }
                                if ((pol_edges[ptFLAG[ncube]][3] & 0x40) != 0 && iz == 0 && vnode3 == vnode3 && vnode2 == vnode2) {
                                    cp = (isovalue - vnode2) / (vnode3 - vnode2);
                                    VX[0][nvet] = xo + xs * (cp + (float)ix);
                                    VY[0][nvet] = yo + ys * (float)(iy + 1);
                                    VZ[0][nvet] = zo + zs * (float)iz;
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + ydim + 1] < 0 ? (float)auxValues[j][pt + ydim + 1] + 256.0f : (float)auxValues[j][pt + ydim + 1]) + (1.0f - cp) * (auxValues[j][pt + 1] < 0 ? (float)auxValues[j][pt + 1] + 256.0f : (float)auxValues[j][pt + 1]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    P_array[bellow * xx + ix * ydim + (iy + 1)] = nvet++;
                                }
                                if ((pol_edges[ptFLAG[ncube]][3] & 0x80) != 0 && ix == 0 && vnode6 == vnode6 && vnode2 == vnode2) {
                                    cp = (isovalue - vnode2) / (vnode6 - vnode2);
                                    VX[0][nvet] = xo + xs * (float)ix;
                                    VY[0][nvet] = yo + ys * (float)(iy + 1);
                                    VZ[0][nvet] = zo + zs * (cp + (float)iz);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + 1 + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + 1] < 0 ? (float)auxValues[j][pt + 1] + 256.0f : (float)auxValues[j][pt + 1]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    P_array[2 * xx + 2 * yy + rear * zz + (iy + 1)] = nvet++;
                                }
                                if ((pol_edges[ptFLAG[ncube]][3] & 0x100) != 0 && vnode7 == vnode7 && vnode3 == vnode3) {
                                    cp = (isovalue - vnode3) / (vnode7 - vnode3);
                                    VX[0][nvet] = xo + xs * (float)(ix + 1);
                                    VY[0][nvet] = yo + ys * (float)(iy + 1);
                                    VZ[0][nvet] = zo + zs * (cp + (float)iz);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + 1 + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + ydim + 1] < 0 ? (float)auxValues[j][pt + ydim + 1] + 256.0f : (float)auxValues[j][pt + ydim + 1]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    P_array[2 * xx + 2 * yy + front * zz + (iy + 1)] = nvet++;
                                }
                                if ((pol_edges[ptFLAG[ncube]][3] & 0x200) != 0 && iy == 0 && vnode5 == vnode5 && vnode4 == vnode4) {
                                    cp = (isovalue - vnode4) / (vnode5 - vnode4);
                                    VX[0][nvet] = xo + xs * (cp + (float)ix);
                                    VY[0][nvet] = yo + ys * (float)iy;
                                    VZ[0][nvet] = zo + zs * (float)(iz + 1);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + xdim_x_ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    P_array[above * xx + ix * ydim + iy] = nvet++;
                                }
                                if ((pol_edges[ptFLAG[ncube]][3] & 0x400) != 0 && ix == 0 && vnode6 == vnode6 && vnode4 == vnode4) {
                                    cp = (isovalue - vnode4) / (vnode6 - vnode4);
                                    VX[0][nvet] = xo + xs * (float)ix;
                                    VY[0][nvet] = yo + ys * (cp + (float)iy);
                                    VZ[0][nvet] = zo + zs * (float)(iz + 1);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + 1 + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + xdim_x_ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    P_array[2 * xx + above * yy + iy * xdim + ix] = nvet++;
                                }
                                if ((pol_edges[ptFLAG[ncube]][3] & 0x800) != 0 && vnode7 == vnode7 && vnode5 == vnode5) {
                                    cp = (isovalue - vnode5) / (vnode7 - vnode5);
                                    VX[0][nvet] = xo + xs * (float)(ix + 1);
                                    VY[0][nvet] = yo + ys * (cp + (float)iy);
                                    VZ[0][nvet] = zo + zs * (float)(iz + 1);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + 1 + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + ydim + xdim_x_ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    P_array[2 * xx + above * yy + iy * xdim + (ix + 1)] = nvet++;
                                }
                                if ((pol_edges[ptFLAG[ncube]][3] & 0x1000) != 0 && vnode7 == vnode7 && vnode6 == vnode6) {
                                    cp = (isovalue - vnode6) / (vnode7 - vnode6);
                                    VX[0][nvet] = xo + xs * (cp + (float)ix);
                                    VY[0][nvet] = yo + ys * (float)(iy + 1);
                                    VZ[0][nvet] = zo + zs * (float)(iz + 1);
                                    for (int j = 0; j < naux; ++j) {
                                        t = (int)(cp * (auxValues[j][pt + 1 + ydim + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + ydim + xdim_x_ydim]) + (1.0f - cp) * (auxValues[j][pt + 1 + xdim_x_ydim] < 0 ? (float)auxValues[j][pt + 1 + xdim_x_ydim] + 256.0f : (float)auxValues[j][pt + 1 + xdim_x_ydim]));
                                        tempaux[j][nvet] = (byte)(t < 0 ? 0 : (t > 255 ? -1 : (t < 128 ? t : t - 256)));
                                    }
                                    P_array[above * xx + ix * ydim + (iy + 1)] = nvet++;
                                }
                            }
                        }
                    }
                    ++ncube;
                    ++pt;
                }
                caseA = rear;
                rear = front;
                front = caseA;
                ++pt;
            }
            caseA = bellow;
            bellow = above;
            above = caseA;
            pt += ydim;
        }
        for (int i = 0; i < naux; ++i) {
            auxLevels[i] = new byte[nvet];
            System.arraycopy(tempaux[i], 0, auxLevels[i], 0, nvet);
        }
        return nvet;
    }

    public boolean equals(Object set) {
        if (!(set instanceof Linear3DSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        return this.X.equals(((Linear3DSet)set).getX()) && this.Y.equals(((Linear3DSet)set).getY()) && this.Z.equals(((Linear3DSet)set).getZ());
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.X.hashCode() ^ this.Y.hashCode() ^ this.Z.hashCode();
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Linear1DSet getLinear1DComponent(int i) {
        if (i == 0) {
            return this.getX();
        }
        if (i == 1) {
            return this.getY();
        }
        if (i == 2) {
            return this.getZ();
        }
        throw new ArrayIndexOutOfBoundsException("Invalid component index");
    }

    public Object cloneButType(MathType type) throws VisADException {
        Linear1DSet[] sets = new Linear1DSet[]{(Linear1DSet)this.X.clone(), (Linear1DSet)this.Y.clone(), (Linear1DSet)this.Z.clone()};
        return new Linear3DSet(type, sets, this.DomainCoordinateSystem, this.SetUnits, this.SetErrors, this.cacheSamples);
    }

    public String longString(String pre) throws VisADException {
        String s = pre + "Linear3DSet: Length = " + this.Length + "\n";
        s = s + pre + "  Dimension 1: Length = " + this.X.getLength() + " Range = " + this.X.getFirst() + " to " + this.X.getLast() + "\n";
        s = s + pre + "  Dimension 2: Length = " + this.Y.getLength() + " Range = " + this.Y.getFirst() + " to " + this.Y.getLast() + "\n";
        s = s + pre + "  Dimension 3: Length = " + this.Z.getLength() + " Range = " + this.Z.getFirst() + " to " + this.Z.getLast() + "\n";
        return s;
    }
}

