/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import ucar.nc2.iosp.gempak.GempakFileReader;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakParameters;
import ucar.nc2.iosp.gempak.GempakStation;
import ucar.nc2.iosp.gempak.GempakUtil;
import visad.util.Trace;

public abstract class AbstractGempakStationFileReader
extends GempakFileReader {
    public static final String DATE = "DATE";
    public static final String TIME = "TIME";
    private static final String DATE_FORMAT = "yyMMdd'/'HHmm";
    private List<GempakFileReader.Key> dateTimeKeys;
    private List<GempakFileReader.Key> stationKeys;
    private List<String> dateList;
    private List<Date> dates;
    private List<GempakStation> stations;
    private List<GempakParameter> params;
    private Map<String, List<GempakParameter>> partParamMap = new HashMap<String, List<GempakParameter>>();
    private SimpleDateFormat dateFmt = new SimpleDateFormat("yyMMdd'/'HHmm");
    protected String subType = "";

    AbstractGempakStationFileReader() {
    }

    @Override
    protected boolean init() throws IOException {
        return this.init(true);
    }

    @Override
    protected boolean init(boolean fullCheck) throws IOException {
        if (!super.init(fullCheck)) {
            return false;
        }
        if (this.dmLabel.kftype != 2 && this.dmLabel.kftype != 1) {
            this.logError("not a point data file ");
            return false;
        }
        return true;
    }

    protected boolean readStationsAndTimes(boolean uniqueTimes) {
        Trace.call1("GEMPAK: making params");
        for (GempakFileReader.DMPart apart : this.parts) {
            List<GempakParameter> params = this.makeParams(apart);
            this.partParamMap.put(apart.kprtnm, params);
        }
        Trace.call2("GEMPAK: making params");
        this.dateTimeKeys = this.getDateTimeKeys();
        if (this.dateTimeKeys == null || this.dateTimeKeys.isEmpty()) {
            return false;
        }
        this.stationKeys = this.findStationKeys();
        if (this.stationKeys == null || this.stationKeys.isEmpty()) {
            return false;
        }
        Trace.call1("GEMPAK: get station list");
        this.stations = this.getStationList();
        Trace.call2("GEMPAK: get station list");
        this.makeFileSubType();
        Trace.call1("GEMPAK: get date list");
        this.dates = null;
        this.dateList = this.makeDateList(uniqueTimes);
        Trace.call2("GEMPAK: get date list");
        return true;
    }

    private List<GempakFileReader.Key> getDateTimeKeys() {
        GempakFileReader.Key date = this.findKey(DATE);
        GempakFileReader.Key time = this.findKey(TIME);
        if (date == null || time == null || !date.type.equals(time.type)) {
            return null;
        }
        ArrayList<GempakFileReader.Key> dt = new ArrayList<GempakFileReader.Key>(2);
        dt.add(date);
        dt.add(time);
        return dt;
    }

    protected List<String> makeDateList(boolean unique) {
        GempakFileReader.Key date = this.dateTimeKeys.get(0);
        GempakFileReader.Key time = this.dateTimeKeys.get(1);
        List<int[]> toCheck = date.type.equals("ROW") ? this.headers.rowHeaders : this.headers.colHeaders;
        ArrayList<String> fileDates = new ArrayList<String>();
        for (int[] header : toCheck) {
            if (header[0] == -9999) continue;
            int idate = header[date.loc + 1];
            int itime = header[time.loc + 1];
            String dateTime = GempakUtil.TI_CDTM(idate, itime);
            fileDates.add(dateTime);
        }
        if (unique && !fileDates.isEmpty()) {
            SortedSet<String> uniqueTimes = Collections.synchronizedSortedSet(new TreeSet());
            uniqueTimes.addAll(fileDates);
            fileDates.clear();
            fileDates.addAll(uniqueTimes);
        }
        return fileDates;
    }

    private List<GempakParameter> makeParams(GempakFileReader.DMPart part) {
        ArrayList<GempakParameter> gemparms = new ArrayList<GempakParameter>(part.kparms);
        for (GempakFileReader.DMParam param : part.params) {
            String name = param.kprmnm;
            GempakParameter parm = GempakParameters.getParameter(name);
            if (parm == null) {
                parm = new GempakParameter(1, name, name, "", 0);
            }
            gemparms.add(parm);
        }
        return gemparms;
    }

    public List<GempakParameter> getParameters(String partName) {
        return this.partParamMap.get(partName);
    }

    private List<GempakStation> getStationList() {
        GempakFileReader.Key slat = this.findKey("SLAT");
        if (slat == null) {
            return null;
        }
        List<int[]> toCheck = slat.type.equals("ROW") ? this.headers.rowHeaders : this.headers.colHeaders;
        ArrayList<GempakStation> fileStations = new ArrayList<GempakStation>();
        int i = 0;
        for (int[] header : toCheck) {
            GempakStation station;
            if (header[0] != -9999 && (station = this.makeStation(header)) != null) {
                station.setIndex(i + 1);
                fileStations.add(station);
            }
            ++i;
        }
        return fileStations;
    }

    private GempakStation makeStation(int[] header) {
        if (this.stationKeys == null || this.stationKeys.isEmpty()) {
            return null;
        }
        GempakStation newStation = new GempakStation();
        for (GempakFileReader.Key key : this.stationKeys) {
            int loc = key.loc + 1;
            if (key.name.equals("STID")) {
                newStation.setSTID(GempakUtil.ST_ITOC(header[loc]).trim());
                continue;
            }
            if (key.name.equals("STNM")) {
                newStation.setSTNM(header[loc]);
                continue;
            }
            if (key.name.equals("SLAT")) {
                newStation.setSLAT(header[loc]);
                continue;
            }
            if (key.name.equals("SLON")) {
                newStation.setSLON(header[loc]);
                continue;
            }
            if (key.name.equals("SELV")) {
                newStation.setSELV(header[loc]);
                continue;
            }
            if (key.name.equals("SPRI")) {
                newStation.setSPRI(header[loc]);
                continue;
            }
            if (key.name.equals("STAT")) {
                newStation.setSTAT(GempakUtil.ST_ITOC(header[loc]).trim());
                continue;
            }
            if (key.name.equals("COUN")) {
                newStation.setCOUN(GempakUtil.ST_ITOC(header[loc]).trim());
                continue;
            }
            if (key.name.equals("SWFO")) {
                newStation.setSWFO(GempakUtil.ST_ITOC(header[loc]).trim());
                continue;
            }
            if (key.name.equals("WFO2")) {
                newStation.setWFO2(GempakUtil.ST_ITOC(header[loc]).trim());
                continue;
            }
            if (!key.name.equals("STD2")) continue;
            newStation.setSTD2(GempakUtil.ST_ITOC(header[loc]).trim());
        }
        return newStation;
    }

    public List<String> getStationKeyNames() {
        ArrayList<String> keys = new ArrayList<String>();
        if (this.stationKeys != null && !this.stationKeys.isEmpty()) {
            for (GempakFileReader.Key key : this.stationKeys) {
                keys.add(key.name);
            }
        }
        return keys;
    }

    private List<GempakFileReader.Key> findStationKeys() {
        GempakFileReader.Key stid = this.findKey("STID");
        GempakFileReader.Key stnm = this.findKey("STNM");
        GempakFileReader.Key slat = this.findKey("SLAT");
        GempakFileReader.Key slon = this.findKey("SLON");
        GempakFileReader.Key selv = this.findKey("SELV");
        GempakFileReader.Key stat = this.findKey("STAT");
        GempakFileReader.Key coun = this.findKey("COUN");
        GempakFileReader.Key std2 = this.findKey("STD2");
        GempakFileReader.Key spri = this.findKey("SPRI");
        GempakFileReader.Key swfo = this.findKey("SWFO");
        GempakFileReader.Key wfo2 = this.findKey("WFO2");
        if (slat == null || slon == null || !slat.type.equals(slon.type)) {
            return null;
        }
        String tslat = slat.type;
        ArrayList<GempakFileReader.Key> stKeys = new ArrayList<GempakFileReader.Key>();
        stKeys.add(slat);
        stKeys.add(slon);
        if (stid != null && !stid.type.equals(tslat)) {
            return null;
        }
        if (stnm != null && !stnm.type.equals(tslat)) {
            return null;
        }
        if (selv != null && !selv.type.equals(tslat)) {
            return null;
        }
        if (stat != null && !stat.type.equals(tslat)) {
            return null;
        }
        if (coun != null && !coun.type.equals(tslat)) {
            return null;
        }
        if (std2 != null && !std2.type.equals(tslat)) {
            return null;
        }
        if (spri != null && !spri.type.equals(tslat)) {
            return null;
        }
        if (swfo != null && !swfo.type.equals(tslat)) {
            return null;
        }
        if (wfo2 != null && !wfo2.type.equals(tslat)) {
            return null;
        }
        if (stid != null) {
            stKeys.add(stid);
        }
        if (stnm != null) {
            stKeys.add(stnm);
        }
        if (selv != null) {
            stKeys.add(selv);
        }
        if (stat != null) {
            stKeys.add(stat);
        }
        if (coun != null) {
            stKeys.add(coun);
        }
        if (std2 != null) {
            stKeys.add(std2);
        }
        if (spri != null) {
            stKeys.add(spri);
        }
        if (swfo != null) {
            stKeys.add(swfo);
        }
        if (wfo2 != null) {
            stKeys.add(wfo2);
        }
        return stKeys;
    }

    public List<GempakStation> getStations() {
        return this.stations;
    }

    public List<Date> getDates() {
        if ((this.dates == null || this.dates.isEmpty()) && !this.dateList.isEmpty()) {
            this.dates = new ArrayList<Date>(this.dateList.size());
            this.dateFmt.setTimeZone(TimeZone.getTimeZone("GMT"));
            for (String dateString : this.dateList) {
                Date d = this.dateFmt.parse(dateString, new ParsePosition(0));
                this.dates.add(d);
            }
        }
        return this.dates;
    }

    protected String getDateString(int index) {
        return this.dateList.get(index);
    }

    public void printDates() {
        StringBuilder builder = new StringBuilder();
        builder.append("\nDates:\n");
        for (String date : this.dateList) {
            builder.append("\t");
            builder.append(date);
            builder.append("\n");
        }
        System.out.println(builder.toString());
    }

    public void printStations(boolean list) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nStations:\n");
        if (list) {
            for (GempakStation station : this.getStations()) {
                builder.append(station);
                builder.append("\n");
            }
        } else {
            builder.append("\t");
            builder.append(this.getStations().size());
        }
        System.out.println(builder.toString());
    }

    public int findStationIndex(String id) {
        for (GempakStation station : this.getStations()) {
            if (!station.getSTID().equals(id)) continue;
            return station.getIndex();
        }
        return -1;
    }

    public String getFileType() {
        String type = "Unknown";
        switch (this.dmLabel.kftype) {
            case 2: {
                type = "Sounding";
                break;
            }
            case 1: {
                type = "Surface";
                break;
            }
        }
        if (!this.subType.equals("")) {
            type = type + " (" + this.subType + ")";
        }
        return type;
    }

    protected abstract void makeFileSubType();

    protected String getFileSubType() {
        return this.subType;
    }
}

