/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.DatasetConstructor;
import ucar.nc2.iosp.grid.GridHorizCoordSys;
import ucar.nc2.iosp.grid.GridRecord;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.Misc;

public class GridVertCoord
implements Comparable<GridVertCoord> {
    private static Logger logger = LoggerFactory.getLogger(GridVertCoord.class);
    protected GridRecord typicalRecord;
    protected String levelName;
    protected GridTableLookup lookup;
    protected int seq = 0;
    protected double[] coordValues = null;
    protected boolean usesBounds = false;
    protected boolean isVerticalCoordinate = false;
    protected double[] factors = null;
    private String positive = "up";
    protected String units;
    protected List<LevelCoord> levels = new ArrayList<LevelCoord>();

    protected GridVertCoord(String name) {
        this.levelName = name;
    }

    protected GridVertCoord(List<GridRecord> records, String levelName, GridTableLookup lookup, GridHorizCoordSys hcs) {
        this.typicalRecord = records.get(0);
        this.levelName = levelName;
        this.lookup = lookup;
        this.isVerticalCoordinate = lookup.isVerticalCoordinate(this.typicalRecord);
        this.positive = lookup.isPositiveUp(this.typicalRecord) ? "up" : "down";
        this.units = lookup.getLevelUnit(this.typicalRecord);
        this.usesBounds = lookup.isLayer(this.typicalRecord);
        for (GridRecord record : records) {
            if (this.coordIndex(record) >= 0) continue;
            this.levels.add(new LevelCoord(record.getLevel1(), record.getLevel2()));
        }
        Collections.sort(this.levels);
        if (this.positive.equals("down")) {
            Collections.reverse(this.levels);
        }
        if (GridServiceProvider.debugVert) {
            System.out.println("GribVertCoord: " + this.getVariableName() + "(" + this.typicalRecord.getLevelType1() + ") isVertDimensionUsed= " + this.isVertDimensionUsed() + " positive=" + this.positive + " units=" + this.units);
        }
    }

    void setSequence(int seq) {
        this.seq = seq;
    }

    String getLevelName() {
        return this.levelName;
    }

    public String getVariableName() {
        return this.seq == 0 ? this.levelName : this.levelName + this.seq;
    }

    int getNLevels() {
        return this.levels.size();
    }

    boolean isVertDimensionUsed() {
        return this.getNLevels() == 1 ? this.isVerticalCoordinate : true;
    }

    boolean matchLevels(List<GridRecord> records) {
        ArrayList<LevelCoord> levelList = new ArrayList<LevelCoord>(records.size());
        for (GridRecord record : records) {
            LevelCoord lc = new LevelCoord(record.getLevel1(), record.getLevel2());
            if (levelList.contains(lc)) continue;
            levelList.add(lc);
        }
        Collections.sort(levelList);
        if (this.positive.equals("down")) {
            Collections.reverse(levelList);
        }
        return levelList.equals(this.levels);
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile, Group g) {
        if (!this.isVertDimensionUsed()) {
            return;
        }
        int nlevs = this.levels.size();
        if (this.coordValues != null) {
            nlevs = this.coordValues.length;
        }
        ncfile.addDimension(g, new Dimension(this.getVariableName(), nlevs, true));
    }

    protected String getLevelDesc() {
        return this.lookup.getLevelDescription(this.typicalRecord);
    }

    protected void addExtraAttributes(Variable v) {
        v.addAttribute(new Attribute("level_type", Integer.toString(this.typicalRecord.getLevelType1())));
    }

    void addToNetcdfFile(NetcdfFile ncfile, Group g) {
        if (!this.isVertDimensionUsed()) {
            this.typicalRecord = null;
            return;
        }
        if (g == null) {
            g = ncfile.getRootGroup();
        }
        Variable v = new Variable(ncfile, g, null, this.getVariableName());
        v.setDataType(DataType.DOUBLE);
        String desc = this.getLevelDesc();
        v.addAttribute(new Attribute("long_name", desc));
        v.addAttribute(new Attribute("units", this.lookup.getLevelUnit(this.typicalRecord)));
        if (this.positive != null) {
            v.addAttribute(new Attribute("positive", this.positive));
        }
        if (this.units != null) {
            AxisType axisType = SimpleUnit.isCompatible((String)"millibar", (String)this.units) ? AxisType.Pressure : (SimpleUnit.isCompatible((String)"m", (String)this.units) ? AxisType.Height : AxisType.GeoZ);
            this.addExtraAttributes(v);
            v.addAttribute(new Attribute("_CoordinateAxisType", axisType.toString()));
        }
        if (this.coordValues == null) {
            this.coordValues = new double[this.levels.size()];
            for (int i = 0; i < this.levels.size(); ++i) {
                LevelCoord lc = this.levels.get(i);
                this.coordValues[i] = lc.mid;
            }
        }
        Array dataArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{this.coordValues.length}, (Object)this.coordValues);
        v.setDimensions(this.getVariableName());
        v.setCachedData(dataArray, true);
        ncfile.addVariable(g, v);
        if (this.usesBounds) {
            Dimension bd = DatasetConstructor.getBoundsDimension((NetcdfFile)ncfile);
            String bname = this.getVariableName() + "_bounds";
            v.addAttribute(new Attribute("bounds", bname));
            v.addAttribute(new Attribute("_CoordinateZisLayer", "true"));
            Variable b = new Variable(ncfile, g, null, bname);
            b.setDataType(DataType.DOUBLE);
            b.setDimensions(this.getVariableName() + " " + bd.getShortName());
            b.addAttribute(new Attribute("long_name", "bounds for " + v.getFullName()));
            b.addAttribute(new Attribute("units", this.lookup.getLevelUnit(this.typicalRecord)));
            Array boundsArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{this.coordValues.length, 2});
            Index ima = boundsArray.getIndex();
            for (int i = 0; i < this.coordValues.length; ++i) {
                LevelCoord lc = this.levels.get(i);
                boundsArray.setDouble(ima.set(i, 0), lc.value1);
                boundsArray.setDouble(ima.set(i, 1), lc.value2);
            }
            b.setCachedData(boundsArray, true);
            ncfile.addVariable(g, b);
        }
        if (this.factors != null) {
            double[] bdata;
            double[] adata;
            if (g == null) {
                g = ncfile.getRootGroup();
            }
            if (g.findVariable("hybrida") != null) {
                return;
            }
            v.addAttribute(new Attribute("standard_name", "atmosphere_hybrid_sigma_pressure_coordinate"));
            v.addAttribute(new Attribute("formula_terms", "ap: hybrida b: hybridb ps: Pressure"));
            Variable ha = new Variable(ncfile, g, null, "hybrida");
            ha.setDataType(DataType.DOUBLE);
            ha.addAttribute(new Attribute("long_name", "level_a_factor"));
            ha.addAttribute(new Attribute("units", ""));
            ha.setDimensions(this.getVariableName());
            int middle = this.factors.length / 2;
            if (this.levels.size() < middle) {
                adata = new double[this.levels.size()];
                bdata = new double[this.levels.size()];
            } else {
                adata = new double[middle];
                bdata = new double[middle];
            }
            for (int i = 0; i < middle && i < this.levels.size(); ++i) {
                adata[i] = this.factors[i];
            }
            Array haArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{adata.length}, (Object)adata);
            ha.setCachedData(haArray, true);
            ncfile.addVariable(g, ha);
            Variable hb = new Variable(ncfile, g, null, "hybridb");
            hb.setDataType(DataType.DOUBLE);
            hb.addAttribute(new Attribute("long_name", "level_b_factor"));
            hb.addAttribute(new Attribute("units", ""));
            hb.setDimensions(this.getVariableName());
            for (int i = 0; i < middle && i < this.levels.size(); ++i) {
                bdata[i] = this.factors[i + middle];
            }
            Array hbArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{bdata.length}, (Object)bdata);
            hb.setCachedData(hbArray, true);
            ncfile.addVariable(g, hb);
        }
    }

    int getIndex(GridRecord record) {
        if (!this.isVertDimensionUsed()) {
            return 0;
        }
        return this.coordIndex(record);
    }

    @Override
    public int compareTo(GridVertCoord gv) {
        return this.getLevelName().compareToIgnoreCase(gv.getLevelName());
    }

    public double getCoord(int i) {
        return this.coordValues == null ? 0.0 : this.coordValues[i];
    }

    private int coordIndex(GridRecord record) {
        double val = record.getLevel1();
        double val2 = record.getLevel2();
        if (this.usesBounds && val > val2) {
            val = record.getLevel2();
            val2 = record.getLevel1();
        }
        for (int i = 0; i < this.levels.size(); ++i) {
            LevelCoord lc = this.levels.get(i);
            if (!(this.usesBounds ? Misc.closeEnough((double)lc.value1, (double)val) && Misc.closeEnough((double)lc.value2, (double)val2) : Misc.closeEnough((double)lc.value1, (double)val))) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return "GridVertCoord{levelName='" + this.levelName + '\'' + ", seq=" + this.seq + '}';
    }

    protected class LevelCoord
    implements Comparable {
        public double mid;
        public double value1;
        public double value2;

        LevelCoord(double value1, double value2) {
            this.value1 = value1;
            this.value2 = value2;
            if (GridVertCoord.this.usesBounds && value1 > value2) {
                this.value1 = value2;
                this.value2 = value1;
            }
            this.mid = GridVertCoord.this.usesBounds ? (value1 + value2) / 2.0 : value1;
        }

        public int compareTo(Object o) {
            LevelCoord other = (LevelCoord)o;
            if (this.mid < other.mid) {
                return -1;
            }
            if (this.mid > other.mid) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof LevelCoord)) {
                return false;
            }
            LevelCoord other = (LevelCoord)oo;
            return Misc.closeEnough((double)this.value1, (double)other.value1) && Misc.closeEnough((double)this.value2, (double)other.value2);
        }

        public int hashCode() {
            return (int)(this.value1 * 100000.0 + this.value2 * 100.0);
        }
    }
}

