/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.Delaunay;
import visad.Gridded2DSet;
import visad.Irregular2DSet;
import visad.SampledSet;
import visad.SetException;
import visad.UnionSet;
import visad.VisADException;

public class DelaunayCustom
extends Delaunay {
    private static final float SELF = 0.9999f;
    private static final float PULL = 1.00016594E-4f;
    private static final float PULL2 = 5.0008297E-5f;

    public DelaunayCustom(float[][] samples, int[][] tri) throws VisADException {
        this(samples, tri, null, null, null, 0, true);
    }

    public DelaunayCustom(float[][] samples, int[][] tri, int[][] vertices, int[][] walk, int[][] edges, int num_edges) throws VisADException {
        this(samples, tri, vertices, walk, edges, num_edges, true);
    }

    public DelaunayCustom(float[][] samples, int[][] tri, int[][] vertices, int[][] walk, int[][] edges, int num_edges, boolean copy) throws VisADException {
        if (tri == null) {
            throw new VisADException("DelaunayCustom: Tri array must be specified!");
        }
        if (samples == null && vertices == null) {
            throw new VisADException("DelaunayCustom: Cannot construct Vertices without samples!");
        }
        if (samples == null && walk == null) {
            throw new VisADException("DelaunayCustom: Cannot construct Walk without samples!");
        }
        if (samples == null && edges == null) {
            throw new VisADException("DelaunayCustom: Cannot construct Edges without samples!");
        }
        if (copy) {
            int i;
            this.Tri = new int[tri.length][];
            for (i = 0; i < tri.length; ++i) {
                this.Tri[i] = new int[tri[i].length];
                System.arraycopy(tri[i], 0, this.Tri[i], 0, tri[i].length);
            }
            if (vertices != null) {
                this.Vertices = new int[vertices.length][];
                for (i = 0; i < vertices.length; ++i) {
                    this.Vertices[i] = new int[vertices[i].length];
                    System.arraycopy(vertices[i], 0, this.Vertices[i], 0, vertices[i].length);
                }
            }
            if (walk != null) {
                this.Walk = new int[walk.length][];
                for (i = 0; i < walk.length; ++i) {
                    this.Walk[i] = new int[walk[i].length];
                    System.arraycopy(walk[i], 0, this.Walk[i], 0, walk[i].length);
                }
            }
            if (edges != null) {
                this.Edges = new int[edges.length][];
                for (i = 0; i < edges.length; ++i) {
                    this.Edges[i] = new int[edges[i].length];
                    System.arraycopy(edges[i], 0, this.Edges[i], 0, edges[i].length);
                }
            }
        } else {
            this.Tri = tri;
            this.Vertices = vertices;
            this.Walk = walk;
            this.Edges = edges;
        }
        this.NumEdges = num_edges;
        if (samples != null) {
            super.finish_triang(samples);
        }
    }

    public static boolean checkSelfIntersection(Gridded2DSet set) throws VisADException {
        if (set == null) {
            return false;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("Gridded2DSet musy have manifold dimension = 1");
        }
        return DelaunayCustom.checkSelfIntersection(set.getSamples());
    }

    public static boolean checkSelfIntersection(float[][] samples) throws VisADException {
        int i;
        if (samples == null) {
            return false;
        }
        if (samples.length != 2 || samples[0].length != samples[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        int n = samples[0].length;
        int[] next = new int[n];
        for (i = 0; i < n - 1; ++i) {
            next[i] = i + 1;
        }
        next[n - 1] = 0;
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                float d0;
                float c0;
                float a1;
                float b1;
                float d1;
                float c1;
                float a0;
                float b0;
                float det;
                if (i == j || i == next[j] || next[i] == j || (double)Math.abs(det = ((b0 = samples[0][next[i]]) - (a0 = samples[0][i])) * ((c1 = samples[1][j]) - (d1 = samples[1][next[j]])) - ((b1 = samples[1][next[i]]) - (a1 = samples[1][i])) * ((c0 = samples[0][j]) - (d0 = samples[0][next[j]]))) < 1.0E-7) continue;
                float x = ((b0 - a0) * (c1 - a1) - (b1 - a1) * (c0 - a0)) / det;
                float y = ((c0 - a0) * (c1 - d1) - (c1 - a1) * (c0 - d0)) / det;
                if (!(0.0f < x) || !(x < 1.0f) || !(0.0f < y) || !(y < 1.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean checkAndFixSelfIntersection(float[][] samples) throws VisADException {
        int i;
        int i2;
        if (samples == null) {
            return false;
        }
        if (samples.length != 2 || samples[0].length != samples[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        int n = samples[0].length;
        boolean intersect = false;
        int[] next = new int[n];
        for (int i3 = 0; i3 < n - 1; ++i3) {
            next[i3] = i3 + 1;
        }
        next[n - 1] = 0;
        float[][] new_samples = new float[2][n];
        int k = 0;
        for (i2 = 0; i2 < n; ++i2) {
            if (samples[0][i2] == samples[0][next[i2]] && samples[1][i2] == samples[1][next[i2]]) continue;
            new_samples[0][k] = samples[0][i2];
            new_samples[1][k] = samples[1][i2];
            ++k;
        }
        if (k != n) {
            samples[0] = new float[k];
            samples[1] = new float[k];
            if (k == 0) {
                return false;
            }
            System.arraycopy(new_samples[0], 0, samples[0], 0, k);
            System.arraycopy(new_samples[1], 0, samples[1], 0, k);
            n = k;
            next = new int[n];
            for (i2 = 0; i2 < n - 1; ++i2) {
                next[i2] = i2 + 1;
            }
            next[n - 1] = 0;
        }
        int[] prev = new int[n];
        for (i = 1; i < n; ++i) {
            prev[i] = i - 1;
        }
        prev[0] = n - 1;
        for (i = 0; i < n; ++i) {
            if (samples[0][i] == samples[0][next[i]] && samples[1][i] == samples[1][next[i]]) {
                System.out.println("equal consecutive points");
            }
            for (int j = 0; j < n; ++j) {
                float d0;
                float c0;
                float a1;
                float b1;
                float d1;
                float c1;
                float a0;
                float b0;
                float det;
                if (i == j || i == next[j] || next[i] == j || (double)Math.abs(det = ((b0 = samples[0][next[i]]) - (a0 = samples[0][i])) * ((c1 = samples[1][j]) - (d1 = samples[1][next[j]])) - ((b1 = samples[1][next[i]]) - (a1 = samples[1][i])) * ((c0 = samples[0][j]) - (d0 = samples[0][next[j]]))) < 1.0E-7) continue;
                float x = ((b0 - a0) * (c1 - a1) - (b1 - a1) * (c0 - a0)) / det;
                float y = ((c0 - a0) * (c1 - d1) - (c1 - a1) * (c0 - d0)) / det;
                if (0.0f < x && x < 1.0f && 0.0f < y && y < 1.0f) {
                    intersect = true;
                    continue;
                }
                if (0.0f != x && x != 1.0f || 0.0f != y && y != 1.0f) continue;
                if (x == 0.0f) {
                    samples[0][i] = 0.9999f * a0 + 5.0008297E-5f * (b0 + samples[0][prev[i]]);
                    samples[1][i] = 0.9999f * a1 + 5.0008297E-5f * (b1 + samples[1][prev[i]]);
                } else if (x == 1.0f) {
                    k = next[i];
                    samples[0][k] = 0.9999f * b0 + 5.0008297E-5f * (a0 + samples[0][next[k]]);
                    samples[1][k] = 0.9999f * b1 + 5.0008297E-5f * (a1 + samples[1][next[k]]);
                }
                if (y == 0.0f) {
                    samples[0][j] = 0.9999f * c0 + 5.0008297E-5f * (d0 + samples[0][prev[j]]);
                    samples[1][j] = 0.9999f * c1 + 5.0008297E-5f * (d1 + samples[1][prev[j]]);
                    continue;
                }
                if (y != 1.0f) continue;
                k = next[j];
                samples[0][k] = 0.9999f * d0 + 5.0008297E-5f * (c0 + samples[0][next[k]]);
                samples[1][k] = 0.9999f * d1 + 5.0008297E-5f * (c1 + samples[1][next[k]]);
            }
        }
        return intersect;
    }

    public static float computeArea(UnionSet set) throws VisADException {
        if (set == null) {
            return 0.0f;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("UnionSet must have manifold dimension = 1");
        }
        SampledSet[] sets = set.getSets();
        if (sets == null) {
            return 0.0f;
        }
        int n = sets.length;
        if (n == 0) {
            return 0.0f;
        }
        float[][][] ss = new float[n][][];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if (!(sets[i] instanceof Gridded2DSet)) {
                throw new SetException("UnionSet must contain only Gridded2DSets");
            }
            ss[k] = sets[i].getSamples();
            if (ss[k] == null || ss[k].length != 2 || ss[k][0].length <= 2) continue;
            ++k;
        }
        if (k == 0) {
            return 0.0f;
        }
        float[][][] new_ss = new float[k][][];
        System.arraycopy(ss, 0, new_ss, 0, k);
        ss = new_ss;
        float[][] samples = DelaunayCustom.link(ss);
        if (samples == null) {
            return 0.0f;
        }
        return DelaunayCustom.computeArea(samples);
    }

    public static float computeArea(Gridded2DSet set) throws VisADException {
        if (set == null) {
            return 0.0f;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("Gridded2DSet musy have manifold dimension = 1");
        }
        return DelaunayCustom.computeArea(set.getSamples());
    }

    public static float computeArea(float[][] samples) throws VisADException {
        if (samples == null) {
            return 0.0f;
        }
        if (samples.length != 2 || samples[0].length != samples[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        if (samples[0].length < 3) {
            return 0.0f;
        }
        if (DelaunayCustom.checkSelfIntersection(samples)) {
            throw new VisADException("path self intersects");
        }
        int n = samples[0].length;
        int[] next = new int[n];
        for (int i = 0; i < n - 1; ++i) {
            next[i] = i + 1;
        }
        next[n - 1] = 0;
        float area = 0.0f;
        for (int i = 0; i < n; ++i) {
            area += samples[0][i] * samples[1][next[i]] - samples[0][next[i]] * samples[1][i];
        }
        return (float)Math.abs(0.5 * (double)area);
    }

    public static Irregular2DSet fill(Gridded2DSet set) throws VisADException {
        return DelaunayCustom.fillCheck(set, true);
    }

    public static Irregular2DSet fillCheck(Gridded2DSet set, boolean check) throws VisADException {
        if (set == null) {
            return null;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("Gridded2DSet musy have manifold dimension = 1");
        }
        float[][] samples = set.getSamples();
        int[][] tris = DelaunayCustom.fillCheck(samples, check);
        if (tris == null || tris[0].length == 0) {
            return null;
        }
        DelaunayCustom delaunay = new DelaunayCustom(samples, tris);
        if (delaunay == null) {
            return null;
        }
        return new Irregular2DSet(set.getType(), samples, null, null, null, delaunay);
    }

    public static int[][] fill(float[][] samples) throws VisADException {
        return DelaunayCustom.fillCheck(samples, true);
    }

    public static int[][] fillCheck(float[][] samples, boolean check) throws VisADException {
        if (samples == null) {
            return null;
        }
        if (samples.length != 2 || samples[0].length != samples[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        if (samples[0].length < 3) {
            return null;
        }
        if (DelaunayCustom.checkAndFixSelfIntersection(samples) && check) {
            throw new VisADException("path self intersects");
        }
        if (samples == null || samples[0].length < 3) {
            System.out.println("fillCheck return null");
            return null;
        }
        int n = samples[0].length;
        int[] next = new int[n];
        for (int i = 0; i < n - 1; ++i) {
            next[i] = i + 1;
        }
        next[n - 1] = 0;
        int[] prev = new int[n];
        for (int i = 1; i < n; ++i) {
            prev[i] = i - 1;
        }
        prev[0] = n - 1;
        float area = 0.0f;
        for (int i = 0; i < n; ++i) {
            area += samples[0][i] * samples[1][next[i]] - samples[0][next[i]] * samples[1][i];
        }
        boolean pos = (double)area > 0.0;
        int[][] tris = new int[n - 2][];
        int i = 0;
        int t = 0;
        int bad = 0;
        boolean bug = false;
        while (n - t > 2) {
            boolean in;
            int j = next[i];
            float a0 = samples[0][j] - samples[0][i];
            int k = next[j];
            float b1 = samples[1][k] - samples[1][j];
            float b0 = samples[0][k] - samples[0][j];
            float a1 = samples[1][j] - samples[1][i];
            boolean bl = in = (double)(a0 * b1 - b0 * a1) > 0.0 == pos;
            if (in && i != next[k]) {
                float ip1;
                int ip;
                float ip0;
                float ik1 = samples[1][i] - samples[1][k];
                float ik0 = samples[0][i] - samples[0][k];
                float ik = samples[1][k] * ik0 - samples[0][k] * ik1;
                float ji1 = samples[1][j] - samples[1][i];
                float ji0 = samples[0][j] - samples[0][i];
                float ji = samples[1][i] * ji0 - samples[0][i] * ji1;
                float kj1 = samples[1][k] - samples[1][j];
                float kj0 = samples[0][k] - samples[0][j];
                float kj = samples[1][j] * kj0 - samples[0][j] * kj1;
                int kn = next[k];
                float kn0 = samples[0][kn];
                float kn1 = samples[1][kn];
                if ((double)(ik + kn0 * ik1 - kn1 * ik0) > 0.0 != pos && (double)(kj + kn0 * kj1 - kn1 * kj0) > 0.0 != pos) {
                    in = false;
                }
                if ((double)(ik + (ip0 = samples[0][ip = prev[i]]) * ik1 - (ip1 = samples[1][ip]) * ik0) > 0.0 != pos && (double)(ji + ip0 * ji1 - ip1 * ji0) > 0.0 != pos) {
                    in = false;
                }
                if (in) {
                    int p = next[k];
                    int q = next[p];
                    a0 = samples[0][i];
                    a1 = samples[1][i];
                    b0 = samples[0][k];
                    b1 = samples[1][k];
                    while (q != i) {
                        float c0 = samples[0][p];
                        float c1 = samples[1][p];
                        float d0 = samples[0][q];
                        float d1 = samples[1][q];
                        float det = (b0 - a0) * (c1 - d1) - (b1 - a1) * (c0 - d0);
                        p = q;
                        q = next[p];
                        if ((double)Math.abs(det) == 0.0) continue;
                        float x = ((b0 - a0) * (c1 - a1) - (b1 - a1) * (c0 - a0)) / det;
                        float y = ((c0 - a0) * (c1 - d1) - (c1 - a1) * (c0 - d0)) / det;
                        if (!(0.0f <= x) || !(x <= 1.0f) || !(0.0f <= y) || !(y <= 1.0f)) continue;
                        in = false;
                        break;
                    }
                }
            }
            if (in) {
                tris[t++] = new int[]{i, j, k};
                next[i] = k;
                prev[k] = i;
                bad = 0;
                continue;
            }
            i = j;
            if (bad++ <= n - t) continue;
            if (bug) {
                if (t > 0) {
                    int[][] new_tris = new int[t][];
                    System.arraycopy(tris, 0, new_tris, 0, t);
                    return new_tris;
                }
                return null;
            }
            bug = true;
            bad = 0;
            pos = !pos;
        }
        return tris;
    }

    public static Irregular2DSet fill(UnionSet set) throws VisADException {
        return DelaunayCustom.fillCheck(set, true);
    }

    public static Irregular2DSet fillCheck(UnionSet set, boolean check) throws VisADException {
        if (set == null) {
            return null;
        }
        if (set.getManifoldDimension() != 1) {
            throw new SetException("UnionSet must have manifold dimension = 1");
        }
        SampledSet[] sets = set.getSets();
        if (sets == null) {
            return null;
        }
        int n = sets.length;
        if (n == 0) {
            return null;
        }
        float[][][] ss = new float[n][][];
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if (!(sets[i] instanceof Gridded2DSet)) {
                throw new SetException("UnionSet must contain only Gridded2DSets");
            }
            ss[k] = sets[i].getSamples();
            if (ss[k] == null || ss[k].length != 2 || ss[k][0].length <= 2) continue;
            ++k;
        }
        if (k == 0) {
            return null;
        }
        float[][][] new_ss = new float[k][][];
        System.arraycopy(ss, 0, new_ss, 0, k);
        ss = new_ss;
        float[][] samples = DelaunayCustom.link(ss);
        int[][] tris = DelaunayCustom.fillCheck(samples, check);
        if (tris == null || tris[0].length == 0) {
            return null;
        }
        DelaunayCustom delaunay = new DelaunayCustom(samples, tris);
        if (delaunay == null) {
            return null;
        }
        return new Irregular2DSet(set.getType(), samples, null, null, null, delaunay);
    }

    public static float[][] link(float[][][] ss) throws VisADException {
        int ii;
        if (ss == null || ((float[][][])ss).length == 0) {
            return null;
        }
        int nn = ((float[][][])ss).length;
        for (int ii2 = 0; ii2 < nn; ++ii2) {
            if (ss[ii2].length != 2 || ss[ii2][0].length != ss[ii2][1].length) {
                throw new VisADException("samples argument bad dimensions");
            }
            if (!DelaunayCustom.checkAndFixSelfIntersection(ss[ii2])) continue;
            throw new VisADException("path self intersects");
        }
        float[][][] new_ss = new float[nn][][];
        int k = 0;
        for (int ii3 = 0; ii3 < nn; ++ii3) {
            if (ss[ii3][0].length <= 2) continue;
            new_ss[k] = ss[ii3];
            ++k;
        }
        if (k == 0) {
            return null;
        }
        if (k == 1) {
            return new_ss[0];
        }
        ss = new float[k][][];
        System.arraycopy(new_ss, 0, ss, 0, k);
        nn = k;
        boolean[][] in = new boolean[nn][nn];
        for (ii = 0; ii < nn; ++ii) {
            for (int jj = 0; jj < nn; ++jj) {
                in[ii][jj] = ii == jj ? false : DelaunayCustom.inside(ss[ii], ss[jj][0][0], ss[jj][1][0]);
            }
        }
        for (ii = 0; ii < nn; ++ii) {
            boolean any_outer = false;
            for (int jj = ii; jj < nn; ++jj) {
                boolean in_any = false;
                for (int kk = ii; kk < nn; ++kk) {
                    if (!in[kk][jj]) continue;
                    in_any = true;
                    break;
                }
                if (in_any) continue;
                any_outer = true;
                if (ii == jj) break;
                float[][] tss = ss[ii];
                ss[ii] = ss[jj];
                ss[jj] = tss;
                boolean[] tin = in[ii];
                in[ii] = in[jj];
                in[jj] = tin;
                for (int kk = 0; kk < nn; ++kk) {
                    boolean tb = in[kk][ii];
                    in[kk][ii] = in[kk][jj];
                    in[kk][jj] = tb;
                }
                break;
            }
            if (any_outer) continue;
        }
        boolean[] orient = new boolean[nn];
        for (int ii4 = 0; ii4 < nn; ++ii4) {
            float area = 0.0f;
            float[][] t = ss[ii4];
            int m = t[0].length;
            for (int i = 0; i < m - 1; ++i) {
                area += t[0][i] * t[1][i + 1] - t[0][i + 1] * t[1][i];
            }
            orient[ii4] = (double)(area += t[0][m - 1] * t[1][0] - t[0][0] * t[1][m - 1]) > 0.0;
        }
        float[][] s = ss[0];
        for (int ii5 = 1; ii5 < nn; ++ii5) {
            float[][] t = ss[ii5];
            if (t[0].length < 3) continue;
            int n = s[0].length;
            int m = t[0].length;
            float distance = Float.MAX_VALUE;
            int near_i = -1;
            int near_j = -1;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < m; ++j) {
                    float d = (s[0][i] - t[0][j]) * (s[0][i] - t[0][j]) + (s[1][i] - t[1][j]) * (s[1][i] - t[1][j]);
                    if (!(d < distance)) continue;
                    distance = d;
                    near_i = i;
                    near_j = j;
                }
            }
            if (near_i < 0) continue;
            boolean inn = in[0][ii5];
            boolean flip = orient[0] == orient[ii5] == inn;
            int new_n = n + m + 2;
            float[][] new_s = new float[2][new_n];
            k = 0;
            System.arraycopy(s[0], 0, new_s[0], k, near_i + 1);
            System.arraycopy(s[1], 0, new_s[1], k, near_i + 1);
            int b1 = (k += near_i + 1) - 1;
            int a1 = k;
            if (flip) {
                int j;
                for (j = near_j; j >= 0; --j) {
                    new_s[0][k] = t[0][j];
                    new_s[1][k] = t[1][j];
                    ++k;
                }
                for (j = m - 1; j >= near_j; --j) {
                    new_s[0][k] = t[0][j];
                    new_s[1][k] = t[1][j];
                    ++k;
                }
            } else {
                System.arraycopy(t[0], near_j, new_s[0], k, m - near_j);
                System.arraycopy(t[1], near_j, new_s[1], k, m - near_j);
                System.arraycopy(t[0], 0, new_s[0], k += m - near_j, near_j + 1);
                System.arraycopy(t[1], 0, new_s[1], k, near_j + 1);
                k += near_j + 1;
            }
            int b2 = k - 1;
            int a2 = k;
            System.arraycopy(s[0], near_i, new_s[0], k, n - near_i);
            System.arraycopy(s[1], near_i, new_s[1], k, n - near_i);
            s[0] = new_s[0];
            s[1] = new_s[1];
            int b1m = b1 > 0 ? b1 - 1 : new_n - 1;
            int a1p = a1 < new_n - 1 ? a1 + 1 : 0;
            int b2m = b2 > 0 ? b2 - 1 : new_n - 1;
            int a2p = a2 < new_n - 1 ? a2 + 1 : 0;
            new_s[0][b1] = 0.9999f * new_s[0][b1] + 1.00016594E-4f * new_s[0][b1m];
            new_s[1][b1] = 0.9999f * new_s[1][b1] + 1.00016594E-4f * new_s[1][b1m];
            new_s[0][a1] = 0.9999f * new_s[0][a1] + 1.00016594E-4f * new_s[0][a1p];
            new_s[1][a1] = 0.9999f * new_s[1][a1] + 1.00016594E-4f * new_s[1][a1p];
            new_s[0][b2] = 0.9999f * new_s[0][b2] + 1.00016594E-4f * new_s[0][b2m];
            new_s[1][b2] = 0.9999f * new_s[1][b2] + 1.00016594E-4f * new_s[1][b2m];
            new_s[0][a2] = 0.9999f * new_s[0][a2] + 1.00016594E-4f * new_s[0][a2p];
            new_s[1][a2] = 0.9999f * new_s[1][a2] + 1.00016594E-4f * new_s[1][a2p];
        }
        return s;
    }

    public static boolean inside(float[][] s, float x, float y) throws VisADException {
        if (s == null) {
            return false;
        }
        if (s.length != 2 || s[0].length != s[1].length) {
            throw new VisADException("samples argument bad dimensions");
        }
        int n = s[0].length;
        double angle = 0.0;
        for (int i = 0; i < n; ++i) {
            int ip = i < n - 1 ? i + 1 : 0;
            double a = Math.atan2(s[0][i] - x, s[1][i] - y) - Math.atan2(s[0][ip] - x, s[1][ip] - y);
            if (a < -Math.PI) {
                a += Math.PI;
            }
            if (a > Math.PI) {
                a -= Math.PI;
            }
            angle += a;
        }
        return Math.abs(angle) > 0.5;
    }

    public static void clip(float[][] samples, int[][] tris, float xc, float yc, float v, float[][][] outs, int[][][] outt) throws VisADException {
        float[][] s = null;
        Object t = null;
        if (samples == null || tris == null) {
            outs[0] = s;
            outt[0] = t;
            return;
        }
        int nsamples = samples[0].length;
        int ns = 0;
        s = new float[2][2 * nsamples];
        int ntris = tris.length;
        int nt = 0;
        t = new int[2 * ntris][];
        int[] smap = new int[nsamples];
        int[][] sother = new int[nsamples][6];
        int[][] snew = new int[nsamples][6];
        int[] minus1s = new int[]{-1, -1, -1, -1, -1, -1};
        for (int i = 0; i < nsamples; ++i) {
            System.arraycopy(minus1s, 0, sother[i], 0, 6);
            if (xc * samples[0][i] + yc * samples[1][i] <= v) {
                s[0][ns] = samples[0][i];
                s[1][ns] = samples[1][i];
                smap[i] = ns++;
                continue;
            }
            smap[i] = -1;
        }
        int nskept = ns;
        int[] incounts = new int[]{0, 1, 1, 2, 1, 2, 2, 3};
        int[] firsts = new int[]{-1, 0, 1, 0, 2, 0, 1, 0};
        int[] seconds = new int[]{-1, 1, 0, 1, 0, 2, 2, 1};
        int[] thirds = new int[]{-1, 2, 2, 2, 1, 1, 0, 2};
        block7: for (int i = 0; i < ntris; ++i) {
            int a = tris[i][0];
            int b = tris[i][1];
            int c = tris[i][2];
            int flags = smap[a] < 0 ? 0 : 1;
            flags += smap[b] < 0 ? 0 : 2;
            switch (incounts[flags += smap[c] < 0 ? 0 : 4]) {
                case 0: {
                    continue block7;
                }
                case 3: {
                    t[nt] = new int[]{smap[tris[i][0]], smap[tris[i][1]], smap[tris[i][2]]};
                    ++nt;
                    continue block7;
                }
                case 1: {
                    int ao = tris[i][firsts[flags]];
                    int bo = tris[i][seconds[flags]];
                    int co = tris[i][thirds[flags]];
                    float av = v - (xc * samples[0][ao] + yc * samples[1][ao]);
                    float bv = v - (xc * samples[0][bo] + yc * samples[1][bo]);
                    float cv = v - (xc * samples[0][co] + yc * samples[1][co]);
                    float bw = av / (av - bv);
                    float bwm = 1.0f - bw;
                    float cw = av / (av - cv);
                    float cwm = 1.0f - cw;
                    float[] sb = new float[]{bwm * samples[0][ao] + bw * samples[0][bo], bwm * samples[1][ao] + bw * samples[1][bo]};
                    float[] sc = new float[]{cwm * samples[0][ao] + cw * samples[0][co], cwm * samples[1][ao] + cw * samples[1][co]};
                    int sbi = -1;
                    int sci = -1;
                    int jmax = -1;
                    for (int j = 0; j < 6 && sother[ao][j] >= 0; ++j) {
                        jmax = j;
                        if (sother[ao][j] == bo) {
                            sbi = snew[ao][j];
                        }
                        if (sother[ao][j] != co) continue;
                        sci = snew[ao][j];
                    }
                    if (sbi < 0) {
                        s[0][ns] = sb[0];
                        s[1][ns] = sb[1];
                        if (jmax < 5) {
                            sother[ao][++jmax] = bo;
                            snew[ao][jmax] = ns;
                        }
                        sbi = ns++;
                    }
                    if (sci < 0) {
                        s[0][ns] = sc[0];
                        s[1][ns] = sc[1];
                        if (jmax < 5) {
                            sother[ao][++jmax] = co;
                            snew[ao][jmax] = ns;
                        }
                        sci = ns++;
                    }
                    t[nt] = new int[]{smap[ao], sbi, sci};
                    ++nt;
                    continue block7;
                }
                case 2: {
                    int ao = tris[i][firsts[flags]];
                    int bo = tris[i][seconds[flags]];
                    int co = tris[i][thirds[flags]];
                    float av = v - (xc * samples[0][ao] + yc * samples[1][ao]);
                    float bv = v - (xc * samples[0][bo] + yc * samples[1][bo]);
                    float cv = v - (xc * samples[0][co] + yc * samples[1][co]);
                    float aw = av / (av - cv);
                    float awm = 1.0f - aw;
                    float bw = bv / (bv - cv);
                    float bwm = 1.0f - bw;
                    float[] sa = new float[]{awm * samples[0][ao] + aw * samples[0][co], awm * samples[1][ao] + aw * samples[1][co]};
                    float[] sb = new float[]{bwm * samples[0][bo] + bw * samples[0][co], bwm * samples[1][bo] + bw * samples[1][co]};
                    int sai = -1;
                    int sbi = -1;
                    int jamax = -1;
                    for (int j = 0; j < 6 && sother[ao][j] >= 0; ++j) {
                        jamax = j;
                        if (sother[ao][j] != co) continue;
                        sai = snew[ao][j];
                    }
                    int jbmax = -1;
                    for (int j = 0; j < 6 && sother[bo][j] >= 0; ++j) {
                        jbmax = j;
                        if (sother[bo][j] != co) continue;
                        sbi = snew[bo][j];
                    }
                    if (sai < 0) {
                        s[0][ns] = sa[0];
                        s[1][ns] = sa[1];
                        if (jamax < 5) {
                            sother[ao][++jamax] = co;
                            snew[ao][jamax] = ns;
                        }
                        sai = ns++;
                    }
                    if (sbi < 0) {
                        s[0][ns] = sb[0];
                        s[1][ns] = sb[1];
                        if (jbmax < 5) {
                            sother[bo][++jbmax] = co;
                            snew[bo][jbmax] = ns;
                        }
                        sbi = ns++;
                    }
                    t[nt] = new int[]{smap[ao], smap[bo], sai};
                    t[++nt] = new int[]{smap[bo], sai, sbi};
                    ++nt;
                }
            }
        }
        if (ns == 0 || nt == 0) {
            outs[0] = null;
            outt[0] = null;
        } else {
            float[][] ss = new float[2][ns];
            System.arraycopy(s[0], 0, ss[0], 0, ns);
            System.arraycopy(s[1], 0, ss[1], 0, ns);
            int[][] tt = new int[nt][];
            System.arraycopy(t, 0, tt, 0, nt);
            outs[0] = ss;
            outt[0] = tt;
        }
    }
}

