/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeException;
import edu.wisc.ssec.mcidas.adde.AddePointDataReader;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ucar.nc2.iosp.adde.AddeStationObsDataset;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.StationImpl;

public class StationDB {
    private static boolean debugOpen = false;
    private static boolean debugCall = false;
    private static boolean debugParse = false;
    private List<Station> stations = new ArrayList<Station>();
    static String testName = "C:/data/station/adde/STNDB.TXT";
    static String testName2 = "http://localhost:8080/test/STNDB.TXT";

    public StationDB(String urlString) throws IOException {
        long start = System.currentTimeMillis();
        InputStream ios = null;
        if (urlString.startsWith("http:")) {
            URL url = new URL(urlString);
            ios = url.openStream();
            if (debugOpen) {
                System.out.println("opened URL " + urlString);
            }
        } else if (urlString.startsWith("resource:")) {
            ClassLoader cl = this.getClass().getClassLoader();
            ios = cl.getResourceAsStream(urlString.substring(9));
            if (debugOpen) {
                System.out.println("opened resource " + urlString);
            }
        } else {
            ios = new FileInputStream(urlString);
            if (debugOpen) {
                System.out.println("opened file " + urlString);
            }
        }
        try (BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios));){
            String line;
            dataIS.readLine();
            dataIS.readLine();
            int count = 0;
            while ((line = dataIS.readLine()) != null) {
                if (line.length() < 85) {
                    break;
                }
                String idn = line.substring(0, 5);
                String id = line.substring(6, 10);
                String name = line.substring(13, 33);
                String type = line.substring(34, 51);
                String state = line.substring(52, 54);
                String country = line.substring(55, 57);
                String latS = line.substring(58, 68);
                String lonS = line.substring(69, 79);
                String elevS = line.substring(80, 85);
                Station s = new Station(idn, id, name, type, state, country, latS, lonS, elevS);
                this.stations.add(s);
                if (debugParse) {
                    System.out.println((Object)s);
                }
                ++count;
            }
        }
        if (debugCall) {
            long took = System.currentTimeMillis() - start;
            System.out.println(" read " + urlString + " count=" + this.stations.size() + " took=" + took + " msec ");
        }
    }

    StationDB(String location, CancelTask cancel) throws IOException {
        HashMap<String, Station> hashStations = new HashMap<String, Station>(5000);
        try {
            if (debugOpen) {
                System.out.println("Call ADDE Server " + location);
            }
            long start = System.currentTimeMillis();
            AddePointDataReader reader = AddeStationObsDataset.callAdde(location + "&num=all&param=ID LAT LON ZS");
            long took = System.currentTimeMillis() - start;
            if (debugOpen) {
                System.out.println(" time = " + took);
            }
            int[][] stationData = reader.getData();
            int nparams = stationData.length;
            int nstations = stationData[0].length;
            System.out.println(" nparams= " + nparams + " nstations=" + nstations);
            System.out.println(" size= " + nparams * nstations * 4 + " bytes");
            int[] scales = reader.getScales();
            double[] scaleFactor = new double[scales.length];
            for (int i = 0; i < nparams; ++i) {
                scaleFactor[i] = scales[i] == 0 ? 1.0 : 1.0 / Math.pow(10.0, scales[i]);
            }
            if (cancel != null && cancel.isCancel()) {
                return;
            }
            int last = 0;
            for (int i = 0; i < nstations; ++i) {
                String stnId = McIDASUtil.intBitsToString(stationData[0][i]);
                if (!hashStations.containsKey(stnId)) {
                    last = i;
                    double lat = (double)stationData[1][i] * scaleFactor[1];
                    double lon = (double)stationData[2][i] * scaleFactor[2];
                    double elev = (double)stationData[3][i] * scaleFactor[3];
                    hashStations.put(stnId, new Station(stnId, "", lat, lon, elev));
                }
                if (cancel == null || !cancel.isCancel()) continue;
                return;
            }
            if (debugCall) {
                System.out.println(" hashStations count= " + hashStations.size() + " last = " + last);
            }
            ArrayList stationList = new ArrayList(hashStations.keySet());
            Collections.sort(stationList);
            this.stations = new ArrayList<Station>();
            for (String id : stationList) {
                this.stations.add((Station)((Object)hashStations.get(id)));
                if (cancel == null || !cancel.isCancel()) continue;
                return;
            }
        }
        catch (AddeException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public List<Station> getStations() {
        return this.stations;
    }

    public static void main(String[] args) throws IOException {
        long start = System.currentTimeMillis();
        StationDB stnDB = new StationDB(testName);
        long took = System.currentTimeMillis() - start;
        List<Station> list = stnDB.getStations();
        double sum = 0.0;
        Iterator<Station> i$ = list.iterator();
        while (i$.hasNext()) {
            Station aList;
            Station s = aList = i$.next();
            sum += s.getLatitude();
        }
        System.out.println(" read " + testName + " count=" + list.size() + " took=" + took + " msec " + " sum= " + sum);
    }

    public static class Station
    extends StationImpl {
        String idn;
        String id;
        String name;
        String type;
        String state;
        String country;
        String desc;

        Station(String idn, String id, String name, String type, String state, String country, String latS, String lonS, String elevS) {
            if (debugParse) {
                System.out.println("-" + idn + "-" + id + "-" + name + "-" + type + "-" + state + "-" + country + "-" + latS + "-" + lonS + "-" + elevS);
            }
            this.idn = idn.trim();
            this.id = id.trim();
            this.name = name.trim();
            this.type = type;
            this.state = state.trim();
            this.country = country.trim();
            this.lat = this.parseDegree(latS);
            this.lon = -1.0 * this.parseDegree(lonS);
            this.desc = this.state.length() > 0 ? this.name + ", " + this.state + ", " + this.country : this.name + ", " + this.country;
            try {
                this.alt = Double.parseDouble(elevS);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }

        private double parseDegree(String s) {
            String degS = s.substring(0, 4);
            String minS = s.substring(5, 7);
            String secS = s.substring(8, 10);
            try {
                double deg = Double.parseDouble(degS);
                double min = Double.parseDouble(minS);
                double sec = Double.parseDouble(secS);
                if (deg < 0.0) {
                    return deg - min / 60.0 - sec / 3600.0;
                }
                return deg + min / 60.0 + sec / 3600.0;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return 0.0;
            }
        }

        Station(String id, String desc, double lat, double lon, double elev) {
            this.id = id;
            this.desc = desc;
            this.lat = lat;
            this.lon = lon;
            this.alt = elev;
        }

        public String toString() {
            return this.idn + " " + this.id + " " + this.name + " " + this.type + " " + this.state + " " + this.country + " " + this.lat + " " + this.lon + " " + this.alt;
        }

        public String getName() {
            return this.id;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getWmoId() {
            return this.idn;
        }

        public double getLatitude() {
            return this.lat;
        }

        public double getLongitude() {
            return this.lon;
        }

        public double getAltitude() {
            return this.alt;
        }

        public int compareTo(Station so) {
            return this.name.compareTo(so.getName());
        }
    }
}

