/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.vis5d;

import ucar.nc2.iosp.grid.GridDefRecord;

public class Vis5DGridDefRecord
extends GridDefRecord {
    private static final int PROJ_GENERIC = 0;
    private static final int PROJ_LINEAR = 1;
    private static final int PROJ_CYLINDRICAL = 20;
    private static final int PROJ_SPHERICAL = 21;
    private static final int PROJ_LAMBERT = 2;
    private static final int PROJ_STEREO = 3;
    private static final int PROJ_ROTATED = 4;
    private int projection;

    public Vis5DGridDefRecord(int Projection, double[] projargs, int nr, int nc) {
        this.projection = Projection;
        this.setParams(Projection, projargs);
        this.addParam("GDSkey", this.toString());
    }

    @Override
    public String getGroupName() {
        return this.getParam("ProjFlag") + "_" + this.getParam("Nx") + "x" + this.getParam("Ny");
    }

    public String toString() {
        return this.getParam("ProjFlag") + " X:" + this.getParam("Nx") + " " + "Y:" + this.getParam("Ny") + " Proj:" + this.projection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vis5DGridDefRecord)) {
            return false;
        }
        return this.toString().equals(o.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    private void setParams(int Projection, double[] projargs) {
        switch (Projection) {
            case 0: {
                this.addParam("ProjFlag", "GENERIC");
            }
            case 1: {
                this.addParam("ProjFlag", "LINEAR");
            }
            case 20: {
                this.addParam("ProjFlag", "CYLINDRICAL");
            }
            case 21: {
                this.addParam("ProjFlag", "SPHERICAL");
                double NorthBound = projargs[0];
                double WestBound = -projargs[1];
                double RowInc = projargs[2];
                double ColInc = projargs[3];
                this.addParam("La1", String.valueOf(NorthBound));
                this.addParam("Lo1", String.valueOf(WestBound));
                this.addParam("Dx", String.valueOf(ColInc));
                this.addParam("Dy", String.valueOf(RowInc));
                break;
            }
            case 4: {
                this.addParam("ProjFlag", "ROTATED");
                double NorthBound = projargs[0];
                double WestBound = projargs[1];
                double RowInc = projargs[2];
                double ColInc = projargs[3];
                double CentralLat = projargs[4];
                double CentralLon = projargs[5];
                double Rotation = projargs[6];
                break;
            }
            case 2: {
                this.addParam("ProjFlag", "LAMBERT");
                double Lat1 = projargs[0];
                double Lat2 = projargs[1];
                double PoleRow = projargs[2];
                double PoleCol = projargs[3];
                double CentralLon = projargs[4];
                double ColInc = projargs[5];
                break;
            }
            case 3: {
                this.addParam("ProjFlag", "STEREO");
                double CentralLat = projargs[0];
                double CentralLon = projargs[1];
                double CentralRow = projargs[2];
                double CentralCol = projargs[3];
                double ColInc = projargs[4];
            }
        }
    }

    public static void printProjArgs(int Projection, double[] projargs) {
        switch (Projection) {
            case 0: 
            case 1: 
            case 20: 
            case 21: {
                double NorthBound = projargs[0];
                double WestBound = projargs[1];
                double RowInc = projargs[2];
                double ColInc = projargs[3];
                System.out.println("Generic, Linear, Cylindrical, Spherical:");
                System.out.println("NB: " + NorthBound + ", WB: " + WestBound + ", rowInc: " + RowInc + ", colInc: " + ColInc);
                break;
            }
            case 4: {
                double NorthBound = projargs[0];
                double WestBound = projargs[1];
                double RowInc = projargs[2];
                double ColInc = projargs[3];
                double CentralLat = projargs[4];
                double CentralLon = projargs[5];
                double Rotation = projargs[6];
                System.out.println("Rotated:");
                System.out.println("NB: " + NorthBound + ", WB: " + WestBound + ", rowInc: " + RowInc + ", colInc: " + ColInc + ", clat: " + CentralLat + ", clon: " + CentralLon + ", rotation: " + Rotation);
                break;
            }
            case 2: {
                double Lat1 = projargs[0];
                double Lat2 = projargs[1];
                double PoleRow = projargs[2];
                double PoleCol = projargs[3];
                double CentralLon = projargs[4];
                double ColInc = projargs[5];
                System.out.println("Lambert: ");
                System.out.println("lat1: " + Lat1 + ", lat2: " + Lat2 + ", poleRow: " + PoleRow + ", PoleCol: " + PoleCol + ", clon: " + CentralLon + ", colInc: " + ColInc);
                break;
            }
            case 3: {
                double CentralLat = projargs[0];
                double CentralLon = projargs[1];
                double CentralRow = projargs[2];
                double CentralCol = projargs[3];
                double ColInc = projargs[4];
                System.out.println("Stereo: ");
                System.out.println("clat: " + CentralLat + ", clon: " + CentralLon + ", cRow: " + CentralRow + ", cCol: " + CentralCol + ", colInc: " + ColInc);
                break;
            }
            default: {
                System.out.println("Projection unknown");
            }
        }
    }
}

