/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.grid.GridCF;
import ucar.nc2.iosp.grid.GridDefRecord;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.grid.GridTableLookup;
import ucar.nc2.iosp.grid.GridVariable;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Orthographic;
import ucar.unidata.geoloc.projection.RotatedLatLon;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.VerticalPerspectiveView;
import ucar.unidata.geoloc.projection.sat.MSGnavigation;
import ucar.unidata.util.GaussianLatitudes;
import ucar.unidata.util.StringUtil2;

public class GridHorizCoordSys {
    private static Logger log = LoggerFactory.getLogger(GridHorizCoordSys.class);
    Map<Integer, GridVariable> varHash = new HashMap<Integer, GridVariable>(200);
    Map<String, List<GridVariable>> productHash = new HashMap<String, List<GridVariable>>(100);
    private GridTableLookup lookup;
    private GridDefRecord gds;
    private Group g;
    private String grid_name;
    private String shape_name;
    private String id;
    private boolean isLatLon = true;
    private boolean isGaussian = false;
    private double startx;
    private double starty;
    private double incrx;
    private double incry;
    private ProjectionImpl proj;
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public GridHorizCoordSys(GridDefRecord gds, GridTableLookup lookup, Group g) {
        this.gds = gds;
        this.lookup = lookup;
        this.g = g;
        this.grid_name = lookup.getGridName(gds);
        this.shape_name = lookup.getShapeName(gds);
        this.isLatLon = lookup.isLatLon(gds);
        this.grid_name = StringUtil2.replace((String)this.grid_name, (char)' ', (String)"_");
        String string = this.id = g == null ? this.grid_name : g.getFullName();
        if (this.isLatLon && lookup.getProjectionType(gds) == 8) {
            this.isGaussian = true;
            double np = gds.getDouble("Np");
            np = Double.isNaN(np) ? 90.0 : np;
            gds.addParam("Dy", String.valueOf(np));
        }
    }

    public String getID() {
        return this.id;
    }

    public String getGridName() {
        return this.grid_name;
    }

    public Group getGroup() {
        return this.g;
    }

    public boolean isLatLon() {
        return this.isLatLon;
    }

    public int getNx() {
        return this.gds.getInt("Nx");
    }

    public int getNy() {
        return this.gds.getInt("Ny");
    }

    public double getDxInKm() {
        return this.getGridSpacingInKm("Dx");
    }

    public double getDyInKm() {
        return this.getGridSpacingInKm("Dy");
    }

    private double getGridSpacingInKm(String type) {
        double value = this.gds.getDouble(type);
        if (Double.isNaN(value)) {
            return value;
        }
        String gridUnit = this.gds.getParam("grid_units");
        SimpleUnit unit = gridUnit == null || gridUnit.length() == 0 ? SimpleUnit.meterUnit : SimpleUnit.factory((String)gridUnit);
        if (unit != null && SimpleUnit.isCompatible((String)unit.getUnitString(), (String)"km")) {
            value = unit.convertTo(value, SimpleUnit.kmUnit);
        }
        return value;
    }

    void addDimensionsToNetcdfFile(NetcdfFile ncfile) {
        if (this.isLatLon) {
            ncfile.addDimension(this.g, new Dimension("lat", this.gds.getInt("Ny"), true));
            ncfile.addDimension(this.g, new Dimension("lon", this.gds.getInt("Nx"), true));
        } else {
            ncfile.addDimension(this.g, new Dimension("y", this.gds.getInt("Ny"), true));
            ncfile.addDimension(this.g, new Dimension("x", this.gds.getInt("Nx"), true));
        }
    }

    void addToNetcdfFile(NetcdfFile ncfile) {
        if (this.isLatLon) {
            double dy;
            if (this.gds.getDouble("Dy") == -9999.0) {
                dy = this.setLatLonDxDy();
            } else {
                double d = dy = this.gds.getDouble("La2") < this.gds.getDouble("La1") ? -this.gds.getDouble("Dy") : this.gds.getDouble("Dy");
            }
            if (this.isGaussian) {
                this.addGaussianLatAxis(ncfile, "lat", "degrees_north", "latitude coordinate", "latitude", AxisType.Lat);
            } else {
                this.addCoordAxis(ncfile, "lat", this.gds.getInt("Ny"), this.gds.getDouble("La1"), dy, "degrees_north", "latitude coordinate", "latitude", AxisType.Lat);
            }
            this.addCoordAxis(ncfile, "lon", this.gds.getInt("Nx"), this.gds.getDouble("Lo1"), this.gds.getDouble("Dx"), "degrees_east", "longitude coordinate", "longitude", AxisType.Lon);
            this.addCoordSystemVariable(ncfile, "latLonCoordSys", "time lat lon");
        } else {
            int projType = this.lookup.getProjectionType(this.gds);
            if (this.makeProjection(ncfile, projType)) {
                double[] xData;
                double[] yData;
                if (projType == 10) {
                    double dy = this.gds.getDouble("La2") < this.gds.getDouble("La1") ? -this.gds.getDouble("Dy") : this.gds.getDouble("Dy");
                    yData = this.addCoordAxis(ncfile, "y", this.gds.getInt("Ny"), this.gds.getDouble("La1"), dy, "degrees", "y coordinate of projection", "projection_y_coordinate", AxisType.GeoY);
                    xData = this.addCoordAxis(ncfile, "x", this.gds.getInt("Nx"), this.gds.getDouble("Lo1"), this.gds.getDouble("Dx"), "degrees", "x coordinate of projection", "projection_x_coordinate", AxisType.GeoX);
                } else if (projType == 7) {
                    yData = this.addCoordAxis(ncfile, "y", this.gds.getInt("Ny"), this.starty, this.incry, "km", "y coordinate of projection", "projection_y_coordinate", AxisType.GeoY);
                    xData = this.addCoordAxis(ncfile, "x", this.gds.getInt("Nx"), this.startx, this.incrx, "km", "x coordinate of projection", "projection_x_coordinate", AxisType.GeoX);
                } else if (projType == 100) {
                    yData = null;
                    xData = null;
                } else {
                    yData = this.addCoordAxis(ncfile, "y", this.gds.getInt("Ny"), this.starty, this.getDyInKm(), "km", "y coordinate of projection", "projection_y_coordinate", AxisType.GeoY);
                    xData = this.addCoordAxis(ncfile, "x", this.gds.getInt("Nx"), this.startx, this.getDxInKm(), "km", "x coordinate of projection", "projection_x_coordinate", AxisType.GeoX);
                }
                if (GridServiceProvider.addLatLon && projType != 100) {
                    this.addLatLon2D(ncfile, xData, yData);
                }
            }
        }
    }

    void empty() {
        this.gds = null;
        this.varHash = null;
        this.productHash = null;
    }

    private double[] addCoordAxis(NetcdfFile ncfile, String name, int n, double start, double incr, String units, String desc, String standard_name, AxisType axis) {
        Variable v = new Variable(ncfile, this.g, null, name);
        v.setDataType(DataType.DOUBLE);
        v.setDimensions(name);
        double[] data = new double[n];
        for (int i = 0; i < n; ++i) {
            data[i] = start + incr * (double)i;
        }
        Array dataArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{n}, (Object)data);
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("long_name", desc));
        v.addAttribute(new Attribute("standard_name", standard_name));
        v.addAttribute(new Attribute("grid_spacing", incr + " " + units));
        v.addAttribute(new Attribute("_CoordinateAxisType", axis.toString()));
        ncfile.addVariable(this.g, v);
        return data;
    }

    private double[] addGaussianLatAxis(NetcdfFile ncfile, String name, String units, String desc, String standard_name, AxisType axis) {
        double np = this.gds.getDouble("NumberParallels");
        if (Double.isNaN(np)) {
            np = this.gds.getDouble("Np");
        }
        if (Double.isNaN(np)) {
            throw new IllegalArgumentException("Gaussian Lat/Lon grid must have 'NumberParallels' or 'Np' (number of parallels) parameter");
        }
        double startLat = this.gds.getDouble("La1");
        double endLat = this.gds.getDouble("La2");
        int nlats = (int)(2.0 * np);
        GaussianLatitudes gaussLats = new GaussianLatitudes(nlats);
        int bestStartIndex = 0;
        int bestEndIndex = 0;
        double bestStartDiff = Double.MAX_VALUE;
        double bestEndDiff = Double.MAX_VALUE;
        for (int i = 0; i < nlats; ++i) {
            double diff = Math.abs(gaussLats.latd[i] - startLat);
            if (diff < bestStartDiff) {
                bestStartDiff = diff;
                bestStartIndex = i;
            }
            if (!((diff = Math.abs(gaussLats.latd[i] - endLat)) < bestEndDiff)) continue;
            bestEndDiff = diff;
            bestEndIndex = i;
        }
        int ny = this.gds.getInt("Ny");
        if (Math.abs(bestEndIndex - bestStartIndex + 1) != ny) {
            log.warn("GRIB gaussian lats: NP != NY, use NY");
            nlats = ny;
            gaussLats = new GaussianLatitudes(nlats);
            bestStartIndex = 0;
            bestEndIndex = ny - 1;
        }
        boolean goesUp = bestEndIndex > bestStartIndex;
        Variable v = new Variable(ncfile, this.g, null, name);
        v.setDataType(DataType.DOUBLE);
        v.setDimensions(name);
        int useIndex = bestStartIndex;
        double[] data = new double[ny];
        double[] gaussw = new double[ny];
        for (int i = 0; i < ny; ++i) {
            data[i] = gaussLats.latd[useIndex];
            gaussw[i] = gaussLats.gaussw[useIndex];
            if (goesUp) {
                ++useIndex;
                continue;
            }
            --useIndex;
        }
        Array dataArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ny}, (Object)data);
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("long_name", desc));
        v.addAttribute(new Attribute("standard_name", standard_name));
        v.addAttribute(new Attribute("weights", "gaussw"));
        v.addAttribute(new Attribute("_CoordinateAxisType", axis.toString()));
        ncfile.addVariable(this.g, v);
        v = new Variable(ncfile, this.g, null, "gaussw");
        v.setDataType(DataType.DOUBLE);
        v.setDimensions(name);
        v.addAttribute(new Attribute("long_name", "gaussian weights (unnormalized)"));
        dataArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ny}, (Object)gaussw);
        v.setCachedData(dataArray, false);
        ncfile.addVariable(this.g, v);
        return data;
    }

    private void addLatLon2D(NetcdfFile ncfile, double[] xData, double[] yData) {
        Variable latVar = new Variable(ncfile, this.g, null, "lat");
        latVar.setDataType(DataType.DOUBLE);
        latVar.setDimensions("y x");
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("long_name", "latitude coordinate"));
        latVar.addAttribute(new Attribute("standard_name", "latitude"));
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lonVar = new Variable(ncfile, this.g, null, "lon");
        lonVar.setDataType(DataType.DOUBLE);
        lonVar.setDimensions("y x");
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("long_name", "longitude coordinate"));
        lonVar.addAttribute(new Attribute("standard_name", "longitude"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int nx = xData.length;
        int ny = yData.length;
        ProjectionPointImpl projPoint = new ProjectionPointImpl();
        LatLonPointImpl latlonPoint = new LatLonPointImpl();
        double[] latData = new double[nx * ny];
        double[] lonData = new double[nx * ny];
        for (int i = 0; i < ny; ++i) {
            for (int j = 0; j < nx; ++j) {
                projPoint.setLocation(xData[j], yData[i]);
                this.proj.projToLatLon((ProjectionPoint)projPoint, latlonPoint);
                latData[i * nx + j] = latlonPoint.getLatitude();
                lonData[i * nx + j] = latlonPoint.getLongitude();
            }
        }
        Array latDataArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ny, nx}, (Object)latData);
        latVar.setCachedData(latDataArray, false);
        Array lonDataArray = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{ny, nx}, (Object)lonData);
        lonVar.setCachedData(lonDataArray, false);
        ncfile.addVariable(this.g, latVar);
        ncfile.addVariable(this.g, lonVar);
    }

    private boolean makeProjection(NetcdfFile ncfile, int projType) {
        switch (projType) {
            case 10: {
                this.makeRotatedLatLon(ncfile);
                break;
            }
            case 1: {
                this.makePS();
                break;
            }
            case 2: {
                this.makeLC();
                break;
            }
            case 3: {
                this.makeMercator();
                break;
            }
            case 7: {
                this.makeMSGgeostationary();
                break;
            }
            case 100: {
                this.makeCurvilinearAxis(ncfile);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown projection = " + this.gds.getInt("grid_type"));
            }
        }
        Variable v = new Variable(ncfile, this.g, null, this.grid_name);
        v.setDataType(DataType.CHAR);
        v.setDimensions("");
        char[] data = new char[]{'d'};
        Array dataArray = Array.factory((DataType)DataType.CHAR, (int[])new int[0], (Object)data);
        v.setCachedData(dataArray, false);
        for (Attribute att : this.attributes) {
            v.addAttribute(att);
        }
        v.addAttribute(new Attribute("earth_shape", this.shape_name));
        double radius_spherical_earth = this.gds.getDouble("grid_radius_spherical_earth");
        if (Double.isNaN(radius_spherical_earth)) {
            radius_spherical_earth = this.gds.getDouble("radius_spherical_earth");
        }
        if (!Double.isNaN(radius_spherical_earth)) {
            if (radius_spherical_earth < 10000.0) {
                radius_spherical_earth *= 1000.0;
            }
            v.addAttribute(new Attribute("earth_radius", (Number)radius_spherical_earth));
        } else {
            double minor_axis;
            double major_axis = this.gds.getDouble("grid_major_axis_earth");
            if (Double.isNaN(major_axis)) {
                major_axis = this.gds.getDouble("major_axis_earth");
            }
            if (Double.isNaN(minor_axis = this.gds.getDouble("grid_minor_axis_earth"))) {
                minor_axis = this.gds.getDouble("minor_axis_earth");
            }
            if (!Double.isNaN(major_axis) && !Double.isNaN(minor_axis)) {
                v.addAttribute(new Attribute("semi_major_axis", (Number)major_axis));
                v.addAttribute(new Attribute("semi_minor_axis", (Number)minor_axis));
            }
        }
        this.addGDSparams(v);
        ncfile.addVariable(this.g, v);
        return true;
    }

    protected String getGDSprefix() {
        return "GDS";
    }

    private void addGDSparams(Variable v) {
        ArrayList<String> keyList = new ArrayList<String>(this.gds.getKeys());
        Collections.sort(keyList);
        String pre = this.getGDSprefix();
        for (String key : keyList) {
            String name = pre + "_param_" + key;
            String vals = this.gds.getParam(key);
            try {
                int vali = Integer.parseInt(vals);
                if (key.equals("VectorComponentFlag")) {
                    String cf = GridCF.VectorComponentFlag.of(vali);
                    v.addAttribute(new Attribute(name, cf));
                    continue;
                }
                v.addAttribute(new Attribute(name, (Number)vali));
            }
            catch (Exception e) {
                try {
                    double vald = Double.parseDouble(vals);
                    v.addAttribute(new Attribute(name, (Number)vald));
                }
                catch (Exception e2) {
                    v.addAttribute(new Attribute(name, vals));
                }
            }
        }
    }

    private void addCoordSystemVariable(NetcdfFile ncfile, String name, String dims) {
        Variable v = new Variable(ncfile, this.g, null, name);
        v.setDataType(DataType.CHAR);
        v.setDimensions("");
        Array dataArray = Array.factory((DataType)DataType.CHAR, (int[])new int[0], (Object)new char[]{'0'});
        v.setCachedData(dataArray, false);
        v.addAttribute(new Attribute("_CoordinateAxes", dims));
        if (this.isLatLon()) {
            v.addAttribute(new Attribute("_CoordinateTransforms", ""));
        } else {
            v.addAttribute(new Attribute("_CoordinateTransforms", this.getGridName()));
        }
        this.addGDSparams(v);
        ncfile.addVariable(this.g, v);
    }

    private void makeLC() {
        this.proj = new LambertConformal(this.gds.getDouble("Latin1"), this.gds.getDouble("LoV"), this.gds.getDouble("Latin1"), this.gds.getDouble("Latin2"));
        LatLonPointImpl startLL = new LatLonPointImpl(this.gds.getDouble("La1"), this.gds.getDouble("Lo1"));
        ProjectionPointImpl start = (ProjectionPointImpl)this.proj.latLonToProj((LatLonPoint)startLL);
        this.startx = start.getX();
        this.starty = start.getY();
        if (Double.isNaN(this.getDxInKm())) {
            this.setDxDy(this.startx, this.starty, this.proj);
        }
        if (GridServiceProvider.debugProj) {
            System.out.println("GridHorizCoordSys.makeLC start at latlon " + startLL);
            double Lo2 = this.gds.getDouble("Lo2");
            double La2 = this.gds.getDouble("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GridHorizCoordSys.makeLC end at latlon " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj((LatLonPoint)endLL);
            System.out.println("   end at proj coord " + endPP);
            double endx = this.startx + (double)this.getNx() * this.getDxInKm();
            double endy = this.starty + (double)this.getNy() * this.getDyInKm();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
        this.attributes.add(new Attribute("grid_mapping_name", "lambert_conformal_conic"));
        if (this.gds.getDouble("Latin1") == this.gds.getDouble("Latin2")) {
            this.attributes.add(new Attribute("standard_parallel", (Number)this.gds.getDouble("Latin1")));
        } else {
            double[] data = new double[]{this.gds.getDouble("Latin1"), this.gds.getDouble("Latin2")};
            this.attributes.add(new Attribute("standard_parallel", Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{2}, (Object)data)));
        }
        this.attributes.add(new Attribute("longitude_of_central_meridian", (Number)this.gds.getDouble("LoV")));
        this.attributes.add(new Attribute("latitude_of_projection_origin", (Number)this.gds.getDouble("Latin1")));
    }

    private void makePS() {
        String nproj = this.gds.getParam("NpProj");
        double latOrigin = nproj == null || nproj.equalsIgnoreCase("true") ? 90.0 : -90.0;
        double lad = this.gds.getDouble("LaD");
        double scale = Double.isNaN(lad) ? 0.933 : (1.0 + Math.sin(Math.toRadians(Math.abs(lad)))) / 2.0;
        this.proj = new Stereographic(latOrigin, this.gds.getDouble("LoV"), scale);
        ProjectionPointImpl start = (ProjectionPointImpl)this.proj.latLonToProj((LatLonPoint)new LatLonPointImpl(this.gds.getDouble("La1"), this.gds.getDouble("Lo1")));
        this.startx = start.getX();
        this.starty = start.getY();
        if (Double.isNaN(this.getDxInKm())) {
            this.setDxDy(this.startx, this.starty, this.proj);
        }
        if (GridServiceProvider.debugProj) {
            System.out.printf("starting proj coord %s lat/lon %s%n", start, this.proj.projToLatLon((ProjectionPoint)start));
            System.out.println("   should be LA1=" + this.gds.getDouble("La1") + " l)1=" + this.gds.getDouble("Lo1"));
        }
        this.attributes.add(new Attribute("grid_mapping_name", "polar_stereographic"));
        this.attributes.add(new Attribute("longitude_of_projection_origin", (Number)this.gds.getDouble("LoV")));
        this.attributes.add(new Attribute("straight_vertical_longitude_from_pole", (Number)this.gds.getDouble("LoV")));
        this.attributes.add(new Attribute("scale_factor_at_projection_origin", (Number)scale));
        this.attributes.add(new Attribute("latitude_of_projection_origin", (Number)latOrigin));
    }

    private void makeMercator() {
        double Latin = this.gds.getDouble("LaD");
        if (Double.isNaN(Latin)) {
            Latin = this.gds.getDouble("Latin");
        }
        double Lo1 = this.gds.getDouble("Lo1");
        double La1 = this.gds.getDouble("La1");
        this.proj = new Mercator(Lo1, Latin);
        ProjectionPoint startP = this.proj.latLonToProj((LatLonPoint)new LatLonPointImpl(La1, Lo1));
        this.startx = startP.getX();
        this.starty = startP.getY();
        if (Double.isNaN(this.getDxInKm())) {
            this.setDxDy(this.startx, this.starty, this.proj);
        }
        this.attributes.add(new Attribute("grid_mapping_name", "mercator"));
        this.attributes.add(new Attribute("standard_parallel", (Number)Latin));
        this.attributes.add(new Attribute("longitude_of_projection_origin", (Number)Lo1));
        if (GridServiceProvider.debugProj) {
            double Lo2 = this.gds.getDouble("Lo2");
            if (Lo2 < Lo1) {
                Lo2 += 360.0;
            }
            double La2 = this.gds.getDouble("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GridHorizCoordSys.makeMercator: end at latlon= " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj((LatLonPoint)endLL);
            System.out.println("   start at proj coord " + new ProjectionPointImpl(this.startx, this.starty));
            System.out.println("   end at proj coord " + endPP);
            double endx = this.startx + (double)(this.getNx() - 1) * this.getDxInKm();
            double endy = this.starty + (double)(this.getNy() - 1) * this.getDyInKm();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
    }

    private void makeRotatedLatLon(NetcdfFile ncfile) {
        double splat = this.gds.getDouble("SpLat");
        double splon = this.gds.getDouble("SpLon");
        double spangle = this.gds.getDouble("RotationAngle");
        this.proj = new RotatedLatLon(splat, splon, spangle);
        LatLonPoint startLL = this.proj.projToLatLon((ProjectionPoint)new ProjectionPointImpl(this.gds.getDouble("Lo1"), this.gds.getDouble("La1")));
        this.startx = startLL.getLongitude();
        this.starty = startLL.getLatitude();
        this.addCoordSystemVariable(ncfile, "latLonCoordSys", "time y x");
        this.attributes.add(new Attribute("grid_mapping_name", "rotated_latlon_grib"));
        this.attributes.add(new Attribute("grid_south_pole_latitude", (Number)splat));
        this.attributes.add(new Attribute("grid_south_pole_longitude", (Number)splon));
        this.attributes.add(new Attribute("grid_south_pole_angle", (Number)spangle));
        if (GridServiceProvider.debugProj) {
            System.out.println("Location of pole of rotated grid:");
            System.out.println("Lon=" + splon + ", Lat=" + splat);
            System.out.println("Axial rotation about pole of rotated grid:" + spangle);
            System.out.println("Location of LL in rotated grid:");
            System.out.println("Lon=" + this.gds.getDouble("Lo1") + ", " + "Lat=" + this.gds.getDouble("La1"));
            System.out.println("Location of LL in non-rotated grid:");
            System.out.println("Lon=" + this.startx + ", Lat=" + this.starty);
            double Lo2 = this.gds.getDouble("Lo2");
            double La2 = this.gds.getDouble("La2");
            System.out.println("Location of UR in rotated grid:");
            System.out.println("Lon=" + Lo2 + ", Lat=" + La2);
            System.out.println("Location of UR in non-rotated grid:");
            LatLonPoint endUR = this.proj.projToLatLon((ProjectionPoint)new ProjectionPointImpl(Lo2, La2));
            System.out.println("Lon=" + endUR.getLongitude() + ", Lat=" + endUR.getLatitude());
            double dy = La2 < this.gds.getDouble("La1") ? -this.gds.getDouble("Dy") : this.gds.getDouble("Dy");
            double endx = this.gds.getDouble("Lo1") + (double)(this.getNx() - 1) * this.gds.getDouble("Dx");
            double endy = this.gds.getDouble("La1") + (double)(this.getNy() - 1) * dy;
            System.out.println("End point rotated grid should be x=" + endx + " y=" + endy);
        }
    }

    private void makeSpaceViewOrOthographic() {
        double minor_axis;
        double Lat0 = this.gds.getDouble("Lap");
        double Lon0 = this.gds.getDouble("Lop");
        double xp = this.gds.getDouble("Xp");
        double yp = this.gds.getDouble("Yp");
        double dx = this.gds.getDouble("Dx");
        double dy = this.gds.getDouble("Dy");
        double major_axis = this.gds.getDouble("grid_major_axis_earth");
        if (Double.isNaN(major_axis)) {
            major_axis = this.gds.getDouble("major_axis_earth");
        }
        if (Double.isNaN(minor_axis = this.gds.getDouble("grid_minor_axis_earth"))) {
            minor_axis = this.gds.getDouble("minor_axis_earth");
        }
        double nr = this.gds.getDouble("Nr") * 1.0E-6;
        double apparentDiameter = 2.0 * Math.sqrt((nr - 1.0) / (nr + 1.0));
        double gridLengthX = major_axis * apparentDiameter / dx;
        double gridLengthY = minor_axis * apparentDiameter / dy;
        this.gds.addParam("Dx", String.valueOf(1000.0 * gridLengthX));
        this.gds.addParam("Dx", new Double(1000.0 * gridLengthX));
        this.gds.addParam("Dy", String.valueOf(1000.0 * gridLengthY));
        this.gds.addParam("Dy", new Double(1000.0 * gridLengthY));
        this.startx = -gridLengthX * xp;
        this.starty = -gridLengthY * yp;
        double radius = Earth.getRadius() / 1000.0;
        if (nr == 1.111111111E9) {
            this.proj = new Orthographic(Lat0, Lon0, radius);
            this.attributes.add(new Attribute("grid_mapping_name", "orthographic"));
            this.attributes.add(new Attribute("longitude_of_projection_origin", (Number)Lon0));
            this.attributes.add(new Attribute("latitude_of_projection_origin", (Number)Lat0));
        } else {
            double height = (nr - 1.0) * radius;
            this.proj = new VerticalPerspectiveView(Lat0, Lon0, radius, height);
            this.attributes.add(new Attribute("grid_mapping_name", "vertical_perspective"));
            this.attributes.add(new Attribute("longitude_of_projection_origin", (Number)Lon0));
            this.attributes.add(new Attribute("latitude_of_projection_origin", (Number)Lat0));
            this.attributes.add(new Attribute("height_above_earth", (Number)height));
        }
        if (GridServiceProvider.debugProj) {
            double Lo2 = this.gds.getDouble("Lo2") + 360.0;
            double La2 = this.gds.getDouble("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GridHorizCoordSys.makeOrthographic end at latlon " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj((LatLonPoint)endLL);
            System.out.println("   end at proj coord " + endPP);
            double endx = this.startx + (double)this.getNx() * this.getDxInKm();
            double endy = this.starty + (double)this.getNy() * this.getDyInKm();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
    }

    private void makeMSGgeostationary() {
        double scale_factor;
        double minor_axis;
        double dx;
        double Lat0 = this.gds.getDouble("Lap");
        double Lon0 = this.gds.getDouble("Lop");
        int ny = this.gds.getInt("Ny");
        int x_off = this.gds.getInt("Xp");
        int y_off = this.gds.getInt("Yp");
        double dy = this.gds.getDouble("Dy");
        if (dy < 2100.0) {
            dx = 1207.0;
            dy = 1203.0;
        } else {
            dx = 3622.0;
            dy = 3610.0;
        }
        double major_axis = this.gds.getDouble("grid_major_axis_earth");
        if (Double.isNaN(major_axis)) {
            major_axis = this.gds.getDouble("major_axis_earth");
        }
        if (Double.isNaN(minor_axis = this.gds.getDouble("grid_minor_axis_earth"))) {
            minor_axis = this.gds.getDouble("minor_axis_earth");
        }
        double nr = this.gds.getDouble("Nr") * 1.0E-6;
        double as = 2.0 * Math.asin(1.0 / nr);
        double cfac = dx / as;
        double lfac = dy / as;
        double scale_x = scale_factor = (nr - 1.0) * major_axis / 1000.0;
        double scale_y = -scale_factor;
        this.startx = scale_factor * (double)(1 - x_off) / cfac;
        this.starty = scale_factor * (double)(y_off - ny) / lfac;
        this.incrx = scale_factor / cfac;
        this.incry = scale_factor / lfac;
        this.attributes.add(new Attribute("grid_mapping_name", "MSGnavigation"));
        this.attributes.add(new Attribute("longitude_of_projection_origin", (Number)Lon0));
        this.attributes.add(new Attribute("latitude_of_projection_origin", (Number)Lat0));
        this.attributes.add(new Attribute("height_from_earth_center", (Number)(nr * major_axis)));
        this.attributes.add(new Attribute("scale_x", (Number)scale_x));
        this.attributes.add(new Attribute("scale_y", (Number)scale_y));
        this.proj = new MSGnavigation(Lat0, Lon0, major_axis, minor_axis, nr * major_axis, scale_x, scale_y);
        if (GridServiceProvider.debugProj) {
            double Lo2 = this.gds.getDouble("Lo2") + 360.0;
            double La2 = this.gds.getDouble("La2");
            LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
            System.out.println("GridHorizCoordSys.makeMSGgeostationary end at latlon " + endLL);
            ProjectionPointImpl endPP = (ProjectionPointImpl)this.proj.latLonToProj((LatLonPoint)endLL);
            System.out.println("   end at proj coord " + endPP);
            double endx = 1 + this.getNx();
            double endy = 1 + this.getNy();
            System.out.println("   should be x=" + endx + " y=" + endy);
        }
    }

    private void makeCurvilinearAxis(NetcdfFile ncfile) {
        List vars = ncfile.getRootGroup().getVariables();
        String latpp = null;
        String lonpp = null;
        String latU = null;
        String lonU = null;
        String latV = null;
        String lonV = null;
        ArrayList<String> timeDimLL = new ArrayList<String>();
        ArrayList<String> timeDimV = new ArrayList<String>();
        for (Variable var : vars) {
            List dims;
            int[] shape;
            if (var.getShortName().startsWith("Latitude")) {
                shape = var.getShape();
                if (var.getRank() == 3 && shape[0] == 1) {
                    dims = var.getDimensions();
                    if (!timeDimLL.contains(((Dimension)dims.get(0)).getShortName())) {
                        timeDimLL.add(((Dimension)dims.get(0)).getShortName());
                    }
                    dims.remove(0);
                    var.setDimensions(dims);
                }
                var.addAttribute(new Attribute("units", "degrees_north"));
                var.addAttribute(new Attribute("long_name", "latitude coordinate"));
                var.addAttribute(new Attribute("standard_name", "latitude"));
                var.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
                if (var.getShortName().contains("U_Wind_Component")) {
                    latU = var.getFullName();
                    continue;
                }
                if (var.getShortName().contains("V_Wind_Component")) {
                    latV = var.getFullName();
                    continue;
                }
                latpp = var.getFullName();
                continue;
            }
            if (!var.getShortName().startsWith("Longitude")) continue;
            shape = var.getShape();
            if (var.getRank() == 3 && shape[0] == 1) {
                dims = var.getDimensions();
                if (!timeDimLL.contains(((Dimension)dims.get(0)).getShortName())) {
                    timeDimLL.add(((Dimension)dims.get(0)).getShortName());
                }
                dims.remove(0);
                var.setDimensions(dims);
            }
            var.addAttribute(new Attribute("units", "degrees_east"));
            var.addAttribute(new Attribute("long_name", "longitude coordinate"));
            var.addAttribute(new Attribute("standard_name", "longitude"));
            var.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
            if (var.getShortName().contains("U_Wind_Component")) {
                lonU = var.getFullName();
                continue;
            }
            if (var.getShortName().contains("V_Wind_Component")) {
                lonV = var.getFullName();
                continue;
            }
            lonpp = var.getFullName();
        }
        for (Variable var : vars) {
            List dims = var.getDimensions();
            if (var.getShortName().startsWith("U-component")) {
                var.addAttribute(new Attribute("coordinates", latU + " " + lonU));
                if (timeDimV.contains(((Dimension)dims.get(0)).getShortName())) continue;
                timeDimV.add(((Dimension)dims.get(0)).getShortName());
                continue;
            }
            if (var.getShortName().startsWith("V-component")) {
                var.addAttribute(new Attribute("coordinates", latV + " " + lonV));
                if (timeDimV.contains(((Dimension)dims.get(0)).getShortName())) continue;
                timeDimV.add(((Dimension)dims.get(0)).getShortName());
                continue;
            }
            var.addAttribute(new Attribute("coordinates", latpp + " " + lonpp));
            if (timeDimV.contains(((Dimension)dims.get(0)).getShortName())) continue;
            timeDimV.add(((Dimension)dims.get(0)).getShortName());
        }
    }

    private void setDxDy(double startx, double starty, ProjectionImpl proj) {
        double Lo2 = this.gds.getDouble("Lo2");
        double La2 = this.gds.getDouble("La2");
        if (Double.isNaN(Lo2) || Double.isNaN(La2)) {
            return;
        }
        LatLonPointImpl endLL = new LatLonPointImpl(La2, Lo2);
        ProjectionPointImpl end = (ProjectionPointImpl)proj.latLonToProj((LatLonPoint)endLL);
        double dx = Math.abs(end.getX() - startx) / (double)(this.gds.getInt("Nx") - 1);
        double dy = Math.abs(end.getY() - starty) / (double)(this.gds.getInt("Ny") - 1);
        this.gds.addParam("Dx", String.valueOf(dx));
        this.gds.addParam("Dy", String.valueOf(dy));
        this.gds.addParam("grid_units", "km");
    }

    private double setLatLonDxDy() {
        double lo1 = this.gds.getDouble("Lo1");
        double la1 = this.gds.getDouble("La1");
        double lo2 = this.gds.getDouble("Lo2");
        double la2 = this.gds.getDouble("La2");
        if (Double.isNaN(lo2) || Double.isNaN(la2)) {
            return Double.NaN;
        }
        if (lo2 < lo1) {
            lo2 += 360.0;
        }
        double dx = Math.abs(lo2 - lo1) / (double)(this.gds.getInt("Nx") - 1);
        double dy = Math.abs(la2 - la1) / (double)(this.gds.getInt("Ny") - 1);
        this.gds.addParam("Dx", String.valueOf(dx));
        this.gds.addParam("Dy", String.valueOf(dy));
        this.gds.addParam("Dx", new Double(dx));
        this.gds.addParam("Dy", new Double(dy));
        this.gds.addParam("grid_units", "degree");
        return dy;
    }

    public GridDefRecord getGds() {
        return this.gds;
    }
}

