/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import edu.wisc.ssec.mcidas.AreaFile;
import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.iosp.mcidas.AreaReader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class AreaServiceProvider
extends AbstractIOServiceProvider {
    protected AreaReader areaReader;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return AreaReader.isValidFile(raf);
    }

    public String getFileTypeId() {
        return "McIDASArea";
    }

    public String getFileTypeDescription() {
        return "McIDAS area file";
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        if (this.areaReader == null) {
            this.areaReader = new AreaReader();
        }
        try {
            this.areaReader.init(raf.getLocation(), ncfile);
        }
        catch (Throwable e) {
            this.close();
            throw new IOException(e);
        }
        finally {
            raf.close();
        }
    }

    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        return this.areaReader.readVariable(v2, section);
    }

    public void close() throws IOException {
        if (this.areaReader != null) {
            if (this.areaReader.af != null) {
                this.areaReader.af.close();
            }
            this.areaReader = null;
        }
    }

    public void release() throws IOException {
        if (this.areaReader.af != null) {
            this.areaReader.af.close();
        }
    }

    public void reacquire() throws IOException {
        try {
            this.areaReader.af = new AreaFile(this.location);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }
}

