/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc.gml;

import java.io.IOException;
import net.opengis.gml.x32.TimePositionType;
import org.joda.time.DateTime;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ogc.MarshallingUtil;

public abstract class NcTimePositionType {
    public static TimePositionType initTime(TimePositionType time, PointFeature pointFeat) {
        time.setStringValue(pointFeat.getNominalTimeAsCalendarDate().toString());
        return time;
    }

    public static TimePositionType initBeginPosition(TimePositionType beginPosition, StationTimeSeriesFeature stationFeat) throws IOException {
        stationFeat.calcBounds();
        if (stationFeat.getCalendarDateRange() != null) {
            beginPosition.setStringValue(stationFeat.getCalendarDateRange().getStart().toString());
        }
        return beginPosition;
    }

    public static TimePositionType initEndPosition(TimePositionType endPosition, StationTimeSeriesFeature stationFeat) throws IOException {
        stationFeat.calcBounds();
        if (stationFeat.getCalendarDateRange() != null) {
            endPosition.setStringValue(stationFeat.getCalendarDateRange().getEnd().toString());
        }
        return endPosition;
    }

    public static TimePositionType initTimePosition(TimePositionType timePosition) {
        DateTime resultTime = MarshallingUtil.fixedResultTime;
        if (resultTime == null) {
            resultTime = new DateTime();
        }
        timePosition.setStringValue(resultTime.toString());
        return timePosition;
    }

    private NcTimePositionType() {
    }
}

