/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ogc.erddap.util;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import ucar.nc2.ogc.erddap.util.ErddapMath2;
import ucar.nc2.ogc.erddap.util.ErddapString2;

public class ErddapCalendar2 {
    public static final int YEAR = 1;
    public static final int MILLISECOND = 14;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int SECONDS_PER_HOUR = 3600;
    public static final int SECONDS_PER_DAY = 86400;
    public static final TimeZone zuluTimeZone = TimeZone.getTimeZone("Zulu");

    public static double[] getTimeBaseAndFactor(String tsUnits) throws Exception {
        String errorInMethod = ErddapString2.ERROR + " in Calendar2.getTimeBaseAndFactor(" + tsUnits + "):\n";
        if (tsUnits == null) {
            throw new NullPointerException(errorInMethod + "tsUnits must be non-null.");
        }
        int sincePo = tsUnits.toLowerCase().indexOf(" since ");
        if (sincePo <= 0) {
            throw new IllegalArgumentException(errorInMethod + "units string doesn't contain \" since \".");
        }
        double factorToGetSeconds = ErddapCalendar2.factorToGetSeconds(tsUnits.substring(0, sincePo));
        GregorianCalendar baseGC = ErddapCalendar2.parseISODateTimeZulu(tsUnits.substring(sincePo + 7));
        double baseSeconds = (double)baseGC.getTimeInMillis() / 1000.0;
        return new double[]{baseSeconds, factorToGetSeconds};
    }

    public static double factorToGetSeconds(String units) throws Exception {
        if ((units = units.trim().toLowerCase()).equals("ms") || units.equals("msec") || units.equals("msecs") || units.equals("millis") || units.equals("millisec") || units.equals("millisecs") || units.equals("millisecond") || units.equals("milliseconds")) {
            return 0.001;
        }
        if (units.equals("s") || units.equals("sec") || units.equals("secs") || units.equals("second") || units.equals("seconds")) {
            return 1.0;
        }
        if (units.equals("m") || units.equals("min") || units.equals("mins") || units.equals("minute") || units.equals("minutes")) {
            return 60.0;
        }
        if (units.equals("h") || units.equals("hr") || units.equals("hrs") || units.equals("hour") || units.equals("hours")) {
            return 3600.0;
        }
        if (units.equals("d") || units.equals("day") || units.equals("days")) {
            return 86400.0;
        }
        if (units.equals("week") || units.equals("weeks")) {
            return 604800.0;
        }
        if (units.equals("mon") || units.equals("mons") || units.equals("month") || units.equals("months")) {
            return 2592000.0;
        }
        if (units.equals("yr") || units.equals("yrs") || units.equals("year") || units.equals("years")) {
            return 3.1104E7;
        }
        throw new RuntimeException(ErddapString2.ERROR + " in Calendar2.factorToGetSeconds: units=\"" + units + "\" is invalid.");
    }

    public static GregorianCalendar newGCalendarZulu() {
        return new GregorianCalendar(zuluTimeZone);
    }

    private static void parseN(String s, char[] separatorN, int[] resultsN) {
        int sLength;
        if (s == null) {
            s = "";
        }
        if ((sLength = (s = s.trim()).length()) < 1 || s.charAt(0) != '-' && !ErddapString2.isDigit(s.charAt(0))) {
            resultsN[0] = Integer.MAX_VALUE;
            return;
        }
        int po2 = -1;
        boolean mMode = s.charAt(0) == '-';
        int nParts = separatorN.length;
        for (int part = 0; part < nParts; ++part) {
            int pmPart;
            int po1;
            if (po2 + 1 >= sLength) continue;
            po2 = po1 = po2 + 1;
            if (mMode) {
                if (po2 < sLength && s.charAt(po2) == '-') {
                    ++po2;
                } else {
                    resultsN[0] = Integer.MAX_VALUE;
                    return;
                }
            }
            while (po2 < sLength && ErddapString2.isDigit(s.charAt(po2))) {
                ++po2;
            }
            if (po2 == po1) {
                return;
            }
            resultsN[part] = part > 0 && separatorN[part - 1] == '.' ? ErddapMath2.roundToInt(1000.0 * ErddapString2.parseDouble("0." + s.substring(po1, po2))) : ErddapString2.parseInt(s.substring(po1, po2));
            if (resultsN[part] == Integer.MAX_VALUE) {
                resultsN[0] = Integer.MAX_VALUE;
                return;
            }
            if (po2 >= sLength) {
                return;
            }
            mMode = false;
            char ch = s.charAt(po2);
            if (ch == ',') {
                ch = '.';
            }
            if (separatorN[part] == '\u0000') continue;
            if (separatorN[part] == '\u00b1') {
                if (ch == '+') continue;
                if (ch == '-') {
                    --po2;
                    mMode = true;
                    continue;
                }
                resultsN[0] = Integer.MAX_VALUE;
                return;
            }
            if (ch == separatorN[part]) continue;
            if ((separatorN[part] == ':' || separatorN[part] == '.') && part < nParts - 1 && (pmPart = ErddapString2.indexOf(separatorN, '\u00b1', part + 1)) >= 0) {
                part = pmPart;
                if (ch == '+') continue;
                if (ch == '-') {
                    --po2;
                    mMode = true;
                    continue;
                }
                resultsN[0] = Integer.MAX_VALUE;
                return;
            }
            resultsN[0] = Integer.MAX_VALUE;
            return;
        }
    }

    public static GregorianCalendar parseISODateTime(GregorianCalendar gc, String s) {
        String last3;
        boolean negative;
        if (s == null) {
            s = "";
        }
        if (negative = s.startsWith("-")) {
            s = s.substring(1);
        }
        if (s.length() < 1 || !ErddapString2.isDigit(s.charAt(0))) {
            throw new RuntimeException(ErddapString2.ERROR + " in parseISODateTime: for first character of dateTime='" + s + "' isn't a digit!");
        }
        if (gc == null) {
            throw new RuntimeException(ErddapString2.ERROR + " in parseISODateTime: gc is null!");
        }
        int[] ymdhmsmom = new int[]{Integer.MAX_VALUE, 1, 1, 0, 0, 0, 0, 0, 0};
        if (Character.toLowerCase((s = s.trim()).charAt(s.length() - 1)) == 'z') {
            s = s.substring(0, s.length() - 1).trim();
        }
        if (s.length() >= 3 && ((last3 = s.substring(s.length() - 3).toLowerCase()).equals("utc") || last3.equals("gmt"))) {
            s = s.substring(0, s.length() - 3).trim();
        }
        s = ErddapString2.replaceAll(s, ' ', '+');
        char[] separator = new char[]{'-', '-', '\u0000', ':', ':', '.', '\u00b1', ':', '\u0000'};
        ErddapCalendar2.parseN(s, separator, ymdhmsmom);
        if (ymdhmsmom[0] == Integer.MAX_VALUE) {
            throw new RuntimeException(ErddapString2.ERROR + " in parseISODateTime: dateTime='" + s + "' has an invalid format!");
        }
        if (ymdhmsmom[7] != 0) {
            ymdhmsmom[3] = ymdhmsmom[3] - ymdhmsmom[7];
        }
        if (ymdhmsmom[8] != 0) {
            ymdhmsmom[4] = ymdhmsmom[4] - (ymdhmsmom[7] < 0 ? -ymdhmsmom[8] : ymdhmsmom[8]);
        }
        gc.set((negative ? -1 : 1) * ymdhmsmom[0], ymdhmsmom[1] - 1, ymdhmsmom[2], ymdhmsmom[3], ymdhmsmom[4], ymdhmsmom[5]);
        gc.set(14, ymdhmsmom[6]);
        gc.get(1);
        return gc;
    }

    public static GregorianCalendar parseISODateTimeZulu(String s) {
        return ErddapCalendar2.parseISODateTime(ErddapCalendar2.newGCalendarZulu(), s);
    }
}

