/*
 * Decompiled with CFR 0.152.
 */
package thredds.bufrtables;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Formatter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.iosp.bufr.writer.Bufr2Xml;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.io.RandomAccessFile;

public class BtMessInfoController
extends AbstractController {
    private DiskCache2 diskCache = null;

    public void setCache(DiskCache2 cache) {
        this.diskCache = cache;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        String path = req.getPathInfo();
        System.out.println(" BtController.handleRequestInternal got " + path);
        if (path.startsWith("/mess/")) {
            long messPos;
            int pos = (path = path.substring(6)).lastIndexOf("/");
            if (pos < 0) {
                res.sendError(400, "no message number");
                return null;
            }
            String cmd = path.substring(pos + 1);
            if ((pos = (path = path.substring(0, pos)).lastIndexOf("/")) < 0) {
                res.sendError(400, "no message number");
                return null;
            }
            String mess = path.substring(pos + 1);
            try {
                messPos = Long.parseLong(mess);
            }
            catch (Exception e) {
                res.sendError(400, "illegal message number=" + mess);
                return null;
            }
            String cacheName = path.substring(0, pos);
            File uploadedFile = this.diskCache.getCacheFile(cacheName);
            if (!uploadedFile.exists()) {
                res.sendError(404, "file not found=" + cacheName + "; may have been purged");
                return null;
            }
            if (cmd.equals("data.xml")) {
                this.showMessData(res, uploadedFile, cacheName, messPos);
            } else if (cmd.equals("dds.txt")) {
                this.showMessDDS(res, uploadedFile, cacheName, messPos);
            } else if (cmd.equals("bitCount.txt")) {
                this.showMessSize(res, uploadedFile, cacheName, messPos);
            } else if (cmd.equals("table.txt")) {
                this.showMessTable(res, uploadedFile, cacheName, messPos);
            }
            return null;
        }
        res.sendError(400, "GET request not understood");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessDDS(HttpServletResponse res, File file, String cacheName, long messPos) throws IOException {
        Message m = null;
        try {
            m = this.getBufrMessageByPos(file, messPos);
            if (m == null) {
                res.sendError(404, "message " + messPos + " not found in " + cacheName);
                return;
            }
            res.setContentType("text/plain");
            ServletOutputStream out = res.getOutputStream();
            Formatter f = new Formatter((OutputStream)out);
            f.format("File %s message at pos %d %n%n", cacheName, messPos);
            if (!m.isTablesComplete()) {
                f.format(" MISSING DATA DESCRIPTORS= ", new Object[0]);
                m.showMissingFields(f);
                f.format("%n%n", new Object[0]);
            }
            m.dump(f);
            f.flush();
        }
        finally {
            if (m != null) {
                m.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessSizeOld(HttpServletResponse res, File file, String cacheName, long messPos) throws IOException {
        Message m = null;
        try {
            m = this.getBufrMessageByPos(file, messPos);
            if (m == null) {
                res.sendError(404, "message " + messPos + " not found in " + cacheName);
                return;
            }
            res.setContentType("text/plain");
            ServletOutputStream out = res.getOutputStream();
            Formatter f = new Formatter((OutputStream)out);
            f.format("File %s message at pos %d %n%n", cacheName, messPos);
            try {
                boolean ok;
                int nbitsCounted = m.calcTotalBits(f);
                int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
                boolean bl = ok = Math.abs(m.getCountedDataBytes() - m.dataSection.getDataLength()) <= 1;
                if (!ok) {
                    f.format("*** BAD BIT COUNT %n", new Object[0]);
                }
                DataDescriptor root = m.getRootDataDescriptor();
                f.format("%nMessage nobs=%d compressed=%s vlen=%s countBits= %d givenBits=%d %n", m.getNumberDatasets(), m.dds.isCompressed(), root.isVarLength(), nbitsCounted, nbitsGiven);
                f.format(" countBits= %d givenBits=%d %n", nbitsCounted, nbitsGiven);
                f.format(" countBytes= %d dataSize=%d %n", m.getCountedDataBytes(), m.dataSection.getDataLength());
                f.format("%n", new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                res.sendError(500, ex.getMessage());
            }
            f.flush();
        }
        finally {
            if (m != null) {
                m.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessSize(HttpServletResponse res, File file, String cacheName, long messPos) throws IOException {
        res.setContentType("text/plain");
        RandomAccessFile raf = null;
        Message m = null;
        try {
            MessageUncompressedDataReader reader;
            raf = new RandomAccessFile(file.getPath(), "r");
            MessageScanner scan = new MessageScanner(raf, messPos, false);
            if (scan.hasNext()) {
                m = scan.next();
            }
            if (m == null) {
                res.sendError(404, "message " + messPos + " not found in " + cacheName);
                return;
            }
            res.setContentType("text/plain");
            ServletOutputStream out = res.getOutputStream();
            Formatter f = new Formatter((OutputStream)out);
            f.format("File %s message at pos %d %n%n", cacheName, messPos);
            if (!m.dds.isCompressed()) {
                reader = new MessageUncompressedDataReader();
                reader.readData(null, m, raf, null, false, f);
            } else {
                reader = new MessageCompressedDataReader();
                reader.readData(null, m, raf, null, f);
            }
            int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
            DataDescriptor root = m.getRootDataDescriptor();
            f.format("Message nobs=%d compressed=%s vlen=%s countBits= %d givenBits=%d %n", m.getNumberDatasets(), m.dds.isCompressed(), root.isVarLength(), m.getCountedDataBits(), nbitsGiven);
            f.format(" countBits= %d givenBits=%d %n", m.getCountedDataBits(), nbitsGiven);
            f.format(" countBytes= %d dataSize=%d %n", m.getCountedDataBytes(), m.dataSection.getDataLength());
            f.format("%n", new Object[0]);
            f.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            res.sendError(500, ex.getMessage());
        }
        finally {
            if (m != null) {
                m.close();
            }
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessTable(HttpServletResponse res, File file, String cacheName, long messPos) throws IOException {
        res.setContentType("text/plain");
        Message m = null;
        try {
            m = this.getBufrMessageByPos(file, messPos);
            if (m == null) {
                res.sendError(404, "message " + messPos + " not found in " + cacheName);
                return;
            }
            res.setContentType("text/plain");
            ServletOutputStream out = res.getOutputStream();
            Formatter f = new Formatter((OutputStream)out);
            f.format("File %s message at pos %d %n%n", cacheName, messPos);
            try {
                boolean ok;
                int nbitsCounted = m.calcTotalBits(f);
                int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
                boolean bl = ok = Math.abs(m.getCountedDataBytes() - m.dataSection.getDataLength()) <= 1;
                if (!ok) {
                    f.format("*** BAD BIT COUNT %n", new Object[0]);
                }
                DataDescriptor root = m.getRootDataDescriptor();
                f.format("%nMessage nobs=%d compressed=%s vlen=%s countBits= %d givenBits=%d %n", m.getNumberDatasets(), m.dds.isCompressed(), root.isVarLength(), nbitsCounted, nbitsGiven);
                f.format(" countBits= %d givenBits=%d %n", nbitsCounted, nbitsGiven);
                f.format(" countBytes= %d dataSize=%d %n", m.getCountedDataBytes(), m.dataSection.getDataLength());
                f.format("%n", new Object[0]);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                res.sendError(500, ex.getMessage());
            }
            f.flush();
        }
        finally {
            if (m != null) {
                m.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showMessData(HttpServletResponse res, File file, String cacheName, long messPos) throws IOException {
        Message message = null;
        NetcdfDataset ncd = null;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file.getPath(), "r");
            MessageScanner scan = new MessageScanner(raf, messPos, false);
            if (scan.hasNext()) {
                message = scan.next();
                byte[] mbytes = scan.getMessageBytesFromLast(message);
                NetcdfFile ncfile = null;
                try {
                    ncfile = NetcdfFile.openInMemory((String)"test", (byte[])mbytes, (String)"ucar.nc2.iosp.bufr.BufrIosp");
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                ncd = new NetcdfDataset(ncfile);
            }
            if (ncd == null) {
                res.sendError(404, "message at pos=" + messPos + " not found in " + cacheName);
                return;
            }
            res.setContentType("application/xml; charset=UTF-8");
            try {
                ServletOutputStream out = res.getOutputStream();
                new Bufr2Xml(message, ncd, (OutputStream)out, false);
                out.flush();
            }
            catch (Exception e) {
                this.logger.warn((Object)("Exception on file " + cacheName), (Throwable)e);
                res.sendError(400, "message at pos=" + messPos + " cant be read, filename= " + cacheName);
            }
        }
        finally {
            if (ncd != null) {
                ncd.close();
            }
            if (raf != null) {
                raf.close();
            }
        }
    }

    private Message getBufrMessageByPos(File file, long pos) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(file.getPath(), "r");
        MessageScanner scan = new MessageScanner(raf, pos, false);
        if (scan.hasNext()) {
            return scan.next();
        }
        if (raf != null) {
            raf.close();
        }
        return null;
    }
}

