/*
 * Decompiled with CFR 0.152.
 */
package thredds.gribtables;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.transform.JDOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public class StandardWmoController
extends AbstractController {
    private static Logger log = LoggerFactory.getLogger(StandardWmoController.class);
    private String filename;
    private List<WMoTable> tableList;

    public void setTableList(String filename) {
        this.filename = filename;
    }

    private void initList() {
        String rootPath = this.getServletContext().getRealPath("/");
        this.tableList = new ArrayList<WMoTable>();
        try {
            String line;
            FileInputStream is = new FileInputStream(rootPath + "/" + this.filename);
            DataInputStream dis = new DataInputStream(is);
            while ((line = dis.readLine()) != null) {
                System.out.printf(" %s%n", line);
                String[] tokes = line.split(" ");
                this.tableList.add(new WMoTable(tokes[0], tokes[1], tokes[2]));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest req, HttpServletResponse res) throws Exception {
        if (this.tableList == null) {
            this.initList();
        }
        String path = req.getPathInfo();
        System.out.println(" StandardWmoController.handleRequestInternal path= " + path);
        try {
            Document doc = this.makeXml(path);
            return new ModelAndView("xsltView", "source", (Object)new JDOMSource(doc));
        }
        catch (Exception e) {
            this.logger.warn((Object)("Exception on file " + path), (Throwable)e);
            res.sendError(400, "File=" + path);
            return null;
        }
    }

    protected Document makeXml(String path) throws Exception {
        Element rootElem = new Element("bufrValidation");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("path", path);
        return doc;
    }

    private class WMoTable {
        String type;
        String version;
        String filename;

        private WMoTable(String type, String version, String filename) {
            this.type = type;
            this.version = version;
            this.filename = filename;
        }
    }
}

