/*
 * Decompiled with CFR 0.152.
 */
package thredds.bufrtables;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.transform.JDOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractCommandController;
import thredds.bufrtables.FileValidateBean;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.util.DiskCache2;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public class BtValidateController
extends AbstractCommandController {
    private static Logger log = LoggerFactory.getLogger(BtValidateController.class);
    private DiskCache2 diskCache = null;
    private Set<Message> messSet = new HashSet<Message>();
    private WritableByteChannel wbc = null;
    private FileOutputStream fos;

    public void setCache(DiskCache2 cache) {
        this.diskCache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUniqueMessageFile(String filename) {
        File f = new File(filename);
        if (f.exists()) {
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(filename, "r");
                MessageScanner scan = new MessageScanner(raf);
                while (scan.hasNext()) {
                    Message m = scan.next();
                    if (m == null) {
                        log.warn("Bad message in file " + filename);
                        continue;
                    }
                    if (this.messSet.contains(m)) continue;
                    this.messSet.add(m);
                }
            }
            catch (IOException e) {
                log.error("Failed to read in unique message file " + filename, (Throwable)e);
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        try {
            this.fos = new FileOutputStream(filename, true);
            this.wbc = this.fos.getChannel();
        }
        catch (FileNotFoundException e) {
            log.error("Failed to open for writing unique message file " + filename, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addUniqueMessages(String filename) {
        if (this.wbc == null) {
            return;
        }
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(filename, "r");
            MessageScanner scan = new MessageScanner(raf);
            while (scan.hasNext()) {
                Message m = scan.next();
                if (m == null) {
                    log.warn("Bad message in file " + filename);
                    continue;
                }
                if (this.messSet.contains(m)) continue;
                scan.writeCurrentMessage(this.wbc);
                this.messSet.add(m);
            }
            this.fos.flush();
        }
        catch (IOException e) {
            log.error("Failed to read message file " + filename, (Throwable)e);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected ModelAndView handle(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        FileValidateBean bean = (FileValidateBean)command;
        String fname = StringUtil2.unescape((String)bean.getFilename());
        File dest = this.diskCache.getCacheFile(fname);
        this.addUniqueMessages(dest.getPath());
        try {
            Document doc = this.makeXml(dest, fname);
            if (bean.isXml()) {
                return new ModelAndView("xmlView", "doc", (Object)doc);
            }
            return new ModelAndView("xsltView", "source", (Object)new JDOMSource(doc));
        }
        catch (Exception e) {
            log.warn("Exception on file " + fname, (Throwable)e);
            response.sendError(400, "File=" + fname);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document makeXml(File f, String filename) throws Exception {
        Element rootElem = new Element("bufrValidation");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("fileName", filename);
        rootElem.setAttribute("fileSize", Long.toString(f.length()));
        RandomAccessFile raf = new RandomAccessFile(f.getPath(), "r");
        try {
            int count = 0;
            MessageScanner scan = new MessageScanner(raf);
            while (scan.hasNext()) {
                boolean ok;
                Message m = scan.next();
                if (m == null) continue;
                Element bufrMessage = new Element("bufrMessage").setAttribute("status", "ok");
                rootElem.addContent((Content)bufrMessage);
                bufrMessage.setAttribute("record", Integer.toString(count));
                bufrMessage.setAttribute("pos", Long.toString(m.getStartPos()));
                if (!m.isTablesComplete()) {
                    bufrMessage.setAttribute("dds", "incomplete");
                } else {
                    bufrMessage.setAttribute("dds", "ok");
                }
                int nbitsCounted = -1;
                try {
                    nbitsCounted = m.getTotalBits();
                }
                catch (Exception e) {
                    // empty catch block
                }
                int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
                boolean bl = ok = Math.abs(m.getCountedDataBytes() - m.dataSection.getDataLength()) <= 1;
                if (ok) {
                    bufrMessage.setAttribute("size", "ok");
                } else {
                    bufrMessage.setAttribute("size", "fail");
                    bufrMessage.addContent((Content)new Element("ByteCount").setText("countBytes " + m.getCountedDataBytes() + " != " + m.dataSection.getDataLength() + " dataSize"));
                }
                bufrMessage.addContent((Content)new Element("BitCount").setText("countBits " + nbitsCounted + " != " + nbitsGiven + " dataSizeBits"));
                bufrMessage.setAttribute("nobs", Integer.toString(m.getNumberDatasets()));
                bufrMessage.addContent((Content)new Element("WMOheader").setText(m.extractWMO()));
                bufrMessage.addContent((Content)new Element("center").setText(m.getCenterName()));
                bufrMessage.addContent((Content)new Element("category").setText(m.getCategoryFullName()));
                bufrMessage.addContent((Content)new Element("date").setText(m.ids.getReferenceTime().toString()));
                ++count;
            }
            Document document = doc;
            return document;
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }
}

