/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.controller;

import edu.ucar.unidata.wmotables.domain.Table;
import edu.ucar.unidata.wmotables.domain.User;
import edu.ucar.unidata.wmotables.service.TableManager;
import edu.ucar.unidata.wmotables.service.UserManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class TableController
implements HandlerExceptionResolver {
    protected static Logger logger = Logger.getLogger(TableController.class);
    @Resource(name="userManager")
    private UserManager userManager;
    @Resource(name="tableManager")
    private TableManager tableManager;

    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public String listAllTables(Model model) {
        List<Table> tables = this.tableManager.getTableList();
        model.addAttribute("tables", tables);
        HashMap<String, User> users = new HashMap<String, User>();
        for (Table table : tables) {
            User user = this.userManager.lookupUser(table.getUserId());
            users.put(new Integer(table.getUserId()).toString(), user);
        }
        model.addAttribute("users", users);
        return "listTables";
    }

    @RequestMapping(value={"/{userId}"}, method={RequestMethod.GET})
    public String listUserTables(@PathVariable int userId, Model model) {
        List<Table> tables = this.tableManager.getTableList(userId);
        model.addAttribute("tables", tables);
        User user = this.userManager.lookupUser(userId);
        model.addAttribute("user", (Object)user);
        return "listTables";
    }

    @RequestMapping(value={"/{userId}/create"}, method={RequestMethod.GET})
    public String createTable(@PathVariable int userId, Model model) {
        User user = this.userManager.lookupUser(userId);
        model.addAttribute("user", (Object)user);
        return "createTable";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public ModelAndView createTable(Table table, BindingResult result, Model model) throws IOException {
        table.setVisibility(1);
        this.tableManager.createTable(table);
        List<Table> tables = this.tableManager.getTableList(table.getUserId());
        model.addAttribute("tables", tables);
        User user = this.userManager.lookupUser(table.getUserId());
        model.addAttribute("user", (Object)user);
        return new ModelAndView((View)new RedirectView("/" + new Integer(table.getUserId()).toString(), true));
    }

    @RequestMapping(value={"/{userId}/{tableId}/update"}, method={RequestMethod.GET})
    public String updateTable(@PathVariable int userId, @PathVariable int tableId, Model model) {
        Table table = this.tableManager.lookupTable(tableId);
        model.addAttribute("table", (Object)table);
        User user = this.userManager.lookupUser(userId);
        model.addAttribute("user", (Object)user);
        return "updateTable";
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ModelAndView updateTable(Table table, BindingResult result, Model model) {
        this.tableManager.updateTable(table);
        List<Table> tables = this.tableManager.getTableList(table.getUserId());
        model.addAttribute("tables", tables);
        User user = this.userManager.lookupUser(table.getUserId());
        model.addAttribute("user", (Object)user);
        return new ModelAndView((View)new RedirectView("/" + new Integer(table.getUserId()).toString(), true));
    }

    @RequestMapping(value={"/hide"}, method={RequestMethod.POST})
    public ModelAndView hideTable(Table table, BindingResult result, Model model) {
        this.tableManager.toggleTableVisibility(table);
        List<Table> tables = this.tableManager.getTableList(table.getUserId());
        model.addAttribute("tables", tables);
        User user = this.userManager.lookupUser(table.getUserId());
        model.addAttribute("user", (Object)user);
        return new ModelAndView((View)new RedirectView("/" + new Integer(table.getUserId()).toString(), true));
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        HashMap model = new HashMap();
        if (exception instanceof MaxUploadSizeExceededException) {
            logger.error((Object)("File size should be less then " + ((MaxUploadSizeExceededException)exception).getMaxUploadSize() + " byte."));
        } else if (exception instanceof NullPointerException) {
            logger.error((Object)("Problem with the tableStashDir argument during File creation.  Verify the wmotables.home value in the wmotables.properties file is correct: " + exception.getMessage()));
        } else if (exception instanceof FileNotFoundException) {
            logger.error((Object)("Unable to create FileOutputStream for File: " + exception.getMessage()));
        } else if (exception instanceof IOException) {
            logger.error((Object)("An IO error occured with the FileOutputStream for File: " + exception.getMessage()));
        } else if (exception instanceof SecurityException) {
            logger.error((Object)("JVM security manager configuration conflict.  Unable to write File: " + exception.getMessage()));
        } else {
            logger.error((Object)("An error has occurred: " + exception.getClass().getName()));
            logger.error((Object)exception.getMessage());
        }
        return new ModelAndView("fatalError");
    }
}

