/*
 * Decompiled with CFR 0.152.
 */
package edu.ucar.unidata.wmotables.controller;

import edu.ucar.unidata.wmotables.domain.User;
import edu.ucar.unidata.wmotables.service.UserManager;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

@Controller
public class UserController
implements HandlerExceptionResolver {
    protected static Logger logger = Logger.getLogger(UserController.class);
    @Resource(name="userManager")
    private UserManager userManager;

    @RequestMapping(value={"/users"}, method={RequestMethod.GET})
    public String listUsers(Model model) {
        List<User> users = this.userManager.getUserList();
        model.addAttribute("users", users);
        return "listUsers";
    }

    @RequestMapping(value={"/users/create"}, method={RequestMethod.GET})
    public String createUser() {
        return "createUser";
    }

    @RequestMapping(value={"/users/create"}, method={RequestMethod.POST})
    public String createUser(User user, BindingResult result, Model model) {
        this.userManager.createUser(user);
        List<User> users = this.userManager.getUserList();
        model.addAttribute("users", users);
        return "listUsers";
    }

    @RequestMapping(value={"/users/{userId}/update"}, method={RequestMethod.GET})
    public String updateUser(@PathVariable int userId, Model model) {
        User user = this.userManager.lookupUser(userId);
        model.addAttribute("user", (Object)user);
        return "updateUser";
    }

    @RequestMapping(value={"/users/update"}, method={RequestMethod.POST})
    public String updateUser(User user, BindingResult result, Model model) {
        this.userManager.updateUser(user);
        List<User> users = this.userManager.getUserList();
        model.addAttribute("users", users);
        return "listUsers";
    }

    @RequestMapping(value={"/users/delete"}, method={RequestMethod.POST})
    public ModelAndView deleteUser(User user, BindingResult result, Model model) {
        this.userManager.deleteUser(user.getUserId());
        List<User> users = this.userManager.getUserList();
        model.addAttribute("users", users);
        return new ModelAndView((View)new RedirectView("/users", true));
    }

    public ModelAndView resolveException(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) {
        HashMap<String, String> model = new HashMap<String, String>();
        logger.error((Object)("An error has occurred: " + exception.getClass().getName()));
        logger.error((Object)exception.getMessage());
        model.put("error", exception.getMessage());
        return new ModelAndView("fatalError");
    }
}

